/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.InspectAction;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class PopupInspectAction
extends InspectAction {
    public static final String ACTION_DEFININITION_ID = "org.eclipse.jdt.debug.ui.commands.Inspect";
    JavaInspectExpression expression;
    private ITextEditor fTextEditor;
    private ISelection fSelectionBeforeEvaluation;

    @Override
    protected void displayResult(IEvaluationResult result) {
        IWorkbenchPart part = this.getTargetPart();
        final StyledText styledText = PopupInspectAction.getStyledText(part);
        if (styledText == null) {
            super.displayResult(result);
        } else {
            this.expression = new JavaInspectExpression(result);
            JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PopupInspectAction.this.showPopup(styledText);
                }
            });
        }
        this.evaluationCleanup();
    }

    protected void showPopup(StyledText textWidget) {
        IWorkbenchPart part = this.getTargetPart();
        if (part instanceof ITextEditor) {
            this.fTextEditor = (ITextEditor)part;
            this.fSelectionBeforeEvaluation = this.getTargetSelection();
        }
        InspectPopupDialog displayPopup = new InspectPopupDialog(this.getShell(), PopupInspectAction.getPopupAnchor(textWidget), ACTION_DEFININITION_ID, (IExpression)this.expression){

            public boolean close() {
                boolean returnValue = super.close();
                if (PopupInspectAction.this.fTextEditor != null && PopupInspectAction.this.fSelectionBeforeEvaluation != null) {
                    PopupInspectAction.this.fTextEditor.getSelectionProvider().setSelection(PopupInspectAction.this.fSelectionBeforeEvaluation);
                    PopupInspectAction.this.fTextEditor = null;
                    PopupInspectAction.this.fSelectionBeforeEvaluation = null;
                }
                return returnValue;
            }
        };
        displayPopup.open();
    }
}

