/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.utils.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConverter;
import org.glycomedb.residuetranslator.ResidueTranslator;
import org.grits.toolbox.utils.data.CartoonOptions;
import org.grits.toolbox.utils.image.ImageCreationException;
import org.grits.toolbox.utils.image.SimianImageConverter;
import org.grits.toolbox.utils.process.GlycoWorkbenchUtil;
import org.grits.toolbox.widgets.tools.IGRITSEventHandler;
import org.grits.toolbox.widgets.tools.IGRITSEventListener;

public class GlycanImageProvider
implements IGRITSEventHandler {
    private static final Logger logger = Logger.getLogger(GlycanImageProvider.class);
    public static final String COMBO_SEQUENCE_SEPARATOR = "~|~";
    private static final Integer STACK_LIMIT = 4000;
    private HashMap<String, List<Glycan>> m_glycans = null;
    private Stack<GlycanImageObject> imageStack = null;
    private boolean blockAccess = false;
    CartoonOptions m_options = null;
    CartoonOptions m_FragmentOptions = null;
    GlycanWorkspace m_gwb;
    GlycoWorkbenchUtil m_gwbUtil;
    private int iCreateCnt = 0;
    private HashMap<String, Integer> mCreateCnt = new HashMap();
    private HashMap<String, Integer> mDisposeCnt = new HashMap();
    private List<IGRITSEventListener> eventListeners = new ArrayList<IGRITSEventListener>();
    public static final int GLYCAN_BLOCK_RELEASED = 12345;

    public GlycanImageProvider() {
        this.m_glycans = new HashMap();
        this.setGlycanWorkspace();
        this.imageStack = new Stack();
    }

    public synchronized void blockAccess() {
        this.blockAccess = true;
    }

    public synchronized void releaseBlock() {
        this.blockAccess = false;
    }

    public GlycanWorkspace getGlycanWorkspace() {
        return this.m_gwb;
    }

    private synchronized HashMap<String, List<Glycan>> getIdToGlycanList() {
        return this.m_glycans;
    }

    public synchronized Stack<GlycanImageObject> getImageStack() {
        return this.imageStack;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void clearCache() {
        if (!this.blockAccess) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            gio = this.imageStack.pop();
            gio.dispose();
lbl5:
            // 2 sources

            ** while (!this.imageStack.isEmpty())
        }
lbl6:
        // 1 sources

        this.m_glycans.clear();
    }

    private synchronized void pushGlycanImageObject(GlycanImageObject gio) {
        if (this.imageStack.size() == STACK_LIMIT.intValue()) {
            GlycanImageObject gioToRemove = (GlycanImageObject)this.imageStack.get(STACK_LIMIT - 1);
            this.imageStack.remove(STACK_LIMIT - 1);
            if (!gio.equals(gioToRemove)) {
                gioToRemove.dispose();
            }
        }
        this.imageStack.push(gio);
    }

    private synchronized GlycanImageObject getFromStack(GlycanImageObject a_gio) {
        if (this.blockAccess) {
            return null;
        }
        int iInx = this.getImageStack().indexOf(a_gio);
        if (iInx >= 0) {
            GlycanImageObject me = (GlycanImageObject)this.getImageStack().remove(iInx);
            if (!me.equals(a_gio)) {
                logger.warn((Object)"Incorrect image object removed from stack.");
            }
            this.pushGlycanImageObject(me);
            return me;
        }
        return null;
    }

    public synchronized GlycanImageObject getImage(String a_imageId) {
        if (this.blockAccess) {
            return null;
        }
        if (!this.m_glycans.containsKey(a_imageId)) {
            return null;
        }
        GlycanImageObject newGio = new GlycanImageObject(a_imageId);
        GlycanImageObject prevGio = this.getFromStack(newGio);
        if (prevGio == null) {
            return newGio;
        }
        newGio.dispose();
        return prevGio;
    }

    public synchronized int getStackSize() {
        if (this.blockAccess) {
            return -2;
        }
        return this.imageStack.size();
    }

    public synchronized int getCacheSize() {
        return this.m_glycans.size();
    }

    public synchronized CartoonOptions getCartoonOptions() {
        return this.m_options;
    }

    public synchronized void setCartoonOptions(CartoonOptions a_options) {
        this.m_options = a_options;
        this.m_gwb.setNotation(this.m_options.getImageLayout());
        this.m_gwb.setDisplay(this.m_options.getImageStyle());
        this.m_gwb.getGraphicOptions().ORIENTATION = a_options.getImageOrientation();
    }

    public static GlycanWorkspace getNewGlycanWorkspace() {
        GlycanWorkspace t_gwb = new GlycanWorkspace(null, false, (GlycanRenderer)new GlycanRendererAWT());
        t_gwb.getGraphicOptions().ORIENTATION = 0;
        t_gwb.getGraphicOptions().SHOW_INFO = true;
        t_gwb.getGraphicOptions().SHOW_MASSES = false;
        t_gwb.getGraphicOptions().SHOW_REDEND = true;
        return t_gwb;
    }

    public void setGlycanWorkspace() {
        if (this.m_gwb == null) {
            this.m_gwb = GlycanImageProvider.getNewGlycanWorkspace();
        }
        if (this.m_gwbUtil == null) {
            Config t_objConf = new Config();
            MonosaccharideConverter t_msdb = new MonosaccharideConverter(t_objConf);
            try {
                this.m_gwbUtil = new GlycoWorkbenchUtil((MonosaccharideConversion)new ResidueTranslator(), (MonosaccharideConversion)t_msdb);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized boolean add(String a_imageId, Glycan a_glycan) throws Exception {
        List<Object> lGlycanList = null;
        if (this.m_glycans.containsKey(a_imageId)) {
            lGlycanList = this.m_glycans.get(a_imageId);
        } else {
            lGlycanList = new ArrayList();
            this.m_glycans.put(a_imageId, lGlycanList);
        }
        if (lGlycanList.contains(a_glycan)) {
            return false;
        }
        lGlycanList.add(a_glycan);
        return true;
    }

    public synchronized void addMergeImageToProviderWithReducingEnd(String combinedGlycoCTSequence, String reducingEnd) throws ImageCreationException {
        try {
            if (this.m_glycans.get(combinedGlycoCTSequence) != null) {
                return;
            }
            int iInx1 = combinedGlycoCTSequence.indexOf(COMBO_SEQUENCE_SEPARATOR);
            int rInx1 = reducingEnd.indexOf(COMBO_SEQUENCE_SEPARATOR);
            if (iInx1 < 0) {
                this.m_gwbUtil.parseGlycoCTCondensedSequence(combinedGlycoCTSequence);
                Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                glycan.setReducingEndType(ResidueType.createOtherResidue((String)reducingEnd, (double)-1.0));
                this.add(combinedGlycoCTSequence, glycan);
            } else {
                String sRemaining = combinedGlycoCTSequence;
                String reducindEndRemaining = reducingEnd;
                do {
                    String sSeq = iInx1 > 0 ? sRemaining.substring(0, iInx1) : sRemaining;
                    String rSeq = rInx1 > 0 ? reducindEndRemaining.substring(0, rInx1) : reducindEndRemaining;
                    this.m_gwbUtil.parseGlycoCTCondensedSequence(sSeq);
                    Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                    if (rSeq == null || rSeq.isEmpty()) {
                        logger.error((Object)("Reducing End is not available for sequence " + combinedGlycoCTSequence));
                        glycan.setReducingEndType(ResidueDictionary.findResidueType((String)"freeEnd"));
                    } else {
                        glycan.setReducingEndType(ResidueType.createOtherResidue((String)rSeq, (double)-1.0));
                    }
                    this.add(String.valueOf(combinedGlycoCTSequence) + reducingEnd, glycan);
                    sRemaining = iInx1 > 0 ? sRemaining.substring(iInx1 + COMBO_SEQUENCE_SEPARATOR.length()) : null;
                    reducindEndRemaining = rInx1 > 0 ? reducindEndRemaining.substring(rInx1 + COMBO_SEQUENCE_SEPARATOR.length()) : null;
                    iInx1 = sRemaining != null ? sRemaining.indexOf(COMBO_SEQUENCE_SEPARATOR) : -1;
                    int n = rInx1 = reducindEndRemaining != null ? reducindEndRemaining.indexOf(COMBO_SEQUENCE_SEPARATOR) : -1;
                } while (sRemaining != null);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ImageCreationException(e);
        }
    }

    public synchronized void addMergeImageToProvider(String _sCombinedSequence, String _sCombinedGlycanID) throws ImageCreationException {
        try {
            if (this.m_glycans.get(_sCombinedSequence) != null) {
                return;
            }
            int iInx1 = _sCombinedSequence.indexOf(COMBO_SEQUENCE_SEPARATOR);
            if (iInx1 < 0) {
                this.m_gwbUtil.parseGWSSequence(_sCombinedSequence);
                Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                this.add(_sCombinedSequence, glycan);
            } else {
                String sRemaining = _sCombinedSequence;
                do {
                    String sSeq = iInx1 > 0 ? sRemaining.substring(0, iInx1) : sRemaining;
                    this.m_gwbUtil.parseGWSSequence(sSeq);
                    Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                    this.add(_sCombinedSequence, glycan);
                    sRemaining = iInx1 > 0 ? sRemaining.substring(iInx1 + COMBO_SEQUENCE_SEPARATOR.length()) : null;
                    int n = iInx1 = sRemaining != null ? sRemaining.indexOf(COMBO_SEQUENCE_SEPARATOR) : -1;
                } while (sRemaining != null);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ImageCreationException(e);
        }
    }

    public synchronized void addImageToProviderWithReducingEnd(String glycoCtSequence, String reducingEnd) throws ImageCreationException {
        try {
            if (this.m_glycans.get(glycoCtSequence) != null) {
                return;
            }
            this.m_gwbUtil.parseGlycoCTCondensedSequence(glycoCtSequence.trim());
            if (this.m_gwbUtil.getGlycoWorkbenchGlycan() != null) {
                Glycan t_glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                if (reducingEnd == null || reducingEnd.isEmpty()) {
                    logger.error((Object)("Reducing End is not available for sequence " + glycoCtSequence));
                    t_glycan.setReducingEndType(ResidueDictionary.findResidueType((String)"freeEnd"));
                } else {
                    t_glycan.setReducingEndType(ResidueType.createOtherResidue((String)reducingEnd, (double)-1.0));
                }
                ArrayList<Glycan> lPhony = new ArrayList<Glycan>();
                lPhony.add(t_glycan);
                this.m_glycans.put(String.valueOf(glycoCtSequence) + reducingEnd, lPhony);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ImageCreationException(e);
        }
    }

    public synchronized void addImageToProvider(String _sSequence, String _sGlycanID) throws ImageCreationException {
        try {
            if (this.m_glycans.get(_sSequence) != null) {
                return;
            }
            this.m_gwbUtil.parseGWSSequence(_sSequence);
            if (this.m_gwbUtil.getGlycoWorkbenchGlycan() != null) {
                Glycan t_glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                ArrayList<Glycan> lPhony = new ArrayList<Glycan>();
                lPhony.add(t_glycan);
                this.m_glycans.put(_sSequence, lPhony);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ImageCreationException(e);
        }
    }

    public static BufferedImage createCombinedImage(List<BufferedImage> a_image) {
        try {
            BufferedImage t_result = SimianImageConverter.createImage(GlycanImageProvider.findMaxWidth(a_image), GlycanImageProvider.totalHeight(a_image));
            int t_positionY = 0;
            for (BufferedImage t_bufferedImage : a_image) {
                GlycanImageProvider.addImage(t_bufferedImage, t_positionY, t_result);
                t_positionY += t_bufferedImage.getHeight();
            }
            return t_result;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static Integer totalHeight(List<BufferedImage> a_image) {
        int t_total = 0;
        for (BufferedImage t_bufferedImage : a_image) {
            t_total += t_bufferedImage.getHeight();
        }
        return t_total;
    }

    private static Integer findMaxWidth(List<BufferedImage> a_image) {
        int t_max = 0;
        for (BufferedImage t_bufferedImage : a_image) {
            if (t_bufferedImage.getWidth() <= t_max) continue;
            t_max = t_bufferedImage.getWidth();
        }
        return t_max;
    }

    private static void addImage(BufferedImage a_bufferedImage, int a_positionY, BufferedImage a_image) {
        a_image.createGraphics().drawImage((Image)a_bufferedImage, 0, a_positionY, null);
    }

    public void addEventListener(IGRITSEventListener arg0) {
        if (!this.eventListeners.contains(arg0)) {
            this.eventListeners.add(arg0);
        }
    }

    public List<IGRITSEventListener> getEventListeners() {
        return this.eventListeners;
    }

    public void notifyListeners(int arg0) {
        for (IGRITSEventListener listener : this.eventListeners) {
            listener.handleEvent(arg0);
        }
    }

    public void removeEventListener(IGRITSEventListener arg0) {
        if (this.eventListeners.contains(arg0)) {
            this.eventListeners.remove(arg0);
        }
    }

    public class GlycanImageObject {
        private org.eclipse.swt.graphics.Image swtImage;
        private BufferedImage awtBufferedImage;
        private String sImageId = null;
        private boolean bIsOriginalSize;
        private double dScaleValX;
        private double dScaleValY;
        private Integer iHashCode = null;
        private boolean bBlock = false;

        public GlycanImageObject(String sImageId) {
            this.sImageId = sImageId;
        }

        public boolean isOriginalSize() {
            return this.bIsOriginalSize;
        }

        public void setIsOriginalSize(boolean bIsOriginalSize) {
            this.bIsOriginalSize = bIsOriginalSize;
        }

        public int hashCode() {
            if (this.iHashCode != null) {
                return this.iHashCode;
            }
            this.iHashCode = new Integer(this.sImageId.hashCode());
            return this.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GlycanImageObject)) {
                return false;
            }
            return ((GlycanImageObject)obj).sImageId.equals(this.sImageId);
        }

        public String toString() {
            return "Image: " + this.sImageId + ", original size: " + this.bIsOriginalSize;
        }

        public String getImageId() {
            return this.sImageId;
        }

        public void blockAccess() {
            this.bBlock = true;
        }

        public void releaseBlock() {
            this.bBlock = false;
        }

        private void setScaledImage(double dScaleValX, double dScaleValY) {
            double dScaleVal2;
            double dScaleVal1 = dScaleValX / (double)this.getAwtBufferedImage().getWidth();
            double dScaleVal = dScaleVal1 < (dScaleVal2 = dScaleValY / (double)this.getAwtBufferedImage().getHeight()) ? dScaleVal1 : dScaleVal2;
            int width = (int)((double)this.getAwtBufferedImage().getWidth() * dScaleVal);
            int height = (int)((double)this.getAwtBufferedImage().getHeight() * dScaleVal);
            Image newImage = this.getAwtBufferedImage().getScaledInstance(width, height, 16);
            this.dispose();
            this.awtBufferedImage = SimianImageConverter.convert(newImage);
            this.swtImage = SimianImageConverter.convert(this.awtBufferedImage);
            this.bIsOriginalSize = false;
            newImage.flush();
        }

        private void loadImageObjects() {
            boolean bShowRedEnd;
            List lGlycans = (List)GlycanImageProvider.this.getIdToGlycanList().get(this.sImageId);
            if (lGlycans == null) {
                return;
            }
            BufferedImage bImage = null;
            boolean bl = bShowRedEnd = this.sImageId.contains("cleavage") ? true : GlycanImageProvider.this.getCartoonOptions().isShowRedEnd();
            if (lGlycans.size() == 1) {
                bImage = SimianImageConverter.createCartoon((Glycan)lGlycans.get(0), GlycanImageProvider.this.getGlycanWorkspace(), GlycanImageProvider.this.getCartoonOptions().getImageScaleFactor(), GlycanImageProvider.this.getCartoonOptions().isShowMasses(), bShowRedEnd, true, 16);
            } else {
                ArrayList<BufferedImage> alList = new ArrayList<BufferedImage>();
                for (Glycan glycan : lGlycans) {
                    BufferedImage newImg = SimianImageConverter.createCartoon(glycan, GlycanImageProvider.this.getGlycanWorkspace(), GlycanImageProvider.this.getCartoonOptions().getImageScaleFactor(), GlycanImageProvider.this.getCartoonOptions().isShowMasses(), bShowRedEnd, true, 16);
                    alList.add(newImg);
                }
                bImage = GlycanImageProvider.createCombinedImage(alList);
            }
            this.awtBufferedImage = bImage;
            this.swtImage = SimianImageConverter.convert(this.awtBufferedImage);
            this.bIsOriginalSize = true;
            GlycanImageProvider glycanImageProvider = GlycanImageProvider.this;
            glycanImageProvider.iCreateCnt = glycanImageProvider.iCreateCnt + 1;
            int iCnt = 0;
            if (GlycanImageProvider.this.mCreateCnt.containsKey(this.sImageId)) {
                iCnt = (Integer)GlycanImageProvider.this.mCreateCnt.get(this.sImageId);
            }
            GlycanImageProvider.this.mCreateCnt.put(this.sImageId, ++iCnt);
        }

        public boolean isDisposed() {
            if (this.swtImage.isDisposed()) {
                return true;
            }
            return this.swtImage == null && this.awtBufferedImage == null;
        }

        public void dispose() {
            if (this.bBlock) {
                return;
            }
            if (this.swtImage != null) {
                this.swtImage.dispose();
                this.swtImage = null;
            }
            if (this.awtBufferedImage != null) {
                this.awtBufferedImage.flush();
                this.awtBufferedImage = null;
            }
            GlycanImageProvider glycanImageProvider = GlycanImageProvider.this;
            glycanImageProvider.iCreateCnt = glycanImageProvider.iCreateCnt - 1;
            int iCnt = 0;
            if (GlycanImageProvider.this.mDisposeCnt.containsKey(this.sImageId)) {
                iCnt = (Integer)GlycanImageProvider.this.mDisposeCnt.get(this.sImageId);
            }
            GlycanImageProvider.this.mDisposeCnt.put(this.sImageId, ++iCnt);
        }

        public BufferedImage getScaledAwtBufferedImage(double dScaleValX, double dScaleValY) {
            if (GlycanImageProvider.this.blockAccess) {
                return null;
            }
            if (this.awtBufferedImage != null && !this.isOriginalSize() && dScaleValX == this.dScaleValX && dScaleValY == this.dScaleValY) {
                if (GlycanImageProvider.this.getFromStack(this) == null) {
                    GlycanImageProvider.this.pushGlycanImageObject(this);
                }
                return this.awtBufferedImage;
            }
            this.setScaledImage(dScaleValX, dScaleValY);
            return this.awtBufferedImage;
        }

        public BufferedImage getAwtBufferedImage() {
            if (GlycanImageProvider.this.blockAccess) {
                return null;
            }
            GlycanImageObject gio = GlycanImageProvider.this.getFromStack(this);
            if (gio != null && gio.awtBufferedImage != null && gio.isOriginalSize()) {
                return gio.awtBufferedImage;
            }
            if (this.awtBufferedImage == null || !this.isOriginalSize()) {
                this.loadImageObjects();
            }
            GlycanImageProvider.this.pushGlycanImageObject(this);
            return this.awtBufferedImage;
        }

        public org.eclipse.swt.graphics.Image getSwtImage() {
            if (GlycanImageProvider.this.blockAccess) {
                return null;
            }
            GlycanImageObject gio = GlycanImageProvider.this.getFromStack(this);
            if (gio != null && gio.swtImage != null && gio.isOriginalSize()) {
                return gio.swtImage;
            }
            if (this.swtImage == null || !this.isOriginalSize()) {
                this.loadImageObjects();
            }
            GlycanImageProvider.this.pushGlycanImageObject(this);
            return this.swtImage;
        }
    }
}

