/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.tablehelpers;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.sort.SortStatePersistor;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreferenceLoader;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMAnnotation;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataProvider;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.datamodel.GRITSTableDataObject;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.tablecore.GRITSHeaderMenuConfiguration;
import org.grits.toolbox.display.control.table.tablecore.GRITSSingleClickConfiguration;
import org.grits.toolbox.display.control.table.tablecore.IGritsTable;
import org.grits.toolbox.entry.ms.annotation.command.MSAnnotationViewColumnChooserCommandHandler;
import org.grits.toolbox.entry.ms.annotation.command.ViewMSOverviewCommandExecutor;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.DoubleDataValidator;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.ExtCheckBoxPainter;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationCellOverrideLabelAccumulator;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationCellOverrideLabelAccumulatorForRowHeader;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationHeaderMenuConfiguration;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationSelectionTableHeaderMenuConfiguration;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTableDataChangedMessage;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.SharedCheckboxWidget;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationEntityScroller;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationPeaksView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationTableBase;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.tablehelpers.MassSpecTable;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecTableBase;
import org.grits.toolbox.ms.annotation.utils.AnnotationRowExtraction;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.osgi.framework.Bundle;

public class MSAnnotationTable
extends MassSpecTable {
    private static final Logger logger = Logger.getLogger(MSAnnotationTable.class);
    public static final Image LOCKED_IMAGE = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.grits.toolbox.entry.ms.annotation"), (IPath)new Path("icons" + File.separator + "lock.png"), null)).createImage();
    public static final Image LOCKED_GRAY_IMAGE = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.grits.toolbox.entry.ms.annotation"), (IPath)new Path("icons" + File.separator + "lock-gray.png"), null)).createImage();
    public static final Image UNLOCKED_IMAGE = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.grits.toolbox.entry.ms.annotation"), (IPath)new Path("icons" + File.separator + "lock-open.png"), null)).createImage();
    public static final String LOCKSELECTION_LABEL = "lockSelectionLabel";
    public static final String UNLOCKSELECTION_LABEL = "unlockSelectionLabel";
    public static final String CELLEDITOR_LABEL = "comment-editor";
    public static final String EDITORCONFIG_LABEL = "comment-config";
    private static final ImagePainter lockedPainter = new ImagePainter(LOCKED_IMAGE);
    private static final ImagePainter lockedGrayPainter = new ImagePainter(LOCKED_GRAY_IMAGE);
    private static final ImagePainter unlockedPainter = new ImagePainter(UNLOCKED_IMAGE);
    protected MSAnnotationTable parentTable = null;
    private String sParentTableRowId;
    private Integer iParentTableParentScanNum;
    private Integer iParentTableRowIndex;
    protected MSAnnotationTable currentSubsetTable = null;
    private String sCurrentTableRowId;
    private Integer iCurrentParentScanNum;
    private Integer iCurrentRowIndex;
    private boolean bHideUnannotated = false;
    private boolean bHideInvisible = false;
    protected SharedCheckboxWidget scw = null;
    protected boolean bLoadedSubset = false;
    protected boolean iParentTableNeedsScroll = false;

    public MSAnnotationTable(Composite parent, TableDataProcessor tableDataExtractor) {
        super(parent, tableDataExtractor);
    }

    public MSAnnotationTable(MSAnnotationTableBase parent, TableDataProcessor xmlExtractor) throws Exception {
        super(parent.getParent(), xmlExtractor);
        this.parentView = parent;
    }

    public MSAnnotationTable(Composite parent, MSAnnotationTable parentTable, int iParentRowIndex, int iParentScanNum, String sParentRowId) {
        super(parent, parentTable.getTableDataProcessor());
        this.sParentTableRowId = sParentRowId;
        this.iParentTableRowIndex = iParentRowIndex;
        this.iParentTableParentScanNum = iParentScanNum;
        this.parentTable = parentTable;
        this.parentView = null;
        this.scw = new SharedCheckboxWidget();
    }

    public void performAutoResize() {
        super.performAutoResize();
        if (this.getParentTableNeedsScroll() && this.getLastMouseDownRow() != -1) {
            this.moveRowIntoViewport(this.getLastMouseDownRow());
            int iSize = this.getViewportLayer().getRowCount();
            int iRowPostion = LayerUtil.convertRowPosition((ILayer)this.getBottomDataLayer(), (int)this.getLastMouseDownRow(), (IUniqueIndexLayer)this.getViewportLayer());
            int iDelta = iSize / 2 - iRowPostion;
            this.moveRowIntoViewport(this.getLastMouseDownRow() - iDelta);
            this.setParentTableNeedsScroll(false);
        }
    }

    public boolean getParentTableNeedsScroll() {
        return this.iParentTableNeedsScroll;
    }

    public void setParentTableNeedsScroll(boolean iParentTableNeedsScroll) {
        this.iParentTableNeedsScroll = iParentTableNeedsScroll;
    }

    public SharedCheckboxWidget getSharedCheckboxWidget() {
        return this.scw;
    }

    protected MSAnnotationMultiPageViewer getParentMultiPageViewer() {
        Entry parentEntry = this.parentView.getEntry().getParent();
        MSAnnotationMultiPageViewer viewer = MSAnnotationMultiPageViewer.getActiveViewerForEntry(this.parentView.getParentEditor().getContext(), parentEntry);
        return viewer;
    }

    public Integer getParentTableRowIndex() {
        return this.iParentTableRowIndex;
    }

    public String getParentTableRowId() {
        return this.sParentTableRowId;
    }

    public void setParentTableRowId(String sParentTableRowId) {
        this.sParentTableRowId = sParentTableRowId;
    }

    public Integer getParentTableParentScanNum() {
        return this.iParentTableParentScanNum;
    }

    public void setParentTableScanNum(Integer iParentScanNum) {
        this.iParentTableParentScanNum = iParentScanNum;
    }

    public String getCurrentRowId() {
        return this.sCurrentTableRowId;
    }

    public void setCurrentRowId(String sCurrentTableRowId) {
        this.sCurrentTableRowId = sCurrentTableRowId;
    }

    public Integer getCurrentParentScanNum() {
        return this.iCurrentParentScanNum;
    }

    public void setCurrentParentScanNum(Integer iCurrentParentScanNum) {
        this.iCurrentParentScanNum = iCurrentParentScanNum;
    }

    public Integer getCurrentRowIndex() {
        return this.iCurrentRowIndex;
    }

    public void setCurrentRowIndex(Integer iCurrentRowIndex) {
        this.iCurrentRowIndex = iCurrentRowIndex;
    }

    public void reInit(Composite parent, MSAnnotationTable parentTable, int iParentRowIndex, int iParentScanNum, String sParentRowId) {
        this.sParentTableRowId = sParentRowId;
        this.iParentTableRowIndex = iParentRowIndex;
        this.iParentTableParentScanNum = iParentScanNum;
        this.parentTable = parentTable;
        this.setMzXMLPathName(parentTable.getMzXMLPathName());
        this.createSubsetTable();
        this.parentView = null;
    }

    protected void initCornerLayer() {
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.columnHeaderDataProvider, (IDataProvider)this.rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        this.cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)this.rowHeaderLayer, (ILayer)this.sortHeaderLayer){

            public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
                if (MSAnnotationTable.this.bLoadedSubset) {
                    Integer iPeakId = (Integer)MSAnnotationTable.this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)MSAnnotationTable.this.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), rowPosition);
                    Integer iScan = null;
                    if (!MSAnnotationTable.this.getMyTableDataObject().getScanNoCols().isEmpty() && ((GRITSListDataRow)MSAnnotationTable.this.getGRITSTableDataObject().getTableData().get(rowPosition)).getDataRow().get((Integer)MSAnnotationTable.this.getMyTableDataObject().getScanNoCols().get(0)) != null) {
                        iScan = (Integer)((GRITSListDataRow)MSAnnotationTable.this.getGRITSTableDataObject().getTableData().get(rowPosition)).getDataRow().get((Integer)MSAnnotationTable.this.getMyTableDataObject().getScanNoCols().get(0));
                    }
                    int parentScanNo = MSAnnotationTable.this.getParentScanNumberFromTable(MSAnnotationTable.this.parentTable.getParentView(), 0);
                    if (iPeakId != null) {
                        String sRowId = Feature.getRowId((Integer)iPeakId, iScan);
                        boolean isLocked = MSAnnotationTable.this.parentTable.getGRITSTableDataObject().isLockedPeak(Integer.valueOf(parentScanNo), sRowId);
                        if (isLocked) {
                            return lockedPainter;
                        }
                    }
                    return unlockedPainter;
                }
                return super.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
            }
        };
    }

    protected void registerLockedIcons(ConfigRegistry configRegistry) {
        CellPainterDecorator locked = new CellPainterDecorator((ICellPainter)new TextPainter(), CellEdgeEnum.BOTTOM_RIGHT, (ICellPainter)lockedGrayPainter);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)locked, "NORMAL", LOCKSELECTION_LABEL);
    }

    public MSAnnotationTable getCurrentSubsetTable() {
        return this.currentSubsetTable;
    }

    public void setCurrentSubsetTable(MSAnnotationTable currentSubsetTable) {
        this.currentSubsetTable = currentSubsetTable;
    }

    public void createMainTable() throws Exception {
        try {
            this.setSimDataObject((GRITSTableDataObject)((MSAnnotationTableDataProcessor)this.getTableDataProcessor()).getSimianTableDataObject());
            this.initCommonTableComponents();
            this.initColumnChooserLayer();
            this.registerDataUpdateHandler();
            this.registerLockedIcons(this.configRegistry);
            this.registerEditableColumns(this.configRegistry);
            this.updateEventListForVisibility();
            this.updateRowVisibilityAfterRead();
            this.bLoadedSubset = false;
            this.finishNatTable();
            this.performAutoResizeAfterPaint();
            this.initialSort();
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing table.");
            throw new Exception(e.getMessage());
        }
    }

    protected void registerDataUpdateHandler() {
        this.dataLayer.unregisterCommandHandler(UpdateDataCommand.class);
        this.dataLayer.registerCommandHandler((ILayerCommandHandler)new UpdateDataCommandHandler(this.dataLayer){

            protected boolean doCommand(UpdateDataCommand command) {
                int columnPosition = command.getColumnPosition();
                int rowPosition = command.getRowPosition();
                Integer commentCol = null;
                if (MSAnnotationTable.this.getMyTableDataObject().getCommentCols() != null && !MSAnnotationTable.this.getMyTableDataObject().getCommentCols().isEmpty()) {
                    commentCol = (Integer)MSAnnotationTable.this.getMyTableDataObject().getCommentCols().get(0);
                }
                Integer ratioCol = null;
                if (MSAnnotationTable.this.getMyTableDataObject().getRatioCols() != null && !MSAnnotationTable.this.getMyTableDataObject().getRatioCols().isEmpty()) {
                    ratioCol = (Integer)MSAnnotationTable.this.getMyTableDataObject().getRatioCols().get(0);
                }
                GRITSListDataRow backendRowData = MSAnnotationTable.this.bodyDataProvider.getGRITSListDataRow(rowPosition);
                int rowIndex = MSAnnotationTable.this.getSourceIndexFromRowId(backendRowData.getId());
                int eventRowIdx = MSAnnotationTable.this.getNatIndexFromSourceIndex(rowIndex);
                GRITSListDataRow rowData = (GRITSListDataRow)MSAnnotationTable.this.getGRITSTableDataObject().getTableData().get(rowIndex);
                GRITSListDataRow eventRowData = (GRITSListDataRow)MSAnnotationTable.this.eventList.get(eventRowIdx);
                if (commentCol != null && columnPosition == commentCol) {
                    rowData.getDataRow().set(commentCol, command.getNewValue());
                    eventRowData.getDataRow().set(commentCol, command.getNewValue());
                }
                if (ratioCol != null && columnPosition == ratioCol) {
                    rowData.getDataRow().set(ratioCol, command.getNewValue());
                    eventRowData.getDataRow().set(ratioCol, command.getNewValue());
                }
                Integer parentScanNo = MSAnnotationTable.this.getParentScanNumberFromTable(MSAnnotationTable.this.getParentView(), rowPosition);
                MSAnnotationTableDataProcessor tdp = (MSAnnotationTableDataProcessor)MSAnnotationTable.this.getTableDataProcessor();
                tdp.addDirtyParentScan(parentScanNo);
                MSAnnotationTable.this.getParentView().setDirty(true);
                return true;
            }
        });
    }

    protected void registerEditableColumns(ConfigRegistry configRegistry) {
        TextCellEditor textCellEditor = new TextCellEditor();
        textCellEditor.setErrorDecorationEnabled(true);
        textCellEditor.setErrorDecorationText("Ratio should be a floating point number");
        textCellEditor.setDecorationPositionOverride(16512);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)textCellEditor, "NORMAL", CELLEDITOR_LABEL + DMAnnotation.annotation_ratio.name());
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(), "NORMAL", CELLEDITOR_LABEL + TableDataProcessor.commentColHeader.getKeyValue());
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)new DoubleDataValidator(), "EDIT", EDITORCONFIG_LABEL + DMAnnotation.annotation_ratio.name());
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)this.getEditableRuleForColumn(DMAnnotation.annotation_ratio.name()), "EDIT", EDITORCONFIG_LABEL + DMAnnotation.annotation_ratio.name());
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)this.getEditableRuleForColumn(TableDataProcessor.commentColHeader.getKeyValue()), "EDIT", EDITORCONFIG_LABEL + TableDataProcessor.commentColHeader.getKeyValue());
    }

    protected void initialSort() {
        if (((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols() != null && !((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().isEmpty()) {
            int iScanNumIndex = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0);
            this.getSortModel().sort(iScanNumIndex, SortDirectionEnum.ASC, false);
        }
    }

    protected boolean addUnrecognizedHeadersToSubsetTable(MSAnnotationViewerPreference parentPref, MSAnnotationViewerPreference pref) {
        boolean bChanged = false;
        for (GRITSColumnHeader parentHeader : parentPref.getPreferenceSettings().getHeaders()) {
            if (pref.getPreferenceSettings().hasColumn(parentHeader.getKeyValue())) continue;
            pref.getPreferenceSettings().addColumn(parentHeader);
            bChanged = true;
        }
        return bChanged;
    }

    public void createSubsetTable() {
        try {
            this.loadDataFromParent();
            MSAnnotationViewerPreference parentPref = (MSAnnotationViewerPreference)this.parentTable.getPreference();
            MSAnnotationViewerPreference pref = MSAnnotationViewerPreferenceLoader.getTableViewerPreference((int)parentPref.getMSLevel(), (FillTypes)FillTypes.Selection);
            if (pref.getPreferenceSettings() == null) {
                pref.setPreferenceSettings(parentPref.getPreferenceSettings());
                pref.writePreference();
            } else {
                boolean bUpdate = this.addUnrecognizedHeadersToSubsetTable(parentPref, pref);
                if (bUpdate) {
                    pref.writePreference();
                }
            }
            this.setPreference((MassSpecViewerPreference)pref);
            this.initCommonTableComponents();
            this.initColumnChooserLayer();
            this.registerSelectedCheckbox((IConfigRegistry)this.configRegistry, this.getCheckboxEditableRule());
            this.bLoadedSubset = true;
            this.finishNatTable();
            this.performAutoResizeAfterPaint();
            this.parentTable.setCurrentSubsetTable(this);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create subset table.", (Throwable)e);
        }
    }

    protected IEditableRule getEditableRuleForColumn(final String column) {
        IEditableRule rule = new IEditableRule(){

            public boolean isEditable(int arg0, int arg1) {
                return arg0 == arg1;
            }

            public boolean isEditable(ILayerCell arg0, IConfigRegistry arg1) {
                if (column.equals(DMAnnotation.annotation_ratio.name())) {
                    int iCurMSLevel = ((MassSpecEntityProperty)MSAnnotationTable.this.parentView.getEntityProperty()).getMsLevel();
                    if (iCurMSLevel > 2) {
                        return false;
                    }
                    if (MSAnnotationTable.this.getMyTableDataObject().getFeatureIdCols() == null || MSAnnotationTable.this.getMyTableDataObject().getFeatureIdCols().isEmpty()) {
                        return false;
                    }
                    Object featureId = MSAnnotationTable.this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)MSAnnotationTable.this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), arg0.getRowIndex());
                    return featureId != null;
                }
                return true;
            }
        };
        return rule;
    }

    protected IEditableRule getCheckboxEditableRule() {
        IEditableRule rule = new IEditableRule(){

            public boolean isEditable(int arg0, int arg1) {
                return arg0 == arg1;
            }

            public boolean isEditable(ILayerCell arg0, IConfigRegistry arg1) {
                if (MSAnnotationTable.this.getBottomDataLayer().getDataValueByPosition(arg0.getColumnIndex(), arg0.getRowIndex()) != null) {
                    Integer iParentScanNum = MSAnnotationTable.this.getParentScanNumberFromTable(MSAnnotationTable.this.parentTable.getParentView(), 0);
                    Integer iPeakId = (Integer)MSAnnotationTable.this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)MSAnnotationTable.this.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), 0);
                    if (iParentScanNum != null && iPeakId != null) {
                        Integer iScan = null;
                        if (!MSAnnotationTable.this.getMyTableDataObject().getScanNoCols().isEmpty() && ((GRITSListDataRow)MSAnnotationTable.this.getGRITSTableDataObject().getTableData().get(0)).getDataRow().get((Integer)MSAnnotationTable.this.getMyTableDataObject().getScanNoCols().get(0)) != null) {
                            iScan = (Integer)((GRITSListDataRow)MSAnnotationTable.this.getGRITSTableDataObject().getTableData().get(0)).getDataRow().get((Integer)MSAnnotationTable.this.getMyTableDataObject().getScanNoCols().get(0));
                        }
                        String sRowId = Feature.getRowId((Integer)iPeakId, iScan);
                        if (!MSAnnotationTable.this.parentTable.getGRITSTableDataObject().isLockedPeak(iParentScanNum, sRowId)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                return false;
            }
        };
        return rule;
    }

    protected boolean addHeaderListeners() {
        return !this.bLoadedSubset;
    }

    protected void initColumnChooserLayer() {
        MSAnnotationViewColumnChooserCommandHandler columnChooserCommandHandler = new MSAnnotationViewColumnChooserCommandHandler((IGritsTable)this);
        this.columnGroupHeaderLayer.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
    }

    public void setHideUnannotated(boolean bHideUnannotated) {
        this.bHideUnannotated = bHideUnannotated;
    }

    public void setHideInvisible(boolean bHideInvisible) {
        this.bHideInvisible = bHideInvisible;
    }

    protected void hideRows(List<Integer> alHiddenRows) {
        super.hideRows(alHiddenRows);
        if (this.isEmpty()) {
            logger.debug((Object)"No annotated rows! Adding an empty one");
            GRITSListDataRow blankRow = TableDataProcessor.getNewRow((int)this.getGRITSTableDataObject().getLastHeader().size(), (int)0);
            GRITSColumnHeader firstCol = this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getColumnAtVisColInx(Integer.valueOf(0));
            int iTableFirstCol = this.getGRITSTableDataObject().getLastHeader().indexOf(firstCol);
            blankRow.getDataRow().set(iTableFirstCol, "No annotated rows");
            this.eventList.add((Object)blankRow);
        }
    }

    public boolean hideUnannotated() {
        return this.bHideUnannotated;
    }

    public boolean getHideInvisible() {
        return this.bHideInvisible;
    }

    public void hideUnannotatedRows() {
        this.setHideUnannotated(true);
        this.finishUpdateHiddenRowsAfterEdit(false);
    }

    public void showUnannotatedRows() {
        this.setHideUnannotated(false);
        this.finishUpdateHiddenRowsAfterEdit(false);
    }

    private MSAnnotationTableDataObject getMyTableDataObject() {
        return (MSAnnotationTableDataObject)this.getGRITSTableDataObject();
    }

    private MSAnnotationTableDataObject getMSAnnotationTableDataObject(MSAnnotationTable _table) {
        return (MSAnnotationTableDataObject)_table.getGRITSTableDataObject();
    }

    protected void loadDataFromParent() {
        boolean bCheckParentScan = !((MSAnnotationTableDataProcessor)this.getTableDataProcessor()).getMethod().getMsType().equals("Direct Infusion");
        this.setSimDataObject((GRITSTableDataObject)this.getMSAnnotationTableDataObject(this.parentTable).getSubsetSimianTableDataObject(this.getParentTableParentScanNum().intValue(), this.getParentTableRowId(), bCheckParentScan));
    }

    public void initCellAccumulator() {
        MSAnnotationCellOverrideLabelAccumulator cellLabelAccumulator = null;
        MSAnnotationCellOverrideLabelAccumulatorForRowHeader rowHeaderCellAccumulator = null;
        Integer filterCol = null;
        if (this.getMyTableDataObject().getFilterCols() != null && !this.getMyTableDataObject().getFilterCols().isEmpty()) {
            filterCol = (Integer)this.getMyTableDataObject().getFilterCols().get(0);
        }
        Integer commentCol = null;
        if (this.getMyTableDataObject().getCommentCols() != null && !this.getMyTableDataObject().getCommentCols().isEmpty()) {
            commentCol = (Integer)this.getMyTableDataObject().getCommentCols().get(0);
        }
        Integer ratioCol = null;
        if (this.getMyTableDataObject().getRatioCols() != null && !this.getMyTableDataObject().getRatioCols().isEmpty()) {
            ratioCol = (Integer)this.getMyTableDataObject().getRatioCols().get(0);
        }
        if (this.parentTable == null) {
            List intensityCols = this.getAllIntensityColumns(null);
            cellLabelAccumulator = new MSAnnotationCellOverrideLabelAccumulator(this.bodyDataProvider, null, filterCol, commentCol, ratioCol, intensityCols);
            rowHeaderCellAccumulator = new MSAnnotationCellOverrideLabelAccumulatorForRowHeader(this.bodyDataProvider, this, 0);
        } else {
            List intensityCols = this.getAllIntensityColumns(1);
            cellLabelAccumulator = new MSAnnotationCellOverrideLabelAccumulator(this.bodyDataProvider, 0, filterCol, commentCol, ratioCol, intensityCols);
        }
        this.dataLayer.setConfigLabelAccumulator(cellLabelAccumulator);
        if (rowHeaderCellAccumulator != null) {
            this.rowHeaderDataLayer.setConfigLabelAccumulator(rowHeaderCellAccumulator);
        }
    }

    protected void updateEventListForVisibility() {
        if (this.getGRITSTableDataObject().getTableData() == null || this.getGRITSTableDataObject().getTableData().isEmpty() || this.getMyTableDataObject().getPeakIdCols().isEmpty()) {
            return;
        }
        try {
            int iStartCol = this.getTableDataProcessor().getLastVisibleCol();
            int i = 0;
            while (i < this.getGRITSTableDataObject().getTableData().size()) {
                if (((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getPeakIdCols().get(0)) != null) {
                    Integer iParentScanNum = this.getScanNumberForVisibility(this.getMyTableDataObject(), i);
                    Integer iPeakId = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getPeakIdCols().get(0));
                    int iNatIndex = this.getNatIndexFromSourceIndex(i);
                    if (iNatIndex >= 0 && iNatIndex < this.eventList.size()) {
                        Integer iScan = null;
                        if (!this.getMyTableDataObject().getScanNoCols().isEmpty() && ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getScanNoCols().get(0)) != null) {
                            iScan = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getScanNoCols().get(0));
                        }
                        String sRowId = Feature.getRowId((Integer)iPeakId, iScan);
                        boolean bInvisible = this.getGRITSTableDataObject().isInvisibleRow(iParentScanNum, sRowId);
                        GRITSListDataRow eventRowData = (GRITSListDataRow)this.eventList.get(iNatIndex);
                        GRITSListDataRow backendRowData = (GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i);
                        int iCol = iStartCol;
                        while (iCol < eventRowData.getDataRow().size()) {
                            Object eventObj = eventRowData.getDataRow().get(iCol);
                            Object backendObj = backendRowData.getDataRow().get(iCol);
                            if (backendObj != null) {
                                if (!backendObj.equals(eventObj) && !bInvisible) {
                                    eventRowData.getDataRow().set(iCol, backendObj);
                                } else if (backendObj.equals(eventObj) && bInvisible) {
                                    eventRowData.getDataRow().set(iCol, null);
                                }
                            }
                            ++iCol;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in GRITStable:updateEventListForVisibility.", (Throwable)ex);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        Object obj;
        logger.debug((Object)"Double click on the table");
        if (this.parentTable != null) {
            return;
        }
        if (this.getMyTableDataObject().getScanNoCols().isEmpty()) {
            return;
        }
        if (this.getMzXMLPathName() == null) {
            return;
        }
        GridLayer gl = (GridLayer)this.getLayer();
        int origRow = gl.getRowPositionByY(e.y);
        if (origRow < 2) {
            return;
        }
        int origCol = gl.getColumnPositionByX(e.x);
        if (origCol < 1) {
            return;
        }
        int iRowPostion = LayerUtil.convertRowPosition((ILayer)gl, (int)origRow, (IUniqueIndexLayer)this.getBottomDataLayer());
        int iColPostion = LayerUtil.convertColumnPosition((ILayer)gl, (int)origCol, (IUniqueIndexLayer)this.getBottomDataLayer());
        int iScanNum = -1;
        int iAnnotId = -1;
        String sFeatureId = null;
        double dMz = 0.0;
        Integer iParentScan = -1;
        if (this.hasColumnGroupHeader()) {
            obj = this.getBottomDataLayer().getDataValueByPosition(iColPostion, iRowPostion);
            if (obj == null) {
                return;
            }
            try {
                iScanNum = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                return;
            }
            if (iScanNum == -1) {
                return;
            }
            this.getMyTableDataObject().getScanNoCols().indexOf(iScanNum);
        } else {
            obj = this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getScanNoCols().get(0)).intValue(), iRowPostion);
            if (obj == null) {
                return;
            }
            try {
                iScanNum = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                return;
            }
            if (!this.getMyTableDataObject().getMzCols().isEmpty()) {
                Object obj2 = this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getMzCols().get(0)).intValue(), iRowPostion);
                try {
                    dMz = Double.parseDouble(obj2.toString());
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    return;
                }
            }
            if (this.getMyTableDataObject().getAnnotationIdCols() != null && !this.getMyTableDataObject().getAnnotationIdCols().isEmpty() && (obj = this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getAnnotationIdCols().get(0)).intValue(), iRowPostion)) != null) {
                try {
                    iAnnotId = Integer.parseInt(obj.toString());
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    return;
                }
            }
            if (this.getMyTableDataObject().getFeatureIdCols() != null && !this.getMyTableDataObject().getFeatureIdCols().isEmpty() && (obj = this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getFeatureIdCols().get(0)).intValue(), iRowPostion)) != null) {
                try {
                    sFeatureId = obj.toString();
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    return;
                }
            }
            iParentScan = -1;
            if (this.getMyTableDataObject().getParentNoCol() != null && !this.getMyTableDataObject().getParentNoCol().isEmpty() && (obj = this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getParentNoCol().get(0)).intValue(), iRowPostion)) != null && !obj.toString().equals("")) {
                try {
                    iParentScan = (Integer)obj;
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        int iCurMSLevel = ((MassSpecEntityProperty)this.parentView.getEntityProperty()).getMsLevel();
        this.performDoubleClickOnScan(iScanNum, dMz, iAnnotId, sFeatureId, iCurMSLevel, iParentScan);
    }

    protected Entry getNewTableCompatibleEntry(Entry parentEntry) {
        Entry newEntry = MSAnnotationEntityProperty.getTableCompatibleEntry(parentEntry);
        return newEntry;
    }

    public void performDoubleClickOnScan(int iScanNum, double dMz, int iAnnotId, String sFeatureId, int iMSLevel, Integer iParentScan) {
        this.parentView.getEntry().getParent().getDisplayName();
        int iParentScanNum = -1;
        double dParentMz = 0.0;
        String sParentFeatureId = null;
        if (this.parentView.getEntry().getProperty() instanceof MSAnnotationEntityProperty) {
            iParentScanNum = ((MSAnnotationEntityProperty)this.parentView.getEntry().getProperty()).getScanNum();
            dParentMz = ((MSAnnotationEntityProperty)this.parentView.getEntry().getProperty()).getMz();
            sParentFeatureId = ((MSAnnotationEntityProperty)this.parentView.getEntry().getProperty()).getFeatureId();
        }
        if (iParentScan != null) {
            iParentScanNum = iParentScan;
        }
        Entry newEntry = this.getNewTableCompatibleEntry(this.parentView.getEntry());
        MassSpecEntityProperty msEntityProp = (MassSpecEntityProperty)newEntry.getProperty();
        msEntityProp.setParentScanNum(Integer.valueOf(iParentScanNum));
        msEntityProp.setScanNum(Integer.valueOf(iScanNum));
        msEntityProp.setMz(Double.valueOf(dMz));
        msEntityProp.setParentMz(Double.valueOf(dParentMz));
        ((MSAnnotationEntityProperty)this.parentView.getEntry().getProperty()).setParentFeatureId(sParentFeatureId);
        msEntityProp.setDataFile(((MSAnnotationEntityProperty)this.parentView.getEntry().getProperty()).getDataFile());
        msEntityProp.setMsLevel(Integer.valueOf(iMSLevel + 1));
        StringBuilder sb = new StringBuilder(newEntry.getDisplayName());
        if (dMz == 0.0) {
            sb.append(": ");
        } else {
            sb.append("->");
        }
        sb.append("[Scan ");
        sb.append(iScanNum);
        sb.append(", MS");
        sb.append(iMSLevel);
        if (dMz > 0.0) {
            sb.append(", ");
            sb.append(dMz);
        }
        if (iMSLevel > 2) {
            sb.append(", ");
            sb.append(iAnnotId);
        }
        sb.append("]");
        newEntry.setDisplayName(sb.toString());
        if (newEntry.getProperty() instanceof MSAnnotationEntityProperty) {
            MSAnnotationEntityProperty msAnnotEntityProp = (MSAnnotationEntityProperty)newEntry.getProperty();
            msAnnotEntityProp.setAnnotationId(iAnnotId);
            msAnnotEntityProp.setFeatureId(sFeatureId);
        }
        this.showMSOverview(newEntry);
    }

    protected void showMSOverview(Entry newEntry) {
        ViewMSOverviewCommandExecutor.showMSOverview(this.parentView.getParentEditor().getContext(), newEntry);
    }

    public void mouseDown(MouseEvent e) {
        if (e.count > 1 || this.parentTable != null || this.hasColumnGroupHeader()) {
            return;
        }
        if (this.getMyTableDataObject().getMSLevel() == 1) {
            return;
        }
        GridLayer gl = (GridLayer)this.getLayer();
        int origRow = gl.getRowPositionByY(e.y);
        if (origRow < 2) {
            return;
        }
        int origCol = gl.getColumnPositionByX(e.x);
        if (origCol < 1) {
            return;
        }
        int iRowPostion = LayerUtil.convertRowPosition((ILayer)gl, (int)origRow, (IUniqueIndexLayer)this.getBottomDataLayer());
        this.performMouseDown(iRowPostion);
    }

    public void performMouseDown(int iRowPostion) {
        GRITSListDataRow row = ((GRITSListDataProvider)this.getBottomDataLayer().getDataProvider()).getGRITSListDataRow(iRowPostion);
        Object obj = this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getPeakIdCols().get(0)).intValue(), iRowPostion);
        if (obj == null) {
            return;
        }
        int iPeakId = -1;
        try {
            iPeakId = (Integer)obj;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return;
        }
        int iScanNum = -1;
        if (this.getMyTableDataObject().getScanNoCols() != null && !this.getMyTableDataObject().getScanNoCols().isEmpty() && this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getScanNoCols().get(0)).intValue(), iRowPostion) != null) {
            Integer iScan = (Integer)this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getScanNoCols().get(0)).intValue(), iRowPostion);
            iScanNum = iScan;
        }
        int iRowIndex = this.getSourceIndexFromRowId(row.getId());
        String sRowId = Feature.getRowId((Integer)iPeakId, (Integer)iScanNum);
        Integer iParentScan = this.getScanNumberForVisibility(this, iRowIndex);
        this.setCurrentRowIndex(iRowIndex);
        this.setCurrentRowId(sRowId);
        this.setCurrentParentScanNum(iParentScan);
        this.setLastMouseDownRow(iRowPostion);
        this.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)this.selectionLayer, 0, iRowPostion, false, false));
        this.openRowSelection(iRowIndex, iParentScan, sRowId);
    }

    protected void openRowSelection(int iSourceRowIndex, int iSourceParentScanNum, String sSourceParentRowId) {
        MSAnnotationPeaksView.showRowSelection(this.parentView.getParentEditor().getContext(), this.parentView.getEntry(), this, iSourceRowIndex, iSourceParentScanNum, sSourceParentRowId);
    }

    public void mouseUp(MouseEvent e) {
    }

    public int getScanNumberForVisibility(MSAnnotationTable table, int i) {
        MSAnnotationTableDataObject tdo = (MSAnnotationTableDataObject)table.getGRITSTableDataObject();
        return this.getScanNumberForVisibility(tdo, i);
    }

    public int getScanNumberForVisibility(MSAnnotationTableDataObject tdo, int i) {
        if (this.parentView == null || (MassSpecEntityProperty)this.parentView.getEntityProperty() == null || ((MassSpecEntityProperty)this.parentView.getEntityProperty()).getMsLevel() == null) {
            return -1;
        }
        int iCurMSLevel = ((MassSpecEntityProperty)this.parentView.getEntityProperty()).getMsLevel();
        if (iCurMSLevel < 3 && ((MSAnnotationTableDataProcessor)this.getTableDataProcessor()).getMethod().getMsType().equals("Direct Infusion")) {
            return ((MSAnnotationTableDataProcessor)this.getTableDataProcessor()).getGRITSdata().getFirstMS1Scan();
        }
        if (i < 0) {
            return -1;
        }
        Integer iParentScanNum = null;
        if (tdo.getParentNoCol() != null && !tdo.getParentNoCol().isEmpty() && ((GRITSListDataRow)tdo.getTableData().get(i)).getDataRow().get((Integer)tdo.getParentNoCol().get(0)) != null) {
            iParentScanNum = (Integer)((GRITSListDataRow)tdo.getTableData().get(i)).getDataRow().get((Integer)tdo.getParentNoCol().get(0));
        }
        if (iParentScanNum == null) {
            return -1;
        }
        return iParentScanNum;
    }

    public boolean startUpdateHiddenRowsAfterEdit(MSAnnotationTable subsetTable) {
        if (this.hasColumnGroupHeader()) {
            return false;
        }
        Hashtable<Integer, Hashtable> htScanToFirstAnnotation = new Hashtable<Integer, Hashtable>();
        Hashtable<Integer, ArrayList> htAtLeastOne = new Hashtable<Integer, ArrayList>();
        boolean isDirty = false;
        int iNumRows = subsetTable.getBottomDataLayer().getRowCount();
        if (iNumRows == 0) {
            return false;
        }
        MSAnnotationTableDataProcessor tdp = (MSAnnotationTableDataProcessor)this.getTableDataProcessor();
        int i = 0;
        while (i < iNumRows) {
            if (subsetTable.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)subsetTable.getGRITSTableDataObject()).getParentNoCol().get(0)).intValue(), i) != null && subsetTable.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)subsetTable.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i) != null && subsetTable.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)subsetTable.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i) != null) {
                boolean bCurHidden;
                Integer iParentScanNum = this.getScanNumberForVisibility(subsetTable, i);
                Integer iScanNum = null;
                if (subsetTable.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)subsetTable.getGRITSTableDataObject()).getScanNoCols().get(0)).intValue(), i) != null) {
                    iScanNum = (Integer)subsetTable.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)subsetTable.getGRITSTableDataObject()).getScanNoCols().get(0)).intValue(), i);
                }
                Integer iPeakId = (Integer)subsetTable.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)subsetTable.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i);
                String sFeature = subsetTable.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)subsetTable.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i).toString();
                String sRowId = Feature.getRowId((Integer)iPeakId, (Integer)iScanNum);
                boolean bPrevInvisible = this.getGRITSTableDataObject().isInvisibleRow(iParentScanNum, sRowId);
                boolean bPrevHidden = this.getGRITSTableDataObject().isHiddenRow(iParentScanNum, sRowId, sFeature);
                boolean bl = bCurHidden = (Boolean)subsetTable.getBottomDataLayer().getDataValueByPosition(0, i) == false;
                if (!bCurHidden) {
                    this.getGRITSTableDataObject().removeHiddenRow(iParentScanNum, sRowId, sFeature);
                    if (bPrevInvisible || bPrevHidden) {
                        int rowIndex = this.locateRowInParentTable(sFeature, iPeakId);
                        this.updateFilterVal(rowIndex, true, true);
                        Integer filterVal = this.getFilterVal(rowIndex, true);
                        if (filterVal != null && filterVal < 10) {
                            this.adjustFilterVal(rowIndex, iParentScanNum, sRowId, iScanNum, true);
                        }
                        isDirty = true;
                    }
                } else if (bCurHidden) {
                    this.getGRITSTableDataObject().setHiddenRow(iParentScanNum, sRowId, sFeature);
                    if (!bPrevHidden || !bPrevInvisible) {
                        int rowIndex = this.locateRowInParentTable(sFeature, iPeakId);
                        this.updateFilterVal(rowIndex, false, true);
                        isDirty = true;
                    }
                }
                if (isDirty) {
                    tdp.addDirtyParentScan(iParentScanNum);
                    String sHeaderKey = MSAnnotationEntityScroller.getCombinedKeyForLookup(iPeakId, sFeature);
                    boolean bChecked = (Boolean)subsetTable.getBottomDataLayer().getDataValueByPosition(0, i);
                    SharedCheckboxWidget scw = subsetTable.getSharedCheckboxWidget();
                    ExtCheckBoxPainter ecbp = scw.getHtGlycanToCheckBox().get(sHeaderKey);
                    ecbp.setCurStatus(bChecked);
                    this.getGRITSTableDataObject().addManuallyChangedPeak(iParentScanNum, sRowId);
                    subsetTable.notifyListeners(iParentScanNum, iPeakId, sFeature);
                }
                if (sFeature != null) {
                    if (!bCurHidden) {
                        ArrayList alAtLeastOne = null;
                        if (!htAtLeastOne.containsKey(iParentScanNum)) {
                            alAtLeastOne = new ArrayList();
                            htAtLeastOne.put(iParentScanNum, alAtLeastOne);
                        } else {
                            alAtLeastOne = (ArrayList)htAtLeastOne.get(iParentScanNum);
                        }
                        alAtLeastOne.add(sRowId);
                    }
                    Hashtable htPeakToFeature = null;
                    if (!htScanToFirstAnnotation.containsKey(iParentScanNum)) {
                        htPeakToFeature = new Hashtable();
                        htScanToFirstAnnotation.put(iParentScanNum, htPeakToFeature);
                    } else {
                        htPeakToFeature = (Hashtable)htScanToFirstAnnotation.get(iParentScanNum);
                    }
                    if (!htPeakToFeature.containsKey(sRowId)) {
                        htPeakToFeature.put(sRowId, sFeature);
                    }
                }
            }
            ++i;
        }
        for (Integer iParentScanNum : htScanToFirstAnnotation.keySet()) {
            Hashtable htPeakToFeature = (Hashtable)htScanToFirstAnnotation.get(iParentScanNum);
            ArrayList alAtLeastOne = (ArrayList)htAtLeastOne.get(iParentScanNum);
            for (String iCurRowId : htPeakToFeature.keySet()) {
                if (alAtLeastOne == null || !alAtLeastOne.contains(iCurRowId)) {
                    this.getGRITSTableDataObject().removeHiddenRow(iParentScanNum, iCurRowId, (String)htPeakToFeature.get(iCurRowId));
                    if (this.getGRITSTableDataObject().isInvisibleRow(iParentScanNum, iCurRowId)) continue;
                    this.getGRITSTableDataObject().addInvisibleRow(iParentScanNum, iCurRowId);
                    continue;
                }
                if (!this.getGRITSTableDataObject().isInvisibleRow(iParentScanNum, iCurRowId)) continue;
                this.getGRITSTableDataObject().removeInvisibleRow(iParentScanNum, iCurRowId);
            }
        }
        return isDirty;
    }

    public void finishUpdateHiddenRowsAfterEdit(boolean isDirty) {
        this.updateRowVisibilityAfterRead();
        this.updateEventListForVisibility();
        this.reSort();
        if (this.parentView != null) {
            IEclipseContext context = this.parentView.getParentEditor().getContext();
            IEventBroker eventBroker = (IEventBroker)context.get(IEventBroker.class);
            eventBroker.send("Value_Modified_for_Checkboxes", (Object)this.parentView.getEntry());
        }
        if (isDirty && !this.parentView.isDirty()) {
            this.parentView.setDirty(true);
        }
    }

    protected void highlightRows() {
        if (this.getGRITSTableDataObject().getTableData() == null || this.getGRITSTableDataObject().getTableData().isEmpty()) {
            return;
        }
        try {
            if (((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols() == null || ((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().isEmpty()) {
                return;
            }
            Integer filterCol = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().get(0);
            if (filterCol == null || filterCol == -1) {
                return;
            }
            int i = 0;
            while (i < this.getGRITSTableDataObject().getTableData().size()) {
                int iNatIndex = this.getNatIndexFromSourceIndex(i);
                if (iNatIndex < 0 || iNatIndex >= this.eventList.size()) {
                    return;
                }
                GRITSListDataRow eventRowData = (GRITSListDataRow)this.eventList.get(iNatIndex);
                GRITSListDataRow backendRowData = (GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i);
                if (backendRowData != null && eventRowData != null) {
                    Integer filterVal = (Integer)backendRowData.getDataRow().get(filterCol);
                    eventRowData.getDataRow().set(filterCol, filterVal);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in GRITStable:hightlightRows.", (Throwable)ex);
        }
    }

    public void reSort() {
        super.reSort();
        this.setParentTableNeedsScroll(true);
        this.performAutoResize();
    }

    public boolean startUpdateHiddenRowsAfterEdit(String _sCustomExtraDataKey, int _iNumTopHits, boolean _bOverrideManual, Object filter, boolean keepExisting, boolean highlightOnly) {
        if (this.hasColumnGroupHeader()) {
            return false;
        }
        this.showAllRows();
        this.clearHighlighting();
        int iNumRows = this.getBottomDataLayer().getRowCount();
        if (iNumRows == 0) {
            return false;
        }
        int iParentScanSortIndex = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getParentNoCol().get(0);
        int iPeakSortIndex = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0);
        int iScanNumIndex = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0);
        SortStatePersistor sortStatePersistor = new SortStatePersistor(this.sortModel);
        Properties sortProperties = new Properties();
        sortStatePersistor.saveState("beforeFilter", sortProperties);
        this.sortModel.sort(iParentScanSortIndex, SortDirectionEnum.ASC, false);
        this.sortModel.sort(iPeakSortIndex, SortDirectionEnum.ASC, true);
        this.sortModel.sort(iScanNumIndex, SortDirectionEnum.ASC, true);
        int iCNDSortIndex = this.getColumnIndexForKey(_sCustomExtraDataKey);
        boolean isDirty = false;
        Hashtable<Integer, Hashtable> htScanToFirstAnnotation = new Hashtable<Integer, Hashtable>();
        Hashtable<Integer, ArrayList> htAtLeastOne = new Hashtable<Integer, ArrayList>();
        Hashtable<Integer, Hashtable<String, ArrayList<String>>> currentHiddenRows = this.copyHiddenRows(this.getGRITSTableDataObject().getHtHiddenRows());
        if (iCNDSortIndex >= 0) {
            this.sortModel.sort(iCNDSortIndex, SortDirectionEnum.DESC, true);
        }
        try {
            isDirty = this.applyFilter(filter, _bOverrideManual, highlightOnly);
        }
        catch (Exception e) {
            logger.error((Object)"Could not apply the filters", (Throwable)e);
        }
        String sLastRowId = null;
        String sLastScan = null;
        int iRowCounter = 0;
        MSAnnotationTableDataProcessor tdp = (MSAnnotationTableDataProcessor)this.getTableDataProcessor();
        int i = 0;
        while (i < iNumRows) {
            if (this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getParentNoCol().get(0)).intValue(), i) != null && this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i) != null && this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i) != null) {
                Integer iParentScanNo = this.getScanNumberForVisibility(this, i);
                Integer iPeakId = (Integer)this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i);
                Integer iScan = null;
                if (this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0)).intValue(), i) != null) {
                    iScan = (Integer)this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0)).intValue(), i);
                }
                String sRowId = Feature.getRowId((Integer)iPeakId, iScan);
                String sFeatureId = this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i).toString();
                boolean bLocked = this.getGRITSTableDataObject().isLockedPeak(iParentScanNo, sRowId);
                if (!bLocked) {
                    boolean bManuallyChanged = this.getGRITSTableDataObject().isManuallyChangedPeak(iParentScanNo, sRowId);
                    if (bManuallyChanged && !_bOverrideManual) {
                        boolean bPrevHidden = this.getGRITSTableDataObject().isHiddenRow(iParentScanNo, sRowId, sFeatureId);
                        if (!bPrevHidden) {
                            this.updateFilterVal(i, true, false);
                            Integer filterVal = this.getFilterVal(i, false);
                            if (filterVal != null && filterVal.equals(0)) {
                                this.adjustFilterVal(i, iParentScanNo, sRowId, iScan, false);
                            }
                        }
                    } else {
                        boolean bCurHidden;
                        this.getGRITSTableDataObject().removeManuallyChangedPeak(iParentScanNo, sRowId);
                        iParentScanNo.intValue();
                        if (!sRowId.equals(sLastRowId) || !iScan.toString().equals(sLastScan)) {
                            sLastRowId = sRowId;
                            sLastScan = iScan.toString();
                            iRowCounter = 0;
                        }
                        boolean bPrevInvisible = this.getGRITSTableDataObject().isInvisibleRow(iParentScanNo, sRowId);
                        boolean bPrevHidden = this.getGRITSTableDataObject().isHiddenRow(iParentScanNo, sRowId, sFeatureId);
                        if (iCNDSortIndex < 0) {
                            bCurHidden = bPrevHidden;
                        } else if (filter != null) {
                            bCurHidden = bPrevHidden || iRowCounter++ >= _iNumTopHits && _iNumTopHits >= 0;
                        } else {
                            boolean bl = bCurHidden = iRowCounter++ >= _iNumTopHits && _iNumTopHits >= 0;
                        }
                        if (!bCurHidden) {
                            this.getGRITSTableDataObject().removeHiddenRow(iParentScanNo, sRowId, sFeatureId);
                            this.updateFilterVal(i, true, false);
                            Integer filterVal = this.getFilterVal(i, false);
                            if (filterVal != null && filterVal.equals(0)) {
                                this.adjustFilterVal(i, iParentScanNo, sRowId, iScan, false);
                            }
                            if (bPrevInvisible || bPrevHidden) {
                                isDirty = true;
                                tdp.addDirtyParentScan(iParentScanNo);
                                MSAnnotationEntityScroller.getCombinedKeyForLookup(iPeakId, sFeatureId);
                                this.notifyListeners(iParentScanNo, iPeakId, sFeatureId);
                            }
                        } else if (bCurHidden) {
                            this.getGRITSTableDataObject().setHiddenRow(iParentScanNo, sRowId, sFeatureId);
                            if (!bPrevHidden && !bPrevInvisible) {
                                isDirty = true;
                                tdp.addDirtyParentScan(iParentScanNo);
                                MSAnnotationEntityScroller.getCombinedKeyForLookup(iPeakId, sFeatureId);
                                this.notifyListeners(iParentScanNo, iPeakId, sFeatureId);
                            }
                        }
                        if (sFeatureId != null) {
                            if (!bCurHidden) {
                                ArrayList alAtLeastOne = null;
                                if (!htAtLeastOne.containsKey(iParentScanNo)) {
                                    alAtLeastOne = new ArrayList();
                                    htAtLeastOne.put(iParentScanNo, alAtLeastOne);
                                } else {
                                    alAtLeastOne = (ArrayList)htAtLeastOne.get(iParentScanNo);
                                }
                                alAtLeastOne.add(sRowId);
                            }
                            Hashtable htPeakToFeature = null;
                            if (!htScanToFirstAnnotation.containsKey(iParentScanNo)) {
                                htPeakToFeature = new Hashtable();
                                htScanToFirstAnnotation.put(iParentScanNo, htPeakToFeature);
                            } else {
                                htPeakToFeature = (Hashtable)htScanToFirstAnnotation.get(iParentScanNo);
                            }
                            if (!htPeakToFeature.containsKey(sRowId)) {
                                htPeakToFeature.put(sRowId, sFeatureId);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        for (Integer iParentScanNum : htScanToFirstAnnotation.keySet()) {
            Hashtable htPeakToFeature = (Hashtable)htScanToFirstAnnotation.get(iParentScanNum);
            ArrayList alAtLeastOne = (ArrayList)htAtLeastOne.get(iParentScanNum);
            for (String sRowId : htPeakToFeature.keySet()) {
                if (alAtLeastOne == null || !alAtLeastOne.contains(sRowId)) {
                    if (keepExisting) {
                        if (this.wasRowSelected(currentHiddenRows, iParentScanNum, sRowId, (String)htPeakToFeature.get(sRowId))) {
                            this.getGRITSTableDataObject().removeHiddenRow(iParentScanNum, sRowId, (String)htPeakToFeature.get(sRowId));
                            continue;
                        }
                        this.getGRITSTableDataObject().removeHiddenRow(iParentScanNum, sRowId, (String)htPeakToFeature.get(sRowId));
                        if (this.getGRITSTableDataObject().isInvisibleRow(iParentScanNum, sRowId)) continue;
                        this.getGRITSTableDataObject().addInvisibleRow(iParentScanNum, sRowId);
                        continue;
                    }
                    this.getGRITSTableDataObject().removeHiddenRow(iParentScanNum, sRowId, (String)htPeakToFeature.get(sRowId));
                    if (this.getGRITSTableDataObject().isInvisibleRow(iParentScanNum, sRowId)) continue;
                    this.getGRITSTableDataObject().addInvisibleRow(iParentScanNum, sRowId);
                    continue;
                }
                if (!this.getGRITSTableDataObject().isInvisibleRow(iParentScanNum, sRowId)) continue;
                this.getGRITSTableDataObject().removeInvisibleRow(iParentScanNum, sRowId);
            }
        }
        sortStatePersistor.loadState("beforeFilter", sortProperties);
        return isDirty;
    }

    protected void clearHighlighting() {
        if (this.getGRITSTableDataObject().getTableData() == null || this.getGRITSTableDataObject().getTableData().isEmpty()) {
            return;
        }
        try {
            if (((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols() == null || ((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().isEmpty()) {
                return;
            }
            Integer filterCol = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().get(0);
            if (filterCol == null || filterCol == -1) {
                return;
            }
            int i = 0;
            while (i < this.getGRITSTableDataObject().getTableData().size()) {
                int iNatIndex = this.getNatIndexFromSourceIndex(i);
                if (iNatIndex < 0 || iNatIndex >= this.eventList.size()) {
                    return;
                }
                GRITSListDataRow eventRowData = (GRITSListDataRow)this.eventList.get(iNatIndex);
                GRITSListDataRow backendRowData = (GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i);
                if (backendRowData != null && eventRowData != null) {
                    backendRowData.getDataRow().set(filterCol, -1);
                    eventRowData.getDataRow().set(filterCol, -1);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in GRITStable:clearHightlighing.", (Throwable)ex);
        }
    }

    private Hashtable<Integer, Hashtable<String, ArrayList<String>>> copyHiddenRows(Hashtable<Integer, Hashtable<String, ArrayList<String>>> htHiddenRows) {
        Hashtable<Integer, Hashtable<String, ArrayList<String>>> copyOfHiddenRows = new Hashtable<Integer, Hashtable<String, ArrayList<String>>>();
        for (Integer parentScan : htHiddenRows.keySet()) {
            Hashtable<String, ArrayList<String>> rowToHiddenPeaks = htHiddenRows.get(parentScan);
            Hashtable copyOfRowToHiddenPeaks = new Hashtable();
            for (String rowId : rowToHiddenPeaks.keySet()) {
                ArrayList<String> secondaryIds = rowToHiddenPeaks.get(rowId);
                ArrayList<String> copyOfSecondaryIds = new ArrayList<String>();
                copyOfSecondaryIds.addAll(secondaryIds);
                copyOfRowToHiddenPeaks.put(rowId, copyOfSecondaryIds);
            }
            copyOfHiddenRows.put(parentScan, copyOfRowToHiddenPeaks);
        }
        return copyOfHiddenRows;
    }

    private boolean wasRowSelected(Hashtable<Integer, Hashtable<String, ArrayList<String>>> currentHiddenRows, Integer _iScanNum, String _iRowId, String _sSecondaryId) {
        Hashtable<String, ArrayList<String>> htRowToHiddenFeatures = null;
        if (!currentHiddenRows.containsKey(_iScanNum)) {
            return true;
        }
        htRowToHiddenFeatures = currentHiddenRows.get(_iScanNum);
        ArrayList<String> alHiddenAnnotations = null;
        if (!htRowToHiddenFeatures.containsKey(_iRowId)) {
            return true;
        }
        alHiddenAnnotations = htRowToHiddenFeatures.get(_iRowId);
        return !alHiddenAnnotations.contains(_sSecondaryId);
    }

    private int locateRowInParentTable(String sFeature, Integer iPeakId) {
        ArrayList rows = this.getGRITSTableDataObject().getTableData();
        int i = 0;
        while (i < rows.size()) {
            GRITSListDataRow row = (GRITSListDataRow)rows.get(i);
            if (row.getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)) != null && row.getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)) != null) {
                Integer peakId = (Integer)row.getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0));
                String feature = row.getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).toString();
                if (sFeature.equals(feature) && peakId.equals(iPeakId)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private void updateFilterVal(int rowIndex, boolean increment, boolean absoluteIndex) {
        if (((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols() == null || ((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().isEmpty()) {
            return;
        }
        if (rowIndex == -1) {
            return;
        }
        Integer filterCol = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().get(0);
        if (filterCol == null || filterCol == -1) {
            return;
        }
        if (filterCol != -1) {
            GRITSListDataRow rowData;
            Integer filterVal;
            int j = rowIndex;
            if (!absoluteIndex) {
                GRITSListDataRow backendRowData = this.bodyDataProvider.getGRITSListDataRow(rowIndex);
                j = this.getSourceIndexFromRowId(backendRowData.getId());
            }
            if ((filterVal = (Integer)(rowData = (GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(j)).getDataRow().get(filterCol)) != null) {
                if (increment && filterVal >= 10) {
                    rowData.getDataRow().set(filterCol, 11);
                } else if (!increment && filterVal == 1) {
                    rowData.getDataRow().set(filterCol, 0);
                } else if (!increment && filterVal == 11) {
                    rowData.getDataRow().set(filterCol, 10);
                }
            }
        }
    }

    private void adjustFilterVal(int rowIndex, Integer iParentScanNo, String peakId, Integer iScan, boolean absolute) {
        int iNumRows = this.getGRITSTableDataObject().getTableData().size();
        boolean match = false;
        int i = 0;
        while (i < iNumRows) {
            if (((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getParentNoCol().get(0)) != null && ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)) != null && ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)) != null && ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().get(0)) != null) {
                Integer iParentScanNo2 = this.getScanNumberForVisibility(this, i);
                Integer iPeakId2 = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0));
                String sFeatureId = ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).toString();
                boolean isHidden = this.getGRITSTableDataObject().isHiddenRow(iParentScanNo2, iPeakId2.toString(), sFeatureId);
                Integer iScan2 = null;
                if (((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0)) != null) {
                    iScan2 = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0));
                }
                Integer filterValue = this.getFilterVal(i, true);
                if (iParentScanNo.equals(iParentScanNo2) && iPeakId2.toString().equals(peakId) && iScan.equals(iScan2) && isHidden && filterValue != null && filterValue >= 10) {
                    match = true;
                }
            }
            ++i;
        }
        if (match) {
            this.setFilterVal(rowIndex, 1, absolute);
        }
    }

    Integer getFilterVal(int rowIndex, boolean absoluteIndex) {
        if (((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols() == null || ((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().isEmpty()) {
            return -1;
        }
        if (rowIndex == -1) {
            return -1;
        }
        Integer filterCol = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().get(0);
        if (filterCol == null || filterCol == -1) {
            return -1;
        }
        if (filterCol != -1) {
            int j = rowIndex;
            if (!absoluteIndex) {
                GRITSListDataRow backendRowData = this.bodyDataProvider.getGRITSListDataRow(rowIndex);
                j = this.getSourceIndexFromRowId(backendRowData.getId());
            }
            GRITSListDataRow rowData = (GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(j);
            Integer filterVal = (Integer)rowData.getDataRow().get(filterCol);
            return filterVal;
        }
        return -1;
    }

    void setFilterVal(int rowIndex, int newValue, boolean absoluteIndex) {
        if (((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols() == null || ((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().isEmpty()) {
            return;
        }
        if (rowIndex == -1) {
            return;
        }
        Integer filterCol = (Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFilterCols().get(0);
        if (filterCol == null || filterCol == -1) {
            return;
        }
        if (filterCol != -1) {
            int j = rowIndex;
            if (!absoluteIndex) {
                GRITSListDataRow backendRowData = this.bodyDataProvider.getGRITSListDataRow(rowIndex);
                j = this.getSourceIndexFromRowId(backendRowData.getId());
            }
            GRITSListDataRow rowData = (GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(j);
            rowData.getDataRow().set(filterCol, newValue);
        }
    }

    protected boolean applyFilter(Object filter, boolean overrideManual, boolean highlightOnly) throws Exception {
        return false;
    }

    protected boolean isHiddenTableRow(int iRowNum) {
        boolean bHidden = this.hideUnannotated() && this.getMyTableDataObject().isUnannotatedRow(iRowNum);
        return bHidden;
    }

    public void updateRowVisibilityAfterRead() {
        ArrayList<Integer> alHiddenRows = new ArrayList<Integer>();
        int iNumRows = this.getGRITSTableDataObject().getTableData().size();
        boolean bHasScan = false;
        int i = 0;
        while (i < iNumRows) {
            block8: {
                boolean bHidden;
                block7: {
                    bHidden = this.isHiddenTableRow(i);
                    if (bHidden) break block7;
                    if (!bHasScan && !((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().isEmpty() && ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0)) != null) {
                        bHasScan = true;
                    }
                    if (((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().isEmpty() || ((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().isEmpty() || ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)) == null || ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)) == null) break block8;
                    Integer iParentScanNum = this.getScanNumberForVisibility(this.getMyTableDataObject(), i);
                    Integer iPeakId = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0));
                    String sFeatureId = (String)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0));
                    Integer iScan = null;
                    if (!((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().isEmpty() && ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0)) != null) {
                        iScan = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0));
                    }
                    String sRowId = Feature.getRowId((Integer)iPeakId, iScan);
                    bHidden = this.getGRITSTableDataObject().isHiddenRow(iParentScanNum, sRowId, sFeatureId);
                }
                if (bHidden) {
                    alHiddenRows.add(i);
                }
            }
            ++i;
        }
        this.hideRows(alHiddenRows);
        this.performAutoResize();
    }

    protected GRITSHeaderMenuConfiguration getNewHeaderMenuConfiguration() {
        return new MSAnnotationHeaderMenuConfiguration((NatTable)this);
    }

    public void updatePreferenceSettingsFromCurrentView() {
        MSAnnotationViewerPreference pref = (MSAnnotationViewerPreference)this.getPreference();
        pref.setHideUnannotatedPeaks(this.hideUnannotated());
        super.updatePreferenceSettingsFromCurrentView();
    }

    public boolean updateViewFromPreferenceSettings() {
        MSAnnotationViewerPreference pref = (MSAnnotationViewerPreference)this.getPreference();
        this.setHideUnannotated(pref.isHideUnannotatedPeaks());
        return super.updateViewFromPreferenceSettings();
    }

    protected void createCheckBoxPainters() {
    }

    public void toggleSubsetTableRowsForClickedItem(String _sKey) {
        int iNumRows = this.getBottomDataLayer().getRowCount();
        if (iNumRows == 0) {
            return;
        }
        int i = 0;
        while (i < iNumRows) {
            String sId;
            Integer iPeakId;
            String sCompareTo;
            if (this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i) != null && this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i) != null && _sKey.equals(sCompareTo = MSAnnotationEntityScroller.getCombinedKeyForLookup(iPeakId = (Integer)this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i), sId = this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i).toString()))) {
                boolean bCurSelected = (Boolean)this.getBottomDataLayer().getDataValueByPosition(0, i);
                this.getBottomDataLayer().getDataProvider().setDataValue(0, i, (Object)(!bCurSelected ? 1 : 0));
                break;
            }
            ++i;
        }
    }

    protected void notifyListeners(Integer iScanNum, Integer iPeakId, String sFeature) {
        if (this.parentTable != null && this.parentTable.getParentMultiPageViewer() != null) {
            ((MSAnnotationTableDataProcessor)this.getTableDataProcessor()).setPropertyScanNum(iScanNum);
            ScanFeatures scanFeatures = ((MSAnnotationTableDataProcessor)this.getTableDataProcessor()).getScanFeatures(iScanNum);
            Feature matchedFeature = null;
            for (Feature feature : scanFeatures.getFeatures()) {
                if (!feature.getId().equals(sFeature)) continue;
                matchedFeature = feature;
            }
            if (matchedFeature == null) {
                logger.error((Object)("Unable to find feature: " + sFeature));
                return;
            }
            Annotation annotation = AnnotationRowExtraction.getAnnotation((Data)((MSAnnotationTableDataProcessor)this.getTableDataProcessor()).getGRITSdata(), (Integer)matchedFeature.getAnnotationId());
            MSAnnotationTableDataChangedMessage message = new MSAnnotationTableDataChangedMessage(this, iPeakId, matchedFeature, annotation);
            IEclipseContext context = this.parentTable.getParentMultiPageViewer().getContext();
            IEventBroker eventBroker = (IEventBroker)context.get(IEventBroker.class);
            eventBroker.send("Value_Modified_for_Checkboxes", (Object)message);
        }
    }

    protected void addConfigurations() {
        this.addConfiguration((IConfiguration)this.getGRITSNatTableStyleConfiguration());
        if (this.addHeaderListeners()) {
            this.addConfiguration((IConfiguration)this.getNewHeaderMenuConfiguration());
        } else {
            this.addConfiguration(this.getNewSubsetTableHeaderMenuConfiguration());
        }
        this.addConfiguration((IConfiguration)this.getBodyMenuConfiguration());
        this.addConfiguration(this.getSingleClickConfiguration());
        this.addConfiguration((IConfiguration)this.getUIBindingConfiguration());
    }

    protected IConfiguration getSingleClickConfiguration() {
        return new GRITSSingleClickConfiguration(this.getGRITSTableDataObject().getTableHeader().size() > 1);
    }

    protected IConfiguration getNewSubsetTableHeaderMenuConfiguration() {
        return new MSAnnotationSelectionTableHeaderMenuConfiguration((NatTable)this);
    }

    public void lockSelection() {
        Integer iParentScanNum = this.getParentScanNumberFromTable(this.parentTable.getParentView(), 0);
        Integer iPeakId = (Integer)this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), 0);
        Integer iScan = null;
        if (this.getMyTableDataObject().getScanNoCols() != null && !this.getMyTableDataObject().getScanNoCols().isEmpty()) {
            iScan = (Integer)this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0)).intValue(), 0);
        }
        if (iParentScanNum != null && iPeakId != null) {
            String sRowId = Feature.getRowId((Integer)iPeakId, iScan);
            if (!this.parentTable.getGRITSTableDataObject().isLockedPeak(iParentScanNum, sRowId)) {
                this.parentTable.getGRITSTableDataObject().addLockedPeak(iParentScanNum, sRowId);
                String sFeatureId = (String)this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), 0);
                this.parentTable.notifyListeners(iParentScanNum, iPeakId, sFeatureId);
                this.saveLockUnlock(iParentScanNum);
            }
        }
    }

    protected Integer getParentScanNumberFromTable(MassSpecTableBase parentView, int row) {
        Integer iParentScanNum = -1;
        MSAnnotationMultiPageViewer viewer = MSAnnotationMultiPageViewer.getActiveViewerForEntry(parentView.getParentEditor().getContext(), parentView.getEntry());
        MSAnnotationTableDataObject tdo = (MSAnnotationTableDataObject)this.getGRITSTableDataObject();
        if (viewer.getDetailsView() != null) {
            if (tdo.getParentNoCol() != null && !tdo.getParentNoCol().isEmpty() && ((GRITSListDataRow)tdo.getTableData().get(row)).getDataRow().get((Integer)tdo.getParentNoCol().get(0)) != null) {
                iParentScanNum = (Integer)((GRITSListDataRow)tdo.getTableData().get(row)).getDataRow().get((Integer)tdo.getParentNoCol().get(0));
            }
        } else {
            iParentScanNum = this.getScanNumberForVisibility(this, 0);
        }
        return iParentScanNum;
    }

    private void saveLockUnlock(Integer parentScanNo) {
        MSAnnotationTableDataProcessor tdp = (MSAnnotationTableDataProcessor)this.parentTable.getTableDataProcessor();
        tdp.addDirtyParentScan(parentScanNo);
        this.parentTable.getParentView().setDirty(true);
    }

    public void unlockSelection() {
        Integer iParentScanNum = this.getParentScanNumberFromTable(this.parentTable.getParentView(), 0);
        Integer iPeakId = (Integer)this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), 0);
        if (iParentScanNum != null && iPeakId != null) {
            Integer iScan = null;
            if (this.getMyTableDataObject().getScanNoCols() != null && !this.getMyTableDataObject().getScanNoCols().isEmpty()) {
                iScan = (Integer)this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0)).intValue(), 0);
            }
            String sRowId = Feature.getRowId((Integer)iPeakId, iScan);
            if (this.parentTable.getGRITSTableDataObject().isLockedPeak(iParentScanNum, sRowId)) {
                this.parentTable.getGRITSTableDataObject().removeLockedPeak(iParentScanNum, sRowId);
                String sFeatureId = (String)this.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), 0);
                this.parentTable.notifyListeners(iParentScanNum, iPeakId, sFeatureId);
                this.saveLockUnlock(iParentScanNum);
            }
        }
    }

    public void hideInvisibleRows() {
        this.setHideInvisible(true);
        this.updateRowVisibilityForInvisibleRows();
        this.updateEventListForVisibility();
        this.reSort();
    }

    public void showInvisibleRows() {
        this.setHideInvisible(false);
        this.updateRowVisibilityForInvisibleRows();
        this.updateEventListForVisibility();
        this.reSort();
    }

    private void updateRowVisibilityForInvisibleRows() {
        ArrayList<Integer> alHiddenRows = new ArrayList<Integer>();
        int iNumRows = this.getGRITSTableDataObject().getTableData().size();
        int i = 0;
        while (i < iNumRows) {
            block6: {
                boolean bHidden;
                block7: {
                    if (((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().isEmpty() || ((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().isEmpty() || ((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().isEmpty() || ((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().isEmpty() || ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0)) == null) break block6;
                    Integer iParentScanNum = this.getScanNumberForVisibility(this.getMyTableDataObject(), i);
                    Integer iPeakId = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getPeakIdCols().get(0));
                    Integer iScan = null;
                    if (((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0)) != null) {
                        iScan = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getScanNoCols().get(0));
                    }
                    String sRowId = Feature.getRowId((Integer)iPeakId, iScan);
                    boolean bl = bHidden = this.getHideInvisible() && this.getMyTableDataObject().isInvisibleRow(iParentScanNum, sRowId);
                    if (bHidden) break block7;
                    if (((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0)) == null) break block6;
                    String sFeatureId = (String)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)((MSAnnotationTableDataObject)this.getGRITSTableDataObject()).getFeatureIdCols().get(0));
                    bHidden = this.getGRITSTableDataObject().isHiddenRow(iParentScanNum, sRowId, sFeatureId);
                }
                if (bHidden) {
                    alHiddenRows.add(i);
                }
            }
            ++i;
        }
        this.hideRows(alHiddenRows);
        this.performAutoResize();
    }

    public MSAnnotationTable getParentTable() {
        return this.parentTable;
    }
}

