/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.dialogs;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.importer.ms.process.RawToMzXMLConverterProcess;

public class RawToMzXMLConverterDialog
extends Dialog {
    protected RawToMzXMLConverterProcess msmsFile_worker = null;
    protected Boolean msmsIsDone = false;
    protected RawToMzXMLConverterProcess msFile_worker = null;
    protected Boolean msIsDone = false;
    protected Label msmsLabel = null;
    protected Label msmsStatus = null;
    protected Label msLabel = null;
    protected Label msStatus = null;
    protected Button cancelButton;
    protected Composite cancelComposite;
    protected Shell shell;
    protected Display display = null;
    protected boolean isCanceled = false;
    protected boolean errorPrinted = false;
    protected ProgressBar msmsFile_ProgressBar = null;
    protected ProgressBar msFile_ProgressBar = null;

    public RawToMzXMLConverterDialog(Shell parentShell) {
        super(parentShell);
    }

    public Thread getMSMSWorker() {
        return this.msmsFile_worker;
    }

    public void setMSMSWorker(RawToMzXMLConverterProcess a_worker) {
        this.msmsFile_worker = a_worker;
    }

    public ProgressBar getMSMSProgressBar() {
        return this.msmsFile_ProgressBar;
    }

    public Thread getMSWorker() {
        return this.msFile_worker;
    }

    public void setMSWorker(RawToMzXMLConverterProcess a_worker) {
        this.msFile_worker = a_worker;
    }

    public ProgressBar getMSProgressBar() {
        return this.msFile_ProgressBar;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    private boolean checkAllDone() {
        boolean bDone = true;
        if (this.msmsFile_worker != null) {
            bDone &= this.msmsIsDone.booleanValue();
        }
        if (this.msFile_worker != null) {
            bDone &= this.msIsDone.booleanValue();
        }
        return bDone;
    }

    public void setDone(final RawToMzXMLConverterProcess _worker) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (_worker.equals(RawToMzXMLConverterDialog.this.msmsFile_worker)) {
                    RawToMzXMLConverterDialog.this.msmsIsDone = Boolean.TRUE;
                    RawToMzXMLConverterDialog.this.msmsFile_ProgressBar.setState(4);
                } else {
                    RawToMzXMLConverterDialog.this.msIsDone = Boolean.TRUE;
                    RawToMzXMLConverterDialog.this.msFile_ProgressBar.setState(4);
                }
            }
        });
    }

    public int open() {
        this.createContents();
        Monitor primary = this.shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.shell.open();
        this.shell.layout();
        if (this.msmsFile_worker != null) {
            this.msmsFile_ProgressBar.setState(0);
            this.updateProgressBar("Starting...", this.msmsFile_worker);
            this.msmsFile_worker.start();
        }
        if (this.msFile_worker != null) {
            this.msFile_ProgressBar.setState(0);
            this.updateProgressBar("Starting...", this.msFile_worker);
            this.msFile_worker.start();
        }
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.isCanceled) {
            return 256;
        }
        return 32;
    }

    public void updateProgressBar(String _sText, RawToMzXMLConverterProcess _worker) {
        final String t_message = new String(_sText);
        final Label processMessageLabel = _worker.equals(this.msmsFile_worker) ? this.msmsStatus : this.msStatus;
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                processMessageLabel.setText(t_message);
            }
        });
    }

    protected void createContents() {
        this.shell = PropertyHandler.getModalDialog((Shell)this.getParent());
        this.display = this.shell.getDisplay();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(483, 210);
        this.shell.setText("Raw-to-MzXML Converter Dialog");
        GridData gd1 = new GridData(768);
        this.msmsLabel = new Label((Composite)this.shell, 0);
        this.msmsLabel.setText("MS/MS File Progress: ");
        this.msmsLabel.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(768);
        this.msmsStatus = new Label((Composite)this.shell, 0);
        this.msmsStatus.setText("Nothing to do");
        this.msmsStatus.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = 2;
        this.msmsFile_ProgressBar = new ProgressBar((Composite)this.shell, 2);
        this.msmsFile_ProgressBar.setLayoutData((Object)gd3);
        this.msmsFile_ProgressBar.setState(4);
        GridData gd4 = new GridData(768);
        this.msLabel = new Label((Composite)this.shell, 0);
        this.msLabel.setText("MS File Progress: ");
        this.msLabel.setLayoutData((Object)gd4);
        GridData gd5 = new GridData(768);
        this.msStatus = new Label((Composite)this.shell, 0);
        this.msStatus.setText("Nothing to do");
        this.msStatus.setLayoutData((Object)gd5);
        GridData gd6 = new GridData(768);
        gd6.horizontalSpan = 2;
        this.msFile_ProgressBar = new ProgressBar((Composite)this.shell, 2);
        this.msFile_ProgressBar.setLayoutData((Object)gd6);
        this.msFile_ProgressBar.setState(4);
        this.cancelComposite = new Composite((Composite)this.shell, 0);
        this.cancelComposite.setLayoutData((Object)new GridData(4, 2, false, false));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        this.cancelComposite.setLayout((Layout)gridLayout_1);
        this.cancelButton = new Button(this.cancelComposite, 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RawToMzXMLConverterDialog.this.isCanceled = true;
                RawToMzXMLConverterDialog.this.clickCancel();
            }
        });
        this.cancelButton.setLayoutData((Object)new GridData(78, -1));
        this.cancelButton.setText("cancel");
    }

    public Display getDisplay() {
        return this.display;
    }

    public void threadFinished(RawToMzXMLConverterProcess worker, boolean successful) {
        this.setDone(worker);
        if (!this.isCanceled && successful) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    RawToMzXMLConverterDialog.this.isCanceled |= false;
                }
            });
        } else {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    RawToMzXMLConverterDialog.this.isCanceled &= true;
                }
            });
        }
        if (this.checkAllDone()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    RawToMzXMLConverterDialog.this.shell.close();
                }
            });
        }
    }

    public void endWithException(final Exception e) {
        if (this.errorPrinted) {
            return;
        }
        if (this.shell.isDisposed()) {
            return;
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                RawToMzXMLConverterDialog.this.errorPrinted = true;
                RawToMzXMLConverterDialog.this.clickCancel();
                if (ErrorUtils.createErrorMessageBoxReturn((Shell)RawToMzXMLConverterDialog.this.shell, (String)"An error has occurred.", (Exception)e) == 1) {
                    RawToMzXMLConverterDialog.this.shell.close();
                }
            }
        });
    }

    protected void clickCancel() {
        this.isCanceled = true;
        if (this.msmsFile_worker != null) {
            this.msmsFile_worker.cancelWork();
        }
        if (this.msFile_worker != null) {
            this.msFile_worker.cancelWork();
        }
    }
}

