/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.utilShare.EntrySelectionAdapter;
import org.grits.toolbox.core.utilShare.FileSelectionAdapter;
import org.grits.toolbox.core.utilShare.ListenerFactory;
import org.grits.toolbox.core.utilShare.SelectionInterface;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.MassSpecPreferencePage;
import org.grits.toolbox.entry.ms.preference.MassSpecSettingPreferenceUI;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.importer.ms.wizard.FileUploadPage;
import org.grits.toolbox.importer.ms.wizard.NewMSWizard;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.om.data.Method;

public class PageOne
extends WizardPage
implements SelectionInterface,
IPropertyChangeListener {
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private Text nameText;
    private String name;
    private Label nameLabel;
    private String msExperimentType = null;
    private Label msExperimentLabel;
    private Text descriptionText;
    private String description;
    private Label descriptionLabel;
    private Text rawFileNameText;
    private String rawFileName;
    private Label rawFileNameLabel;
    private Text mzxmlFileNameText;
    private String mzxmlFileName;
    private Label mzxmlFileNameLabel;
    private Text sampleText;
    private Label sampleNameLabel;
    private Entry sampleEntry = null;
    private Composite container;
    private MassSpecSettingPreferenceUI settingsPreference;
    private boolean nextPage = false;
    private FileUploadPage fileUploadPage;
    private List<Button> experimentTypeButtons = new ArrayList<Button>();

    public PageOne() {
        super("New MS Experiment");
        this.setTitle("New MS Experiment");
        this.setDescription("Create a new MS Experiment.");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 10;
        this.container.setLayout((Layout)gridLayout);
        GridData sampleNameData = new GridData();
        this.sampleNameLabel = new Label(this.container, 0);
        this.sampleNameLabel.setText("Sample");
        this.sampleNameLabel = this.setMandatoryLabel(this.sampleNameLabel);
        this.sampleNameLabel.setLayoutData((Object)sampleNameData);
        GridData samplenameTextData = new GridData();
        samplenameTextData.grabExcessHorizontalSpace = true;
        samplenameTextData.horizontalAlignment = 4;
        this.sampleText = new Text(this.container, 2048);
        if (this.sampleEntry != null) {
            this.sampleText.setText(this.sampleEntry.getDisplayName());
        }
        this.sampleText.setEditable(false);
        this.sampleText.setLayoutData((Object)samplenameTextData);
        GridData sampleProjectBrowserButtonData = new GridData();
        Button button = new Button(this.container, 8);
        button.setText("Browse");
        button.setLayoutData((Object)sampleProjectBrowserButtonData);
        EntrySelectionAdapter sampleProjectSelectionAdapter = new EntrySelectionAdapter("org.grits.toolbox.property.sample", "Sample Selection", "Choose a sample");
        sampleProjectSelectionAdapter.setParent(this.container);
        sampleProjectSelectionAdapter.setEntry(this.sampleEntry);
        sampleProjectSelectionAdapter.setParentWindow((SelectionInterface)this);
        button.addSelectionListener((SelectionListener)sampleProjectSelectionAdapter);
        this.createSeparator(this.container, 3);
        GridData nameData = new GridData();
        this.nameLabel = new Label(this.container, 0);
        this.nameLabel.setText("Display Name");
        this.nameLabel = this.setMandatoryLabel(this.nameLabel);
        this.nameLabel.setLayoutData((Object)nameData);
        GridData nameTextData = new GridData();
        nameTextData.grabExcessHorizontalSpace = true;
        nameTextData.horizontalAlignment = 4;
        nameTextData.horizontalSpan = 2;
        this.nameText = new Text(this.container, 2048);
        this.nameText.setLayoutData((Object)nameTextData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageOne.this.setPageComplete(PageOne.this.isReadyToFinish());
            }
        });
        String sDefaultExpType = NewMSWizard.preferences.getExperimentType() != null && !NewMSWizard.preferences.getExperimentType().equals("") ? NewMSWizard.preferences.getExperimentType() : "Tandem MS (MS2, MS3,...)";
        this.msExperimentLabel = MassSpecPreferencePage.createLabel((Composite)this.container, (String)"Experiment Type");
        this.createExperimentGroup(this.container, NewMSWizard.preferences.getAllExperimentTypes(), sDefaultExpType);
        MassSpecPreferencePage.setMandatoryLabel((Label)this.msExperimentLabel);
        GridData descriptionData = new GridData();
        this.descriptionLabel = new Label(this.container, 16384);
        this.descriptionLabel.setText("Description");
        this.descriptionLabel.setLayoutData((Object)descriptionData);
        GridData descriptionTextData = new GridData();
        descriptionTextData.minimumHeight = 80;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.grabExcessVerticalSpace = true;
        descriptionTextData.horizontalAlignment = 4;
        descriptionTextData.horizontalSpan = 2;
        this.descriptionText = new Text(this.container, 2562);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageOne.this.setPageComplete(PageOne.this.isReadyToFinish());
            }
        });
        this.descriptionText.addKeyListener(ListenerFactory.getCTRLAListener());
        this.addInstrumentOptions(this.container);
        GridData rawFileNameData = new GridData();
        this.rawFileNameLabel = new Label(this.container, 0);
        this.rawFileNameLabel.setText("MS Instrument File");
        this.rawFileNameLabel.setLayoutData((Object)rawFileNameData);
        GridData rawFileNameTextData = new GridData();
        rawFileNameTextData.grabExcessHorizontalSpace = true;
        rawFileNameTextData.horizontalAlignment = 4;
        rawFileNameTextData.horizontalSpan = 1;
        this.rawFileNameText = new Text(this.container, 2048);
        this.rawFileNameText.setLayoutData((Object)rawFileNameTextData);
        this.rawFileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageOne.this.setPageComplete(PageOne.this.isReadyToFinish());
            }
        });
        this.rawFileNameText.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                Text source = (Text)e.widget;
                String oldS = source.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                if (newS.isEmpty()) {
                    PageOne.this.rawFileName = null;
                }
                MSPropertyDataFile toBeRemoved = null;
                for (MSPropertyDataFile msPropertyDataFile : ((NewMSWizard)PageOne.this.getWizard()).getAllFiles()) {
                    if (!msPropertyDataFile.getName().equals(oldS)) continue;
                    toBeRemoved = msPropertyDataFile;
                }
                if (toBeRemoved != null) {
                    ((NewMSWizard)PageOne.this.getWizard()).getAllFiles().remove(toBeRemoved);
                }
            }
        });
        GridData rawFilebrowseButtonData = new GridData();
        Button button2 = new Button(this.container, 8);
        button2.setText("Browse");
        button2.setLayoutData((Object)rawFilebrowseButtonData);
        FileSelectionAdapter rawFileBrowserSelectionAdapter = new FileSelectionAdapter();
        rawFileBrowserSelectionAdapter.setShell(this.container.getShell());
        rawFileBrowserSelectionAdapter.setText(this.rawFileNameText);
        button2.addSelectionListener((SelectionListener)rawFileBrowserSelectionAdapter);
        rawFileBrowserSelectionAdapter.setFilterExtensions(new String[]{"*.raw;*.y;*.mgf;*.fid;*.yep;*.baf;*.gf;*.ms2;*.cms2;*.bms2", "*.*"});
        rawFileBrowserSelectionAdapter.setFilterNames(new String[]{"Thermo (.raw), Waters (.raw), Bruker (.fid, .yep, .baf), Sciex (.wiff), Agilent (.d))", "All files"});
        GridData mzxmlFileNameData = new GridData();
        this.mzxmlFileNameLabel = new Label(this.container, 0);
        this.mzxmlFileNameLabel.setText("MS Annotation File (mzML, mzXML etc.)");
        this.mzxmlFileNameLabel.setLayoutData((Object)mzxmlFileNameData);
        GridData mzxmlFileTextData = new GridData();
        mzxmlFileTextData.grabExcessHorizontalSpace = true;
        mzxmlFileTextData.horizontalAlignment = 4;
        mzxmlFileTextData.horizontalSpan = 1;
        this.mzxmlFileNameText = new Text(this.container, 2048);
        this.mzxmlFileNameText.setLayoutData((Object)mzxmlFileTextData);
        this.mzxmlFileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageOne.this.setPageComplete(PageOne.this.isReadyToFinish());
            }
        });
        this.mzxmlFileNameText.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                Text source = (Text)e.widget;
                String oldS = source.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                if (newS.isEmpty()) {
                    PageOne.this.mzxmlFileName = null;
                }
                MSPropertyDataFile parentToBeRemoved = null;
                for (MSPropertyDataFile msPropertyDataFile : ((NewMSWizard)PageOne.this.getWizard()).getAllFiles()) {
                    if (msPropertyDataFile.getChildren() == null) continue;
                    MSPropertyDataFile toBeRemoved = null;
                    for (MSPropertyDataFile child : msPropertyDataFile.getChildren()) {
                        if (!child.getName().equals(oldS)) continue;
                        toBeRemoved = child;
                    }
                    if (toBeRemoved == null) continue;
                    msPropertyDataFile.getChildren().remove(toBeRemoved);
                    if (!msPropertyDataFile.getChildren().isEmpty() || !msPropertyDataFile.getName().isEmpty()) continue;
                    parentToBeRemoved = msPropertyDataFile;
                }
                if (parentToBeRemoved != null) {
                    ((NewMSWizard)PageOne.this.getWizard()).getAllFiles().remove(parentToBeRemoved);
                }
            }
        });
        GridData mzxmlbrowseButtonData = new GridData();
        Button button3 = new Button(this.container, 8);
        button3.setText("Browse");
        button3.setLayoutData((Object)mzxmlbrowseButtonData);
        FileSelectionAdapter mzxmlFileBrowserSelectionAdapter = new FileSelectionAdapter();
        mzxmlFileBrowserSelectionAdapter.setShell(this.container.getShell());
        mzxmlFileBrowserSelectionAdapter.setText(this.mzxmlFileNameText);
        String sMzXML = "*.mzXML";
        String sMzML = "*.mzML";
        mzxmlFileBrowserSelectionAdapter.setFilterExtensions(new String[]{String.valueOf(sMzXML) + ";" + sMzML, "*.*"});
        mzxmlFileBrowserSelectionAdapter.setFilterNames(new String[]{"MS files (" + sMzML + "," + sMzML + ")", "All files"});
        button3.addSelectionListener((SelectionListener)mzxmlFileBrowserSelectionAdapter);
        this.createSeparator(this.container, 3);
        this.createQuantificationFileOption(this.container);
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private void createExperimentGroup(Composite parent, Set<String> allExperimentTypes, String sDefaultExpType) {
        Group experimentComposite = new Group(parent, 0);
        GridData expComboData = new GridData();
        expComboData.grabExcessHorizontalSpace = true;
        expComboData.horizontalAlignment = 4;
        expComboData.horizontalSpan = 2;
        experimentComposite.setLayoutData((Object)expComboData);
        GridLayout experimentLayout = new GridLayout(3, false);
        experimentComposite.setLayout((Layout)experimentLayout);
        Composite firstGroup = new Composite((Composite)experimentComposite, 0);
        firstGroup.setLayout((Layout)new GridLayout(1, true));
        new Label((Composite)experimentComposite, 514);
        Composite secondGroup = new Composite((Composite)experimentComposite, 0);
        secondGroup.setLayout((Layout)new GridLayout(1, true));
        final Button experimentTypeButton1 = new Button(firstGroup, 16);
        experimentTypeButton1.setText("LC-MS/MS");
        if (sDefaultExpType.equals("LC-MS/MS")) {
            experimentTypeButton1.setSelection(true);
        }
        this.experimentTypeButtons.add(experimentTypeButton1);
        new Label(firstGroup, 0);
        new Label(firstGroup, 0);
        experimentTypeButton1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (experimentTypeButton1.getSelection()) {
                    PageOne.this.disableOtherButtons(experimentTypeButton1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        String expType = "MS Profile";
        final Button experimentTypeButton2 = new Button(secondGroup, 16);
        if (expType.equals(sDefaultExpType)) {
            experimentTypeButton2.setSelection(true);
        }
        experimentTypeButton2.setText(expType);
        this.experimentTypeButtons.add(experimentTypeButton2);
        experimentTypeButton2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (experimentTypeButton2.getSelection()) {
                    PageOne.this.disableOtherButtons(experimentTypeButton2);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        expType = "Tandem MS (MS2, MS3,...)";
        final Button experimentTypeButton3 = new Button(secondGroup, 16);
        if (expType.equals(sDefaultExpType)) {
            experimentTypeButton3.setSelection(true);
        }
        experimentTypeButton3.setText(expType);
        this.experimentTypeButtons.add(experimentTypeButton3);
        experimentTypeButton3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (experimentTypeButton3.getSelection()) {
                    PageOne.this.disableOtherButtons(experimentTypeButton3);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        expType = "Total Ion Mapping (TIM)";
        final Button experimentTypeButton4 = new Button(secondGroup, 16);
        if (expType.equals(sDefaultExpType)) {
            experimentTypeButton4.setSelection(true);
        }
        experimentTypeButton4.setText(expType);
        this.experimentTypeButtons.add(experimentTypeButton4);
        experimentTypeButton4.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (experimentTypeButton4.getSelection()) {
                    PageOne.this.disableOtherButtons(experimentTypeButton4);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void disableOtherButtons(Button selected) {
        for (Button button : this.experimentTypeButtons) {
            if (button.equals(selected)) continue;
            button.setSelection(false);
        }
    }

    private void addInstrumentOptions(Composite container) {
        Composite container2 = new Composite(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        container2.setLayoutData((Object)gridData);
        container2.setLayout((Layout)new FillLayout());
        this.settingsPreference = new MassSpecSettingPreferenceUI(container2, 0, (IPropertyChangeListener)this);
        this.settingsPreference.setPreferences(NewMSWizard.preferences);
        this.settingsPreference.initComponents();
    }

    private void createQuantificationFileOption(Composite container) {
        GridData msDIOptionBtnGridData = new GridData();
        msDIOptionBtnGridData.horizontalSpan = 3;
        msDIOptionBtnGridData.grabExcessHorizontalSpace = true;
        msDIOptionBtnGridData.horizontalAlignment = 4;
        Group group1 = new Group(container, 4);
        group1.setText("Do you have additional files to upload (eg. for quantification)?");
        group1.setLayoutData((Object)msDIOptionBtnGridData);
        group1.setLayout((Layout)new RowLayout(256));
        final Button yesOption = new Button((Composite)group1, 16);
        yesOption.setText("Yes");
        yesOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (yesOption.getSelection()) {
                    PageOne.this.nextPage = true;
                    PageOne.this.canFlipToNextPage();
                    PageOne.this.setPageComplete(PageOne.this.isReadyToFinish());
                    PageOne.this.getWizard().getContainer().updateButtons();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button noOption = new Button((Composite)group1, 16);
        noOption.setText("No");
        noOption.setSelection(true);
        noOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (noOption.getSelection()) {
                    PageOne.this.nextPage = false;
                    PageOne.this.canFlipToNextPage();
                    PageOne.this.setPageComplete(PageOne.this.isReadyToFinish());
                    if (PageOne.this.fileUploadPage != null) {
                        PageOne.this.fileUploadPage.setPageComplete(true);
                    }
                    PageOne.this.getWizard().getContainer().updateButtons();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected Label createSeparator(Composite container, int span) {
        GridData separatorData = new GridData();
        separatorData.grabExcessHorizontalSpace = true;
        separatorData.horizontalAlignment = 4;
        separatorData.horizontalSpan = span;
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)separatorData);
        return separator;
    }

    protected boolean checkSameNameEntry() {
        if (this.sampleEntry != null) {
            for (Entry child : this.sampleEntry.getChildren()) {
                if (!child.getDisplayName().equals(this.nameText.getText())) continue;
                this.setErrorMessage("Please choose a different name for ms.");
                return true;
            }
            this.setErrorMessage(null);
            return false;
        }
        this.setErrorMessage(null);
        return false;
    }

    protected Label setMandatoryLabel(Label lable) {
        lable.setText(String.valueOf(lable.getText()) + "*");
        lable.setFont(this.boldFont);
        return lable;
    }

    public boolean canFlipToNextPage() {
        return this.nextPage && this.isReadyToFinish();
    }

    public IWizardPage getNextPage() {
        this.save();
        if (this.nextPage) {
            if (this.fileUploadPage == null) {
                this.fileUploadPage = new FileUploadPage();
                ((Wizard)this.getWizard()).addPage((IWizardPage)this.fileUploadPage);
                this.getWizard().getContainer().updateButtons();
            } else {
                this.fileUploadPage.refresh();
            }
            return this.fileUploadPage;
        }
        return super.getNextPage();
    }

    private boolean isReadyToFinish() {
        if (this.sampleText.getText().isEmpty() || this.sampleEntry == null) {
            return false;
        }
        if (this.nameText.getText().isEmpty()) {
            this.setErrorMessage("Display Name name name cannot be blank.");
            return false;
        }
        if (this.checkSameNameEntry()) {
            return false;
        }
        if (!this.nameText.getText().isEmpty() && this.nameText.getText().length() >= 128) {
            this.setErrorMessage("Name must be less than 128 characters.");
            return false;
        }
        if (!this.descriptionText.getText().isEmpty() && this.descriptionText.getText().length() >= Integer.parseInt(PropertyHandler.getVariable((String)"descriptionLength"))) {
            this.setErrorMessage("Description must be less than 1024 characters.");
            return false;
        }
        if (!this.rawFileNameText.getText().isEmpty() && !this.fileExists(this.rawFileNameText.getText())) {
            this.setErrorMessage("Specified file for 'Raw File' does not exist.");
            return false;
        }
        if (!this.mzxmlFileNameText.getText().isEmpty() && !this.fileExists(this.mzxmlFileNameText.getText())) {
            this.setErrorMessage("Specified file for 'mzML/mzXML File' does not exist.");
            return false;
        }
        if (!this.settingsPreference.isPageCompete()) {
            this.setErrorMessage(this.settingsPreference.getErrorMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean fileExists(String _sFileName) {
        File file = new File(_sFileName);
        return file.exists();
    }

    public void setMsMsMzXMLText(String _sText) {
        this.mzxmlFileNameText.setText(_sText);
    }

    public void setRawFileNameText(String _sText) {
        this.rawFileNameText.setText(_sText);
    }

    public void save() {
        this.name = this.nameText.getText();
        this.description = this.descriptionText.getText();
        this.msExperimentType = this.getExperimentSelection();
        if (MassSpecPreferencePage.hasChanged((String)this.msExperimentType, (String)NewMSWizard.preferences.getExperimentType(), (Set)NewMSWizard.preferences.getAllExperimentTypes())) {
            NewMSWizard.preferences.setExperimentType(this.msExperimentType);
        }
        if (!this.rawFileNameText.getText().equals("")) {
            this.rawFileName = this.rawFileNameText.getText();
        }
        if (this.mzxmlFileName != null && !this.mzxmlFileName.equals(MassSpecProperty.CONVERT_RAW) || !this.mzxmlFileNameText.getText().equals("")) {
            this.mzxmlFileName = this.mzxmlFileNameText.getText();
        }
        MSPropertyDataFile parent = null;
        if (this.rawFileName != null) {
            int iLastDot = this.rawFileName.lastIndexOf(".");
            if (iLastDot >= 0) {
                this.rawFileName.substring(iLastDot + 1);
            }
            parent = new MSPropertyDataFile(this.rawFileName, "1.0", "RAW", FileCategory.ANNOTATION_CATEGORY, "Instrument", this.rawFileName, Arrays.asList(FileCategory.ANNOTATION_CATEGORY.getLabel()), true);
            this.addToFileList(parent);
        }
        if (this.mzxmlFileName != null) {
            String sExtension = ".mzXML";
            int iLastDot = this.mzxmlFileName.lastIndexOf(".");
            if (iLastDot >= 0) {
                sExtension = this.mzxmlFileName.substring(iLastDot + 1);
            }
            String sMSFormat = "";
            sMSFormat = sExtension.equalsIgnoreCase("mzML") ? "mzML" : "mzXML";
            MSPropertyDataFile mzXMLFile = new MSPropertyDataFile(this.mzxmlFileName, "1.0", sMSFormat, FileCategory.ANNOTATION_CATEGORY, "Converted", this.mzxmlFileName, Arrays.asList(FileCategory.ANNOTATION_CATEGORY.getLabel()), false);
            if (parent == null) {
                parent = new MSPropertyDataFile("", "1.0", "RAW", FileCategory.ANNOTATION_CATEGORY, "Instrument", "", Arrays.asList(FileCategory.ANNOTATION_CATEGORY.getLabel()), true);
                this.addToFileList(parent);
            }
            parent.addChild(mzXMLFile);
        }
        this.settingsPreference.updatePreferences();
    }

    private String getExperimentSelection() {
        for (Button button : this.experimentTypeButtons) {
            if (!button.getSelection()) continue;
            String selectedLabel = button.getText();
            return Method.getMsTypeByLabel((String)selectedLabel);
        }
        return null;
    }

    private void addToFileList(MSPropertyDataFile parent) {
        boolean exists = false;
        for (MSPropertyDataFile f : ((NewMSWizard)this.getWizard()).getAllFiles()) {
            if (!f.getName().equals(parent.getName()) || !f.getCategory().equals((Object)parent.getCategory()) || !f.getMSFileType().equals(parent.getMSFileType())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            ((NewMSWizard)this.getWizard()).getAllFiles().add(parent);
        }
    }

    public Entry getSampleEntry() {
        return this.sampleEntry;
    }

    public void setSampleEntry(Entry sampleEntry) {
        this.sampleEntry = sampleEntry;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMSDescription() {
        return this.description;
    }

    public void setMSDescription(String description) {
        this.description = description;
    }

    public String getRawFileName() {
        return this.rawFileName;
    }

    public void setRawFileName(String rawFileName) {
        this.rawFileName = rawFileName;
    }

    public String getMzxmlFileName() {
        return this.mzxmlFileName;
    }

    public void setMzxmlFileName(String mzxmlFileName) {
        this.mzxmlFileName = mzxmlFileName;
    }

    public String getMsExperimentType() {
        return this.msExperimentType;
    }

    public void setMsExperimentType(String msExperimentType) {
        this.msExperimentType = msExperimentType;
    }

    public void updateComponent(SelectionAdapter adapter) {
        if (adapter instanceof EntrySelectionAdapter) {
            this.sampleEntry = ((EntrySelectionAdapter)adapter).getEntry();
            this.sampleText.setText(((EntrySelectionAdapter)adapter).getEntry().getDisplayName());
            this.setPageComplete(this.isReadyToFinish());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isReadyToFinish()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public MassSpecPreference getSettingsPreference() {
        return this.settingsPreference.getPreferences();
    }

    public boolean isNextPage() {
        return this.nextPage;
    }

    public FileUploadPage getFileUploadPage() {
        return this.fileUploadPage;
    }
}

