/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.util.Collection;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NotesDocument
extends BaseDocument
implements SAXUtils.SAXWriter {
    private String text = "";

    public NotesDocument() {
    }

    public NotesDocument(String t) {
        if (t != null) {
            this.text = t;
        }
    }

    public String getName() {
        return "Notes";
    }

    public ImageIcon getIcon() {
        return FileUtils.defaultThemeManager.getImageIcon("notes");
    }

    public Collection<FileFilter> getFileFormats() {
        Vector<FileFilter> filters = new Vector<FileFilter>();
        filters.add((FileFilter)new ExtensionFileFilter(new String[]{"txt"}, "Text files"));
        return filters;
    }

    public FileFilter getAllFileFormats() {
        return new ExtensionFileFilter(new String[]{"txt"}, "Text files");
    }

    public void initData() {
        this.text = "";
    }

    public int size() {
        return this.text.length();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        this.fill(t);
    }

    public String toString() {
        return this.text;
    }

    public void fromString(String str, boolean merge) throws Exception {
        this.text = merge ? this.text + str : str;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element n_node = document.createElement("Notes");
        XMLUtils.setText((Node)n_node, (String)this.text);
        return n_node;
    }

    public void fromXML(Node n_node, boolean merge) throws Exception {
        String t;
        if (!merge) {
            this.text = "";
        }
        if ((t = XMLUtils.getText((Node)n_node)) != null && t.length() > 0) {
            this.text = this.text + t;
        }
    }

    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "Notes", new AttributesImpl());
        th.characters(this.text.toCharArray(), 0, this.text.length());
        th.endElement("", "", "Notes");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private NotesDocument theDocument;
        private boolean merge;

        public SAXHandler(NotesDocument _doc, boolean _merge) {
            this.theDocument = _doc;
            this.merge = _merge;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Notes";
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            if (!this.merge) {
                this.theDocument.text = "";
            }
            this.theDocument.text = this.theDocument.text + this.text.toString();
            this.object = this.theDocument;
            return this.object;
        }
    }
}

