/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eurocarbdb.application.glycanbuilder.CrossRingFragmentDictionary;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.IonCloudUtils;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotation;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationCollection;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakFinderOptions;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.GlycoPeakfinder;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.AnnotationEntity;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationDerivatisation;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationFragment;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationIon;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationMolecule;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationParameter;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.CalculationPeak;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.Persubstitution;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.Scan;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.SpectraType;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.util.DefaultMasses;

public class PeakFinderThread
extends Thread {
    private static Pattern crossring_pattern = Pattern.compile("^\\^\\{([0-9])\\,([0-9])\\}([AX])\\_\\{(\\S+)\\}$");
    private AnnotatedPeakList annotated_peaks = new AnnotatedPeakList();
    private PeakList peaks = null;
    private PeakFinderOptions pf_opt = null;
    private AnnotationOptions ann_opt = null;
    private FragmentOptions frag_opt = null;

    public PeakFinderThread(PeakList _peaks, PeakFinderOptions _pf_opt, AnnotationOptions _ann_opt, FragmentOptions _frag_opt) {
        this.peaks = _peaks;
        this.pf_opt = _pf_opt;
        this.ann_opt = _ann_opt;
        this.frag_opt = _frag_opt;
    }

    public AnnotatedPeakList getAnnotatedPeaks() {
        return this.annotated_peaks;
    }

    public void setAnnotatedPeaks(AnnotatedPeakList apl) {
        this.annotated_peaks = apl;
    }

    @Override
    public void run() {
        if (this.peaks == null || this.ann_opt == null) {
            this.interrupt();
            return;
        }
        try {
            CalculationParameter pf_parameters = this.initParameters(this.peaks, this.pf_opt, this.ann_opt, this.frag_opt);
            GlycoPeakfinder calculator = new GlycoPeakfinder();
            CalculationParameter pf_results = calculator.calculate(pf_parameters);
            this.getResults(this.annotated_peaks, this.peaks, pf_results);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            this.interrupt();
        }
    }

    private CalculationParameter initParameters(PeakList peaks, PeakFinderOptions pf_opt, AnnotationOptions ann_opt, FragmentOptions frag_opt) throws Exception {
        CalculationParameter ret = new CalculationParameter();
        DefaultMasses defaultMasses = new DefaultMasses(this.getClass().getResource("/conf/peak_finder_masses.xml"), this.getClass().getResource("/conf/peak_finder_ax.xml"));
        boolean monoisotopic = true;
        Persubstitution persubstitution = null;
        if (pf_opt.DERIVATIZATION.equals("Und")) {
            persubstitution = Persubstitution.None;
        } else if (pf_opt.DERIVATIZATION.equals("perMe")) {
            persubstitution = Persubstitution.Me;
        } else if (pf_opt.DERIVATIZATION.equals("perDMe")) {
            persubstitution = Persubstitution.DMe;
        } else if (pf_opt.DERIVATIZATION.equals("perAc")) {
            persubstitution = Persubstitution.Ac;
        } else if (pf_opt.DERIVATIZATION.equals("perDAc")) {
            persubstitution = Persubstitution.DAc;
        }
        if (frag_opt == null) {
            ret.setSpectraType(SpectraType.Profile);
        } else {
            ret.setSpectraType(SpectraType.Fragmented);
        }
        ret.setAccuracy(ann_opt.MASS_ACCURACY);
        ret.setAccuracyPpm(ann_opt.MASS_ACCURACY_UNIT.equals("ppm"));
        ret.setMassShift(0.0);
        Scan scan = new Scan();
        scan.setId(Integer.valueOf(1));
        scan.setPrecursorMass(null);
        ArrayList<CalculationPeak> scan_peaks = new ArrayList<CalculationPeak>();
        for (Peak p : peaks.getPeaks()) {
            scan_peaks.add(new CalculationPeak(p.getMZ(), p.getIntensity()));
        }
        scan.setPeaks(scan_peaks);
        ret.setScan(scan);
        ArrayList<CalculationMolecule> residues = new ArrayList<CalculationMolecule>();
        if (pf_opt.MAX_PEN > 0) {
            residues.add(new CalculationMolecule("Pen", defaultMasses.getResidueMass("pen", persubstitution, monoisotopic), pf_opt.MIN_PEN, pf_opt.MAX_PEN));
        }
        if (pf_opt.MAX_HEX > 0) {
            residues.add(new CalculationMolecule("Hex", defaultMasses.getResidueMass("hex", persubstitution, monoisotopic), pf_opt.MIN_HEX, pf_opt.MAX_HEX));
        }
        if (pf_opt.MAX_HEP > 0) {
            residues.add(new CalculationMolecule("Hept", defaultMasses.getResidueMass("hep", persubstitution, monoisotopic), pf_opt.MIN_HEP, pf_opt.MAX_HEP));
        }
        if (pf_opt.MAX_HEXN > 0) {
            residues.add(new CalculationMolecule("HexN", defaultMasses.getResidueMass("hexn", persubstitution, monoisotopic), pf_opt.MIN_HEXN, pf_opt.MAX_HEXN));
        }
        if (pf_opt.MAX_HEXNAC > 0) {
            residues.add(new CalculationMolecule("HexNAc", defaultMasses.getResidueMass("hexnac", persubstitution, monoisotopic), pf_opt.MIN_HEXNAC, pf_opt.MAX_HEXNAC));
        }
        if (pf_opt.MAX_DPEN > 0) {
            residues.add(new CalculationMolecule("dPen", defaultMasses.getResidueMass("dpen", persubstitution, monoisotopic), pf_opt.MIN_DPEN, pf_opt.MAX_DPEN));
        }
        if (pf_opt.MAX_DHEX > 0) {
            residues.add(new CalculationMolecule("dHex", defaultMasses.getResidueMass("dhex", persubstitution, monoisotopic), pf_opt.MIN_DHEX, pf_opt.MAX_DHEX));
        }
        if (pf_opt.MAX_DDHEX > 0) {
            residues.add(new CalculationMolecule("ddHex", defaultMasses.getResidueMass("ddhex", persubstitution, monoisotopic), pf_opt.MIN_DDHEX, pf_opt.MAX_DDHEX));
        }
        if (pf_opt.MAX_MEHEX > 0) {
            residues.add(new CalculationMolecule("MeH", defaultMasses.getResidueMass("(4mehex)", persubstitution, monoisotopic), pf_opt.MIN_MEHEX, pf_opt.MAX_MEHEX));
        }
        if (pf_opt.MAX_OR1 > 0 && pf_opt.OR1_MASS > 0.0) {
            residues.add(new CalculationMolecule(pf_opt.OR1_NAME, pf_opt.OR1_MASS, pf_opt.MIN_OR1, pf_opt.MAX_OR1));
        }
        if (pf_opt.MAX_OR2 > 0 && pf_opt.OR1_MASS > 0.0) {
            residues.add(new CalculationMolecule(pf_opt.OR2_NAME, pf_opt.OR2_MASS, pf_opt.MIN_OR2, pf_opt.MAX_OR2));
        }
        if (pf_opt.MAX_OR3 > 0 && pf_opt.OR1_MASS > 0.0) {
            residues.add(new CalculationMolecule(pf_opt.OR3_NAME, pf_opt.OR3_MASS, pf_opt.MIN_OR3, pf_opt.MAX_OR3));
        }
        if (pf_opt.MAX_HEXA > 0) {
            residues.add(new CalculationMolecule("HexA", defaultMasses.getResidueMass("hexa", persubstitution, monoisotopic), pf_opt.MIN_HEXA, pf_opt.MAX_HEXA));
        }
        if (pf_opt.MAX_DHEXA > 0) {
            residues.add(new CalculationMolecule("dHexA", defaultMasses.getResidueMass("dhexa", persubstitution, monoisotopic), pf_opt.MIN_DHEXA, pf_opt.MAX_DHEXA));
        }
        if (pf_opt.MAX_NEU5GC > 0) {
            residues.add(new CalculationMolecule("NeuGc", defaultMasses.getResidueMass("neu5gc", persubstitution, monoisotopic), pf_opt.MIN_NEU5GC, pf_opt.MAX_NEU5GC));
        }
        if (pf_opt.MAX_NEU5AC > 0) {
            residues.add(new CalculationMolecule("NeuAc", defaultMasses.getResidueMass("neu5ac", persubstitution, monoisotopic), pf_opt.MIN_NEU5AC, pf_opt.MAX_NEU5AC));
        }
        if (pf_opt.MAX_NEU5GCLAC > 0) {
            residues.add(new CalculationMolecule("NeuGcLac", defaultMasses.getResidueMass("neu5gc-lac", persubstitution, monoisotopic), pf_opt.MIN_NEU5GCLAC, pf_opt.MAX_NEU5GCLAC));
        }
        if (pf_opt.MAX_NEU5ACLAC > 0) {
            residues.add(new CalculationMolecule("NeuAcLac", defaultMasses.getResidueMass("neu5ac-lac", persubstitution, monoisotopic), pf_opt.MIN_NEU5ACLAC, pf_opt.MAX_NEU5ACLAC));
        }
        if (pf_opt.MAX_KDO > 0) {
            residues.add(new CalculationMolecule("KDO", defaultMasses.getResidueMass("kdo", persubstitution, monoisotopic), pf_opt.MIN_KDO, pf_opt.MAX_KDO));
        }
        if (pf_opt.MAX_KDN > 0) {
            residues.add(new CalculationMolecule("KDN", defaultMasses.getResidueMass("kdn", persubstitution, monoisotopic), pf_opt.MIN_KDN, pf_opt.MAX_KDN));
        }
        if (pf_opt.MAX_MUR > 0) {
            residues.add(new CalculationMolecule("MurNAc", defaultMasses.getResidueMass("mur", persubstitution, monoisotopic), pf_opt.MIN_MUR, pf_opt.MAX_MUR));
        }
        if (pf_opt.MAX_S > 0 && defaultMasses.getResidueMass("s", persubstitution, monoisotopic) > 0.0) {
            residues.add(new CalculationMolecule("S", defaultMasses.getResidueMass("s", persubstitution, monoisotopic), pf_opt.MIN_S, pf_opt.MAX_S));
        }
        if (pf_opt.MAX_P > 0 && defaultMasses.getResidueMass("p", persubstitution, monoisotopic) > 0.0) {
            residues.add(new CalculationMolecule("P", defaultMasses.getResidueMass("p", persubstitution, monoisotopic), pf_opt.MIN_P, pf_opt.MAX_P));
        }
        if (pf_opt.MAX_AC > 0 && defaultMasses.getResidueMass("ac", persubstitution, monoisotopic) > 0.0) {
            residues.add(new CalculationMolecule("Ac", defaultMasses.getResidueMass("ac", persubstitution, monoisotopic), pf_opt.MIN_AC, pf_opt.MAX_AC));
        }
        if (pf_opt.MAX_PYR > 0 && defaultMasses.getResidueMass("pyr", persubstitution, monoisotopic) > 0.0) {
            residues.add(new CalculationMolecule("Pyr", defaultMasses.getResidueMass("pyr", persubstitution, monoisotopic), pf_opt.MIN_PYR, pf_opt.MAX_PYR));
        }
        if (pf_opt.MAX_PC > 0 && defaultMasses.getResidueMass("pc", persubstitution, monoisotopic) > 0.0) {
            residues.add(new CalculationMolecule("PC", defaultMasses.getResidueMass("pc", persubstitution, monoisotopic), pf_opt.MIN_PC, pf_opt.MAX_PC));
        }
        ret.setResidues(residues);
        if (frag_opt != null) {
            ArrayList<CalculationFragment> fragmentsRed = new ArrayList<CalculationFragment>();
            if (frag_opt.ADD_BFRAGMENTS) {
                fragmentsRed.add(new CalculationFragment("B", null, defaultMasses.getGlycosidicFragmentMass("b", monoisotopic)));
            }
            if (frag_opt.ADD_CFRAGMENTS) {
                fragmentsRed.add(new CalculationFragment("C", null, defaultMasses.getGlycosidicFragmentMass("c", monoisotopic)));
            }
            if (frag_opt.ADD_AFRAGMENTS) {
                for (CalculationMolecule cm : ret.getResidues()) {
                    String res = cm.getId();
                    String lc_res = cm.getId().toLowerCase();
                    for (int i = 0; i <= 3; ++i) {
                        for (int l = i + 2; l <= 5; ++l) {
                            try {
                                String name = "^{" + i + "," + l + "}A_{" + res + "}";
                                fragmentsRed.add(new CalculationFragment(name, res, defaultMasses.getCrossringFragmentMass("A", persubstitution, monoisotopic, lc_res, i, l)));
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            ret.setFragmentsRed(fragmentsRed);
            ArrayList<CalculationFragment> fragmentsNonRed = new ArrayList<CalculationFragment>();
            if (frag_opt.ADD_YFRAGMENTS) {
                fragmentsNonRed.add(new CalculationFragment("Y", null, defaultMasses.getGlycosidicFragmentMass("y", monoisotopic)));
            }
            if (frag_opt.ADD_ZFRAGMENTS) {
                fragmentsNonRed.add(new CalculationFragment("Z", null, defaultMasses.getGlycosidicFragmentMass("z", monoisotopic)));
            }
            if (frag_opt.ADD_XFRAGMENTS) {
                for (CalculationMolecule cm : ret.getResidues()) {
                    String res = cm.getId();
                    String lc_res = cm.getId().toLowerCase();
                    for (int i = 0; i <= 3; ++i) {
                        for (int l = i + 2; l <= 5; ++l) {
                            try {
                                String name = "^{" + i + "," + l + "}X_{" + res + "}";
                                fragmentsNonRed.add(new CalculationFragment(name, res, defaultMasses.getCrossringFragmentMass("X", persubstitution, monoisotopic, lc_res, i, l)));
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            ret.setFragmentsNonRed(fragmentsNonRed);
            ArrayList<Integer> nofragments = new ArrayList<Integer>();
            for (int i = 1; i <= frag_opt.MAX_NO_CLEAVAGES; ++i) {
                nofragments.add(i);
            }
            ret.setMultiFragments(nofragments);
        }
        ArrayList<CalculationIon> ions = new ArrayList<CalculationIon>();
        if (ann_opt.NEGATIVE_MODE) {
            ions.add(new CalculationIon("-H", -defaultMasses.getIonMass("h", monoisotopic), 1));
        } else {
            if (ann_opt.MAX_NO_H_IONS > 0) {
                ions.add(new CalculationIon("H", defaultMasses.getIonMass("h", monoisotopic), 1));
            }
            if (ann_opt.MAX_NO_NA_IONS > 0) {
                ions.add(new CalculationIon("Na", defaultMasses.getIonMass("na", monoisotopic), 1));
            }
            if (ann_opt.MAX_NO_LI_IONS > 0) {
                ions.add(new CalculationIon("Li", defaultMasses.getIonMass("li", monoisotopic), 1));
            }
            if (ann_opt.MAX_NO_K_IONS > 0) {
                ions.add(new CalculationIon("K", defaultMasses.getIonMass("k", monoisotopic), 1));
            }
        }
        ret.setIons(ions);
        ArrayList<Integer> nocharges = new ArrayList<Integer>();
        for (int i = 1; i <= ann_opt.MAX_NO_CHARGES; ++i) {
            nocharges.add(i);
        }
        ret.setCharges(nocharges);
        int max_no_exchanges = 0;
        ArrayList<CalculationIon> exchanges = new ArrayList<CalculationIon>();
        if (ann_opt.COMPUTE_EXCHANGES) {
            if (ann_opt.MAX_EX_NA_IONS > 0) {
                exchanges.add(new CalculationIon("Na", defaultMasses.getIonMass("na", monoisotopic), 1));
            }
            if (ann_opt.MAX_EX_LI_IONS > 0) {
                exchanges.add(new CalculationIon("Li", defaultMasses.getIonMass("li", monoisotopic), 1));
            }
            if (ann_opt.MAX_EX_K_IONS > 0) {
                exchanges.add(new CalculationIon("K", defaultMasses.getIonMass("k", monoisotopic), 1));
            }
            max_no_exchanges = Math.max(Math.max(ann_opt.MAX_EX_NA_IONS, ann_opt.MAX_EX_LI_IONS), ann_opt.MAX_EX_K_IONS);
        }
        ret.setIonExchangeIon(exchanges);
        max_no_exchanges = Math.min(max_no_exchanges, 20);
        ArrayList<Integer> exchangeNumbers = new ArrayList<Integer>();
        for (int i = 1; i <= max_no_exchanges; ++i) {
            exchangeNumbers.add(i);
        }
        ret.setIonExchangeCount(exchangeNumbers);
        ArrayList<CalculationDerivatisation> derivatization = new ArrayList<CalculationDerivatisation>();
        if (!pf_opt.REDUCING_END.equals("XXX")) {
            derivatization.add(new CalculationDerivatisation(pf_opt.REDUCING_END, defaultMasses.getDerivatisationMass(pf_opt.REDUCING_END, persubstitution, monoisotopic)));
        } else {
            derivatization.add(new CalculationDerivatisation(pf_opt.OTHER_REDEND_NAME, pf_opt.OTHER_REDEND_MASS));
        }
        ret.setDerivatisation(derivatization);
        ret.setCompletionNonRed(defaultMasses.getCompletionMass("nonred", persubstitution, monoisotopic));
        if (!pf_opt.REDUCING_END.equals("XXX")) {
            ret.setCompletionRed(defaultMasses.getCompletionMass("red", persubstitution, monoisotopic));
        } else {
            ret.setCompletionRed(defaultMasses.getCompletionMass("red", Persubstitution.None, monoisotopic));
        }
        ret.setNonReducingDifference(defaultMasses.getNonReducingDifference(persubstitution, monoisotopic));
        ret.setExchangeIonMass(defaultMasses.getExchangeIonMass(monoisotopic));
        return ret;
    }

    private void getResults(AnnotatedPeakList dest, PeakList peaks, CalculationParameter pf_results) {
        try {
            dest.clear();
            Glycan motif = new Glycan();
            for (CalculationPeak cp : pf_results.getScan().getPeaks()) {
                Peak p = new Peak(cp.getMz(), cp.getIntensity());
                for (org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.PeakAnnotation pa : cp.getAnnotation()) {
                    FragmentEntry fe = this.createFragmentEntry(pa);
                    if (!IonCloudUtils.isRealistic(fe)) continue;
                    this.annotated_peaks.addPeakAnnotation(motif, new PeakAnnotation(p, fe), true);
                }
            }
            PeakAnnotationCollection pac = this.annotated_peaks.getPeakAnnotationCollection(motif);
            for (Peak p : peaks.getPeaks()) {
                if (pac != null && pac.isAnnotated(p)) continue;
                this.annotated_peaks.addPeakAnnotation(motif, new PeakAnnotation(p), true);
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    private FragmentEntry createFragmentEntry(org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.PeakAnnotation pa) throws Exception {
        Glycan fragment = this.getCompositionAsGlycan(pa);
        String name = this.getFragmentName(pa);
        IonCloud charges = new IonCloud();
        for (AnnotationEntity ae : pa.getIons()) {
            if (ae.getId().startsWith("-")) {
                charges.add(ae.getId().substring(1), -ae.getNumber());
                continue;
            }
            charges.add(ae.getId(), ae.getNumber());
        }
        fragment.setCharges(charges);
        int no_exchanges = 0;
        IonCloud exchanges = new IonCloud();
        for (AnnotationEntity ae : pa.getIonExchange()) {
            exchanges.add(ae.getId(), ae.getNumber());
            no_exchanges += ae.getNumber();
        }
        exchanges.add("H", -no_exchanges);
        fragment.setNeutralExchanges(exchanges);
        return new FragmentEntry(fragment, name);
    }

    private Glycan getCompositionAsGlycan(org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.PeakAnnotation pa) throws Exception {
        Glycan ret;
        if (this.pf_opt.REDUCING_END.equals("XXX")) {
            ResidueType re_type = ResidueType.createOtherReducingEnd((String)this.pf_opt.OTHER_REDEND_NAME, (double)this.pf_opt.OTHER_REDEND_MASS);
            ret = Glycan.createComposition((MassOptions)new MassOptions(this.pf_opt.DERIVATIZATION, re_type.getName()));
        } else {
            ret = Glycan.createComposition((MassOptions)new MassOptions(this.pf_opt.DERIVATIZATION, this.pf_opt.REDUCING_END));
        }
        for (AnnotationEntity ae : pa.getResidues()) {
            for (int i = 0; i < ae.getNumber(); ++i) {
                if (ae.getId().equals(this.pf_opt.OR1_NAME)) {
                    ret.addAntenna(new Residue(ResidueType.createOtherResidue((String)this.pf_opt.OR1_NAME, (double)this.pf_opt.OR1_MASS)));
                    continue;
                }
                if (ae.getId().equals(this.pf_opt.OR2_NAME)) {
                    ret.addAntenna(new Residue(ResidueType.createOtherResidue((String)this.pf_opt.OR2_NAME, (double)this.pf_opt.OR2_MASS)));
                    continue;
                }
                if (ae.getId().equals(this.pf_opt.OR3_NAME)) {
                    ret.addAntenna(new Residue(ResidueType.createOtherResidue((String)this.pf_opt.OR3_NAME, (double)this.pf_opt.OR3_MASS)));
                    continue;
                }
                ret.addAntenna(ResidueDictionary.newResidue((String)ae.getId()));
            }
        }
        boolean first = true;
        for (AnnotationEntity ae : pa.getFragments()) {
            for (int i = 0; i < ae.getNumber(); ++i) {
                Residue cleavage = this.getCleavage(ae);
                if (cleavage.getCleavedResidue() == null) {
                    cleavage.setCleavedResidue(ResidueDictionary.newResidue((String)"Hex"));
                }
                if (cleavage.canBeReducingEnd()) {
                    ret.setRoot(cleavage);
                    continue;
                }
                ret.addAntenna(cleavage);
            }
        }
        return ret;
    }

    private Residue getCleavage(AnnotationEntity ae) throws Exception {
        if (ae.getId().equals("B")) {
            return ResidueDictionary.createBCleavage();
        }
        if (ae.getId().equals("C")) {
            return ResidueDictionary.createCCleavage();
        }
        if (ae.getId().equals("Y")) {
            return ResidueDictionary.createYCleavage();
        }
        if (ae.getId().equals("Z")) {
            return ResidueDictionary.createZCleavage();
        }
        Matcher m = crossring_pattern.matcher(ae.getId());
        if (m.matches()) {
            int first_pos = Integer.valueOf(m.group(1));
            int last_pos = Integer.valueOf(m.group(2));
            char type = m.group(3).charAt(0);
            return CrossRingFragmentDictionary.newCrossRingFragment((char)type, (int)first_pos, (int)last_pos, (Residue)ResidueDictionary.newResidue((String)m.group(4)));
        }
        throw new Exception("Invalid cleavage type: " + ae.getId());
    }

    private String getCompositionAsString(org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.PeakAnnotation pa) {
        StringBuilder sb_name = new StringBuilder();
        if (pa.getDerivatisation() != null && !pa.getDerivatisation().equals("freeEnd")) {
            sb_name.append(pa.getDerivatisation());
            sb_name.append('-');
        }
        for (AnnotationEntity ae : pa.getResidues()) {
            if (ae.getNumber() <= 0) continue;
            sb_name.append(ae.getId());
            sb_name.append("" + ae.getNumber());
        }
        boolean first = true;
        for (AnnotationEntity ae : pa.getFragments()) {
            if (ae.getNumber() <= 0) continue;
            if (first) {
                sb_name.append('/');
            } else {
                sb_name.append(',');
            }
            sb_name.append(ae.getId());
            if (ae.getNumber() > 1) {
                sb_name.append("" + ae.getNumber());
            }
            first = false;
        }
        return sb_name.toString();
    }

    private String getFragmentName(org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.PeakAnnotation pa) {
        StringBuilder sb_name = new StringBuilder();
        for (AnnotationEntity ae : pa.getFragments()) {
            if (ae.getNumber() <= 0) continue;
            sb_name.append(ae.getId());
            if (ae.getNumber() <= 1) continue;
            sb_name.append("" + ae.getNumber());
        }
        return sb_name.toString();
    }
}

