/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.ContinuousWaveletTransform;

public class ContinuousWaveletTransformNumIntegration
extends ContinuousWaveletTransform {
    public void transform(Peak[] data, int begin_input, int end_input, double resolution) {
        this.transform(data, begin_input, end_input, resolution, 0);
    }

    public void transform(Peak[] data, int begin_input, int end_input, double resolution, int zeros) {
        if (Math.abs(resolution - 1.0) < 1.0E-4) {
            int n;
            this.signal_length_ = n = end_input - begin_input;
            this.signal_ = new Peak[n];
            int help = begin_input;
            for (int i = 0; i < n; ++i) {
                this.signal_[i] = new Peak();
                this.signal_[i].setMZ(data[help].getMZ());
                this.signal_[i].setIntensity(this.integrate_(data, help, begin_input, end_input));
                ++help;
            }
            this.begin_right_padding_ = n;
            this.end_left_padding_ = -1;
        } else {
            int i;
            int n = (int)resolution * (end_input - begin_input);
            double origin = data[begin_input].getMZ();
            double spacing = (data[end_input - 1].getMZ() - origin) / (double)(n - 1);
            if (zeros > 0) {
                n += 2 * zeros;
            }
            double[] processed_input = new double[n];
            this.signal_ = new Peak[n];
            int it_help = begin_input;
            if (zeros > 0) {
                processed_input[0] = data[it_help].getMZ() - (double)zeros * spacing;
                for (int i2 = 0; i2 < zeros; ++i2) {
                    processed_input[i2] = 0.0;
                }
            } else {
                processed_input[0] = data[it_help].getIntensity();
            }
            for (int k = 1; k < n - zeros; ++k) {
                double x = origin + (double)k * spacing;
                while (it_help + 1 < end_input && data[it_help + 1].getMZ() < x) {
                    ++it_help;
                }
                processed_input[k] = this.getInterpolatedValue_(data, x, it_help);
            }
            if (zeros > 0) {
                for (i = 0; i < zeros; ++i) {
                    processed_input[n - zeros + i] = 0.0;
                }
            }
            for (i = 0; i < n; ++i) {
                this.signal_[i].setMZ(origin + (double)i * spacing);
                this.signal_[i].setIntensity(this.integrate_(processed_input, spacing, i));
            }
            if (zeros == 0) {
                this.begin_right_padding_ = n;
                this.end_left_padding_ = -1;
            } else {
                this.begin_right_padding_ = n - zeros;
                this.end_left_padding_ = zeros - 1;
            }
        }
    }

    @Override
    public void init(double scale, double spacing) {
        super.init(scale, spacing);
        int number_of_points_right = (int)Math.ceil(5.0 * this.scale_ / this.spacing_);
        int number_of_points = number_of_points_right + 1;
        this.wavelet_ = new double[number_of_points];
        this.wavelet_[0] = 1.0;
        for (int i = 1; i < number_of_points; ++i) {
            this.wavelet_[i] = this.marr_((double)i * this.spacing_ / this.scale_);
        }
    }

    protected double integrate_(Peak[] data, int x, int first, int last) {
        double distance;
        int help;
        double v = 0.0;
        int middle = this.wavelet_.length;
        double start_pos = data[x].getMZ() - (double)middle * this.spacing_ > data[first].getMZ() ? data[x].getMZ() - (double)middle * this.spacing_ : data[first].getMZ();
        double end_pos = data[x].getMZ() + (double)middle * this.spacing_ < data[last - 1].getMZ() ? data[x].getMZ() + (double)middle * this.spacing_ : data[last - 1].getMZ();
        for (help = x; help != first && data[help - 1].getMZ() > start_pos; --help) {
            distance = Math.abs(data[x].getMZ() - data[help].getMZ());
            int index_w_r = (int)Math.floor(distance / this.spacing_);
            double wavelet_right = this.wavelet_[index_w_r];
            distance = Math.abs(data[x].getMZ() - data[help - 1].getMZ());
            int index_w_l = (int)Math.floor(distance / this.spacing_);
            double wavelet_left = this.wavelet_[index_w_l];
            v += Math.abs(data[help - 1].getMZ() - data[help].getMZ()) / 2.0 * (data[help - 1].getIntensity() * wavelet_left + data[help].getIntensity() * wavelet_right);
        }
        for (help = x; help != last - 1 && data[help + 1].getMZ() < end_pos; ++help) {
            distance = Math.abs(data[x].getMZ() - data[help].getMZ());
            int index_w_l = (int)Math.floor(distance / this.spacing_);
            double wavelet_left = this.wavelet_[index_w_l];
            distance = Math.abs(data[x].getMZ() - data[help + 1].getMZ());
            int index_w_r = (int)Math.floor(distance / this.spacing_);
            double wavelet_right = this.wavelet_[index_w_r];
            v += Math.abs(data[help].getMZ() - data[help + 1].getMZ()) / 2.0 * (data[help].getIntensity() * wavelet_left + data[help + 1].getIntensity() * wavelet_right);
        }
        return v / Math.sqrt(this.scale_);
    }

    protected double integrate_(double[] processed_input, double spacing_data, int index) {
        int index_w_l;
        int index_w_r;
        int i;
        double v = 0.0;
        int half_width = this.wavelet_.length;
        int index_in_data = (int)Math.floor((double)half_width * this.spacing_ / spacing_data);
        int offset_data_left = index - index_in_data < 0 ? 0 : index - index_in_data;
        int offset_data_right = index + index_in_data > processed_input.length - 1 ? processed_input.length - 2 : index + index_in_data;
        for (i = index; i > offset_data_left; --i) {
            index_w_r = (int)Math.round((double)(index - i) * spacing_data / this.spacing_);
            index_w_l = (int)Math.round((double)(index - (i - 1)) * spacing_data / this.spacing_);
            v += spacing_data / 2.0 * (processed_input[i] * this.wavelet_[index_w_r] + processed_input[i - 1] * this.wavelet_[index_w_l]);
        }
        for (i = index; i < offset_data_right; ++i) {
            index_w_r = (int)Math.round((double)(i + 1 - index) * spacing_data / this.spacing_);
            index_w_l = (int)Math.round((double)(i - index) * spacing_data / this.spacing_);
            v += spacing_data / 2.0 * (processed_input[i + 1] * this.wavelet_[index_w_r] + processed_input[i] * this.wavelet_[index_w_l]);
        }
        return v / Math.sqrt(this.scale_);
    }

    private double marr_(double x) {
        return (1.0 - x * x) * Math.exp(-x * x / 2.0);
    }
}

