/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.Color;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.GraphicUtils;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportOptions;
import org.jdesktop.layout.GroupLayout;

public class AnnotationReportOptionsDialog
extends EscapeDialog
implements ActionListener {
    private AnnotationReportOptions theOptions = null;
    private HashMap<JButton, Color> field_color_map = new HashMap();
    private JColorChooser color_chooser = new JColorChooser();
    private JButton button_cancel;
    private JButton button_connection_lines_color;
    private JButton button_default;
    private JButton button_highlighted_color;
    private JButton button_mass_text_color;
    private JButton button_ok;
    private JButton button_spectrum_color;
    private JSpinner field_annotation_line_width;
    private JSpinner field_annotation_margin;
    private JComboBox field_annotation_mz_font;
    private JSpinner field_annotation_mz_size;
    private JTextField field_chart_height;
    private JTextField field_chart_width;
    private JTextField field_chart_x_margin;
    private JTextField field_chart_y_margin;
    private JTextField field_draw_x_margin;
    private JTextField field_draw_y_margin;
    private JSpinner field_scale_glycans;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;

    public AnnotationReportOptionsDialog(Frame parent, AnnotationReportOptions options) {
        super(parent, true);
        this.theOptions = options;
        this.initComponents();
        this.initData(this.theOptions);
        this.setTraversal();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
    }

    private Icon createIcon(Color color) {
        BufferedImage img = GraphicUtils.createImage((int)150, (int)15, (boolean)true);
        Graphics2D g2d = img.createGraphics();
        g2d.setBackground(color);
        g2d.clearRect(0, 0, 150, 15);
        return new ImageIcon(img);
    }

    private void initData(AnnotationReportOptions options) {
        this.field_annotation_margin.setModel(new SpinnerNumberModel(1, 1, 24, 1));
        this.field_annotation_mz_size.setModel(new SpinnerNumberModel(1, 1, 24, 1));
        this.field_annotation_mz_font.setModel(new DefaultComboBoxModel(GraphicOptions.getAllFontFaces()));
        this.field_annotation_line_width.setModel(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.1));
        this.field_scale_glycans.setModel(new SpinnerNumberModel(0.0, 0.0, 2.0, 0.05));
        this.field_draw_x_margin.setText("" + options.DRAW_X_MARGIN);
        this.field_draw_y_margin.setText("" + options.DRAW_Y_MARGIN);
        this.field_chart_width.setText("" + options.CHART_WIDTH_NONSCALED);
        this.field_chart_height.setText("" + options.CHART_HEIGHT_NONSCALED);
        this.field_chart_x_margin.setText("" + options.CHART_X_MARGIN_NONSCALED);
        this.field_chart_y_margin.setText("" + options.CHART_Y_MARGIN_NONSCALED);
        this.field_annotation_margin.setValue(options.ANNOTATION_MARGIN_NONSCALED);
        this.field_annotation_mz_size.setValue(options.ANNOTATION_MZ_SIZE_NONSCALED);
        this.field_annotation_mz_font.setSelectedItem(options.ANNOTATION_MZ_FONT);
        this.field_annotation_line_width.setValue(options.ANNOTATION_LINE_WIDTH);
        this.field_scale_glycans.setValue(options.SCALE_GLYCANS_NONSCALED);
        this.field_color_map.put(this.button_spectrum_color, options.SPECTRUM_COLOR);
        this.field_color_map.put(this.button_mass_text_color, options.MASS_TEXT_COLOR);
        this.field_color_map.put(this.button_connection_lines_color, options.CONNECTION_LINES_COLOR);
        this.field_color_map.put(this.button_highlighted_color, options.HIGHLIGHTED_COLOR);
        for (Map.Entry<JButton, Color> e : this.field_color_map.entrySet()) {
            e.getKey().setIcon(this.createIcon(e.getValue()));
        }
        this.pack();
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.field_draw_x_margin);
        tp.addComponent((Component)this.field_draw_y_margin);
        tp.addComponent((Component)this.field_chart_width);
        tp.addComponent((Component)this.field_chart_height);
        tp.addComponent((Component)this.field_chart_x_margin);
        tp.addComponent((Component)this.field_chart_y_margin);
        tp.addComponent((Component)this.field_annotation_margin);
        tp.addComponent((Component)this.field_annotation_mz_size);
        tp.addComponent((Component)this.field_annotation_mz_font);
        tp.addComponent((Component)this.field_annotation_line_width);
        tp.addComponent((Component)this.field_scale_glycans);
        tp.addComponent((Component)this.button_spectrum_color);
        tp.addComponent((Component)this.button_mass_text_color);
        tp.addComponent((Component)this.button_connection_lines_color);
        tp.addComponent((Component)this.button_highlighted_color);
        tp.addComponent((Component)this.button_cancel);
        tp.addComponent((Component)this.button_default);
        tp.addComponent((Component)this.button_ok);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setActions() {
        for (Map.Entry<JButton, Color> e : this.field_color_map.entrySet()) {
            e.getKey().addActionListener(this);
            e.getKey().setActionCommand("Change color");
        }
        this.button_default.addActionListener(this);
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
    }

    private void retrieveData() {
        this.theOptions.DRAW_X_MARGIN = Integer.valueOf(this.field_draw_x_margin.getText());
        this.theOptions.DRAW_Y_MARGIN = Integer.valueOf(this.field_draw_y_margin.getText());
        this.theOptions.CHART_WIDTH_NONSCALED = Integer.valueOf(this.field_chart_width.getText());
        this.theOptions.CHART_HEIGHT_NONSCALED = Integer.valueOf(this.field_chart_height.getText());
        this.theOptions.CHART_X_MARGIN_NONSCALED = Integer.valueOf(this.field_chart_x_margin.getText());
        this.theOptions.CHART_Y_MARGIN_NONSCALED = Integer.valueOf(this.field_chart_y_margin.getText());
        this.theOptions.ANNOTATION_MARGIN_NONSCALED = (Integer)this.field_annotation_margin.getValue();
        this.theOptions.ANNOTATION_MZ_SIZE_NONSCALED = (Integer)this.field_annotation_mz_size.getValue();
        this.theOptions.ANNOTATION_MZ_FONT = (String)this.field_annotation_mz_font.getSelectedItem();
        this.theOptions.ANNOTATION_LINE_WIDTH = (Double)this.field_annotation_line_width.getValue();
        this.theOptions.SCALE_GLYCANS_NONSCALED = (Double)this.field_scale_glycans.getValue();
        this.theOptions.SPECTRUM_COLOR = this.field_color_map.get(this.button_spectrum_color);
        this.theOptions.MASS_TEXT_COLOR = this.field_color_map.get(this.button_mass_text_color);
        this.theOptions.CONNECTION_LINES_COLOR = this.field_color_map.get(this.button_connection_lines_color);
        this.theOptions.HIGHLIGHTED_COLOR = this.field_color_map.get(this.button_highlighted_color);
        this.theOptions.setScale(this.theOptions.SCALE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "Default") {
            this.initData(new AnnotationReportOptions());
        } else if (action == "Change color") {
            this.changeColor((JButton)e.getSource());
        } else if (action == "OK") {
            this.return_status = action;
            this.retrieveData();
            this.closeDialog();
        } else if (action == "Cancel") {
            this.return_status = action;
            this.closeDialog();
        }
    }

    public void changeColor(final JButton field) {
        this.color_chooser.setColor(this.field_color_map.get(field));
        JDialog dlg = JColorChooser.createDialog((Component)((Object)this), "Select new color", true, this.color_chooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationReportOptionsDialog.this.field_color_map.put(field, AnnotationReportOptionsDialog.this.color_chooser.getColor());
                field.setIcon(AnnotationReportOptionsDialog.this.createIcon(AnnotationReportOptionsDialog.this.color_chooser.getColor()));
            }
        }, null);
        dlg.setVisible(true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.field_draw_x_margin = new JTextField();
        this.jLabel2 = new JLabel();
        this.field_draw_y_margin = new JTextField();
        this.jLabel3 = new JLabel();
        this.field_chart_width = new JTextField();
        this.jLabel4 = new JLabel();
        this.field_chart_height = new JTextField();
        this.jLabel5 = new JLabel();
        this.field_chart_x_margin = new JTextField();
        this.jLabel6 = new JLabel();
        this.field_chart_y_margin = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.field_annotation_margin = new JSpinner();
        this.field_annotation_mz_size = new JSpinner();
        this.jLabel9 = new JLabel();
        this.field_annotation_mz_font = new JComboBox();
        this.jLabel10 = new JLabel();
        this.field_annotation_line_width = new JSpinner();
        this.jLabel11 = new JLabel();
        this.field_scale_glycans = new JSpinner();
        this.jSeparator1 = new JSeparator();
        this.button_default = new JButton();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.button_spectrum_color = new JButton();
        this.jLabel12 = new JLabel();
        this.button_mass_text_color = new JButton();
        this.jLabel13 = new JLabel();
        this.button_connection_lines_color = new JButton();
        this.jLabel14 = new JLabel();
        this.button_highlighted_color = new JButton();
        this.jLabel15 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AnnotationReportOptionsDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Canvas X margin");
        this.field_draw_x_margin.setText("jTextField1");
        this.jLabel2.setText("Canvas Y margin");
        this.field_draw_y_margin.setText("jTextField1");
        this.jLabel3.setText("Chart width");
        this.field_chart_width.setText("jTextField1");
        this.jLabel4.setText("Chart height");
        this.field_chart_height.setText("jTextField1");
        this.jLabel5.setText("Chart X margin");
        this.field_chart_x_margin.setText("jTextField1");
        this.jLabel6.setText("Chart Y margin");
        this.field_chart_y_margin.setText("jTextField1");
        this.jLabel7.setText("m/z text margin");
        this.jLabel8.setText("m/z text size");
        this.jLabel9.setText("m/z text font");
        this.field_annotation_mz_font.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel10.setText("Line width");
        this.jLabel11.setText("Structures scale factor");
        this.button_default.setText("Default");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.button_spectrum_color.setText(" ");
        this.jLabel12.setText("Spectrum color");
        this.button_mass_text_color.setText(" ");
        this.jLabel13.setText("Mass text color");
        this.button_connection_lines_color.setText(" ");
        this.jLabel14.setText("Connection lines color");
        this.button_highlighted_color.setText(" ");
        this.jLabel15.setText("Highlighted color");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(55, 55, 55).add((Component)this.button_default).addPreferredGap(0).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel)).add(2, (Component)this.jSeparator1, -1, 326, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel9, -1, 145, Short.MAX_VALUE).add((Component)this.jLabel8, -1, 145, Short.MAX_VALUE).add((Component)this.jLabel7, -1, 145, Short.MAX_VALUE).add((Component)this.jLabel6, -1, 145, Short.MAX_VALUE).add((Component)this.jLabel5, -1, 145, Short.MAX_VALUE).add(2, (Component)this.jLabel1, -1, 145, Short.MAX_VALUE).add((Component)this.jLabel4, -1, 145, Short.MAX_VALUE).add((Component)this.jLabel2, -1, 145, Short.MAX_VALUE).add((Component)this.jLabel3, -1, 145, Short.MAX_VALUE).add((Component)this.jLabel10, -1, 145, Short.MAX_VALUE).add(2, (Component)this.jLabel11, -1, -1, Short.MAX_VALUE).add((Component)this.jLabel12)).addPreferredGap(0)).add((Component)this.jLabel13).add((Component)this.jLabel14)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel15).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.button_mass_text_color, -1, 169, Short.MAX_VALUE).add((Component)this.field_annotation_mz_font, 0, 169, Short.MAX_VALUE).add((Component)this.field_draw_y_margin, -1, 169, Short.MAX_VALUE).add((Component)this.field_chart_width, -1, 169, Short.MAX_VALUE).add((Component)this.field_chart_height, -1, 169, Short.MAX_VALUE).add((Component)this.field_chart_x_margin, -1, 169, Short.MAX_VALUE).add((Component)this.field_chart_y_margin, -1, 169, Short.MAX_VALUE).add((Component)this.field_annotation_margin, -1, 169, Short.MAX_VALUE).add((Component)this.field_draw_x_margin, -1, 169, Short.MAX_VALUE).add((Component)this.field_annotation_mz_size, -1, 169, Short.MAX_VALUE).add((Component)this.field_annotation_line_width, -1, 169, Short.MAX_VALUE).add((Component)this.field_scale_glycans, -1, 169, Short.MAX_VALUE).add((Component)this.button_spectrum_color, -1, 169, Short.MAX_VALUE).add(2, (Component)this.button_connection_lines_color, -1, 169, Short.MAX_VALUE).add((Component)this.button_highlighted_color, -1, 169, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_default, this.button_ok}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.field_draw_x_margin, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.field_draw_y_margin, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.field_chart_width, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4, -2, 15, -2).add((Component)this.field_chart_height, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.field_chart_x_margin, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.field_chart_y_margin, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.field_annotation_margin, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.field_annotation_mz_size, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.field_annotation_mz_font, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.field_annotation_line_width, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.field_scale_glycans, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_spectrum_color).add((Component)this.jLabel12)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.button_mass_text_color)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel14).add((Component)this.button_connection_lines_color)).addPreferredGap(0, 10, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_highlighted_color).add((Component)this.jLabel15)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_default).add((Component)this.button_ok).add((Component)this.button_cancel)).addContainerGap()));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

