/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.layer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter2;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class NatLayerPainter
implements ILayerPainter {
    private static final Log log = LogFactory.getLog(NatLayerPainter.class);
    private final NatTable natTable;

    public NatLayerPainter(NatTable natTable) {
        this.natTable = natTable;
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        try {
            this.paintBackground(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
            gc.setForeground(this.natTable.getForeground());
            ILayerPainter layerPainter = this.natTable.getLayer().getLayerPainter();
            layerPainter.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
            this.paintOverlays(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
        }
        catch (Exception e) {
            log.error((Object)"Error while painting table", (Throwable)e);
        }
    }

    protected void paintBackground(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        gc.setBackground(this.natTable.getBackground());
        gc.fillRectangle(rectangle);
    }

    protected void paintOverlays(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        for (IOverlayPainter overlayPainter : this.natTable.getOverlayPainters()) {
            if (overlayPainter instanceof IOverlayPainter2) {
                ((IOverlayPainter2)overlayPainter).paintOverlay(this.natTable, gc, xOffset, yOffset, rectangle);
                continue;
            }
            overlayPainter.paintOverlay(gc, this.natTable);
        }
    }

    @Override
    public Rectangle adjustCellBounds(int columnPosition, int rowPosition, Rectangle cellBounds) {
        ILayerPainter layerPainter = this.natTable.getLayer().getLayerPainter();
        return layerPainter.adjustCellBounds(columnPosition, rowPosition, cellBounds);
    }
}

