/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.print;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.formula.command.DisableFormulaCachingCommand;
import org.eclipse.nebula.widgets.nattable.formula.command.EnableFormulaCachingCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.resize.AutoResizeHelper;
import org.eclipse.nebula.widgets.nattable.summaryrow.command.CalculateSummaryRowValuesCommand;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LayerPrinter {
    private final IConfigRegistry configRegistry;
    private final ILayer layer;
    private final IClientAreaProvider originalClientAreaProvider;
    public static final int FOOTER_HEIGHT_IN_PRINTER_DPI = 300;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm a");
    private final String footerDate;
    protected boolean preRender = true;

    public LayerPrinter(ILayer layer, IConfigRegistry configRegistry) {
        this.layer = layer;
        this.configRegistry = configRegistry;
        this.originalClientAreaProvider = layer.getClientAreaProvider();
        this.footerDate = this.dateFormat.format(new Date());
    }

    private float[] computeScaleFactor(Printer printer) {
        Point screenDPI = Display.getDefault().getDPI();
        Point printerDPI = printer.getDPI();
        float sfX = Float.valueOf(printerDPI.x).floatValue() / Float.valueOf(screenDPI.x).floatValue();
        float sfY = Float.valueOf(printerDPI.y).floatValue() / Float.valueOf(screenDPI.y).floatValue();
        return new float[]{sfX, sfY};
    }

    private Rectangle getTotalArea() {
        return new Rectangle(0, 0, this.layer.getWidth(), this.layer.getHeight());
    }

    private Point getPageCount(Printer printer) {
        Rectangle layerArea = this.getTotalArea();
        Rectangle printArea = this.computePrintArea(printer);
        float[] scaleFactor = this.computeScaleFactor(printer);
        int numOfHorizontalPages = Float.valueOf((float)layerArea.width / ((float)printArea.width / scaleFactor[0])).intValue();
        int numOfVerticalPages = Float.valueOf((float)layerArea.height / ((float)(printArea.height - 300) / scaleFactor[1])).intValue();
        return new Point(numOfHorizontalPages + 1, numOfVerticalPages + 1);
    }

    public void print(Shell shell) {
        this.layer.doCommand(new TurnViewportOffCommand());
        Printer printer = null;
        try {
            printer = this.setupPrinter(shell);
            if (printer == null) {
                return;
            }
        }
        finally {
            this.layer.doCommand(new TurnViewportOnCommand());
        }
        Display.getDefault().asyncExec((Runnable)new PrintJob(printer));
    }

    private boolean shouldPrint(PrinterData printerData, int totalPageCount) {
        if (printerData.scope == 1) {
            return totalPageCount >= printerData.startPage && totalPageCount <= printerData.endPage;
        }
        return true;
    }

    private Printer setupPrinter(Shell shell) {
        Printer defaultPrinter = new Printer();
        Point pageCount = this.getPageCount(defaultPrinter);
        defaultPrinter.dispose();
        PrintDialog printDialog = new PrintDialog(shell);
        printDialog.setStartPage(1);
        printDialog.setEndPage(pageCount.x * pageCount.y);
        printDialog.setScope(0);
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            return null;
        }
        return new Printer(printerData);
    }

    private Rectangle computePrintArea(Printer printer) {
        int bottom;
        int top;
        int right;
        Rectangle rect = printer.getClientArea();
        Rectangle trim = printer.computeTrim(0, 0, 0, 0);
        Point dpi = printer.getDPI();
        dpi.x /= 2;
        dpi.y /= 2;
        int left = trim.x + dpi.x;
        if (left < rect.x) {
            left = rect.x;
        }
        if ((right = rect.width + trim.x + trim.width - dpi.x) > rect.width) {
            right = rect.width;
        }
        if ((top = trim.y + dpi.y) < rect.y) {
            top = rect.y;
        }
        if ((bottom = rect.height + trim.y + trim.height - dpi.y) > rect.height) {
            bottom = rect.height;
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public void enablePreRendering() {
        this.preRender = true;
    }

    public void disablePreRendering() {
        this.preRender = false;
    }

    private class PrintJob
    implements Runnable {
        private final Printer printer;

        private PrintJob(Printer printer) {
            this.printer = printer;
        }

        @Override
        public void run() {
            float[] scaleFactor = LayerPrinter.this.computeScaleFactor(this.printer);
            Integer width = LayerPrinter.this.configRegistry.getConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH, "NORMAL", new String[0]);
            if (width == null) {
                LayerPrinter.this.configRegistry.registerConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH, 2);
            }
            if (LayerPrinter.this.preRender) {
                Transform tempTransform = new Transform((Device)this.printer);
                tempTransform.scale(scaleFactor[0], scaleFactor[1]);
                AutoResizeHelper.autoResize(LayerPrinter.this.layer, LayerPrinter.this.configRegistry);
                tempTransform.dispose();
            }
            if (this.printer.startJob("NatTable")) {
                try {
                    LayerPrinter.this.layer.doCommand(new CalculateSummaryRowValuesCommand());
                    LayerPrinter.this.layer.doCommand(new TurnViewportOffCommand());
                    LayerPrinter.this.layer.doCommand(new DisableFormulaCachingCommand());
                    this.setLayerSize(this.printer.getPrinterData());
                    Rectangle printerClientArea = LayerPrinter.this.computePrintArea(this.printer);
                    Point pageCount = LayerPrinter.this.getPageCount(this.printer);
                    GC gc = new GC((Drawable)this.printer);
                    int currentPage = 1;
                    int verticalPageNumber = 0;
                    while (verticalPageNumber < pageCount.y) {
                        int horizontalPageNumber = 0;
                        while (horizontalPageNumber < pageCount.x) {
                            Rectangle printBounds = new Rectangle(Float.valueOf((float)printerClientArea.width / scaleFactor[0] * (float)horizontalPageNumber).intValue(), Float.valueOf((float)(printerClientArea.height - 300) / scaleFactor[1] * (float)verticalPageNumber).intValue(), Float.valueOf((float)printerClientArea.width / scaleFactor[0]).intValue(), Float.valueOf((float)(printerClientArea.height - 300) / scaleFactor[1]).intValue());
                            if (LayerPrinter.this.shouldPrint(this.printer.getPrinterData(), currentPage)) {
                                this.printer.startPage();
                                Transform printerTransform = new Transform((Device)this.printer);
                                printerTransform.scale(scaleFactor[0], scaleFactor[1]);
                                printerTransform.translate((float)printerClientArea.x / scaleFactor[0], (float)printerClientArea.y / scaleFactor[1]);
                                printerTransform.translate((float)(-1 * printBounds.x), (float)(-1 * printBounds.y));
                                gc.setTransform(printerTransform);
                                this.printLayer(gc, printBounds);
                                this.printFooter(gc, currentPage, printBounds);
                                this.printer.endPage();
                                printerTransform.dispose();
                            }
                            ++currentPage;
                            ++horizontalPageNumber;
                        }
                        ++verticalPageNumber;
                    }
                    this.printer.endJob();
                    gc.dispose();
                    this.printer.dispose();
                }
                finally {
                    this.restoreLayerState();
                }
            }
            if (width == null) {
                LayerPrinter.this.configRegistry.unregisterConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH);
            }
        }

        private void setLayerSize(PrinterData printerData) {
            if (printerData != null && printerData.scope == 2) {
                LayerPrinter.this.layer.setClientAreaProvider(LayerPrinter.this.originalClientAreaProvider);
            } else {
                final Rectangle fullLayerSize = LayerPrinter.this.getTotalArea();
                LayerPrinter.this.layer.setClientAreaProvider(new IClientAreaProvider(){

                    @Override
                    public Rectangle getClientArea() {
                        return fullLayerSize;
                    }
                });
                LayerPrinter.this.layer.doCommand(new PrintEntireGridCommand());
            }
        }

        private void printLayer(GC gc, Rectangle printBounds) {
            LayerPrinter.this.layer.getLayerPainter().paintLayer(LayerPrinter.this.layer, gc, 0, 0, printBounds, LayerPrinter.this.configRegistry);
        }

        private void printFooter(GC gc, int totalPageCount, Rectangle printBounds) {
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.setBackground(Display.getCurrent().getSystemColor(1));
            gc.drawLine(printBounds.x, printBounds.y + printBounds.height + 10, printBounds.x + printBounds.width, printBounds.y + printBounds.height + 10);
            gc.drawText(String.valueOf(Messages.getString("Printer.page")) + " " + totalPageCount, printBounds.x, printBounds.y + printBounds.height + 15);
            gc.drawText(LayerPrinter.this.footerDate, printBounds.x + printBounds.width - 140, printBounds.y + printBounds.height + 15);
        }

        private void restoreLayerState() {
            LayerPrinter.this.layer.setClientAreaProvider(LayerPrinter.this.originalClientAreaProvider);
            LayerPrinter.this.layer.doCommand(new TurnViewportOnCommand());
            LayerPrinter.this.layer.doCommand(new EnableFormulaCachingCommand());
        }
    }
}

