/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.property.project;

import java.util.Date;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.grits.toolbox.core.datamodel.property.project.DateAdapter;
import org.grits.toolbox.core.datamodel.property.project.ProjectAction;

@XmlRootElement(name="event")
@XmlType(propOrder={"projectAction", "eventDate", "description", "addByDefault"})
public class ProjectEvent {
    private boolean addByDefault = false;
    private ProjectAction projectAction = null;
    private Date eventDate = null;
    private String description = null;

    @XmlAttribute(name="addByDefault", required=true)
    public boolean isAddByDefault() {
        return this.addByDefault;
    }

    public void setAddByDefault(boolean addByDefault) {
        this.addByDefault = addByDefault;
    }

    @XmlElement(name="projectAction", required=true)
    public ProjectAction getProjectAction() {
        return this.projectAction;
    }

    public void setProjectAction(ProjectAction projectAction) {
        this.projectAction = projectAction;
    }

    @XmlElement(name="eventDate", required=true)
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    @XmlAttribute(name="description", required=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlTransient
    public ProjectEvent getACopy() {
        ProjectEvent projectEvent = new ProjectEvent();
        projectEvent.setAddByDefault(this.addByDefault);
        projectEvent.setDescription(this.description);
        if (this.eventDate != null) {
            projectEvent.setEventDate(new Date(this.eventDate.getTime()));
        }
        if (this.projectAction != null) {
            projectEvent.setProjectAction(this.projectAction.getACopy());
        }
        return projectEvent;
    }

    public boolean matches(ProjectEvent projectEvent) {
        return this.projectAction == null && projectEvent.getProjectAction() == null || this.projectAction != null && projectEvent.getProjectAction() != null && Objects.equals(this.projectAction.getAction(), projectEvent.getProjectAction().getAction());
    }
}

