/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.preference.project.StringLabelProvider;
import org.grits.toolbox.core.preference.share.MultiChoicePreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.CheckboxStringSorter;

public class KeywordPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(KeywordPreference.class);
    public static final String PREFERENCE_PAGE_ID = "org.grits.toolbox.core.preference.project.keyword";
    public static String lastSelection = null;
    private MultiChoicePreference<String> keywordPreference = null;
    private List<String> otherKeywords = null;
    private List<String> defaultKeywords = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private TableViewerColumn tableColumn2 = null;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 15;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Keywords");
        label.setLayoutData((Object)new GridData(32, 2, true, false, 2, 1));
        this.checkboxTableViewer = this.createKeywordsTableViewer(container);
        Button addButton = this.createButton(container, "Add", true);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List allKeywords = (List)KeywordPreference.this.checkboxTableViewer.getInput();
                int newKeywordCount = 1;
                while (allKeywords.contains("Keyword " + newKeywordCount)) {
                    ++newKeywordCount;
                }
                String newKeyword = "Keyword " + newKeywordCount;
                KeywordPreference.this.otherKeywords.add(newKeyword);
                allKeywords.add(newKeyword);
                KeywordPreference.this.checkboxTableViewer.refresh();
                KeywordPreference.this.tableColumn2.getViewer().editElement((Object)newKeyword, 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = this.createButton(container, "Remove", false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.remove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.remove();
            }

            private void remove() {
                StructuredSelection selection = (StructuredSelection)KeywordPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    List allKeywords = (List)KeywordPreference.this.checkboxTableViewer.getInput();
                    String selectedKeyword = (String)selection.getFirstElement();
                    int selectionIndex = KeywordPreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                    if (KeywordPreference.this.defaultKeywords.contains(selectedKeyword)) {
                        KeywordPreference.this.defaultKeywords.remove(selectedKeyword);
                    } else {
                        KeywordPreference.this.otherKeywords.remove(selectedKeyword);
                    }
                    allKeywords.remove(selectedKeyword);
                    KeywordPreference.this.checkboxTableViewer.refresh();
                    if (!allKeywords.isEmpty()) {
                        selectionIndex = Math.min(selectionIndex, allKeywords.size() - 1);
                        KeywordPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection(KeywordPreference.this.checkboxTableViewer.getElementAt(selectionIndex)));
                    }
                }
            }
        });
        this.checkboxTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)KeywordPreference.this.checkboxTableViewer.getSelection();
                lastSelection = selection.isEmpty() ? lastSelection : (String)selection.getFirstElement();
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return KeywordPreference.this.defaultKeywords.contains(element);
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String selectedKeyword = (String)event.getElement();
                boolean checked = event.getChecked();
                if (checked) {
                    logger.debug((Object)("Select keyword : " + selectedKeyword));
                    KeywordPreference.this.defaultKeywords.add(selectedKeyword);
                    KeywordPreference.this.otherKeywords.remove(selectedKeyword);
                } else {
                    logger.debug((Object)("Unselect keyword : " + selectedKeyword));
                    KeywordPreference.this.otherKeywords.add(selectedKeyword);
                    KeywordPreference.this.defaultKeywords.remove(selectedKeyword);
                }
            }
        });
        this.loadValues();
        this.initializeTable();
        return container;
    }

    private void loadValues() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.ParameterizedPreference.KEYWORD.getPreferenceName()));
        this.keywordPreference = ProjectPreferenceStore.getMultiChoicePreference(ProjectPreferenceStore.ParameterizedPreference.KEYWORD);
        this.defaultKeywords = new ArrayList<String>();
        this.defaultKeywords.addAll(this.keywordPreference.getSelectedValues());
        this.otherKeywords = new ArrayList<String>();
        this.otherKeywords.addAll(this.keywordPreference.getOtherValues());
    }

    private Button createButton(Composite container, String buttonText, boolean grabHorizontal) {
        Button button = new Button(container, 0);
        button.setText(buttonText);
        GridData buttonData = new GridData(128);
        buttonData.widthHint = 80;
        buttonData.verticalSpan = 1;
        buttonData.grabExcessHorizontalSpace = grabHorizontal;
        buttonData.verticalAlignment = 2;
        buttonData.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    private void initializeTable() {
        ArrayList<String> allKeywords = new ArrayList<String>();
        allKeywords.addAll(this.defaultKeywords);
        allKeywords.addAll(this.otherKeywords);
        Collections.sort(allKeywords, String.CASE_INSENSITIVE_ORDER);
        this.checkboxTableViewer.setInput(allKeywords);
        this.checkboxTableViewer.refresh();
    }

    private CheckboxTableViewer createKeywordsTableViewer(Composite container) {
        Table keywordsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 2;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 260;
        tableLayouData.heightHint = 300;
        keywordsTable.setLayoutData((Object)tableLayouData);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(keywordsTable, "Default");
        this.tableColumn2 = new TableViewerColumn((TableViewer)tableViewer, 4, 1);
        this.tableColumn2.getColumn().setText("Keywords");
        this.tableColumn2.getColumn().setWidth(300);
        this.tableColumn2.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer, tableViewer){
            TextCellEditor textEditor;
            {
                this.textEditor = new TextCellEditor((Composite)checkboxTableViewer.getTable());
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof String && value instanceof String) {
                    List allKeywords = (List)KeywordPreference.this.checkboxTableViewer.getInput();
                    String newValue = ((String)value).trim();
                    if (KeywordPreference.this.checkboxTableViewer.getChecked(element)) {
                        if (KeywordPreference.this.defaultKeywords.contains(element)) {
                            KeywordPreference.this.defaultKeywords.set(KeywordPreference.this.defaultKeywords.indexOf(element), newValue);
                        } else {
                            KeywordPreference.this.defaultKeywords.add(newValue);
                        }
                    } else if (KeywordPreference.this.otherKeywords.contains(element)) {
                        KeywordPreference.this.otherKeywords.set(KeywordPreference.this.otherKeywords.indexOf(element), newValue);
                    } else {
                        KeywordPreference.this.otherKeywords.add(newValue);
                    }
                    if (allKeywords.contains(element)) {
                        allKeywords.set(allKeywords.indexOf(element), newValue);
                    }
                    KeywordPreference.this.checkboxTableViewer.refresh();
                    KeywordPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)newValue));
                }
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                return element instanceof String ? this.textEditor : null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof String;
            }
        });
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this.tableColumn2.getColumn().addSelectionListener((SelectionListener)new CheckboxStringSorter(tableViewer));
        return tableViewer;
    }

    protected void performDefaults() {
        Map<String, Boolean> allKeywordsMap = this.keywordPreference.getDefaultValuesObjectMap();
        ArrayList<String> allKeywords = new ArrayList<String>();
        this.defaultKeywords = new ArrayList<String>();
        this.otherKeywords = new ArrayList<String>();
        for (String keyword : allKeywordsMap.keySet()) {
            allKeywords.add(keyword);
            if (allKeywordsMap.get(keyword).booleanValue()) {
                this.defaultKeywords.add(keyword);
                continue;
            }
            this.otherKeywords.add(keyword);
        }
        this.initializeTable();
        super.performDefaults();
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Keyword\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        List allKeywords = (List)this.checkboxTableViewer.getInput();
        String errorMessage = null;
        HashSet uniqueKeywords = new HashSet();
        uniqueKeywords.addAll(allKeywords);
        String string = errorMessage = uniqueKeywords.size() == allKeywords.size() ? errorMessage : "Duplicate Keywords";
        if (uniqueKeywords.contains("")) {
            errorMessage = "Empty Keyword";
            this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)""));
        }
        return errorMessage;
    }

    private boolean save() {
        List allKeywords = (List)this.checkboxTableViewer.getInput();
        this.keywordPreference.setSelectedValues(new ArrayList());
        this.keywordPreference.setOtherValues(new ArrayList());
        for (String keyword : allKeywords) {
            if (this.checkboxTableViewer.getChecked(keyword)) {
                this.keywordPreference.addSelectedValue(keyword);
                continue;
            }
            this.keywordPreference.addOtherValue(keyword);
        }
        return this.keywordPreference.savePreference();
    }
}

