/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.Collection;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanCanvas;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.Annotation;
import org.eurocarbdb.application.glycoworkbench.AnnotationSelection;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationMultiple;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.SortingTablePanel;

public class PeakAnnotationSummaryPanel
extends SortingTablePanel<AnnotatedPeakList>
implements ActionListener,
AnnotatedPeakList.AnnotationChangeListener {
    protected JToolBar theToolBarDocument;
    protected JToolBar theToolBarEdit;
    boolean update_header = false;

    @Override
    protected void initComponents() {
        super.initComponents();
        JPanel theToolBarPanel = new JPanel(new BorderLayout());
        this.theToolBarDocument = this.createToolBarDocument();
        this.theToolBarEdit = this.createToolBarEdit();
        theToolBarPanel.add((Component)this.theToolBarDocument, "North");
        theToolBarPanel.add((Component)this.theToolBarEdit, "Center");
        this.add((Component)theToolBarPanel, "South");
    }

    @Override
    public AnnotatedPeakList getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return workspace != null ? workspace.getAnnotatedPeakList() : null;
    }

    @Override
    public void setDocumentFromWorkspace(GlycanWorkspace workspace) {
        if (this.theDocument != null) {
            ((AnnotatedPeakList)((Object)this.theDocument)).removeAnnotationChangeListener(this);
        }
        this.theDocument = this.getDocumentFromWorkspace(workspace);
        if (this.theDocument == null) {
            this.theDocument = new AnnotatedPeakList();
        }
        ((AnnotatedPeakList)((Object)this.theDocument)).addAnnotationChangeListener(this);
        this.update_header = true;
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("new", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear all", 78, "", (ActionListener)this);
        this.theActionManager.add("open", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open", 79, "", (ActionListener)this);
        this.theActionManager.add("save", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE, Plugin.DEFAULT_ICON_SIZE), "Save", 83, "", (ActionListener)this);
        this.theActionManager.add("saveas", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE_AS, Plugin.DEFAULT_ICON_SIZE), "Save as...", 65, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("cut", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.CUT, Plugin.DEFAULT_ICON_SIZE), "Cut", -1, "", (ActionListener)this);
        this.theActionManager.add("copy", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.COPY, Plugin.DEFAULT_ICON_SIZE), "Copy", 67, "", (ActionListener)this);
        this.theActionManager.add("paste", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.PASTE, Plugin.DEFAULT_ICON_SIZE), "Paste", 80, "", (ActionListener)this);
        this.theActionManager.add("delete", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("deleteNew", Plugin.DEFAULT_ICON_SIZE), "Delete", -1, "", (ActionListener)this);
        this.theActionManager.add("transfer", FileUtils.defaultThemeManager.getImageIcon("transfer"), "Copy fragments into canvas", 86, "", (ActionListener)this);
        this.theActionManager.add("goto", FileUtils.defaultThemeManager.getImageIcon("goto"), "Jump to a specific m/z value", -1, "", (ActionListener)this);
        this.theActionManager.add("filterselection", FileUtils.defaultThemeManager.getImageIcon(""), "Show only selected annotations", -1, "", (ActionListener)this);
        this.theActionManager.add("showallrows", FileUtils.defaultThemeManager.getImageIcon(""), "Show all annotations", -1, "", (ActionListener)this);
        this.theActionManager.add("addIsotopeCurves", FileUtils.defaultThemeManager.getImageIcon(""), "Show isotopic distributions", -1, "", (ActionListener)this);
    }

    @Override
    protected void updateActions() {
        this.theActionManager.get("save").setEnabled(((AnnotatedPeakList)((Object)this.theDocument)).hasChanged());
        boolean has_selection = this.theTable.getSelectedRows().length > 0;
        this.theActionManager.get("cut").setEnabled(has_selection);
        this.theActionManager.get("copy").setEnabled(has_selection);
        this.theActionManager.get("delete").setEnabled(has_selection);
        this.theActionManager.get("transfer").setEnabled(has_selection);
        this.theActionManager.get("goto").setEnabled(this.getRowCount() > 0);
        this.theActionManager.get("filterselection").setEnabled(has_selection);
        this.theActionManager.get("showallrows").setEnabled(!this.theTableSorter.isAllRowsVisible());
        this.theActionManager.get("addIsotopeCurves").setEnabled(has_selection);
    }

    private JToolBar createToolBarDocument() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.add((Action)this.theActionManager.get("save"));
        toolbar.add((Action)this.theActionManager.get("saveas"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        return toolbar;
    }

    private JToolBar createToolBarEdit() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("cut"));
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("paste"));
        toolbar.add((Action)this.theActionManager.get("delete"));
        toolbar.add((Action)this.theActionManager.get("transfer"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("goto"));
        return toolbar;
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("cut"));
        menu.add((Action)this.theActionManager.get("copy"));
        menu.add((Action)this.theActionManager.get("paste"));
        menu.add((Action)this.theActionManager.get("delete"));
        menu.add((Action)this.theActionManager.get("transfer"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("filterselection"));
        menu.add((Action)this.theActionManager.get("showallrows"));
        menu.add((Action)this.theActionManager.get("addIsotopeCurves"));
        return menu;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Double.class;
        }
        if (columnIndex == 1) {
            return Double.class;
        }
        if (columnIndex == 2) {
            return Double.class;
        }
        return Vector.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Mass to\ncharge";
        }
        if (columnIndex == 1) {
            return "Intensity";
        }
        if (columnIndex == 2) {
            return "Relative\nintensity";
        }
        return "Structure" + (columnIndex - 3);
    }

    @Override
    public int getColumnCount() {
        return 3 + ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures();
    }

    @Override
    public int getRowCount() {
        return ((AnnotatedPeakList)((Object)this.theDocument)).getNoPeaks();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return ((AnnotatedPeakList)((Object)this.theDocument)).getMZ(rowIndex);
        }
        if (columnIndex == 1) {
            return ((AnnotatedPeakList)((Object)this.theDocument)).getIntensity(rowIndex);
        }
        if (columnIndex == 2) {
            return ((AnnotatedPeakList)((Object)this.theDocument)).getRelativeIntensity(rowIndex);
        }
        return ((AnnotatedPeakList)((Object)this.theDocument)).getFragments(rowIndex, columnIndex - 3);
    }

    public void clear() {
        ((AnnotatedPeakList)((Object)this.theDocument)).clear();
    }

    @Override
    public void updateData() {
    }

    @Override
    public void updateView() {
        if (this.update_header) {
            this.fireTableStructureChanged();
            for (int i = 0; i < ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures(); ++i) {
                this.theTable.getColumn("Structure" + i).setHeaderValue(((AnnotatedPeakList)((Object)this.theDocument)).getStructure(i));
            }
            this.update_header = false;
        }
        super.updateView();
    }

    public void onNew() {
        this.clear();
    }

    public void onPrint() {
        this.theTable.print(this.theWorkspace.getPrinterJob());
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void delete() {
        if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0) {
            this.ignore_document_changes = true;
            Vector<Peak> peaks = new Vector<Peak>();
            int[] sel_ind = this.theTable.getSelectedRows();
            for (int i = 0; i < sel_ind.length; ++i) {
                peaks.add(((AnnotatedPeakList)((Object)this.theDocument)).getPeak(this.theTableSorter.modelIndex(sel_ind[i])));
            }
            for (Peak p : peaks) {
                int ind = ((AnnotatedPeakList)((Object)this.theDocument)).indexOf(p);
                if (((AnnotatedPeakList)((Object)this.theDocument)).isAnnotated(p)) {
                    ((AnnotatedPeakList)((Object)this.theDocument)).clearAnnotationsFor(p);
                    this.fireRowChanged(this.theTableSorter.viewIndex(ind));
                    continue;
                }
                ((AnnotatedPeakList)((Object)this.theDocument)).removePeak(p);
                this.fireRowDeleted(this.theTableSorter.viewIndex(ind));
            }
            this.ignore_document_changes = false;
        }
    }

    public void copy() {
        int[] sel_inds = this.theTable.getSelectedRows();
        if (sel_inds.length > 0) {
            Collection cv;
            Object v;
            int focusRow = this.theTable.getSelectionModel().getLeadSelectionIndex();
            int focusColumn = this.theTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            Collection structures = null;
            if (focusRow != -1 && focusColumn != -1 && (v = this.getValueAt(focusRow, focusColumn)) instanceof Collection && (cv = (Collection)v).size() > 0 && cv.iterator().next() instanceof Glycan) {
                structures = cv;
            }
            int[] mod_inds = this.theTableSorter.modelIndexes(sel_inds);
            if (structures != null) {
                ClipUtils.setContents((Transferable)((Object)new AnnotationSelection(this.theTable.getSelectedData(), ((AnnotatedPeakList)((Object)this.theDocument)).extractAnnotations(mod_inds), (GlycanRendererAWT)this.theWorkspace.getGlycanRenderer(), structures)));
            } else {
                ClipUtils.setContents((Transferable)((Object)new AnnotationSelection(this.theTable.getSelectedData(), ((AnnotatedPeakList)((Object)this.theDocument)).extractAnnotations(mod_inds))));
            }
        }
    }

    public void paste() {
        try {
            Transferable t = ClipUtils.getContents();
            if (t != null && t.isDataFlavorSupported(AnnotationSelection.annotationFlavor)) {
                String content = TextUtils.consume((InputStream)((InputStream)t.getTransferData(AnnotationSelection.annotationFlavor)));
                ((AnnotatedPeakList)((Object)this.theDocument)).fromString(content, true, true);
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void transfer() {
        GlycanCanvas theCanvas = this.theApplication.getCanvas();
        this.copy();
        theCanvas.resetSelection();
        theCanvas.paste();
    }

    public void goToMZ() {
        int mod_ind;
        String m_z = JOptionPane.showInputDialog((Component)((Object)this.theApplication), (Object)"Insert m/z value");
        if (m_z != null && (mod_ind = ((AnnotatedPeakList)((Object)this.theDocument)).nearestTo(Double.valueOf(m_z))) != -1) {
            int sel_ind = this.theTableSorter.viewIndex(mod_ind);
            this.theTable.setRowSelectionInterval(sel_ind, sel_ind);
            this.theTable.scrollRectToVisible(this.theTable.getCellRect(sel_ind, 0, false));
        }
    }

    public void filterSelection() {
        int[] sel_inds = this.theTable.getSelectedRows();
        if (sel_inds != null & sel_inds.length > 0) {
            this.theTableSorter.setVisibleRows(this.theTableSorter.modelIndexes(sel_inds));
        }
    }

    public void showAllRows() {
        this.theTableSorter.resetVisibleRows();
    }

    public void addIsotopeCurves() {
        int focusRow = this.theTable.getSelectionModel().getLeadSelectionIndex();
        int focusColumn = this.theTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (focusRow == -1 || focusColumn == -1) {
            return;
        }
        PeakAnnotationMultiple pam = ((AnnotatedPeakList)((Object)this.theDocument)).getAnnotations(this.theTableSorter.modelIndex(focusRow));
        TreeMap<Peak, Vector<Annotation>> annotations = new TreeMap<Peak, Vector<Annotation>>();
        annotations.put(pam.getPeak(), pam.getAnnotations(Math.max(0, focusColumn - 3)));
        try {
            this.theApplication.getPluginManager().runAction("Spectra", "addIsotopeCurves", annotations);
            this.theApplication.getPluginManager().runAction("PeakList", "addIsotopeCurves", annotations);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("new")) {
            this.theApplication.onNew((BaseDocument)this.theDocument);
        } else if (action.equals("open")) {
            this.theApplication.onOpen(null, (BaseDocument)this.theDocument, false);
        } else if (action.equals("save")) {
            this.theApplication.onSave((BaseDocument)this.theDocument);
        } else if (action.equals("saveas")) {
            this.theApplication.onSaveAs((BaseDocument)this.theDocument);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("cut")) {
            this.cut();
        } else if (action.equals("copy")) {
            this.copy();
        } else if (action.equals("paste")) {
            this.paste();
        } else if (action.equals("delete")) {
            this.cut();
        } else if (action.equals("transfer")) {
            this.transfer();
        } else if (action.equals("goto")) {
            this.goToMZ();
        } else if (action.equals("filterselection")) {
            this.filterSelection();
        } else if (action.equals("showallrows")) {
            this.showAllRows();
        } else if (action.equals("addIsotopeCurves")) {
            this.addIsotopeCurves();
        }
        this.updateActions();
    }

    @Override
    public void structuresChanged(AnnotatedPeakList.AnnotationChangeEvent e) {
        if (!this.ignore_document_changes) {
            this.update_header = true;
            this.updateDocument();
        }
    }

    @Override
    public void annotationsChanged(AnnotatedPeakList.AnnotationChangeEvent e) {
        if (!this.ignore_document_changes) {
            this.updateDocument();
        }
    }

    @Override
    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        if (!this.ignore_document_changes) {
            this.update_header = true;
            super.documentInit(e);
        }
    }

    @Override
    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        if (!this.ignore_document_changes) {
            this.update_header = true;
            super.documentChanged(e);
        }
    }
}

