/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.commands;

import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartStackImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.entry.qrtpcr.manager.GeneListManagerEditor;

public class OpenGeneListManagerEditor {
    private Logger logger = Logger.getLogger(OpenGeneListManagerEditor.class);

    @Execute
    public Object execute(EModelService modelService, EPartService partService, MApplication application, IGritsUIService gritsUiService) {
        this.logger.debug((Object)"START COMMAND : Open Gene List Manager Editor ...");
        MPart managerPart = partService.findPart(GeneListManagerEditor.ID);
        if (managerPart == null) {
            this.logger.debug((Object)"Gene list manager part not found. Creating Gene List Manager part");
            managerPart = partService.createPart(GeneListManagerEditor.ID);
            this.logger.debug((Object)"Adding gene list manager to partstack - e4.primaryDataStack");
            PartStackImpl partStackImpl = (PartStackImpl)modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)application);
            partStackImpl.getChildren().add(managerPart);
        }
        partService.showPart(managerPart, EPartService.PartState.ACTIVATE);
        gritsUiService.selectPerspective("org.grits.toolbox.core.perspective.projectexplorer");
        this.logger.debug((Object)"...END COMMAND : Open Gene List Manager Editor");
        return null;
    }
}

