/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.editor;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.Section;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.ImageRegistry;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.model.ChartData;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRRun;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.table.MasterTableBase;
import org.grits.toolbox.entry.qrtpcr.table.QrtPCRNatTable;
import org.grits.toolbox.entry.qrtpcr.view.HistogramView;

public class MasterTablePage
implements IQrtPCRPart {
    private static final Logger logger = Logger.getLogger(MasterTablePage.class);
    QrtPCRTable qrtPCRTable;
    private List<Gene> geneList;
    Double lowerThreshold;
    Double stdevCutOff;
    QrtPCRTableEditor editor;
    private QrtPCRNatTable table;
    private CTabItem cTabItem;
    @Inject
    EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    MApplication application;

    @Inject
    public MasterTablePage(QrtPCRTable table, CTabItem cTabItem, @Named(value="lowerThresholdContext") Double l, @Named(value="stDevContext") Double s) {
        this.qrtPCRTable = table;
        this.cTabItem = cTabItem;
        this.lowerThreshold = l;
        this.stdevCutOff = s;
    }

    @PostConstruct
    protected void createFormContent(MPart part) {
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.cTabItem.getParent(), 768);
        GridData layoutData = new GridData();
        scrolledComposite.setLayoutData((Object)layoutData);
        scrolledComposite.setLayout((Layout)new GridLayout());
        Composite parent = new Composite((Composite)scrolledComposite, 4);
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite sectionParentComposite = new Composite(parent, 4);
        sectionParentComposite.setLayout((Layout)new FillLayout());
        Section section = new Section(sectionParentComposite, 320);
        section.setText("Data");
        Composite client = new Composite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        this.createLegend(client);
        ToolBarManager toolBarManager = new ToolBarManager();
        Action chartAction = new Action("Histogram"){

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.HISTOGRAM_ICON);
            }

            public void run() {
                ArrayList<ChartData> dataList = new ArrayList<ChartData>();
                String secondaryId = MasterTablePage.this.qrtPCRTable.getPlateDataMap().values().iterator().next().getName();
                MPart part = MasterTablePage.this.partService.createPart("qrtPCR-histogram");
                part.setLabel(secondaryId);
                List stacks = MasterTablePage.this.modelService.findElements((MUIElement)MasterTablePage.this.application, "org.grits.toolbox.core.partstack.histogramview", MPartStack.class, null);
                if (stacks.size() < 1) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error ", (String)"Part stack not found. Is the following ID correct?org.grits.toolbox.core.partstack.histogramview");
                    return;
                }
                ((MPartStack)stacks.get(0)).getChildren().add(part);
                ((MPartStack)stacks.get(0)).setVisible(true);
                MasterTablePage.this.partService.showPart(part, EPartService.PartState.ACTIVATE);
                HistogramView view = (HistogramView)part.getObject();
                if (MasterTablePage.this.geneList != null) {
                    for (Gene gene : MasterTablePage.this.geneList) {
                        if (!MasterTablePage.this.isSelected(gene)) continue;
                        ChartData data = new ChartData();
                        data.setGeneIdentifier(gene.getGeneIdentifier());
                        data.setGeneSymbol(gene.getGeneSymbol());
                        data.setValue(gene.getAdjustedAverage(gene.getRunId(), MasterTablePage.this.lowerThreshold, gene.getNormValue(gene.getRunId())));
                        data.setError(gene.getStDevForAdjusted(gene.getRunId(), MasterTablePage.this.lowerThreshold, gene.getNormValue(gene.getRunId())));
                        dataList.add(data);
                    }
                }
                view.setPartName(part.getLabel());
                if (!dataList.isEmpty()) {
                    view.initializeChart(dataList);
                } else {
                    ErrorUtils.createWarningMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"No Selection", (String)"Please select rows before displaying the histogram");
                }
            }

            public String getToolTipText() {
                return "Show average values in a histogram";
            }
        };
        Action selectAllAction = new Action("Select All"){

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.SELECT_ICON);
            }

            public String getToolTipText() {
                return this.getText();
            }

            public void run() {
                if (MasterTablePage.this.table != null) {
                    MasterTablePage.this.table.selectAll();
                }
            }
        };
        toolBarManager.add((IAction)selectAllAction);
        toolBarManager.add((IAction)chartAction);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        MasterTableBase myTable = new MasterTableBase(this.editor);
        myTable.setLowerThreshold(this.lowerThreshold);
        myTable.setStDevCutOff(this.stdevCutOff);
        this.geneList = QrtPCRRun.generateMasterTable(this.qrtPCRTable);
        myTable.setGeneList(this.geneList);
        this.table = (QrtPCRNatTable)myTable.createControl(client);
        this.table.setLayoutData(new GridData(4, 4, true, true, 1, 20));
        section.setClient((Control)client);
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.verticalSpan = 1;
        compositeLayoutData.horizontalSpan = 1;
        sectionParentComposite.setLayoutData((Object)compositeLayoutData);
        scrolledComposite.setContent((Control)parent);
        scrolledComposite.setMinSize(parent.computeSize(-1, -1));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        this.cTabItem.setControl((Control)scrolledComposite);
    }

    private void createLegend(Composite client) {
        Group legendGroup = new Group(client, 0);
        legendGroup.setText("Legend");
        legendGroup.setLayout((Layout)new GridLayout(2, true));
        Text highlightText = new Text((Composite)legendGroup, 2048);
        highlightText.setBackground(Display.getDefault().getSystemColor(5));
        highlightText.setEnabled(false);
        highlightText.setEditable(false);
        Label label = new Label((Composite)legendGroup, 0);
        label.setText("Rerun Genes");
    }

    boolean isSelected(Gene gene) {
        boolean selected = false;
        if (this.table != null) {
            return this.table.isSelected(gene);
        }
        return selected;
    }

    public void refreshInput() {
        if (this.table != null) {
            this.table.refresh();
        }
    }

    public void refreshInput(QrtPCRTable newTable) {
        this.qrtPCRTable = newTable;
        if (this.table != null) {
            List<Gene> geneList = QrtPCRRun.generateMasterTable(this.qrtPCRTable);
            ArrayList<TableData> tableData = new ArrayList<TableData>();
            tableData.addAll(geneList);
            this.table.setTableData(tableData);
            this.table.updateTable();
        }
    }

    public QrtPCRNatTable getTable() {
        return this.table;
    }
}

