/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.manager;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.manager.pages.GeneListOverviewPage;
import org.grits.toolbox.entry.qrtpcr.manager.pages.MasterGeneListPage;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreference;
import org.grits.toolbox.entry.qrtpcr.table.manager.ManagerNatTable;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;
import org.grits.toolbox.entry.qrtpcr.util.GeneUtils;

public class GeneListManagerEditor
implements IQrtPCRPart {
    public static String ID = "org.grits.toolbox.entry.qrtpcr.managerEditor";
    private static final Logger logger = Logger.getLogger(GeneListManagerEditor.class);
    public static final String MASTER_LIST = "masterList";
    public static final String MASTER_SUB_LIST = "masterSubList";
    public static final String GENE_SUB_LIST = "geneSubList";
    public static final String GENE_LIST = "geneList";
    List<GeneList> masterLists;
    List<GeneList> masterSubLists;
    List<File> masterGeneListFiles;
    List<File> masterGeneSubListFiles;
    @Inject
    private MDirtyable dirtyable = null;
    private GeneListOverviewPage overviewPage;
    private Map<CTabItem, IQrtPCRPart> cTabItemToPartTabMap = new HashMap<CTabItem, IQrtPCRPart>();
    private CTabFolder cTabFolder;

    @Inject
    public GeneListManagerEditor(@Named(value="configuration_location") String configLocation) {
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        File configFolder = new File(configFolderLocation);
        if (!configFolder.exists()) {
            try {
                FileUtils.copyMasterGeneListsFromJar();
            }
            catch (IOException e) {
                logger.warn((Object)"There are no master gene list files defined in the system", (Throwable)e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"There are no master gene list files defined in the system", (String)e.getMessage());
            }
        }
        this.masterGeneListFiles = new ArrayList<File>();
        this.masterGeneListFiles.addAll(Arrays.asList(configFolder.listFiles()));
        configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr" + File.separator + "sub-lists";
        configFolder = new File(configFolderLocation);
        this.masterGeneSubListFiles = new ArrayList<File>();
        if (configFolder.exists()) {
            this.masterGeneSubListFiles.addAll(Arrays.asList(configFolder.listFiles()));
        }
    }

    protected void addPages(MPart part) {
        if (this.masterLists == null) {
            return;
        }
        CTabItem cTabItem = new CTabItem(this.cTabFolder, 0);
        cTabItem.setText("Overview");
        cTabItem.setShowClose(false);
        part.getContext().set(CTabItem.class, (Object)cTabItem);
        part.getContext().set(MASTER_LIST, this.masterLists);
        part.getContext().set(MASTER_SUB_LIST, this.masterSubLists);
        this.overviewPage = (GeneListOverviewPage)ContextInjectionFactory.make(GeneListOverviewPage.class, (IEclipseContext)part.getContext());
        this.getcTabItemToPartTabMap().put(cTabItem, this.overviewPage);
    }

    @PostConstruct
    public void postConstruct(Composite parent, final MPart part) {
        logger.info((Object)"Creating tabs");
        this.cTabFolder = new CTabFolder(parent, 0);
        this.cTabFolder.setTabPosition(1024);
        this.cTabFolder.setLayoutData((Object)new GridData(4, 4, true, false));
        this.cTabFolder.setSimple(false);
        part.getContext().set(CTabFolder.class, (Object)this.cTabFolder);
        this.masterLists = new ArrayList<GeneList>();
        this.masterSubLists = new ArrayList<GeneList>();
        try {
            this.loadFiles(this.masterLists, this.masterGeneListFiles);
            this.loadFiles(this.masterSubLists, this.masterGeneSubListFiles);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot find the gene list", (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot find the gene list");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Cannot retrieve the gene list", (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot retrieve the gene list");
        }
        catch (JAXBException e) {
            logger.error((Object)"Cannot retrieve the gene list", (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot retrieve the gene list");
        }
        catch (IOException e) {
            logger.error((Object)"Cannot retrieve the gene list", (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot retrieve the gene list");
        }
        this.cTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.changeTab(e);
            }

            private void changeTab(SelectionEvent e) {
                int selectionIndex = GeneListManagerEditor.this.cTabFolder.getSelectionIndex();
                logger.info((Object)("Tab changed to " + selectionIndex));
                selectionIndex = selectionIndex < 0 ? 0 : selectionIndex;
                IQrtPCRPart currentTab = GeneListManagerEditor.this.getcTabItemToPartTabMap().get(GeneListManagerEditor.this.cTabFolder.getSelection());
                part.getContext().set(IQrtPCRPart.class, (Object)currentTab);
                GeneListManagerEditor.this.cTabFolder.getSelection().notifyListeners(13, new Event());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.changeTab(e);
            }
        });
        this.addPages(part);
        int selectionIndex = this.getcTabItemToPartTabMap().size() - 1;
        this.cTabFolder.setSelection(selectionIndex);
        this.cTabFolder.notifyListeners(13, new Event());
    }

    private void loadFiles(List<GeneList> geneLists, List<File> files) throws JAXBException, IOException {
        for (File file : files) {
            if (file.isDirectory() || file.isHidden()) continue;
            FileInputStream inputStream = new FileInputStream(file.getAbsolutePath());
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GeneList.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            GeneList geneList = (GeneList)unmarshaller.unmarshal((Reader)reader);
            geneList.setFilename(file.getName());
            if (geneList.getGenes() == null) {
                geneList.setGenes(new ArrayList<Gene>());
            }
            geneLists.add(geneList);
            reader.close();
            inputStream.close();
        }
    }

    @Persist
    public void doSave() {
        if (this.masterLists == null) {
            return;
        }
        String configFolderLocation = String.valueOf(PropertyHandler.getVariable((String)"configuration_location")) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        for (GeneList geneList : this.masterLists) {
            try {
                GeneUtils.cleanUpGenesForMasterGeneList(geneList);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GeneList.class});
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal((Object)geneList, (OutputStream)os);
                FileWriter fileWriter = new FileWriter(String.valueOf(configFolderLocation) + File.separator + geneList.getFilename());
                fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
                fileWriter.close();
                os.close();
            }
            catch (IOException e) {
                logger.error((Object)"The changes made could not be written to the file.", (Throwable)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Writing File", (String)"The changes made could not be written to the file.");
            }
            catch (JAXBException e) {
                logger.error((Object)"The changes made could not be serialized as xml.", (Throwable)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Parsing File", (String)"The changes made could not be serialized to xml.");
            }
        }
        this.resetDirtyFlag();
    }

    public boolean isDirty() {
        return this.dirtyable.isDirty();
    }

    private void resetDirtyFlag() {
        this.dirtyable.setDirty(false);
    }

    public void markDirty() {
        this.dirtyable.setDirty(true);
    }

    public void refreshOverview(GeneList newSublist) {
        this.overviewPage.addSubList(newSublist);
    }

    public void refreshGeneListPage(List<Gene> existing) {
        IQrtPCRPart activePage = this.getcTabItemToPartTabMap().get(this.cTabFolder.getSelection());
        if (activePage instanceof MasterGeneListPage) {
            ((MasterGeneListPage)activePage).refresh(existing);
        }
    }

    public void updateColumnPreferences(QrtPCRPreference updatePref) {
        IQrtPCRPart activePage = this.getcTabItemToPartTabMap().get(this.cTabFolder.getSelection());
        if (activePage instanceof MasterGeneListPage) {
            this.updateColumnPreferences(((MasterGeneListPage)activePage).getTable(), (QrtPCRPreference)((MasterGeneListPage)activePage).getTable().getTablePreference(), updatePref);
        }
    }

    protected void updateColumnPreferences(ManagerNatTable table, QrtPCRPreference curPref, QrtPCRPreference updatePref) {
        if (((Object)((Object)curPref)).getClass().equals(((Object)((Object)updatePref)).getClass()) && !updatePref.getColumnSettings().equals(curPref.getColumnSettings())) {
            table.setTablePreference(updatePref);
            table.updateViewFromPreferenceSettings();
        }
    }

    public Map<CTabItem, IQrtPCRPart> getcTabItemToPartTabMap() {
        return this.cTabItemToPartTabMap;
    }
}

