/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.manager.pages;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.Section;
import org.grits.toolbox.entry.qrtpcr.ImageRegistry;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.manager.GeneListManagerEditor;
import org.grits.toolbox.entry.qrtpcr.manager.actions.AddGeneToListAction;
import org.grits.toolbox.entry.qrtpcr.manager.actions.SaveGeneListAction;
import org.grits.toolbox.entry.qrtpcr.manager.actions.UpdateGenesAction;
import org.grits.toolbox.entry.qrtpcr.manager.pages.GeneSelectionListContentProvider;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.model.view.GeneView;
import org.grits.toolbox.entry.qrtpcr.table.manager.ManagerNatTable;
import org.grits.toolbox.entry.qrtpcr.table.manager.ManagerTableBase;
import org.grits.toolbox.entry.qrtpcr.util.ExcelFileHandler;
import org.grits.toolbox.entry.qrtpcr.util.GeneUtils;

public class MasterGeneListPage
implements IQrtPCRPart {
    GeneList geneList;
    GeneList subList;
    private TableViewer selectedTableViewer;
    private Action upAction;
    private Action downAction;
    private Action deleteAction;
    private SashForm sash;
    Boolean allSelected = false;
    ManagerNatTable table;
    private CTabItem cTabItem;
    GeneListManagerEditor editor;

    @Inject
    public MasterGeneListPage(@Named(value="geneList") GeneList masterList, @Optional @Named(value="geneSubList") GeneList subList, CTabItem cTabItem) {
        this.cTabItem = cTabItem;
        this.geneList = masterList;
        this.subList = subList;
    }

    @PostConstruct
    public void postConstruct(MPart part) {
        this.editor = (GeneListManagerEditor)part.getObject();
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.cTabItem.getParent(), 768);
        GridData layoutData = new GridData();
        scrolledComposite.setLayoutData((Object)layoutData);
        scrolledComposite.setLayout((Layout)new GridLayout());
        Composite parent = new Composite((Composite)scrolledComposite, 4);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 4;
        parent.setLayout((Layout)layout);
        this.createSash(parent);
        scrolledComposite.setContent((Control)parent);
        scrolledComposite.setMinSize(parent.computeSize(-1, -1));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        this.cTabItem.setControl((Control)scrolledComposite);
    }

    private void createSash(Composite parent) {
        this.sash = new SashForm(parent, 512);
        this.createMainTableSection((Composite)this.sash);
        this.addSelectedListArea((Composite)this.sash);
        this.table.setSelectedTableViewer(this.selectedTableViewer);
        this.sash.setWeights(new int[]{10, 3});
    }

    private void createMainTableSection(final Composite parent) {
        Section section = new Section(parent, 320);
        section.setText(String.valueOf(this.geneList.getListName()) + " Genes");
        Composite client = new Composite((Composite)section, 64){

            public Point computeSize(int hint, int hint2, boolean changed) {
                return new Point(0, 0);
            }
        };
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        ToolBarManager toolBarManager = new ToolBarManager();
        AddGeneToListAction addGeneAction = new AddGeneToListAction(this.getEditor());
        toolBarManager.add((IContributionItem)new ControlContribution("Search"){

            protected Control createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout(2, false));
                Label searchLabel = new Label(composite, 0);
                searchLabel.setText("Search: ");
                final Text searchField = new Text(composite, 2048);
                searchField.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.character == '\r') {
                            this.doSearch(searchField.getText());
                        }
                    }

                    private void doSearch(String text) {
                        (this).MasterGeneListPage.this.table.deSelectAll();
                        (this).MasterGeneListPage.this.table.filter(text);
                    }
                });
                return composite;
            }
        });
        Action selectAllAction = new Action("Select All"){

            public void run() {
                if (MasterGeneListPage.this.table != null) {
                    MasterGeneListPage.this.selectDeselectAll();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.SELECT_ICON);
            }

            public String getToolTipText() {
                return "Select/Deselect all genes for the update (or copying)";
            }
        };
        toolBarManager.add((IAction)selectAllAction);
        toolBarManager.add((IAction)addGeneAction);
        UpdateGenesAction updateAction = new UpdateGenesAction(this);
        toolBarManager.add((IAction)updateAction);
        toolBarManager.add((IAction)new Action("Delete"){

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.DELETE_ICON);
            }

            public void run() {
                if (MasterGeneListPage.this.table != null) {
                    List<TableData> selections = MasterGeneListPage.this.table.getSelected();
                    if (selections.size() == 0) {
                        return;
                    }
                    boolean delete = MessageDialog.openConfirm((Shell)parent.getShell(), (String)"Confirm Delete", (String)("Are you sure you want to delete " + selections.size() + " gene(s) from the list"));
                    if (!delete) {
                        return;
                    }
                    for (TableData selection : selections) {
                        MasterGeneListPage.this.table.removeRow(selection);
                        if (MasterGeneListPage.this.selectedTableViewer == null) continue;
                        ((List)MasterGeneListPage.this.selectedTableViewer.getInput()).remove((Gene)selection);
                    }
                    if (MasterGeneListPage.this.selectedTableViewer != null) {
                        MasterGeneListPage.this.selectedTableViewer.refresh();
                    }
                    MasterGeneListPage.this.getEditor().markDirty();
                }
            }

            public String getToolTipText() {
                return "Delete selected items from the list";
            }
        });
        toolBarManager.add((IAction)new Action("Copy To Selected"){

            public String getToolTipText() {
                return "Copy selected genes to the list below";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.FORWARD_ICON);
            }

            public void run() {
                if (MasterGeneListPage.this.selectedTableViewer != null) {
                    GeneSelectionListContentProvider cp = (GeneSelectionListContentProvider)MasterGeneListPage.this.selectedTableViewer.getContentProvider();
                    List<TableData> selections = MasterGeneListPage.this.table.getSelected();
                    if (selections.size() == 0) {
                        return;
                    }
                    for (TableData selection : selections) {
                        if (!(selection instanceof Gene)) continue;
                        boolean found = false;
                        List<Gene> existing = cp.getGenes();
                        for (Gene gene : existing) {
                            if (!gene.getGeneIdentifier().equals(((Gene)selection).getGeneIdentifier())) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            boolean addDuplicate = MessageDialog.openQuestion((Shell)parent.getShell(), (String)"Duplicate", (String)"This gene is already in the list, do you want to add it again anyway?");
                            if (!addDuplicate) continue;
                            Gene newGene = GeneUtils.makeACopy((Gene)selection);
                            existing.add(newGene);
                            continue;
                        }
                        existing.add((Gene)selection);
                    }
                    MasterGeneListPage.this.table.deSelectAll();
                    MasterGeneListPage.this.selectedTableViewer.refresh();
                }
            }
        });
        toolBarManager.add((IAction)new Action("Export"){

            public String getToolTipText() {
                return "Export the list into Excel";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.EXPORT_ICON);
            }

            public void run() {
                if (MasterGeneListPage.this.table != null) {
                    FileDialog fileDialog = new FileDialog(parent.getShell(), 8192);
                    fileDialog.setText("Select File");
                    fileDialog.setFilterExtensions(new String[]{"*.xlsx"});
                    fileDialog.setFilterNames(new String[]{"Excel (*.xlsx)"});
                    fileDialog.setFileName(String.valueOf(MasterGeneListPage.this.geneList.getListName()) + ".xlsx");
                    fileDialog.setOverwrite(true);
                    String selected = fileDialog.open();
                    if (selected != null) {
                        ExcelFileHandler.exportMasterGeneList(MasterGeneListPage.this.geneList.getListName(), MasterGeneListPage.this.table, selected);
                    }
                }
            }
        });
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        ManagerTableBase myTable = new ManagerTableBase(this.getEditor());
        myTable.setGeneList(this.geneList);
        this.table = (ManagerNatTable)myTable.createControl(client);
        this.table.setLayoutData(new GridData(4, 4, true, true, 1, 20));
        section.setClient((Control)client);
        addGeneAction.setInput(this.geneList.getGenes());
        addGeneAction.setOrganism(this.geneList.getOrganism());
    }

    public GeneListManagerEditor getEditor() {
        return this.editor;
    }

    protected void selectDeselectAll() {
        if (!this.allSelected.booleanValue()) {
            this.table.selectAll();
            this.allSelected = true;
        } else {
            this.table.deSelectAll();
            this.allSelected = false;
        }
    }

    public GeneList getSelectedGeneList() {
        GeneList selectedList = new GeneList();
        ArrayList<Gene> selectedGenes = new ArrayList<Gene>();
        for (TableData row : this.table.getSelected()) {
            if (!(row instanceof Gene)) continue;
            selectedGenes.add((Gene)row);
        }
        selectedList.setGenes(selectedGenes);
        return selectedList;
    }

    public List<TableData> getDataFromTable() {
        if (this.table != null) {
            return this.table.getTreeList().subList(0, this.table.getTreeList().size());
        }
        return new ArrayList<TableData>();
    }

    public void clearSelection() {
        this.table.deSelectAll();
        this.allSelected = false;
    }

    int calculateHeightForTable(Composite parent, int weight) {
        int topHeight = parent.getShell().getSize().y - 220;
        int height = (int)Math.ceil((double)topHeight * (double)weight / 13.0);
        return height;
    }

    private void addSelectedListArea(final Composite parent) {
        Section section = new Section(parent, 320);
        section.setText("Selected Genes");
        Composite client = new Composite((Composite)section, 64){

            public Point computeSize(int hint, int hint2, boolean changed) {
                return new Point(0, 0);
            }
        };
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        ToolBarManager toolBarManager = new ToolBarManager();
        this.upAction = new Action("Up"){

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.UP_ICON);
            }

            public void run() {
                GeneSelectionListContentProvider cp = (GeneSelectionListContentProvider)MasterGeneListPage.this.selectedTableViewer.getContentProvider();
                cp.up(MasterGeneListPage.this.getElementList(), MasterGeneListPage.this.selectedTableViewer);
            }

            public String getToolTipText() {
                return "Move the gene up in the list";
            }
        };
        this.downAction = new Action("Down"){

            public String getToolTipText() {
                return "Move the gene down in the list";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.DOWN_ICON);
            }

            public void run() {
                GeneSelectionListContentProvider cp = (GeneSelectionListContentProvider)MasterGeneListPage.this.selectedTableViewer.getContentProvider();
                cp.down(MasterGeneListPage.this.getElementList(), MasterGeneListPage.this.selectedTableViewer);
            }
        };
        this.deleteAction = new Action("Delete"){

            public String getToolTipText() {
                return "Remove selected gene from the list";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.DELETE_ICON);
            }

            public void run() {
                GeneSelectionListContentProvider cp = (GeneSelectionListContentProvider)MasterGeneListPage.this.selectedTableViewer.getContentProvider();
                List<?> selected = MasterGeneListPage.this.getElementList();
                for (Object object : selected) {
                    cp.getGenes().remove(object);
                }
                MasterGeneListPage.this.selectedTableViewer.refresh();
            }
        };
        SaveGeneListAction saveAsAction = new SaveGeneListAction();
        this.upAction.setEnabled(false);
        this.downAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        toolBarManager.add((IAction)this.upAction);
        toolBarManager.add((IAction)this.downAction);
        toolBarManager.add((IAction)this.deleteAction);
        toolBarManager.add((IAction)saveAsAction);
        toolBarManager.add((IAction)new Action("Export"){

            public String getToolTipText() {
                return "Export the list into Excel";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.EXPORT_ICON);
            }

            public void run() {
                if (MasterGeneListPage.this.selectedTableViewer != null) {
                    FileDialog fileDialog = new FileDialog(parent.getShell(), 8192);
                    fileDialog.setText("Select File");
                    fileDialog.setFilterExtensions(new String[]{"*.xlsx"});
                    fileDialog.setFilterNames(new String[]{"Excel (*.xlsx)"});
                    if (MasterGeneListPage.this.subList != null) {
                        fileDialog.setFileName(String.valueOf(MasterGeneListPage.this.subList.getListName()) + ".xlsx");
                    }
                    fileDialog.setOverwrite(true);
                    String selected = fileDialog.open();
                    if (selected != null) {
                        if (selected.contains("/")) {
                            String nameOnly = selected.substring(selected.lastIndexOf("/") + 1);
                            ExcelFileHandler.exportMasterGeneList(nameOnly, MasterGeneListPage.this.selectedTableViewer, selected);
                        } else {
                            ExcelFileHandler.exportMasterGeneList(selected, MasterGeneListPage.this.selectedTableViewer, selected);
                        }
                    }
                }
            }
        });
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        this.selectedTableViewer = new TableViewer(client, 68352);
        Table table = this.selectedTableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = this.calculateHeightForTable(parent, 3);
        table.setLayoutData((Object)gd);
        section.setClient((Control)client);
        TableViewerColumn orderColumn = new TableViewerColumn(this.selectedTableViewer, 0);
        TableColumn order = orderColumn.getColumn();
        order.setText("order");
        order.setWidth(50);
        orderColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    GeneSelectionListContentProvider cp = (GeneSelectionListContentProvider)MasterGeneListPage.this.selectedTableViewer.getContentProvider();
                    return String.valueOf(cp.getGenes().indexOf(element));
                }
                return null;
            }
        });
        this.createColumns(this.selectedTableViewer);
        if (this.subList != null) {
            this.selectedTableViewer.setContentProvider((IContentProvider)new GeneSelectionListContentProvider(this.subList.getGenes()));
            this.selectedTableViewer.setInput(this.subList.getGenes());
        } else {
            this.selectedTableViewer.setContentProvider((IContentProvider)new GeneSelectionListContentProvider(new ArrayList<Gene>()));
            this.selectedTableViewer.setInput(new ArrayList());
        }
        this.selectedTableViewer.addSelectionChangedListener((ISelectionChangedListener)new GeneSelectionListAdapter());
        saveAsAction.setViewer(this.selectedTableViewer);
        saveAsAction.setEditor(this.getEditor());
        saveAsAction.setMasterList(this.geneList);
    }

    private void createColumns(TableViewer tableViewer) {
        TableViewerColumn geneIdColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn geneId = geneIdColumn.getColumn();
        geneId.setText("Gene Identifier");
        geneIdColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getGeneIdentifier();
                }
                return null;
            }
        });
        geneId.pack();
        TableViewerColumn geneSymbolColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn geneSymbol = geneSymbolColumn.getColumn();
        geneSymbol.setText("Gene Symbol");
        geneSymbolColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getGeneSymbol();
                }
                return null;
            }
        });
        geneSymbol.pack();
        TableViewerColumn idColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn id = idColumn.getColumn();
        id.setText("ID");
        idColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    if (((Gene)element).getGeneIds() != null) {
                        return ((Gene)element).getGeneIdString();
                    }
                    return null;
                }
                return null;
            }
        });
        id.pack();
        TableViewerColumn nameColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn fullName = nameColumn.getColumn();
        fullName.setText("Name");
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getFullName();
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof GeneView && ((GeneView)element).isUpdated() && ((GeneView)element).getUpdatedFields().contains("Name")) {
                    return Display.getDefault().getSystemColor(3);
                }
                return super.getBackground(element);
            }
        });
        fullName.pack();
        TableViewerColumn designedForColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn designedFor = designedForColumn.getColumn();
        designedFor.setText("Notes");
        designedForColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getNotes();
                }
                return null;
            }
        });
        designedFor.pack();
        TableViewerColumn forwardPrimerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn forwardPrimer = forwardPrimerColumn.getColumn();
        forwardPrimer.setText("Forward Primer");
        forwardPrimerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getForwardPrimer();
                }
                return null;
            }
        });
        forwardPrimer.pack();
        TableViewerColumn reversePrimerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn reversePrimer = reversePrimerColumn.getColumn();
        reversePrimer.setText("Reverse Primer");
        reversePrimerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getReversePrimer();
                }
                return null;
            }
        });
        reversePrimer.pack();
        TableViewerColumn aliasColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn alias = aliasColumn.getColumn();
        alias.setText("Aliases");
        aliasColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getAliasString();
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof GeneView && ((GeneView)element).isUpdated() && ((GeneView)element).getUpdatedFields().contains("Aliases")) {
                    return Display.getDefault().getSystemColor(3);
                }
                return super.getBackground(element);
            }
        });
        alias.pack();
        TableViewerColumn descriptionColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn description = descriptionColumn.getColumn();
        description.setText("Description");
        descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getDescription();
                }
                return null;
            }
        });
        description.pack();
        TableViewerColumn groupColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn group = groupColumn.getColumn();
        group.setText("Group");
        groupColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getGroup();
                }
                return null;
            }
        });
        group.pack();
        TableViewerColumn locationColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn location = locationColumn.getColumn();
        location.setText("Genomic Location");
        locationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getLocationString();
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof GeneView && ((GeneView)element).isUpdated() && ((GeneView)element).getUpdatedFields().contains("Genomic Location")) {
                    return Display.getDefault().getSystemColor(3);
                }
                return super.getBackground(element);
            }
        });
        location.pack();
        TableViewerColumn refSeqColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn refSeq = refSeqColumn.getColumn();
        refSeq.setText("RefSeq");
        refSeqColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getRefSeqString();
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof GeneView && ((GeneView)element).isUpdated() && ((GeneView)element).getUpdatedFields().contains("RefSeq")) {
                    return Display.getDefault().getSystemColor(3);
                }
                return super.getBackground(element);
            }
        });
        refSeq.pack();
        TableViewerColumn refSeqColumn2 = new TableViewerColumn(tableViewer, 0);
        TableColumn refSeq2 = refSeqColumn2.getColumn();
        refSeq2.setText("Protein RefSeq");
        refSeqColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getSecondaryRefSeqString();
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof GeneView && ((GeneView)element).isUpdated() && ((GeneView)element).getUpdatedFields().contains("Protein RefSeq")) {
                    return Display.getDefault().getSystemColor(3);
                }
                return super.getBackground(element);
            }
        });
        refSeq2.pack();
        TableViewerColumn controlColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn control = controlColumn.getColumn();
        control.setText("Control?");
        controlColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getIsCommon() != false ? "Control" : "";
                }
                return null;
            }
        });
        control.pack();
    }

    List<?> getElementList() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedTableViewer.getSelection();
        List elements = selection.toList();
        ArrayList elementList = new ArrayList();
        int i = 0;
        while (i < elements.size()) {
            elementList.add(elements.get(i));
            ++i;
        }
        return elementList;
    }

    public void refresh(List<Gene> existing) {
        if (this.table != null) {
            ArrayList<TableData> allData = new ArrayList<TableData>();
            for (Gene gene : existing) {
                allData.add(gene);
            }
            this.table.setTableData(allData);
            this.table.setRedraw(true);
            this.table.updateTable();
        }
    }

    public ManagerNatTable getTable() {
        return this.table;
    }

    class GeneSelectionListAdapter
    implements ISelectionChangedListener {
        GeneSelectionListAdapter() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)MasterGeneListPage.this.selectedTableViewer.getSelection();
            List selections = selection.toList();
            GeneSelectionListContentProvider cp = (GeneSelectionListContentProvider)MasterGeneListPage.this.selectedTableViewer.getContentProvider();
            MasterGeneListPage.this.upAction.setEnabled(cp.canMoveUp(selections));
            MasterGeneListPage.this.downAction.setEnabled(cp.canMoveDown(selections));
            MasterGeneListPage.this.deleteAction.setEnabled(!selections.isEmpty());
        }
    }
}

