/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.analytical.mass;

import java.util.ArrayList;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.analytical.mass.GlycoMassException;
import org.eurocarbdb.MolecularFramework.util.analytical.mass.GlycoVisitorRepeatLinkType;
import org.eurocarbdb.MolecularFramework.util.analytical.mass.MassComponents;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTreeSingle;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlycoVisitorPerPosition
implements GlycoVisitor {
    protected boolean m_bMonoisotopic = true;
    protected double m_dMass = 0.0;
    protected MassComponents m_objMasses = new MassComponents();
    protected int m_iPerMePos = 0;
    protected int m_iPerAcPos = 0;

    public double getMass() {
        return this.m_dMass;
    }

    public void setMonoisotopic(boolean a_bMonoisotpic) {
        this.m_bMonoisotopic = a_bMonoisotpic;
    }

    public boolean getMonoisotopic() {
        return this.m_bMonoisotopic;
    }

    @Override
    public void clear() {
        this.m_dMass = 0.0;
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserTreeSingle(a_objVisitor);
    }

    @Override
    public void visit(Monosaccharide a_objMonosaccharide) throws GlycoVisitorException {
        double t_dMass = this.m_objMasses.getSuperclassMass(a_objMonosaccharide.getSuperclass(), this.m_bMonoisotopic);
        int t_iKetoCount = 0;
        for (Modification t_objModi : a_objMonosaccharide.getModification()) {
            if (t_objModi.getModificationType() != ModificationType.KETO) {
                t_dMass += this.m_objMasses.getModificationMass(t_objModi.getModificationType(), this.m_bMonoisotopic, t_objModi.getPositionOne());
                continue;
            }
            ++t_iKetoCount;
        }
        if (t_iKetoCount > 1) {
            t_dMass += (double)(t_iKetoCount - 1) * this.m_objMasses.getModificationMass(ModificationType.KETO, this.m_bMonoisotopic, 2);
        }
        if (a_objMonosaccharide.getParentEdge() != null) {
            Iterator<Linkage> t_iterLinkages = a_objMonosaccharide.getParentEdge().getGlycosidicLinkages().iterator();
            while (t_iterLinkages.hasNext()) {
                LinkageType t_objLinkageType = t_iterLinkages.next().getChildLinkageType();
                t_dMass += this.m_objMasses.getLinkageTypeMass(t_objLinkageType, this.m_bMonoisotopic);
            }
        }
        Iterator<GlycoEdge> t_iterEdges = a_objMonosaccharide.getChildEdges().iterator();
        while (t_iterEdges.hasNext()) {
            Iterator<Linkage> t_iterLinkages = t_iterEdges.next().getGlycosidicLinkages().iterator();
            while (t_iterLinkages.hasNext()) {
                LinkageType t_objLinkageType = t_iterLinkages.next().getParentLinkageType();
                t_dMass += this.m_objMasses.getLinkageTypeMass(t_objLinkageType, this.m_bMonoisotopic);
            }
        }
        this.m_dMass += t_dMass;
    }

    @Override
    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        double t_dMass = this.m_objMasses.getSubstitutionsMass(a_objSubstituent.getSubstituentType(), this.m_bMonoisotopic);
        int t_iLinkageCount = 0;
        if (a_objSubstituent.getParentEdge() != null) {
            Iterator<Linkage> t_iterLinkage = a_objSubstituent.getParentEdge().getGlycosidicLinkages().iterator();
            while (t_iterLinkage.hasNext()) {
                t_iterLinkage.next();
                ++t_iLinkageCount;
            }
        }
        Iterator<GlycoEdge> t_iterEdge = a_objSubstituent.getChildEdges().iterator();
        while (t_iterEdge.hasNext()) {
            Iterator<Linkage> t_iterLinkage = t_iterEdge.next().getGlycosidicLinkages().iterator();
            while (t_iterLinkage.hasNext()) {
                t_iterLinkage.next();
                ++t_iLinkageCount;
            }
        }
        SubstituentType t_objSubstType = a_objSubstituent.getSubstituentType();
        if (t_iLinkageCount < t_objSubstType.getMinValence()) {
            throw new GlycoMassException("Error with minimum linkage count of substituent " + a_objSubstituent.getSubstituentType().getName() + ".");
        }
        if (t_iLinkageCount > t_objSubstType.getMinValence()) {
            t_dMass += this.handleMultipleLinkedSubstituents(0, t_iLinkageCount, a_objSubstituent);
        }
        this.m_dMass += t_dMass;
    }

    @Override
    public void visit(UnvalidatedGlycoNode unvalidated) throws GlycoVisitorException {
        throw new GlycoMassException("Mass calculation of Unvalidated residues (UnvalidatedGlycoNode) is not supported .");
    }

    @Override
    public void visit(GlycoEdge linkage) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitAlternative alternative) throws GlycoVisitorException {
        throw new GlycoMassException("Mass calculation of alternative SugarUnits is not supported .");
    }

    @Override
    public void visit(NonMonosaccharide residue) throws GlycoVisitorException {
        throw new GlycoMassException("Mass calculation of NonMonosaccharide " + residue.getName() + " is not supported .");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(SugarUnitRepeat a_objRepeate) throws GlycoVisitorException {
        if (a_objRepeate.getMinRepeatCount() != a_objRepeate.getMaxRepeatCount() || a_objRepeate.getMinRepeatCount() == -1) {
            throw new GlycoMassException("Mass calculation of repeat units with not exactly defined repeat count is not possible..");
        }
        GlycoVisitorPerPosition t_objMass = new GlycoVisitorPerPosition();
        GlycoTraverser t_trav = this.getTraverser(t_objMass);
        t_trav.traverseGraph(a_objRepeate);
        this.m_dMass += t_objMass.getMass() * (double)a_objRepeate.getMinRepeatCount();
        double t_dLinkIn = this.specialLinkage(a_objRepeate.getRepeatLinkage(), true, a_objRepeate);
        double t_dLinkOut = this.specialLinkage(a_objRepeate.getRepeatLinkage(), false, a_objRepeate);
        this.m_dMass += (t_dLinkIn + t_dLinkOut) * (double)(a_objRepeate.getMinRepeatCount() - 1);
        if (a_objRepeate.getParentEdge() != null) {
            if (a_objRepeate.getParentEdge().getGlycosidicLinkages().size() != a_objRepeate.getRepeatLinkage().getGlycosidicLinkages().size()) {
                throw new GlycoMassException("Repeat in linkage and repeat linkage weight does not match.");
            }
            this.m_dMass += t_dLinkIn;
        }
        Iterator<GlycoEdge> t_iterEdges = a_objRepeate.getChildEdges().iterator();
        while (t_iterEdges.hasNext()) {
            if (t_iterEdges.next().getGlycosidicLinkages().size() != a_objRepeate.getRepeatLinkage().getGlycosidicLinkages().size()) {
                throw new GlycoMassException("Repeat out linkage and repeat linkage weight does not match.");
            }
            this.m_dMass += t_dLinkOut;
        }
        for (UnderdeterminedSubTree t_objUTree : a_objRepeate.getUndeterminedSubTrees()) {
            if (t_objUTree.getProbabilityLower() < 100.0) {
                throw new GlycoMassException("Mass calculation for stoichometric distribution is not possible.");
            }
            t_objMass = new GlycoVisitorPerPosition();
            t_trav = this.getTraverser(t_objMass);
            t_trav.traverseGraph(t_objUTree);
            this.m_dMass += t_objMass.getMass();
            for (Linkage t_objLinkage : t_objUTree.getConnection().getGlycosidicLinkages()) {
                if (t_objLinkage.getParentLinkageType() == LinkageType.NONMONOSACCHARID) {
                    if (!this.isHomogenSubst(t_objUTree.getParents())) throw new GlycoMassException("Mass calculation of (heterogen) composition repeat unit is not possible.");
                    this.m_dMass += this.checkAndCalculateSubstituent(t_objUTree.getParents(), t_objUTree.getConnection());
                } else {
                    this.m_dMass += this.m_objMasses.getLinkageTypeMass(t_objLinkage.getParentLinkageType(), this.m_bMonoisotopic);
                }
                if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID) {
                    try {
                        if (!this.isHomogenSubst(t_objUTree.getRootNodes())) throw new GlycoMassException("Mass calculation of (heterogen) composition repeat unit is not possible.");
                        this.m_dMass += this.checkAndCalculateSubstituent(t_objUTree.getRootNodes(), t_objUTree.getConnection());
                        continue;
                    }
                    catch (GlycoconjugateException e) {
                        throw new GlycoVisitorException(e.getMessage(), e);
                    }
                }
                this.m_dMass += this.m_objMasses.getLinkageTypeMass(t_objLinkage.getChildLinkageType(), this.m_bMonoisotopic);
            }
        }
    }

    private double specialLinkage(GlycoEdge a_objRepeatEdge, boolean a_bIn, SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        double t_dMass = 0.0;
        if (a_bIn) {
            for (Linkage t_objLinkage : a_objRepeatEdge.getGlycosidicLinkages()) {
                if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID) {
                    GlycoVisitorRepeatLinkType t_visStart = new GlycoVisitorRepeatLinkType();
                    a_objRepeat.accept(t_visStart);
                    if (t_visStart.getEdge() == null) {
                        throw new GlycoMassException("Mass calculation of repeat is not possible.");
                    }
                    if (a_objRepeatEdge.getGlycosidicLinkages().size() != t_visStart.getEdge().getGlycosidicLinkages().size()) {
                        throw new GlycoMassException("Repeat linkage and inner repeat linkage weight does not match.");
                    }
                    if (this.isHomogenSubst(t_visStart.getStartNodes())) {
                        t_dMass += this.checkAndCalculateSubstituent(t_visStart.getStartNodes(), t_visStart.getEdge());
                        continue;
                    }
                    throw new GlycoMassException("Mass calculation of (heterogen) composition repeat unit is not possible.");
                }
                t_dMass += this.m_objMasses.getLinkageTypeMass(t_objLinkage.getChildLinkageType(), this.m_bMonoisotopic);
            }
        } else {
            for (Linkage t_objLinkage : a_objRepeatEdge.getGlycosidicLinkages()) {
                if (t_objLinkage.getParentLinkageType() == LinkageType.NONMONOSACCHARID) {
                    GlycoVisitorRepeatLinkType t_visStart = new GlycoVisitorRepeatLinkType();
                    t_visStart.setRepeatIn(false);
                    a_objRepeat.accept(t_visStart);
                    if (t_visStart.getEdge() == null) {
                        throw new GlycoMassException("Mass calculation of repeat is not possible.");
                    }
                    if (a_objRepeatEdge.getGlycosidicLinkages().size() != t_visStart.getEdge().getGlycosidicLinkages().size()) {
                        throw new GlycoMassException("Repeat linkage and inner repeat linkage weight does not match.");
                    }
                    if (this.isHomogenSubst(t_visStart.getStartNodes())) {
                        t_dMass += this.checkAndCalculateSubstituent(t_visStart.getStartNodes(), t_visStart.getEdge());
                        continue;
                    }
                    throw new GlycoMassException("Mass calculation of (heterogen) composition repeat unit is not possible.");
                }
                t_dMass += this.m_objMasses.getLinkageTypeMass(t_objLinkage.getParentLinkageType(), this.m_bMonoisotopic);
            }
        }
        return t_dMass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objSugar);
        for (UnderdeterminedSubTree t_objUTree : a_objSugar.getUndeterminedSubTrees()) {
            if (t_objUTree.getProbabilityLower() < 100.0) {
                throw new GlycoMassException("Mass calculation for stoichometric distribution is not possible.");
            }
            GlycoVisitorPerPosition t_objMass = new GlycoVisitorPerPosition();
            GlycoTraverser t_trav = this.getTraverser(t_objMass);
            t_trav.traverseGraph(t_objUTree);
            this.m_dMass += t_objMass.getMass();
            for (Linkage t_objLinkage : t_objUTree.getConnection().getGlycosidicLinkages()) {
                if (t_objLinkage.getParentLinkageType() == LinkageType.NONMONOSACCHARID) {
                    if (!this.isHomogenSubst(t_objUTree.getParents())) throw new GlycoMassException("Mass calculation of (heterogen) composition repeat unit is not possible.");
                    this.m_dMass += this.checkAndCalculateSubstituent(t_objUTree.getParents(), t_objUTree.getConnection());
                } else {
                    this.m_dMass += this.m_objMasses.getLinkageTypeMass(t_objLinkage.getParentLinkageType(), this.m_bMonoisotopic);
                }
                if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID) {
                    try {
                        if (!this.isHomogenSubst(t_objUTree.getRootNodes())) throw new GlycoMassException("Mass calculation of (heterogen) composition repeat unit is not possible.");
                        this.m_dMass += this.checkAndCalculateSubstituent(t_objUTree.getRootNodes(), t_objUTree.getConnection());
                        continue;
                    }
                    catch (GlycoconjugateException e) {
                        throw new GlycoVisitorException(e.getMessage(), e);
                    }
                }
                this.m_dMass += this.m_objMasses.getLinkageTypeMass(t_objLinkage.getChildLinkageType(), this.m_bMonoisotopic);
            }
        }
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
        if (a_objCyclic.getParentEdge() != null) {
            Iterator<Linkage> t_iterLinkages = a_objCyclic.getParentEdge().getGlycosidicLinkages().iterator();
            while (t_iterLinkages.hasNext()) {
                LinkageType t_objLinkageType = t_iterLinkages.next().getChildLinkageType();
                if (t_objLinkageType == LinkageType.NONMONOSACCHARID) {
                    GlycoVisitorRepeatLinkType t_visStart = new GlycoVisitorRepeatLinkType();
                    a_objCyclic.getCyclicStart().accept(t_visStart);
                    if (t_visStart.getEdge() == null) {
                        throw new GlycoMassException("Mass calculation of cyclic start is not possible.");
                    }
                    if (a_objCyclic.getParentEdge().getGlycosidicLinkages().size() != t_visStart.getEdge().getGlycosidicLinkages().size()) {
                        throw new GlycoMassException("Cyclic linkage and repeat linkage weight does not match.");
                    }
                    if (this.isHomogenSubst(t_visStart.getStartNodes())) {
                        this.m_dMass += this.checkAndCalculateSubstituent(t_visStart.getStartNodes(), t_visStart.getEdge());
                        continue;
                    }
                    throw new GlycoMassException("Mass calculation of (heterogen) composition repeat unit is not possible.");
                }
                this.m_dMass += this.m_objMasses.getLinkageTypeMass(t_objLinkageType, this.m_bMonoisotopic);
            }
        } else {
            throw new GlycoMassException("Mass calculation of unconnected cylcic unit is not possible.");
        }
    }

    private double checkAndCalculateSubstituent(ArrayList<GlycoNode> a_aStartNodes, GlycoEdge a_objEdge) throws GlycoVisitorException {
        double t_dMass = -1.0;
        double t_dMassTemp = -1.0;
        int t_iLinkageCount = 0;
        GlycoVisitorNodeType t_visType = new GlycoVisitorNodeType();
        for (GlycoNode t_objNode : a_aStartNodes) {
            if (t_objNode.getParentEdge() != null) {
                t_iLinkageCount += t_objNode.getParentEdge().getGlycosidicLinkages().size();
            }
            Iterator<GlycoEdge> t_iterLinkage = t_objNode.getChildEdges().iterator();
            while (t_iterLinkage.hasNext()) {
                t_iLinkageCount += t_iterLinkage.next().getGlycosidicLinkages().size();
            }
            t_dMassTemp = this.handleMultipleLinkedSubstituents(t_iLinkageCount, a_objEdge.getGlycosidicLinkages().size(), t_visType.getSubstituent(t_objNode));
            if (t_dMass == -1.0) {
                t_dMass = t_dMassTemp;
                continue;
            }
            if (t_dMass == t_dMassTemp) continue;
            throw new GlycoMassException("Mass calculation of heterogen repeat substituents is not possible.");
        }
        return t_dMass;
    }

    private boolean isHomogenSubst(ArrayList<GlycoNode> startNodes) throws GlycoVisitorException {
        boolean t_bOther = false;
        GlycoVisitorNodeType t_visType = new GlycoVisitorNodeType();
        Iterator<GlycoNode> t_iter = startNodes.iterator();
        while (t_iter.hasNext()) {
            if (t_visType.isSubstituent(t_iter.next())) continue;
            t_bOther = true;
        }
        return !t_bOther;
    }

    private double handleMultipleLinkedSubstituents(int t_iLinkageCalculated, int t_iLinkageCountNew, Substituent a_objSubstituent) throws GlycoMassException {
        SubstituentType t_objSubstType = a_objSubstituent.getSubstituentType();
        if (t_objSubstType == SubstituentType.PHOSPHATE) {
            double t_dIncMass = 0.0;
            t_dIncMass = this.m_bMonoisotopic ? 17.0027396541 : 17.0073456821841;
            if (t_iLinkageCountNew + t_iLinkageCalculated > t_objSubstType.getMaxValence()) {
                throw new GlycoMassException("Error with max. linkage count) of substituent phosphate.");
            }
            return (double)(1 - (t_iLinkageCalculated + t_iLinkageCountNew)) * t_dIncMass;
        }
        throw new GlycoMassException("Error with linkage count of substituent " + a_objSubstituent.getSubstituentType().getName() + ".");
    }
}

