/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.analytical.mass;

import java.util.ArrayList;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlycoVisitorRepeatLinkType
implements GlycoVisitor {
    private GlycoEdge m_objEdge = null;
    private ArrayList<GlycoNode> m_aNodes = new ArrayList();
    private boolean m_bRepeatIn = true;

    @Override
    public void clear() {
        this.m_objEdge = null;
        this.m_aNodes = new ArrayList();
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor visitor) throws GlycoVisitorException {
        return null;
    }

    @Override
    public void start(Sugar sugar) throws GlycoVisitorException {
        this.clear();
    }

    @Override
    public void visit(Monosaccharide a_objMonosaccharide) throws GlycoVisitorException {
        this.clear();
    }

    @Override
    public void visit(NonMonosaccharide residue) throws GlycoVisitorException {
        this.clear();
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        GlycoVisitorNodeType t_visType = new GlycoVisitorNodeType();
        boolean t_bSimple = false;
        boolean t_bComplex = false;
        try {
            if (this.m_bRepeatIn) {
                for (GlycoNode t_objNode : a_objRepeat.getRootNodes()) {
                    if (t_visType.isMonosaccharide(t_objNode)) {
                        t_bSimple = true;
                        continue;
                    }
                    if (t_visType.isSubstituent(t_objNode)) {
                        t_bSimple = true;
                        continue;
                    }
                    if (!t_visType.isSugarUnitRepeat(t_objNode)) continue;
                    t_bComplex = true;
                    t_visType.getSugarUnitRepeat(t_objNode).accept(this);
                }
                if (t_bSimple && t_bComplex) {
                    this.clear();
                } else if (t_bSimple) {
                    this.m_aNodes = a_objRepeat.getRootNodes();
                    this.m_objEdge = a_objRepeat.getRepeatLinkage();
                }
            } else if (a_objRepeat.getRepeatLinkage().getParent() == null) {
                for (GlycoNode t_objNode : a_objRepeat.getNodes()) {
                    if (t_visType.isMonosaccharide(t_objNode)) {
                        t_bSimple = true;
                        continue;
                    }
                    if (t_visType.isSubstituent(t_objNode)) {
                        t_bSimple = true;
                        continue;
                    }
                    if (!t_visType.isSugarUnitRepeat(t_objNode)) continue;
                    t_bComplex = true;
                    t_visType.getSugarUnitRepeat(t_objNode).accept(this);
                }
                if (t_bSimple && t_bComplex) {
                    this.clear();
                } else if (t_bSimple) {
                    this.m_aNodes = a_objRepeat.getNodes();
                    this.m_objEdge = a_objRepeat.getRepeatLinkage();
                }
            } else {
                GlycoNode t_objNode = a_objRepeat.getRepeatLinkage().getParent();
                if (t_visType.isMonosaccharide(t_objNode)) {
                    this.m_aNodes.clear();
                    this.m_aNodes.add(t_objNode);
                    this.m_objEdge = a_objRepeat.getRepeatLinkage();
                } else if (t_visType.isSubstituent(t_objNode)) {
                    this.m_aNodes.clear();
                    this.m_aNodes.add(t_objNode);
                    this.m_objEdge = a_objRepeat.getRepeatLinkage();
                } else if (t_visType.isSugarUnitRepeat(t_objNode)) {
                    t_visType.getSugarUnitRepeat(t_objNode).accept(this);
                }
            }
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
    }

    @Override
    public void visit(Substituent substituent) throws GlycoVisitorException {
        this.clear();
    }

    @Override
    public void visit(SugarUnitCyclic cyclic) throws GlycoVisitorException {
        this.clear();
    }

    @Override
    public void visit(SugarUnitAlternative alternative) throws GlycoVisitorException {
        this.clear();
    }

    @Override
    public void visit(UnvalidatedGlycoNode unvalidated) throws GlycoVisitorException {
        this.clear();
    }

    @Override
    public void visit(GlycoEdge linkage) throws GlycoVisitorException {
        this.clear();
    }

    public GlycoEdge getEdge() {
        return this.m_objEdge;
    }

    public ArrayList<GlycoNode> getStartNodes() {
        return this.m_aNodes;
    }

    public void setRepeatIn(boolean b) {
        this.m_bRepeatIn = b;
    }
}

