/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ImageRegistry {
    private static Logger logger = Logger.getLogger(ImageRegistry.class);
    private static final String IMAGE_PATH = "icons" + File.separator;
    private static Map<MSImage, ImageDescriptor> imageCache = new HashMap<MSImage, ImageDescriptor>();

    public static ImageDescriptor getImageDescriptor(String pluginId, MSImage image) {
        logger.info((Object)("Get image from ms plugin : " + (Object)((Object)image)));
        ImageDescriptor imageDescriptor = null;
        if (image != null) {
            imageDescriptor = imageCache.get((Object)image);
            if (imageDescriptor == null) {
                logger.info((Object)"ImageDescriptor not found in cache");
                URL fullPathString = FileLocator.find((Bundle)Platform.getBundle((String)pluginId), (IPath)new Path(String.valueOf(IMAGE_PATH) + image.iconName), null);
                logger.info((Object)("Loading image from url : " + fullPathString));
                if (fullPathString != null) {
                    imageDescriptor = ImageDescriptor.createFromURL((URL)fullPathString);
                    imageCache.put(image, imageDescriptor);
                }
            }
        } else {
            logger.error((Object)"Cannot load image from ms plugin (image name is null)");
        }
        return imageDescriptor;
    }

    public static enum MSImage {
        MASSSPEC_ICON("massspectrum.png"),
        MSANNOTATION_ICON("IconAnnotation.png"),
        MSMERGE_ICON("merge.png"),
        MSCONVERT_ICON("MSConvert.png"),
        GLYCRESOFT_ICON("glycresoft.png");

        private String iconName = null;

        private MSImage(String iconName) {
            this.iconName = iconName;
        }
    }
}

