/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference;

import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.MassSpecPreferencePage;

public class MassSpecSettingPreferenceUI
extends Composite {
    private static final Logger logger = Logger.getLogger(MassSpecSettingPreferenceUI.class);
    private Combo msExperimentCombo;
    private String msExperimentType = null;
    private Label msExperimentLabel;
    private Text instrumentText;
    private String instrument = null;
    private Label instrumentLabel;
    private MassSpecPreference preferences = null;
    private boolean isComplete = true;
    private String errorMessage = null;
    IPropertyChangeListener listener = null;
    private boolean bAddExperimentType = false;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (MassSpecSettingPreferenceUI.this.isReadyToFinish()) {
                MassSpecSettingPreferenceUI.this.setPageComplete(true);
            } else {
                MassSpecSettingPreferenceUI.this.setPageComplete(false);
            }
        }
    };

    public MassSpecSettingPreferenceUI(Composite parent, int style, IPropertyChangeListener listener) {
        super(parent, style);
        this.listener = listener;
    }

    public void setbAddExperimentType(boolean bAddExperimentType) {
        this.bAddExperimentType = bAddExperimentType;
    }

    public void setPreferences(MassSpecPreference preferences) {
        this.preferences = preferences;
    }

    public MassSpecPreference getPreferences() {
        return this.preferences;
    }

    public void initComponents() {
        String sDefaultExpType;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = 10;
        this.setLayout((Layout)gridLayout);
        this.initInitialValues();
        String string = sDefaultExpType = this.preferences.getExperimentType() != null && !this.preferences.getExperimentType().equals("") ? this.preferences.getExperimentType() : "Direct Infusion";
        if (this.bAddExperimentType) {
            this.msExperimentLabel = MassSpecPreferencePage.createLabel(this, "Experiment Type");
            this.msExperimentCombo = MassSpecPreferencePage.createCombo(this, this.msExperimentLabel, this.preferences.getAllExperimentTypes(), sDefaultExpType, false, false);
            this.msExperimentCombo.addListener(24, this.getComboListener());
            MassSpecPreferencePage.setMandatoryLabel(this.msExperimentLabel);
        }
        this.instrumentLabel = MassSpecPreferencePage.createLabel(this, "Instrument");
        this.instrumentText = MassSpecPreferencePage.createText(this, this.instrumentLabel, this.preferences.getInstrument());
        this.instrumentText.addModifyListener(this.modifyListener);
    }

    private Listener getComboListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                String cfr_ignored_0 = event.text;
                if (MassSpecSettingPreferenceUI.this.isReadyToFinish()) {
                    MassSpecSettingPreferenceUI.this.setPageComplete(true);
                } else {
                    MassSpecSettingPreferenceUI.this.setPageComplete(false);
                }
            }
        };
        return listener;
    }

    private void initInitialValues() {
        try {
            this.instrument = this.preferences != null && this.preferences.getInstrument() != null ? this.preferences.getInstrument() : "";
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isReadyToFinish() {
        this.setErrorMessage(null);
        return true;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setPageComplete(boolean isComplete) {
        PropertyChangeEvent e = new PropertyChangeEvent((Object)this, "Page Complete", (Object)this.isComplete, (Object)isComplete);
        this.isComplete = isComplete;
        this.listener.propertyChange(e);
    }

    public boolean isPageCompete() {
        return this.isComplete;
    }

    public void updateSettings() {
        if (this.bAddExperimentType) {
            this.msExperimentType = this.msExperimentCombo.getText();
        }
        this.instrument = this.instrumentText.getText();
    }

    public void updatePreferences() {
        if (this.bAddExperimentType && MassSpecPreferencePage.hasChanged(this.msExperimentType, this.preferences.getExperimentType(), this.preferences.getAllExperimentTypes())) {
            this.preferences.setExperimentType(this.msExperimentType);
        }
        if (MassSpecPreferencePage.hasChanged(this.instrument, this.preferences.getInstrument(), null)) {
            this.preferences.setInstrument(this.instrument);
        }
    }

    public String getInstrument() {
        return this.instrument;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }
}

