/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import org.apache.log4j.Logger;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.GlycanSettingsTableWithActions;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;

public class GlycanSettingsForm
extends WizardPage
implements IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(GlycanSettingsForm.class);
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private Text txtAccuracy;
    private Combo cmbMono;
    private Combo cmbAccuracy;
    private boolean readyToFinish = false;
    private Method method = null;
    private MSGlycanAnnotationWizard myWizard;
    private String displayName = "";
    private Label lblAccuracyMsn;
    private Text txtMsnAccuracy;
    private Combo cmbMsnAccuracyType;
    private Button chkTrustCharge;
    private double cutOff = 0.0;
    private String cutOffType = null;
    private double cutOffPrecursor = 0.0;
    private String cutOffTypePrecursor = null;
    private Label label;
    private Text txtCutOff;
    private Combo cmbCutOffType;
    private Text txtCutOffPrecursor;
    private Combo cmbCutOffTypePrecursor;
    private Button chkUseDatabaseMetaInfo;
    private String sMassType = null;
    private Double dPrecursorAccuracy = null;
    private boolean bPrecursorAccuracyIsPPM = true;
    private Double dFragmentAccuracy = null;
    private boolean bFragmentAccuracyIsPPM = true;
    private boolean bTrustCharge = false;
    private GlycanSettingsTableWithActions databaseSettings;
    private FiltersLibrary filterLibrary;
    private double dIntensityCutoff;
    private double dPrecursorIntensityCutoff;
    private ModifyListener txtCutOffPrecursorListener;
    private SelectionAdapter cmbCutOffTypePrecursotSelectionListener;
    private ModifyListener txtCutOffListener;
    private SelectionAdapter cmbCutOffTypeListener;
    private ModifyListener txtAccuracyListener;
    private ModifyListener txtMsnAccuracyListener;

    public GlycanSettingsForm(Method method, MSGlycanAnnotationWizard wizard, FiltersLibrary filterLibrary) {
        this("glycanSettings", method, wizard, filterLibrary);
        this.setTitle("Glycan Settings");
        this.setDescription("Describe general glycan settings");
    }

    public GlycanSettingsForm(String pageName, Method method, MSGlycanAnnotationWizard wizard, FiltersLibrary filterLibrary) {
        super(pageName);
        this.setPageComplete(false);
        this.method = method;
        method.setShift(Double.valueOf(0.0));
        this.myWizard = wizard;
        this.filterLibrary = filterLibrary;
    }

    protected Label setMandatoryLabel(Label lable) {
        lable.setText(String.valueOf(lable.getText()) + "*");
        lable.setFont(this.boldFont);
        return lable;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setFont(SWTResourceManager.getFont("Segoe UI", 9, 0));
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(3, false);
        gl_container.verticalSpacing = 10;
        container.setLayout((Layout)gl_container);
        this.addMassTypeControls(container);
        this.addAccuracyControls(container);
        this.addIntensityCutoffControls(container);
        this.addTrustChargeControls(container);
        this.addDatabaseSettings(container);
        this.setControl((Control)container);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        this.setPageComplete(false);
        if (this.validateInput()) {
            this.canFlipToNextPage();
        } else {
            this.readyToFinish = false;
            this.canFlipToNextPage();
        }
    }

    protected void addDatabaseSettings(Composite container) {
        this.databaseSettings = this.getSettingsTable(container);
        this.databaseSettings.setFilterLibrary(this.filterLibrary);
        this.databaseSettings.setPreferences(this.myWizard.getPreferences());
        this.databaseSettings.initComponents();
    }

    protected GlycanSettingsTableWithActions getSettingsTable(Composite container) {
        return new GlycanSettingsTableWithActions(container, 0, this);
    }

    public boolean useMetaInfoControls() {
        return this.chkUseDatabaseMetaInfo.getSelection();
    }

    private void addTrustChargeControls(Composite container) {
        this.label = new Label(container, 0);
        this.label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.label.setText("Charge Assignment");
        this.chkTrustCharge = new Button(container, 32);
        this.chkTrustCharge.setText("Trust Charge in MS XML File (mzML, mzXML)");
        boolean bValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().isTrustCharge() : true;
        this.chkTrustCharge.setSelection(bValue);
        new Label(container, 0);
    }

    private void addIntensityCutoffControls(Composite container) {
        boolean bValue;
        boolean bPreValue;
        this.label = new Label(container, 0);
        this.label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.label.setText("Precursor Intensity Cut-Off");
        this.txtCutOffPrecursor = new Text(container, 2048);
        Double dPreValue = this.myWizard.getPreferences() != null && this.myWizard.getPreferences().getPrecursorIntensityCutoff() != null ? this.myWizard.getPreferences().getPrecursorIntensityCutoff() : 0.0;
        this.setCutOffPrecursor(dPreValue);
        String sPreValue = dPreValue > 0.0 ? dPreValue.toString() : "";
        this.txtCutOffPrecursor.setText(sPreValue);
        this.txtCutOffPrecursorListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GlycanSettingsForm.this.validateInput()) {
                    double dVal = !GlycanSettingsForm.this.txtCutOffPrecursor.getText().isEmpty() ? Double.parseDouble(GlycanSettingsForm.this.txtCutOffPrecursor.getText()) : 0.0;
                    GlycanSettingsForm.this.setCutOffPrecursor(dVal);
                    GlycanSettingsForm.this.setCutOffTypePrecursor(GlycanSettingsForm.this.cmbCutOffTypePrecursor.getItem(GlycanSettingsForm.this.cmbCutOffTypePrecursor.getSelectionIndex()));
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    GlycanSettingsForm.this.readyToFinish = false;
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.txtCutOffPrecursor.addModifyListener(this.txtCutOffPrecursorListener);
        this.txtCutOffPrecursor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbCutOffTypePrecursor = new Combo(container, 0);
        this.cmbCutOffTypePrecursotSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GlycanSettingsForm.this.validateInput()) {
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    GlycanSettingsForm.this.readyToFinish = false;
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.cmbCutOffTypePrecursor.addSelectionListener((SelectionListener)this.cmbCutOffTypePrecursotSelectionListener);
        this.cmbCutOffTypePrecursor.setItems(new String[]{"Percentage", "Absolute Value"});
        this.cmbCutOffTypePrecursor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        boolean bl = bPreValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().isPrecursorIntensityCutoffIsPercentage() : true;
        if (bPreValue) {
            this.cmbCutOffTypePrecursor.select(0);
        } else {
            this.cmbCutOffTypePrecursor.select(1);
        }
        this.setCutOffTypePrecursor(this.cmbCutOffTypePrecursor.getItem(this.cmbCutOffTypePrecursor.getSelectionIndex()));
        this.label = new Label(container, 0);
        this.label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.label.setText("Fragment Intensity Cut-Off");
        this.txtCutOff = new Text(container, 2048);
        Double dValue = this.myWizard.getPreferences() != null && this.myWizard.getPreferences().getIntensityCutoff() != null ? this.myWizard.getPreferences().getIntensityCutoff() : 0.0;
        this.setCutOff(dValue);
        String sValue = dValue > 0.0 ? dValue.toString() : "";
        this.txtCutOff.setText(sValue);
        this.txtCutOffListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GlycanSettingsForm.this.validateInput()) {
                    double dVal = !GlycanSettingsForm.this.txtCutOff.getText().isEmpty() ? Double.parseDouble(GlycanSettingsForm.this.txtCutOff.getText()) : 0.0;
                    GlycanSettingsForm.this.setCutOff(dVal);
                    GlycanSettingsForm.this.setCutOffType(GlycanSettingsForm.this.cmbCutOffType.getItem(GlycanSettingsForm.this.cmbCutOffType.getSelectionIndex()));
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    GlycanSettingsForm.this.readyToFinish = false;
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.txtCutOff.addModifyListener(this.txtCutOffListener);
        this.txtCutOff.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbCutOffType = new Combo(container, 0);
        this.cmbCutOffTypeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GlycanSettingsForm.this.validateInput()) {
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    GlycanSettingsForm.this.readyToFinish = false;
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.cmbCutOffType.addSelectionListener((SelectionListener)this.cmbCutOffTypeListener);
        this.cmbCutOffType.setItems(new String[]{"Percentage", "Absolute Value"});
        this.cmbCutOffType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        boolean bl2 = bValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().isIntensityCutoffIsPercentage() : true;
        if (bValue) {
            this.cmbCutOffType.select(0);
        } else {
            this.cmbCutOffType.select(1);
        }
        this.setCutOffType(this.cmbCutOffType.getItem(this.cmbCutOffType.getSelectionIndex()));
    }

    private void addAccuracyControls(Composite container) {
        boolean bValue;
        Label lblAccuracy = new Label(container, 0);
        lblAccuracy.setText("Accuracy MS");
        lblAccuracy = this.setMandatoryLabel(lblAccuracy);
        this.txtAccuracy = new Text(container, 2048);
        String sValue = this.myWizard.getPreferences() != null && this.myWizard.getPreferences().getPrecursorTol() != null ? this.myWizard.getPreferences().getPrecursorTol().toString() : "500";
        this.txtAccuracy.setText(sValue);
        GridData gd_txtAccuracy = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtAccuracy.widthHint = 131;
        this.txtAccuracy.setLayoutData((Object)gd_txtAccuracy);
        this.txtAccuracyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GlycanSettingsForm.this.validateInput()) {
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    GlycanSettingsForm.this.readyToFinish = false;
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.txtAccuracy.addModifyListener(this.txtAccuracyListener);
        this.cmbAccuracy = new Combo(container, 0);
        GridData gd_cmbAccuracy = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_cmbAccuracy.widthHint = 131;
        this.cmbAccuracy.setLayoutData((Object)gd_cmbAccuracy);
        this.cmbAccuracy.setItems(new String[]{"Dalton", "ppm"});
        boolean bl = bValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().isPrecursorTolIsPPM() : true;
        if (bValue) {
            this.cmbAccuracy.select(1);
        } else {
            this.cmbAccuracy.select(0);
        }
        this.lblAccuracyMsn = new Label(container, 0);
        this.lblAccuracyMsn.setText("Accuracy MSn");
        this.txtMsnAccuracy = new Text(container, 2048);
        sValue = this.myWizard.getPreferences() != null && this.myWizard.getPreferences().getFragmentTol() != null ? this.myWizard.getPreferences().getFragmentTol().toString() : "500";
        this.txtMsnAccuracy.setText(sValue);
        this.txtMsnAccuracyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GlycanSettingsForm.this.validateInput()) {
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    GlycanSettingsForm.this.readyToFinish = false;
                    GlycanSettingsForm.this.canFlipToNextPage();
                    GlycanSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.txtMsnAccuracy.addModifyListener(this.txtMsnAccuracyListener);
        this.txtMsnAccuracy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbMsnAccuracyType = new Combo(container, 0);
        this.cmbMsnAccuracyType.setItems(new String[]{"Dalton", "ppm"});
        this.cmbMsnAccuracyType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        boolean bl2 = bValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().isFragmentTolIsPPM() : true;
        if (bValue) {
            this.cmbMsnAccuracyType.select(1);
        } else {
            this.cmbMsnAccuracyType.select(0);
        }
    }

    private void addMassTypeControls(Composite container) {
        String sValue;
        Label lblMonoisotopic = new Label(container, 0);
        lblMonoisotopic.setText("Mass Type");
        lblMonoisotopic = this.setMandatoryLabel(lblMonoisotopic);
        this.cmbMono = new Combo(container, 0);
        this.cmbMono.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.cmbMono.setItems(new String[]{"Monoisotopic", "Average"});
        String string = sValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().getMassType() : "Monoisotopic";
        if (sValue.equalsIgnoreCase("Monoisotopic")) {
            this.cmbMono.select(0);
        } else {
            this.cmbMono.select(1);
        }
    }

    public IWizardPage getNextPage() {
        this.save();
        return super.getNextPage();
    }

    public void updateControlsFromPreferences() {
        if (this.myWizard.getPreferences() != null && this.myWizard.getPreferences().getMethod() != null) {
            boolean bPreValue;
            this.removeListeners();
            if (this.databaseSettings != null) {
                this.databaseSettings.setAnalyteSettings(this.myWizard.getPreferences().getMethod().getAnalyteSettings());
            }
            boolean bValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().isTrustCharge() : true;
            this.chkTrustCharge.setSelection(bValue);
            Double dPreValue = this.myWizard.getPreferences() != null && this.myWizard.getPreferences().getPrecursorIntensityCutoff() != null ? this.myWizard.getPreferences().getPrecursorIntensityCutoff() : 0.0;
            this.setCutOffPrecursor(dPreValue);
            String sPreValue = dPreValue > 0.0 ? dPreValue.toString() : "";
            this.txtCutOffPrecursor.setText(sPreValue);
            boolean bl = bPreValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().isPrecursorIntensityCutoffIsPercentage() : true;
            if (bPreValue) {
                this.cmbCutOffTypePrecursor.select(0);
            } else {
                this.cmbCutOffTypePrecursor.select(1);
            }
            this.setCutOffTypePrecursor(this.cmbCutOffTypePrecursor.getItem(this.cmbCutOffTypePrecursor.getSelectionIndex()));
            Double dValue = this.myWizard.getPreferences() != null && this.myWizard.getPreferences().getIntensityCutoff() != null ? this.myWizard.getPreferences().getIntensityCutoff() : 0.0;
            this.setCutOff(dValue);
            String sValue = dValue > 0.0 ? dValue.toString() : "";
            this.txtCutOff.setText(sValue);
            boolean bl2 = bValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().isIntensityCutoffIsPercentage() : true;
            if (bValue) {
                this.cmbCutOffType.select(0);
            } else {
                this.cmbCutOffType.select(1);
            }
            this.setCutOffType(this.cmbCutOffType.getItem(this.cmbCutOffType.getSelectionIndex()));
            sValue = this.myWizard.getPreferences() != null && this.myWizard.getPreferences().getPrecursorTol() != null ? this.myWizard.getPreferences().getPrecursorTol().toString() : "500";
            this.txtAccuracy.setText(sValue);
            boolean bl3 = bValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().isPrecursorTolIsPPM() : true;
            if (bValue) {
                this.cmbAccuracy.select(1);
            } else {
                this.cmbAccuracy.select(0);
            }
            sValue = this.myWizard.getPreferences() != null && this.myWizard.getPreferences().getFragmentTol() != null ? this.myWizard.getPreferences().getFragmentTol().toString() : "500";
            this.txtMsnAccuracy.setText(sValue);
            boolean bl4 = bValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().isFragmentTolIsPPM() : true;
            if (bValue) {
                this.cmbMsnAccuracyType.select(1);
            } else {
                this.cmbMsnAccuracyType.select(0);
            }
            String string = sValue = this.myWizard.getPreferences() != null ? this.myWizard.getPreferences().getMassType() : "";
            if (sValue.equalsIgnoreCase("Monoisotopic")) {
                this.cmbMono.select(0);
            } else {
                this.cmbMono.select(1);
            }
            this.setErrorMessage(null);
            this.readyToFinish = true;
            this.addListeners();
        }
    }

    private void addListeners() {
        this.txtCutOffPrecursor.addModifyListener(this.txtCutOffPrecursorListener);
        this.cmbCutOffTypePrecursor.addSelectionListener((SelectionListener)this.cmbCutOffTypePrecursotSelectionListener);
        this.txtCutOff.addModifyListener(this.txtCutOffListener);
        this.cmbCutOffType.addSelectionListener((SelectionListener)this.cmbCutOffTypeListener);
        this.txtAccuracy.addModifyListener(this.txtAccuracyListener);
        this.txtMsnAccuracy.addModifyListener(this.txtMsnAccuracyListener);
    }

    private void removeListeners() {
        this.txtCutOffPrecursor.removeModifyListener(this.txtCutOffPrecursorListener);
        this.cmbCutOffTypePrecursor.removeSelectionListener((SelectionListener)this.cmbCutOffTypePrecursotSelectionListener);
        this.txtCutOff.removeModifyListener(this.txtCutOffListener);
        this.cmbCutOffType.removeSelectionListener((SelectionListener)this.cmbCutOffTypeListener);
        this.txtAccuracy.removeModifyListener(this.txtAccuracyListener);
        this.txtMsnAccuracy.removeModifyListener(this.txtMsnAccuracyListener);
    }

    public void save() {
        this.sMassType = this.cmbMono.getText();
        this.dPrecursorAccuracy = Double.parseDouble(this.txtAccuracy.getText());
        this.bPrecursorAccuracyIsPPM = this.cmbAccuracy.getText().equals("ppm");
        this.dFragmentAccuracy = Double.parseDouble(this.txtMsnAccuracy.getText());
        this.bFragmentAccuracyIsPPM = this.cmbMsnAccuracyType.getText().equals("ppm");
        this.dIntensityCutoff = 0.0;
        if (!this.txtCutOff.getText().trim().equals("")) {
            this.dIntensityCutoff = Double.parseDouble(this.txtCutOff.getText().trim());
        }
        this.dPrecursorIntensityCutoff = 0.0;
        if (!this.txtCutOffPrecursor.getText().trim().equals("")) {
            this.dPrecursorIntensityCutoff = Double.parseDouble(this.txtCutOffPrecursor.getText().trim());
        }
        this.bTrustCharge = this.chkTrustCharge.getSelection();
        this.method.setAccuracy(this.dPrecursorAccuracy);
        this.method.setFragAccuracy(this.dFragmentAccuracy);
        this.method.setAccuracyPpm(Boolean.valueOf(this.bPrecursorAccuracyIsPPM));
        this.method.setFragAccuracyPpm(Boolean.valueOf(this.bFragmentAccuracyIsPPM));
        this.method.setTrustMzCharge(Boolean.valueOf(this.bTrustCharge));
        if (this.sMassType.equalsIgnoreCase("Monoisotopic")) {
            this.method.setMonoisotopic(Boolean.valueOf(true));
        } else {
            this.method.setMonoisotopic(Boolean.valueOf(false));
        }
        this.method.setAnnotationType("GLYCAN");
        this.method.setAnnotationSource("GRITS");
        this.method.setIntensityCutoff(Double.valueOf(this.dIntensityCutoff));
        this.method.setIntensityCutoffType(this.cmbCutOffType.getText());
        this.method.setPrecursorIntensityCutoff(Double.valueOf(this.dPrecursorIntensityCutoff));
        this.method.setPrecursorIntensityCutoffType(this.cmbCutOffTypePrecursor.getText());
        if (this.databaseSettings != null) {
            this.method.setAnalyteSettings(this.databaseSettings.getAnalyteSettings());
        }
    }

    public boolean canFlipToNextPage() {
        return this.readyToFinish;
    }

    public boolean canFinish() {
        return this.readyToFinish;
    }

    public boolean validateInput() {
        if (TextFieldUtils.isEmpty((Text)this.txtAccuracy) || !TextFieldUtils.isDouble((Text)this.txtAccuracy)) {
            this.setErrorMessage("Enter a valid number in the MS Accuracy field");
            return false;
        }
        if (TextFieldUtils.isEmpty((Text)this.txtMsnAccuracy) || !TextFieldUtils.isDouble((Text)this.txtMsnAccuracy)) {
            this.setErrorMessage("Enter a valid number in the Msn Accuracy field");
            return false;
        }
        if (!TextFieldUtils.isEmpty((Text)this.txtCutOff) && !TextFieldUtils.isNonZero((Text)this.txtCutOff)) {
            this.setErrorMessage("Please input a valid fragment cutoff value");
            return false;
        }
        if (this.cmbCutOffType.getSelectionIndex() != -1 && this.cmbCutOffType.getItem(this.cmbCutOffType.getSelectionIndex()).equals("Percentage")) {
            if (!TextFieldUtils.isEmpty((Text)this.txtCutOff) && !TextFieldUtils.isValidPercent((Text)this.txtCutOff)) {
                this.setErrorMessage("Please input a valid fragment cutoff value");
                return false;
            }
        } else if (this.cmbCutOffType.getSelectionIndex() == -1 && !TextFieldUtils.isEmpty((Text)this.txtCutOff) && !TextFieldUtils.isValidPercent((Text)this.txtCutOff)) {
            this.setErrorMessage("Please input a valid fragment cutoff value");
            return false;
        }
        if (!TextFieldUtils.isEmpty((Text)this.txtCutOffPrecursor) && !TextFieldUtils.isNonZero((Text)this.txtCutOffPrecursor)) {
            this.setErrorMessage("Please input a valid precursor cutoff value");
            return false;
        }
        if (this.cmbCutOffTypePrecursor.getSelectionIndex() != -1 && this.cmbCutOffTypePrecursor.getItem(this.cmbCutOffTypePrecursor.getSelectionIndex()).equals("Percentage")) {
            if (!TextFieldUtils.isEmpty((Text)this.txtCutOffPrecursor) && !TextFieldUtils.isValidPercent((Text)this.txtCutOffPrecursor)) {
                this.setErrorMessage("Please input a valid precursor cutoff value");
                return false;
            }
        } else if (this.cmbCutOffTypePrecursor.getSelectionIndex() == -1 && !TextFieldUtils.isEmpty((Text)this.txtCutOffPrecursor) && !TextFieldUtils.isValidPercent((Text)this.txtCutOffPrecursor)) {
            this.setErrorMessage("Please input a valid precursor cutoff value");
            return false;
        }
        if (!this.databaseValid()) {
            this.setErrorMessage("Please add at least one valid database");
            return false;
        }
        this.setErrorMessage(null);
        this.readyToFinish = true;
        return true;
    }

    protected boolean databaseValid() {
        return this.databaseSettings != null && this.databaseSettings.getAnalyteSettings() != null && !this.databaseSettings.getAnalyteSettings().isEmpty();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCutOffType() {
        return this.cutOffType;
    }

    public void setCutOffType(String cutOffType) {
        this.cutOffType = cutOffType;
    }

    public double getCutOff() {
        return this.cutOff;
    }

    public void setCutOff(double cutOff) {
        this.cutOff = cutOff;
    }

    public String getCutOffTypePrecursor() {
        return this.cutOffTypePrecursor;
    }

    public void setCutOffTypePrecursor(String cutOffTypePrecursor) {
        this.cutOffTypePrecursor = cutOffTypePrecursor;
    }

    public double getCutOffPrecursor() {
        return this.cutOffPrecursor;
    }

    public void setCutOffPrecursor(double cutOffPrecursor) {
        this.cutOffPrecursor = cutOffPrecursor;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.validateInput()) {
            this.canFlipToNextPage();
            this.getWizard().getContainer().updateButtons();
        } else {
            this.readyToFinish = false;
            this.canFlipToNextPage();
            this.getWizard().getContainer().updateButtons();
        }
    }
}

