/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.util.List;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.grits.toolbox.entry.ms.annotation.glycan.dialog.DatabaseSettingsTableComposite;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationPreference;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.GlycanSettingsDialog;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;

public class GlycanSettingsTableWithActions
extends Composite {
    protected FiltersLibrary filterLibrary;
    protected MSGlycanAnnotationPreference preferences;
    private DatabaseSettingsTableComposite table;
    protected TableViewer settingsTableViewer;
    protected Table settingsTable;
    protected IPropertyChangeListener listener;

    public GlycanSettingsTableWithActions(Composite parent, int style, IPropertyChangeListener listener) {
        super(parent, style);
        this.listener = listener;
    }

    public void initComponents() {
        this.initLayout();
        this.createTable();
        this.addButtons();
    }

    protected void createTable() {
        this.table = new DatabaseSettingsTableComposite((Composite)this, 0);
        GridData gd2 = new GridData(4, 4, true, true, 4, 1);
        List existing = null;
        if (this.preferences != null && this.preferences.getMethod() != null) {
            existing = this.preferences.getMethod().getAnalyteSettings();
        }
        if (existing != null) {
            this.table.setAnaylteSettings(existing);
        }
        this.table.setLayoutData((Object)gd2);
        this.table.createTable();
        this.settingsTableViewer = this.table.getSettingsTableViewer();
        this.settingsTable = this.settingsTableViewer.getTable();
    }

    public void initLayout() {
        GridLayout layout2 = new GridLayout(4, false);
        layout2.marginWidth = 2;
        layout2.marginHeight = 2;
        this.setLayout((Layout)layout2);
        GridData gd = new GridData(4, 4, true, true, 3, 1);
        this.setLayoutData(gd);
    }

    public void addButtons() {
        GridData gd1 = new GridData(4, 4, true, true, 1, 1);
        gd1.widthHint = 200;
        new Label((Composite)this, 0).setLayoutData((Object)gd1);
        this.addAddButton();
        this.addEditButton();
        this.addDeleteButton();
    }

    protected void addDeleteButton() {
        Button deleteButton = new Button((Composite)this, 8);
        deleteButton.setText("Delete");
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyteSettings setting;
                TableItem[] items = GlycanSettingsTableWithActions.this.settingsTable.getSelection();
                if (items.length > 0 && (setting = (AnalyteSettings)items[0].getData()) != null) {
                    boolean wasEmpty = GlycanSettingsTableWithActions.this.getAnalyteSettings().isEmpty();
                    GlycanSettingsTableWithActions.this.getAnalyteSettings().remove(setting);
                    GlycanSettingsTableWithActions.this.settingsTableViewer.refresh();
                    PropertyChangeEvent ce = new PropertyChangeEvent((Object)this, "Page Complete", (Object)(!wasEmpty ? 1 : 0), (Object)(!GlycanSettingsTableWithActions.this.getAnalyteSettings().isEmpty() ? 1 : 0));
                    GlycanSettingsTableWithActions.this.listener.propertyChange(ce);
                }
            }
        });
    }

    protected void addEditButton() {
        Button editButton = new Button((Composite)this, 8);
        editButton.setText("Edit");
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlycanSettingsDialog dialog;
                AnalyteSettings setting;
                TableItem[] items = GlycanSettingsTableWithActions.this.settingsTable.getSelection();
                if (items.length > 0 && (setting = (AnalyteSettings)items[0].getData()) != null && (dialog = new GlycanSettingsDialog(GlycanSettingsTableWithActions.this.getShell(), GlycanSettingsTableWithActions.this.filterLibrary, setting.getGlycanSettings())).open() == 0) {
                    GlycanSettingsTableWithActions.this.settingsTableViewer.refresh();
                }
            }
        });
    }

    protected void addAddButton() {
        Button addButton = new Button((Composite)this, 8);
        addButton.setText("Add");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlycanSettingsDialog dialog = new GlycanSettingsDialog(GlycanSettingsTableWithActions.this.getShell(), GlycanSettingsTableWithActions.this.filterLibrary);
                if (dialog.open() == 0) {
                    PropertyChangeEvent ce = new PropertyChangeEvent((Object)this, "Page Complete", (Object)(!GlycanSettingsTableWithActions.this.getAnalyteSettings().isEmpty() ? 1 : 0), (Object)true);
                    GlycanSettings gSettings = dialog.getGlycanSettings();
                    AnalyteSettings analyte = new AnalyteSettings();
                    analyte.setGlycanSettings(gSettings);
                    GlycanSettingsTableWithActions.this.getAnalyteSettings().add(analyte);
                    GlycanSettingsTableWithActions.this.settingsTableViewer.refresh();
                    GlycanSettingsTableWithActions.this.listener.propertyChange(ce);
                }
            }
        });
    }

    public List<AnalyteSettings> getAnalyteSettings() {
        return this.table.getAnaylteSettings();
    }

    public void setAnalyteSettings(List<AnalyteSettings> settings) {
        this.table.setAnaylteSettings(settings);
    }

    public void setFilterLibrary(FiltersLibrary filterLibrary) {
        this.filterLibrary = filterLibrary;
    }

    public void setPreferences(MSGlycanAnnotationPreference preferences) {
        this.preferences = preferences;
    }
}

