/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.process.loader;

import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;
import org.grits.toolbox.datamodel.ms.annotation.glycan.report.tablemodel.MSGlycanAnnotationReportTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.utils.image.ImageCreationException;
import org.grits.toolbox.widgets.tools.NotifyingProcess;

public class MSGlycanAnnotationImageConversion
extends NotifyingProcess {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationImageConversion.class);
    protected MSGlycanAnnotationTableDataObject msAnnotationTableData = null;
    private String sReportName = null;

    public boolean convertImages() {
        this.updateListeners("Converting images.", 0);
        int i = 0;
        while (i < this.msAnnotationTableData.getTableData().size()) {
            block16: {
                try {
                    if ((i + 1) % 100 == 0) {
                        this.updateListeners("Converting images. Row: " + (i + 1) + " of " + this.msAnnotationTableData.getTableData().size(), i + 1);
                    }
                    if (this.msAnnotationTableData instanceof MSGlycanAnnotationReportTableDataObject) {
                        int j = 0;
                        while (j < this.msAnnotationTableData.getCartoonCols().size()) {
                            int iInx;
                            Object cartoon = ((GRITSListDataRow)this.msAnnotationTableData.getTableData().get(i)).getDataRow().get((Integer)this.msAnnotationTableData.getCartoonCols().get(j));
                            if (cartoon != null && (iInx = cartoon.toString().indexOf(".png")) >= 0) {
                                String sSequence = cartoon.toString().substring(0, iInx);
                                try {
                                    MSGlycanAnnotationTableDataObject.glycanImageProvider.addMergeImageToProvider(sSequence, cartoon.toString());
                                }
                                catch (ImageCreationException imageCreationException) {
                                    this.updateErrorListener("Error creating image: " + (i + 1));
                                }
                            }
                            ++j;
                        }
                        break block16;
                    }
                    int j = 0;
                    while (j < this.msAnnotationTableData.getSequenceCols().size()) {
                        int iSeqCol = (Integer)this.msAnnotationTableData.getSequenceCols().get(j);
                        int iCartoonCol = (Integer)this.msAnnotationTableData.getCartoonCols().get(j);
                        GRITSListDataRow row = (GRITSListDataRow)this.msAnnotationTableData.getTableData().get(i);
                        Object sequence = row.getDataRow().get(iSeqCol);
                        Object glycanID = row.getDataRow().get(iCartoonCol);
                        if (sequence != null && glycanID != null) {
                            int iInx = ((String)sequence).indexOf(".png");
                            if (iInx > 0) {
                                sequence = ((String)sequence).substring(0, iInx);
                            }
                            try {
                                if (((String)sequence).contains("~|~")) {
                                    MSGlycanAnnotationTableDataObject.glycanImageProvider.addMergeImageToProvider(sequence.toString(), glycanID.toString());
                                } else {
                                    MSGlycanAnnotationTableDataObject.glycanImageProvider.addImageToProvider(sequence.toString(), glycanID.toString());
                                }
                            }
                            catch (ImageCreationException imageCreationException) {
                                this.updateErrorListener("Error creating image: " + (i + 1));
                            }
                        }
                        ++j;
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            ++i;
        }
        logger.debug((Object)("Current image cache size: " + MSGlycanAnnotationTableDataObject.glycanImageProvider.getCacheSize() + ", stack size: " + MSGlycanAnnotationTableDataObject.glycanImageProvider.getStackSize()));
        return true;
    }

    public BufferedImage getImageFromMemory(String _sSequence) throws Exception {
        if (MSGlycanAnnotationTableDataObject.glycanImageProvider == null) {
            return null;
        }
        return MSGlycanAnnotationTableDataObject.glycanImageProvider.getImage(_sSequence).getAwtBufferedImage();
    }

    public void setSimianTableData(MSGlycanAnnotationTableDataObject msAnnotationTableData) {
        this.msAnnotationTableData = msAnnotationTableData;
    }

    public String getReportName() {
        return this.sReportName;
    }

    public void setReportName(String sReportName) {
        this.sReportName = sReportName;
    }
}

