/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.process.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.MSGlycanAnnotationSummaryViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationSummaryTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.dmtranslate.DMGlycanAnnotation;
import org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMFeature;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.glycan.process.loader.MSGlycanAnnotationSummaryTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers.MSGlycanAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationEntityScroller;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;

public class MSGlycanAnnotationSummaryTableDataProcessor
extends MSAnnotationTableDataProcessor {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationSummaryTableDataProcessor.class);
    public static final GRITSColumnHeader FIRST_GROUP = new GRITSColumnHeader("Peak Info", "peak_info");
    protected List<MSAnnotationTableDataProcessor> tableDataProcessors = null;
    protected MSGlycanAnnotationTable msParentGAT = null;
    protected List<Integer> iSummaryAnnotIds = null;

    public MSGlycanAnnotationSummaryTableDataProcessor(Entry _entry, Property _sourceProperty, List<MSAnnotationTableDataProcessor> tableDataProcessors) {
        super(_entry, _sourceProperty, -1);
        this.tableDataProcessors = tableDataProcessors;
        this.data = this.tableDataProcessors.get(0).getData();
    }

    public List<MSAnnotationTableDataProcessor> getTableDataProcessors() {
        return this.tableDataProcessors;
    }

    protected TableViewerColumnSettings initializeColumnSettings() {
        TableViewerColumnSettings newSettings = this.getNewTableViewerSettings();
        int iCols = MSGlycanAnnotationSummaryTableDataProcessorUtil.fillMSGlycanAnnotationSummaryColumnSettings(newSettings);
        this.setLastVisibleCol(iCols);
        return newSettings;
    }

    public TableViewerPreference initializePreferences() {
        MSAnnotationViewerPreference preferences = (MSAnnotationViewerPreference)super.initializePreferences();
        MSGlycanAnnotationSummaryTableDataProcessorUtil.postProcessColumnSettings((TableViewerPreference)preferences);
        return preferences;
    }

    protected TableViewerPreference getNewTableViewerPreferences() {
        return new MSGlycanAnnotationSummaryViewerPreference();
    }

    public boolean createTable() throws Exception {
        return super.createTable();
    }

    public void initializeTableDataObject(Property _sourceProperty) {
        MSGlycanAnnotationSummaryTableDataObject mobj = new MSGlycanAnnotationSummaryTableDataObject(((MassSpecEntityProperty)_sourceProperty).getMsLevel().intValue(), this.fillType);
        this.setSimianTableDataObject((MassSpecTableDataObject)mobj);
        this.getSimianTableDataObject().initializePreferences();
        if (this.getSimianTableDataObject().getTablePreferences().settingsNeedInitialization()) {
            TableViewerPreference tvp = this.initializePreferences();
            MSGlycanAnnotationSummaryTableDataProcessor.setDefaultColumnViewSettings(tvp.getPreferenceSettings());
            this.getSimianTableDataObject().setTablePreferences(tvp);
            this.getSimianTableDataObject().getTablePreferences().writePreference();
        }
    }

    public boolean saveChanges() throws Exception {
        return true;
    }

    public boolean readDataFromFile() {
        return false;
    }

    public void buildTable() throws Exception {
        this.processExternalQuant();
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Building table...");
        HashMap<PeakInfo, HashMap<Integer, List<FeatureInfo>>> htAllPeaks = this.getAnnotatedPeaks();
        int iMax = htAllPeaks.size();
        this.progressBarDialog.getMinorProgressBarListener(0).setMaxValue(iMax);
        ArrayList<ArrayList<GRITSColumnHeader>> alHeaders = this.getHeaderLines(this.getTempPreference().getPreferenceSettings());
        this.getSimianTableDataObject().getTableHeader().add(alHeaders.get(0));
        this.getSimianTableDataObject().getTableHeader().add(alHeaders.get(1));
        this.addTableData(htAllPeaks);
        if (this.getSimianTableDataObject().getTableData().isEmpty()) {
            this.getSimianTableDataObject().getTableData().add(TableDataProcessor.getNewRow((int)this.getSimianTableDataObject().getLastHeader().size(), (int)this.getSimianTableDataObject().getTableData().size()));
            this.getSimianTableDataObject().getTableData().add(TableDataProcessor.getNewRow((int)this.getSimianTableDataObject().getLastHeader().size(), (int)this.getSimianTableDataObject().getTableData().size()));
        }
    }

    public static void setDefaultColumnViewSettings(TableViewerColumnSettings tvs) {
        GRITSColumnHeader header = tvs.getColumnHeader(DMPeak.peak_id.name());
        if (header != null) {
            tvs.setVisColInx(header, Integer.valueOf(-1));
        }
        if ((header = tvs.getColumnHeader(DMGlycanAnnotation.glycan_annotation_glycanId.name())) != null) {
            tvs.setVisColInx(header, Integer.valueOf(-1));
        }
        if ((header = tvs.getColumnHeader(DMFeature.feature_sequence.name())) != null) {
            tvs.setVisColInx(header, Integer.valueOf(-1));
        }
        if ((header = tvs.getColumnHeader(DMFeature.feature_id.name())) != null) {
            tvs.setVisColInx(header, Integer.valueOf(-1));
        }
        if ((header = tvs.getColumnHeader(DMFeature.feature_charge.name())) != null) {
            tvs.setVisColInx(header, Integer.valueOf(-1));
        }
    }

    private MSGlycanAnnotationTableDataObject getMySimianTableDataObject() {
        return (MSGlycanAnnotationTableDataObject)this.getSimianTableDataObject();
    }

    public static Annotation getAnnotation(Data _data, Integer annId) {
        for (Annotation ann : _data.getAnnotation()) {
            if (!ann.getId().equals(annId)) continue;
            return ann;
        }
        return null;
    }

    public void setParentViewerSubsetTable(MSGlycanAnnotationTable msParentGAT) {
        this.msParentGAT = msParentGAT;
    }

    private ArrayList<ArrayList<GRITSColumnHeader>> getHeaderLines(TableViewerColumnSettings _columnSettings) throws Exception {
        ArrayList<ArrayList<GRITSColumnHeader>> alHeaders = new ArrayList<ArrayList<GRITSColumnHeader>>();
        ArrayList<GRITSColumnHeader> alHeader = new ArrayList<GRITSColumnHeader>();
        ArrayList<String> lProcessed = new ArrayList<String>();
        GRITSColumnHeader colHeader = null;
        this.iSummaryAnnotIds = new ArrayList<Integer>();
        try {
            int i;
            Annotation parentAnnot;
            for (GRITSColumnHeader header : _columnSettings.keySet()) {
                if (header.isGrouped()) continue;
                alHeader.add(FIRST_GROUP);
            }
            int iNumRows = this.msParentGAT.getBottomDataLayer().getRowCount();
            lProcessed.clear();
            for (MSAnnotationTableDataProcessor processor : this.tableDataProcessors) {
                parentAnnot = processor.getCurAnnotation();
                if (parentAnnot == null) continue;
                i = 0;
                while (i < iNumRows) {
                    if (this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i) != null && this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i) != null && this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getAnnotationIdCols().get(0)).intValue(), i) != null) {
                        Integer iPeakId = (Integer)this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i);
                        String sId = this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i).toString();
                        Integer iAnnotId = (Integer)this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getAnnotationIdCols().get(0)).intValue(), i);
                        Annotation annot = this.getAnnotation(iAnnotId);
                        if (parentAnnot.getId() == annot.getId()) {
                            if (!this.iSummaryAnnotIds.contains(annot.getId())) {
                                this.iSummaryAnnotIds.add(annot.getId());
                            }
                            String sHeaderKey = MSAnnotationEntityScroller.getCombinedKeyForLookup((Integer)iPeakId, (String)sId);
                            if (!lProcessed.contains(sId)) {
                                String sLabel = this.getAnnotationStructureId(annot);
                                colHeader = new GRITSColumnHeader(sLabel, sHeaderKey);
                                for (GRITSColumnHeader header : _columnSettings.keySet()) {
                                    if (!header.isGrouped()) continue;
                                    alHeader.add(colHeader);
                                }
                                lProcessed.add(sId);
                            }
                        }
                    }
                    ++i;
                }
            }
            alHeaders.add(alHeader);
            alHeader = new ArrayList();
            for (GRITSColumnHeader header : _columnSettings.keySet()) {
                if (header.isGrouped()) continue;
                this.addHeaderLine(alHeader.size(), header, alHeader);
            }
            lProcessed.clear();
            for (MSAnnotationTableDataProcessor processor : this.tableDataProcessors) {
                parentAnnot = processor.getCurAnnotation();
                if (parentAnnot == null) continue;
                i = 0;
                while (i < iNumRows) {
                    if (this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i) != null && this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i) != null && this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getAnnotationIdCols().get(0)).intValue(), i) != null && this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getSequenceCols().get(0)).intValue(), i) != null) {
                        Integer iAnnotId = (Integer)this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getAnnotationIdCols().get(0)).intValue(), i);
                        Annotation annot = this.getAnnotation(iAnnotId);
                        String sSeq = (String)this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getSequenceCols().get(0)).intValue(), i);
                        Integer iPeakId = (Integer)this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i);
                        String sId = this.msParentGAT.getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)this.msParentGAT.getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i).toString();
                        if (parentAnnot.getId() == annot.getId()) {
                            MSAnnotationEntityScroller.getCombinedKeyForLookup((Integer)iPeakId, (String)sId);
                            if (!lProcessed.contains(sId)) {
                                for (GRITSColumnHeader header : _columnSettings.keySet()) {
                                    if (!header.isGrouped()) continue;
                                    if (header.getKeyValue().equals(DMGlycanAnnotation.glycan_annotation_glycancartoon.name())) {
                                        GRITSColumnHeader cartoonHeader = new GRITSColumnHeader(String.valueOf(sSeq) + ".png", sSeq);
                                        this.addHeaderLine(alHeader.size(), cartoonHeader, alHeader);
                                        continue;
                                    }
                                    this.addHeaderLine(alHeader.size(), header, alHeader);
                                }
                                lProcessed.add(sId);
                            }
                        }
                    }
                    ++i;
                }
            }
            alHeaders.add(alHeader);
            return alHeaders;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in getHeaderLines", (Throwable)ex);
            throw ex;
        }
    }

    protected String getAnnotationStructureId(Annotation annot) {
        return "GlycanID: " + ((GlycanAnnotation)annot).getStringId();
    }

    protected void addHeaderLine(int iPrefColNum, GRITSColumnHeader colHeader, ArrayList<GRITSColumnHeader> alHeader) {
        if (colHeader.getLabel().endsWith(".png")) {
            this.getMySimianTableDataObject().addCartoonCol(Integer.valueOf(iPrefColNum));
        } else if (colHeader.getKeyValue().equals(DMFeature.feature_id.name())) {
            this.getMySimianTableDataObject().addFeatureIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMFeature.feature_sequence.name())) {
            this.getMySimianTableDataObject().addSequenceCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMFeature.feature_charge.name())) {
            this.getMySimianTableDataObject().addFeatureChargeCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMGlycanAnnotation.glycan_annotation_glycanId.name())) {
            this.getMySimianTableDataObject().addAnnotationIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_id.name())) {
            this.getMySimianTableDataObject().addPeakIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_mz.name())) {
            this.getMySimianTableDataObject().addMzCol(iPrefColNum);
        }
        alHeader.add(colHeader);
    }

    private HashMap<PeakInfo, HashMap<Integer, List<FeatureInfo>>> getAnnotatedPeaks() {
        try {
            HashMap<PeakInfo, HashMap<Integer, List<FeatureInfo>>> htRetData = new HashMap<PeakInfo, HashMap<Integer, List<FeatureInfo>>>();
            ArrayList<Integer> processedParent = new ArrayList<Integer>();
            for (MSAnnotationTableDataProcessor processor : this.tableDataProcessors) {
                Annotation parentAnnot = processor.getCurAnnotation();
                if (parentAnnot == null || processedParent.contains(parentAnnot.getId())) continue;
                MSAnnotationTableDataObject tdo = (MSAnnotationTableDataObject)processor.getSimianTableDataObject();
                int i = 0;
                while (i < tdo.getTableData().size()) {
                    GRITSListDataRow row = (GRITSListDataRow)tdo.getTableData().get(i);
                    Integer iPeakId = (Integer)row.getDataRow().get((Integer)tdo.getPeakIdCols().get(0));
                    if (iPeakId != null) {
                        Integer iScanNum = (Integer)row.getDataRow().get((Integer)tdo.getScanNoCols().get(0));
                        Double dMz = (Double)row.getDataRow().get((Integer)tdo.getMzCols().get(0));
                        if (dMz != null) {
                            String sSeq = (String)row.getDataRow().get((Integer)tdo.getSequenceCols().get(0));
                            String sFeatId = (String)row.getDataRow().get((Integer)tdo.getFeatureIdCols().get(0));
                            Object oCharge = row.getDataRow().get((Integer)tdo.getFeatureChargeCols().get(0));
                            String sFeatCharge = "-1";
                            if (oCharge != null) {
                                sFeatCharge = oCharge.toString();
                            }
                            Integer iAnnotId = (Integer)row.getDataRow().get((Integer)tdo.getAnnotationIdCols().get(0));
                            Annotation annot = null;
                            if (iAnnotId != null) {
                                annot = processor.getAnnotation(iAnnotId);
                            }
                            Double dIntensity = (Double)row.getDataRow().get((Integer)tdo.getPeakIntensityCols().get(0));
                            PeakInfo pI = new PeakInfo(iPeakId, iScanNum, dMz, dIntensity);
                            HashMap<Object, Object> htFeatureToListOfSO = null;
                            if (htRetData.containsKey(pI)) {
                                htFeatureToListOfSO = htRetData.get(pI);
                            } else {
                                htFeatureToListOfSO = new HashMap();
                                htRetData.put(pI, htFeatureToListOfSO);
                            }
                            if (sFeatId != null && (parentAnnot.getStringId() == null || annot.getStringId() == null || annot.getStringId().startsWith(parentAnnot.getStringId()))) {
                                List<FeatureInfo> lFi = null;
                                if (htFeatureToListOfSO.containsKey(parentAnnot.getId())) {
                                    lFi = (List)htFeatureToListOfSO.get(parentAnnot.getId());
                                } else {
                                    lFi = new ArrayList();
                                    htFeatureToListOfSO.put(parentAnnot.getId(), lFi);
                                }
                                FeatureInfo fi = new FeatureInfo(sSeq, sFeatId, sFeatCharge);
                                lFi.add(fi);
                            }
                        }
                    }
                    ++i;
                }
                processedParent.add(parentAnnot.getId());
            }
            return htRetData;
        }
        catch (Exception exception) {
            logger.error((Object)"getAnnotatedPeaks: Error creating list of Peaks");
            return null;
        }
    }

    protected void addTableData(HashMap<PeakInfo, HashMap<Integer, List<FeatureInfo>>> htAllPeaks) {
        Set<PeakInfo> setPeakInfo = htAllPeaks.keySet();
        int iCnt = 1;
        this.getMySimianTableDataObject().setUnAnnotatedRows(new ArrayList());
        for (PeakInfo pI : setPeakInfo) {
            HashMap<Integer, List<FeatureInfo>> htFeatToListofFI = htAllPeaks.get(pI);
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Building table. Peak: " + iCnt);
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressValue(iCnt++);
            this.addTableRow(pI, htFeatToListofFI);
            if (!this.bCancel) continue;
            this.setSimianTableDataObject(null);
            return;
        }
    }

    protected void addTableRow(PeakInfo pI, HashMap<Integer, List<FeatureInfo>> htFeatToListofFI) {
        try {
            GRITSListDataRow alRow = this.getNewRow();
            MSGlycanAnnotationSummaryTableDataProcessorUtil.fillMSGlycanAnnotationSummryRowPrefix(pI, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            int iOffset = 0;
            boolean bMatchedOne = false;
            for (MSAnnotationTableDataProcessor processor : this.tableDataProcessors) {
                Annotation parentAnnot = processor.getCurAnnotation();
                if (parentAnnot == null || !this.iSummaryAnnotIds.contains(parentAnnot.getId())) continue;
                if (htFeatToListofFI.containsKey(parentAnnot.getId())) {
                    bMatchedOne = true;
                    StringBuilder sbSequence = new StringBuilder();
                    StringBuilder sbFeatureId = new StringBuilder();
                    StringBuilder sbFeatureCharge = new StringBuilder();
                    int iCnt2 = 0;
                    for (FeatureInfo fi : htFeatToListofFI.get(parentAnnot.getId())) {
                        if (iCnt2++ > 5) continue;
                        if (!sbSequence.toString().equals("")) {
                            sbSequence.append("~|~");
                            sbFeatureId.append("~|~");
                        }
                        sbSequence.append(fi.sFeatureSeq);
                        sbFeatureId.append(fi.sFeatureId);
                        if (iCnt2 != 1) continue;
                        sbFeatureCharge.append(fi.sFeatureCharge);
                    }
                    this.fillMSAnnotationSummaryEntryData(parentAnnot, sbFeatureId.toString(), sbSequence.toString(), sbFeatureCharge.toString(), iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
                }
                iOffset += this.getLastVisibleCol();
            }
            this.getSimianTableDataObject().getTableData().add(alRow);
            if (!bMatchedOne) {
                this.getMySimianTableDataObject().getUnAnnotatedRows().add(this.getSimianTableDataObject().getTableData().size() - 1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"addScanData: error adding scans data to table model.", (Throwable)e);
        }
    }

    protected void fillMSAnnotationSummaryEntryData(Annotation parentAnnot, String sFeatureId, String sSequence, String sFeatureCharge, int iOffset, ArrayList<Object> alDataRow, TableViewerColumnSettings preferenceSettings) {
        MSGlycanAnnotationSummaryTableDataProcessorUtil.fillMSGlycanAnnotationSummryEntryData((GlycanAnnotation)parentAnnot, sFeatureId, sSequence, sFeatureCharge, iOffset, alDataRow, preferenceSettings);
    }

    public class FeatureInfo {
        public String sFeatureSeq = null;
        public String sFeatureId = null;
        public String sFeatureCharge = null;

        public FeatureInfo(String sFeatureSeq, String sFeatureId, String sFeatureCharge) {
            this.sFeatureSeq = sFeatureSeq;
            this.sFeatureId = sFeatureId;
            this.sFeatureCharge = sFeatureCharge;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof FeatureInfo) {
                return this.sFeatureId == ((FeatureInfo)arg0).sFeatureId;
            }
            return false;
        }

        public int hashCode() {
            return this.sFeatureId.hashCode();
        }
    }

    public class PeakInfo {
        public Integer iPeakId = null;
        public Integer iScanNum = null;
        public Double dMz = null;
        public Double dIntensity = null;

        public PeakInfo(Integer iPeakId, Integer iScanNum, Double dMz, Double dIntensity) {
            this.iPeakId = iPeakId;
            this.iScanNum = iScanNum;
            this.dMz = dMz;
            this.dIntensity = dIntensity;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof PeakInfo) {
                return this.iPeakId.equals(((PeakInfo)arg0).iPeakId);
            }
            return false;
        }

        public int hashCode() {
            return this.iPeakId.hashCode();
        }
    }
}

