/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import org.eurocarbdb.application.glycanbuilder.ChildAnomericCarbonCondition;
import org.eurocarbdb.application.glycanbuilder.ChildAnomericStateCondition;
import org.eurocarbdb.application.glycanbuilder.ChildIsBracketCondition;
import org.eurocarbdb.application.glycanbuilder.ChildIsCleavageCondition;
import org.eurocarbdb.application.glycanbuilder.ChildIsRepetitionCondition;
import org.eurocarbdb.application.glycanbuilder.ChildIsRingFragmentCondition;
import org.eurocarbdb.application.glycanbuilder.ChildIsSaccharideCondition;
import org.eurocarbdb.application.glycanbuilder.ChildIsSpecialCondition;
import org.eurocarbdb.application.glycanbuilder.ChildTypeCondition;
import org.eurocarbdb.application.glycanbuilder.FalseCondition;
import org.eurocarbdb.application.glycanbuilder.LinkageMatcher;
import org.eurocarbdb.application.glycanbuilder.LinkagePositionCondition;
import org.eurocarbdb.application.glycanbuilder.ParentIsAttachPointCondition;
import org.eurocarbdb.application.glycanbuilder.ParentIsBracketCondition;
import org.eurocarbdb.application.glycanbuilder.ParentIsCleavageCondition;
import org.eurocarbdb.application.glycanbuilder.ParentIsRepetitionCondition;
import org.eurocarbdb.application.glycanbuilder.ParentIsRingFragmentCondition;
import org.eurocarbdb.application.glycanbuilder.ParentIsSaccharideCondition;
import org.eurocarbdb.application.glycanbuilder.ParentIsSpecialCondition;
import org.eurocarbdb.application.glycanbuilder.ParentTypeCondition;
import org.eurocarbdb.application.glycanbuilder.ReducingEndCondition;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycanbuilder.TrueCondition;

class ConditionFactory {
    ConditionFactory() {
    }

    public static LinkageMatcher fromString(String init) throws Exception {
        if (TextUtils.findFirstOf(init, "&|^!") != -1) {
            throw new Exception("Invalid condition format: " + init);
        }
        if ((init = TextUtils.trim(init)).equals("1") || init.equals("true")) {
            return new TrueCondition();
        }
        if (init.equals("0") || init.equals("false")) {
            return new FalseCondition();
        }
        int ind = init.indexOf(61);
        if (ind == -1) {
            String attribute = init;
            if (attribute.equals("re")) {
                return new ReducingEndCondition();
            }
            if (attribute.equals("ps")) {
                return new ParentIsSaccharideCondition();
            }
            if (attribute.equals("pr")) {
                return new ParentIsRingFragmentCondition();
            }
            if (attribute.equals("px")) {
                return new ParentIsSpecialCondition();
            }
            if (attribute.equals("pc")) {
                return new ParentIsCleavageCondition();
            }
            if (attribute.equals("pb")) {
                return new ParentIsBracketCondition();
            }
            if (attribute.equals("pp")) {
                return new ParentIsRepetitionCondition();
            }
            if (attribute.equals("pa")) {
                return new ParentIsAttachPointCondition();
            }
            if (attribute.equals("cs")) {
                return new ChildIsSaccharideCondition();
            }
            if (attribute.equals("cr")) {
                return new ChildIsRingFragmentCondition();
            }
            if (attribute.equals("cx")) {
                return new ChildIsSpecialCondition();
            }
            if (attribute.equals("cc")) {
                return new ChildIsCleavageCondition();
            }
            if (attribute.equals("cb")) {
                return new ChildIsBracketCondition();
            }
            if (attribute.equals("cp")) {
                return new ChildIsRepetitionCondition();
            }
            throw new Exception("Invalid attribute name: <" + attribute + ">");
        }
        String attribute = init.substring(0, ind);
        String value = init.substring(ind + 1);
        if (attribute.equals("pt")) {
            return new ParentTypeCondition(value);
        }
        if (attribute.equals("ct")) {
            return new ChildTypeCondition(value);
        }
        if (attribute.equals("lp")) {
            return new LinkagePositionCondition(value);
        }
        if (attribute.equals("as")) {
            return new ChildAnomericStateCondition(value);
        }
        if (attribute.equals("ac")) {
            return new ChildAnomericCarbonCondition(value);
        }
        throw new Exception("Invalid attribute name: <" + attribute + ">");
    }
}

