/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.SVGUtils;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class StyledTextCellRenderer
extends JPanel
implements TableCellRenderer,
SVGUtils.Renderable {
    private static final long serialVersionUID = 0L;
    private static final int MAX_LINE_SIZE = 30;
    protected Color unselectedForeground;
    protected Color unselectedBackground;
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected JTextPane textPane;
    protected GridBagLayout gbl;

    public StyledTextCellRenderer() {
        this(true);
    }

    public StyledTextCellRenderer(boolean opaque) {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        this.textPane = new JTextPane();
        this.add((Component)this.textPane, c);
        this.setOpaque(opaque);
        this.textPane.setOpaque(opaque);
        this.textPane.setBorder(StyledTextCellRenderer.getNoFocusBorder());
        this.textPane.setAlignmentX(1.0f);
        this.textPane.setAlignmentY(0.5f);
        StyledDocument doc = this.textPane.getStyledDocument();
        Style sub_style = doc.addStyle("subscript", null);
        StyleConstants.setSubscript(sub_style, true);
        Style super_style = doc.addStyle("superscript", null);
        StyleConstants.setSuperscript(super_style, true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.invalidate();
        this.textPane.invalidate();
        if (isSelected) {
            this.textPane.setForeground(table.getSelectionForeground());
            this.textPane.setBackground(table.getSelectionBackground());
            super.setBackground(table.getSelectionBackground());
        } else {
            this.textPane.setForeground(table.getForeground());
            this.textPane.setBackground(table.getBackground());
            super.setBackground(table.getBackground());
        }
        this.textPane.setFont(table.getFont());
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            super.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color bcol;
                Color fcol = UIManager.getColor("Table.focusCellForeground");
                if (fcol != null) {
                    this.textPane.setForeground(fcol);
                }
                if ((bcol = UIManager.getColor("Table.focusCellBackground")) != null) {
                    this.textPane.setBackground(bcol);
                }
            }
        } else {
            super.setBorder(StyledTextCellRenderer.getNoFocusBorder());
        }
        this.setValue(value);
        this.textPane.setSize(Short.MAX_VALUE, Short.MAX_VALUE);
        this.textPane.setMinimumSize(this.textPane.getPreferredSize());
        return this;
    }

    public Component getRendererComponent(Font font, Color fg, Color bg, Object value) {
        super.invalidate();
        this.textPane.invalidate();
        this.textPane.setForeground(fg);
        this.textPane.setBackground(bg);
        this.textPane.setFont(font);
        this.setValue(value);
        this.textPane.setSize(Short.MAX_VALUE, Short.MAX_VALUE);
        this.textPane.setMinimumSize(this.textPane.getPreferredSize());
        return this;
    }

    public void beforeRendering() {
    }

    public Dimension getRenderableSize() {
        return this.getPreferredSize();
    }

    public void paintRenderable(Graphics2D g) {
        this.textPane.paint(g);
    }

    public void afterRendering() {
    }

    public String getValue() {
        return this.textPane.getText();
    }

    private void setValue(Object value) {
        StyledDocument doc = this.textPane.getStyledDocument();
        this.textPane.setText("");
        try {
            if (value != null) {
                int last_count = 0;
                String text = (String)value;
                StringBuilder buffer = new StringBuilder(text.length());
                for (int i = 0; i < text.length(); ++i) {
                    if (text.charAt(i) == '_' || text.charAt(i) == '^') {
                        if (buffer.length() > 0) {
                            doc.insertString(doc.getLength(), buffer.toString(), doc.getStyle("base"));
                            buffer = new StringBuilder(text.length());
                        }
                        Style style = text.charAt(i) == '_' ? doc.getStyle("subscript") : doc.getStyle("superscript");
                        String toadd = "";
                        if (i >= text.length() - 1) continue;
                        if (text.charAt(i + 1) == '{') {
                            int ind = TextUtils.findClosedParenthesis(text, i + 2, '{', '}');
                            if (ind != -1) {
                                toadd = text.substring(i + 2, ind);
                                i = ind;
                            } else {
                                toadd = text.substring(i + 2);
                                i = text.length() - 1;
                            }
                        } else {
                            toadd = "" + text.charAt(i + 1);
                            ++i;
                        }
                        doc.insertString(doc.getLength(), toadd, style);
                        continue;
                    }
                    if (buffer.length() - last_count > 30 && (text.charAt(i) == ',' || text.charAt(i) == ' ')) {
                        buffer.append('\n');
                        while (text.charAt(i + 1) == ' ') {
                            ++i;
                        }
                        last_count = buffer.length();
                        continue;
                    }
                    buffer.append(text.charAt(i));
                }
                if (buffer.length() > 0) {
                    doc.insertString(doc.getLength(), buffer.toString(), doc.getStyle("base"));
                }
            }
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    private static Border getNoFocusBorder() {
        return noFocusBorder;
    }
}

