/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table.manager;

import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.validate.DataValidator;
import org.grits.toolbox.entry.qrtpcr.model.TableData;

public class IntegerValidator
extends DataValidator {
    private IColumnPropertyAccessor<TableData> columnPropertyAccessor;

    public IntegerValidator(IColumnPropertyAccessor<TableData> columnPropertyAccessor) {
        this.columnPropertyAccessor = columnPropertyAccessor;
    }

    public boolean validate(int columnIndex, int rowIndex, Object newValue) {
        String stringValue;
        String columnName = this.getColumnProperty(columnIndex);
        if (columnName != null && columnName.equals("ID") && newValue != null && !(stringValue = (String)newValue).isEmpty()) {
            String[] geneIdNumbers;
            String splitChar = ",";
            if (stringValue.contains("/")) {
                splitChar = "/";
            }
            String[] stringArray = geneIdNumbers = stringValue.split(splitChar);
            int n = geneIdNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                String geneId = stringArray[n2];
                try {
                    Integer.parseInt(geneId.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    String getColumnProperty(int columnIndex) {
        return this.columnPropertyAccessor.getColumnProperty(columnIndex);
    }
}

