/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.dialog.email;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;
import org.grits.toolbox.entry.archive.model.ArchivedBasicEmail;

public class AddEmailDialog
extends TitleAreaDialog {
    private static Logger logger = Logger.getLogger(AddEmailDialog.class);
    private ComboViewer personCombo = null;
    private Text emailSubjectText = null;
    private CDateTime cDateTime = null;
    private ArchivedBasicEmail archivedEmail = null;
    private String emailSubject = null;

    public AddEmailDialog(Shell parentShell, String emailSubject) {
        super(parentShell);
        this.emailSubject = emailSubject;
    }

    public void create() {
        super.create();
        this.setTitle("Add Email");
        this.setMessage("Add Email to the Archive");
        this.getShell().setText("Add Email");
        this.getButton(0).setText("Add");
        if (this.emailSubject != null) {
            this.emailSubjectText.setText(this.emailSubject);
        }
    }

    protected Control createDialogArea(Composite parent) {
        logger.debug((Object)"Creating add email dialog");
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 2048);
        container.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout layout = new GridLayout(4, false);
        layout.marginTop = 10;
        layout.marginBottom = 40;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        container.setLayout((Layout)layout);
        this.personCombo = this.createComboLine(container, "From", 3);
        SingleChoicePreference personPreference = ProjectPreferenceStore.getSingleChoicePreference((ProjectPreferenceStore.Preference)ProjectPreferenceStore.Preference.PERSON);
        ArrayList<String> personList = new ArrayList<String>();
        personList.addAll(personPreference.getAllValues());
        String[] persons = this.getSortedArrayFromList(personList);
        this.personCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.personCombo.setInput((Object)persons);
        this.selectInCombo(this.personCombo, personPreference.getDefaultValue());
        Label displayLabel = new Label(container, 0);
        displayLabel.setText("Subject");
        this.emailSubjectText = new Text(container, 2048);
        this.emailSubjectText.setText("");
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        buttonData.horizontalAlignment = 4;
        this.emailSubjectText.setLayoutData((Object)buttonData);
        this.createLabel(container, "Email Date");
        this.cDateTime = new CDateTime(container, 3);
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        textGridData.minimumWidth = 100;
        textGridData.horizontalSpan = 3;
        this.cDateTime.setLayoutData((Object)textGridData);
        this.cDateTime.setSelection(new Date());
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    private void selectInCombo(ComboViewer comboViewer, String selectedValue) {
        String[] arrayOfValues = comboViewer.getCombo().getItems();
        if (arrayOfValues.length > 0 && selectedValue != null) {
            int i = 0;
            int selectionIndex = -1;
            String[] stringArray = arrayOfValues;
            int n = arrayOfValues.length;
            int n2 = 0;
            while (n2 < n) {
                String position = stringArray[n2];
                if (selectedValue != null && position.equals(selectedValue)) {
                    selectionIndex = i;
                }
                ++i;
                ++n2;
            }
            comboViewer.setInput((Object)arrayOfValues);
            if (selectionIndex >= 0) {
                comboViewer.getCombo().select(selectionIndex);
            }
        }
    }

    private ComboViewer createComboLine(Composite composite, String label, int horizontalSpan) {
        this.createLabel(composite, label);
        return this.createComboViewer(composite, horizontalSpan);
    }

    private ComboViewer createComboViewer(Composite composite, int horizontalSpan) {
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        GridData comboGridData = new GridData();
        comboGridData.grabExcessHorizontalSpace = true;
        comboGridData.horizontalAlignment = 4;
        comboGridData.horizontalSpan = horizontalSpan;
        comboViewer.getCombo().setLayoutData((Object)comboGridData);
        return comboViewer;
    }

    private void createLabel(Composite composite, String label) {
        Label labelLabel = new Label(composite, 0);
        GridData labelGridData = new GridData();
        labelGridData.verticalAlignment = 1;
        labelLabel.setLayoutData((Object)labelGridData);
        labelLabel.setText(label);
    }

    private String[] getSortedArrayFromList(List<String> listOfValue) {
        Collections.sort(listOfValue);
        String[] arrayOfValue = new String[listOfValue.size()];
        int i = 0;
        Iterator<String> iterator = listOfValue.iterator();
        while (iterator.hasNext()) {
            String value;
            arrayOfValue[i] = value = iterator.next();
            ++i;
        }
        return arrayOfValue;
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        this.getButton(0).setEnabled(newErrorMessage == null);
    }

    protected void okPressed() {
        if (this.personCombo.getCombo().getItems().length == 0 || this.personCombo.getCombo().getSelectionIndex() >= 0) {
            this.archivedEmail = new ArchivedBasicEmail();
            this.archivedEmail.setFromPerson(this.personCombo.getCombo().getText());
            this.archivedEmail.setEmailSubject(this.emailSubjectText.getText());
            this.archivedEmail.setEmailDate(this.cDateTime.getSelection());
            this.archivedEmail.setModifiedDate(new Date());
            super.okPressed();
        } else {
            this.setErrorMessage("Select the person");
        }
    }

    public ArchivedBasicEmail getArchivedEmail() {
        return this.archivedEmail;
    }
}

