/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eurocarbdb.application.glycanbuilder.Configuration;

public class Param {
    protected HashMap<String, Object> values_ = new HashMap();
    protected HashMap<String, String> descriptions_ = new HashMap();
    public int inheritance_steps_max = 15;

    public Param clone() {
        Param ret = new Param();
        ret.copy(this);
        return ret;
    }

    public void copy(Param rhs) {
        this.values_ = (HashMap)rhs.values_.clone();
        this.descriptions_ = (HashMap)rhs.descriptions_.clone();
    }

    public boolean equals(Param rhs) {
        return this.values_.equals(rhs.values_);
    }

    public Map<String, Object> getValues() {
        return this.values_;
    }

    public void setValue(String key, Object value) {
        this.setValue(key, value, "");
    }

    public void setValue(String key, Object value, String description) {
        this.values_.put(key, value);
        this.setDescription(key, description);
    }

    public Object getValue(String key) {
        return this.values_.get(key);
    }

    public void setDescription(String location, String description) {
        if (description != null && description.length() > 0) {
            this.descriptions_.put(location, description);
        }
    }

    public String getDescription(String key) {
        String ret = this.descriptions_.get(key);
        return ret == null ? "" : ret;
    }

    public int size() {
        return this.values_.size();
    }

    public boolean empty() {
        return this.values_.size() == 0;
    }

    public void clear() {
        this.values_.clear();
        this.descriptions_.clear();
    }

    public void insert(String prefix, Param para) {
        if (prefix == null || prefix.length() == 0) {
            for (Map.Entry<String, Object> entry : para.values_.entrySet()) {
                this.values_.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : para.descriptions_.entrySet()) {
                this.descriptions_.put(entry.getKey(), (String)entry.getValue());
            }
        } else {
            if (!prefix.endsWith(":")) {
                prefix = prefix + ':';
            }
            for (Map.Entry<String, Object> entry : para.values_.entrySet()) {
                this.values_.put(prefix + entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : para.descriptions_.entrySet()) {
                this.descriptions_.put(prefix + entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void remove(String prefix) {
        Map.Entry<String, Object> e;
        Iterator<Map.Entry<String, Object>> it = this.values_.entrySet().iterator();
        while (it.hasNext()) {
            e = it.next();
            if (!e.getKey().startsWith(prefix)) continue;
            it.remove();
        }
        it = this.descriptions_.entrySet().iterator();
        while (it.hasNext()) {
            e = it.next();
            if (!e.getKey().startsWith(prefix)) continue;
            it.remove();
        }
    }

    public void setDefaults(Param defaults) {
        this.setDefaults(defaults, "", false);
    }

    public void setDefaults(Param defaults, String prefix) {
        this.setDefaults(defaults, prefix, false);
    }

    public void setDefaults(Param defaults, String prefix, boolean showMessage) {
        if (prefix != null && prefix.length() > 0 && !prefix.startsWith(":")) {
            prefix = prefix + ":";
        }
        for (Map.Entry<String, Object> entry : defaults.values_.entrySet()) {
            if (this.values_.get(prefix + entry.getKey()) != null) continue;
            if (showMessage) {
                System.out.println("Setting " + prefix + entry.getKey() + " to " + entry.getValue());
            }
            this.values_.put(prefix + entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : defaults.descriptions_.entrySet()) {
            if (this.descriptions_.get(prefix + entry.getKey()) != null) continue;
            this.descriptions_.put(prefix + entry.getKey(), (String)entry.getValue());
        }
    }

    public void checkDefaults(String name, Param defaults) {
        this.checkDefaults(name, defaults, "", System.out);
    }

    public void checkDefaults(String name, Param defaults, String prefix) {
        this.checkDefaults(name, defaults, prefix, System.out);
    }

    public void checkDefaults(String name, Param defaults, String prefix, PrintStream os) {
        HashMap<String, String> check_descriptions;
        HashMap<String, Object> check_values;
        if (prefix == null || prefix.length() > 0) {
            check_values = this.values_;
            check_descriptions = this.descriptions_;
        } else {
            if (!prefix.endsWith(":")) {
                prefix = prefix + ":";
            }
            Param copied = this.copy(prefix, true);
            check_values = copied.values_;
            check_descriptions = copied.descriptions_;
        }
        for (Map.Entry<String, Object> e : check_values.entrySet()) {
            if (defaults.values_.get(e.getKey()) != null) continue;
            os.print("Warning: " + name + " received the unknown parameter '" + e.getKey() + "'");
            if (prefix.length() > 0) {
                os.print(" in '" + prefix + "'");
            }
            os.println("!");
        }
    }

    public Param copy(String prefix) {
        return this.copy(prefix, false, "");
    }

    public Param copy(String prefix, boolean remove_prefix) {
        return this.copy(prefix, remove_prefix, "");
    }

    public Param copy(String prefix, boolean remove_prefix, String new_prefix) {
        String key;
        if (new_prefix.length() > 0 && !new_prefix.endsWith(":")) {
            new_prefix = new_prefix + ":";
        }
        Param out = new Param();
        for (Map.Entry<String, Object> entry : this.values_.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            key = remove_prefix ? entry.getKey().substring(prefix.length(), entry.getKey().length() - prefix.length()) : entry.getKey();
            if (new_prefix.length() > 0) {
                key = new_prefix + key;
            }
            out.values_.put(key, entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.descriptions_.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            key = remove_prefix ? entry.getKey().substring(prefix.length(), entry.getKey().length() - prefix.length()) : entry.getKey();
            if (new_prefix.length() > 0) {
                key = new_prefix + key;
            }
            out.descriptions_.put(key, (String)entry.getValue());
        }
        return out;
    }

    public void outputValues() {
        for (Map.Entry<String, Object> e : this.values_.entrySet()) {
            System.out.println(e.getKey() + " = " + e.getValue().toString());
        }
    }

    public void store(String name, Configuration config) {
        for (Map.Entry<String, Object> e : this.values_.entrySet()) {
            config.put(name, this.clean(e.getKey()), e.getValue());
        }
    }

    public void retrieve(String name, Configuration config) {
        for (Map.Entry<String, Object> e : this.values_.entrySet()) {
            this.setValue(e.getKey(), config.get(name, this.clean(e.getKey()), e.getValue()));
        }
    }

    private String clean(String str) {
        return str.replace(':', '_');
    }
}

