/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.GlycanMatcher;
import org.grits.toolbox.ms.annotation.gelato.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanScansAnnotation;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;

public class FragmentMatcher {
    private static final Logger logger = Logger.getLogger(FragmentMatcher.class);
    GlycanScansAnnotation parentScansAnnotation = null;

    public FragmentMatcher(GlycanScansAnnotation parentScansAnnotation) {
        this.parentScansAnnotation = parentScansAnnotation;
    }

    public List<Integer> getMatchingSubScans(Data data, int iCurScanNum, Peak parentPeak) {
        ArrayList<Integer> iMatchingScans = new ArrayList<Integer>();
        List<Integer> lScans = GelatoUtils.getSubScanForPrecursor(data, iCurScanNum, parentPeak);
        if (!lScans.isEmpty()) {
            for (Integer iSubScanNum : lScans) {
                iMatchingScans.add(iSubScanNum);
            }
        }
        return iMatchingScans;
    }

    public boolean matchFragment(GlycanScansAnnotation fragmentScansAnnotation, int iParentScanNum, GlycanAnnotation fragAnnotation, Glycan fragGlycan, GlycanStructure fragStructure, String seq, Data data, List<IonSettings> lFragmentAdductsToAnalyze, List<Integer> lFragmentAdductCounts, List<IonSettings> lFragmentExchangesToAnalyze, List<Integer> lFragmentExchangesCounts, List<MoleculeSettings> lFragmentNeutralLossesToAnalyze, List<Integer> lFragmentNeutralLossCounts, AnalyteSettings settings, int precursorIndex, String fragmentType, String tempPath, AnnotationWriter writer) {
        boolean bRes = false;
        try {
            double[] glycanMzAndCharge = GlycanStructureAnnotation.getGlycanMzAndCharge(fragGlycan, settings, lFragmentAdductsToAnalyze, lFragmentAdductCounts, lFragmentExchangesToAnalyze, lFragmentExchangesCounts, lFragmentNeutralLossesToAnalyze, lFragmentNeutralLossCounts);
            double glycanMz = glycanMzAndCharge[0];
            int iParentCharge = (int)glycanMzAndCharge[1];
            int iNumParentExchanges = (int)glycanMzAndCharge[2];
            int iNumParentLosses = (int)glycanMzAndCharge[3];
            Scan scan = (Scan)data.getScans().get(iParentScanNum);
            for (int iPeakInx = 0; iPeakInx < scan.getPeaklist().size(); ++iPeakInx) {
                try {
                    int[] iPeakMatchInfo = GelatoUtils.getMatchingPeak(scan, iPeakInx, glycanMz, data.getDataHeader().getMethod(), false);
                    if (iPeakMatchInfo == null || iPeakMatchInfo[1] == -1) continue;
                    Peak peak = (Peak)scan.getPeaklist().get(iPeakMatchInfo[1]);
                    boolean bCurRes = GlycanMatcher.scorePeakToFeature(data, this.parentScansAnnotation, glycanMz, fragGlycan, fragmentType, fragAnnotation, fragmentScansAnnotation, fragStructure, lFragmentAdductsToAnalyze, lFragmentAdductCounts, iParentCharge, lFragmentExchangesToAnalyze, lFragmentExchangesCounts, iNumParentExchanges, lFragmentNeutralLossesToAnalyze, lFragmentNeutralLossCounts, iNumParentLosses, settings, peak, iParentScanNum, tempPath, writer);
                    if (bCurRes) {
                        logger.debug((Object)"\t\t\tSCORED!");
                        if (!((Scan)data.getScans().get(iParentScanNum)).getAnnotatedPeaks().containsKey(peak.getId()) || !((Boolean)((Scan)data.getScans().get(iParentScanNum)).getAnnotatedPeaks().get(peak.getId())).booleanValue()) {
                            int iNumAnnot = ((Scan)data.getScans().get(iParentScanNum)).getNumAnnotatedPeaks() != null ? ((Scan)data.getScans().get(iParentScanNum)).getNumAnnotatedPeaks() : 0;
                            ((Scan)data.getScans().get(iParentScanNum)).setNumAnnotatedPeaks(Integer.valueOf(iNumAnnot + 1));
                            ((Scan)data.getScans().get(iParentScanNum)).getAnnotatedPeaks().put(peak.getId(), Boolean.TRUE);
                        }
                    }
                    iPeakInx = iPeakMatchInfo[0] - 1;
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Error analyzing peaks in FragmentMatcherGlycanBased:matchFragment.", (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in FragmentMatcherGlycanBased:matchFragment.", (Throwable)e);
            e.printStackTrace();
        }
        return bRes;
    }
}

