/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.FeatureSelection;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.IonAdduct;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;

public class GelatoUtils {
    private static final Logger logger = Logger.getLogger(GelatoUtils.class);

    public static double getTargetAccuracy(Method _method, double _dMz, boolean _bIsPrecursor) {
        double targetAccuracy = 0.0;
        targetAccuracy = _bIsPrecursor ? (_method.getAccuracyPpm().booleanValue() ? _method.getAccuracy() / 1000000.0 * _dMz : _method.getAccuracy()) : (_method.getFragAccuracyPpm() != false ? _method.getFragAccuracy() / 1000000.0 * _dMz : _method.getFragAccuracy());
        return targetAccuracy;
    }

    public static List<Integer> getMatchingSubScans(Data data, Scan scan, int iPeakInx) {
        Peak peak = (Peak)scan.getPeaklist().get(iPeakInx);
        List iSubScans = scan.getSubScans();
        ArrayList<Integer> iMatchingScans = new ArrayList<Integer>();
        for (int i = 0; i < iSubScans.size(); ++i) {
            Scan subScan = (Scan)data.getScans().get(iSubScans.get(i));
            if (subScan.getPrecursor().getMz() != peak.getPrecursorMz()) continue;
            iMatchingScans.add(subScan.getScanNo());
        }
        return iMatchingScans;
    }

    public static int[] getMatchingPeak(Scan scan, int iPeakInx, double glycanMz, Method method, boolean _bIsPrecursor) {
        try {
            boolean bGo;
            Peak peak = (Peak)scan.getPeaklist().get(iPeakInx);
            if (peak == null || peak.getMz() == null || peak.getIntensity() == null) {
                return null;
            }
            double peakMz = peak.getMz() + method.getShift();
            double targetAccuracy = GelatoUtils.getTargetAccuracy(method, glycanMz, _bIsPrecursor);
            double dMaxInt = -1.0;
            int iMaxPeakInx = -1;
            boolean bl = bGo = Math.abs(peakMz - glycanMz) <= targetAccuracy;
            while (bGo) {
                if (peak.getIntensity() > dMaxInt) {
                    dMaxInt = peak.getIntensity();
                    iMaxPeakInx = iPeakInx;
                }
                if (++iPeakInx < scan.getPeaklist().size()) {
                    peak = (Peak)scan.getPeaklist().get(iPeakInx);
                    if (peak == null || peak.getMz() == null || peak.getIntensity() == null) continue;
                    peakMz = peak.getMz() + method.getShift();
                    bGo = Math.abs(peakMz - glycanMz) <= targetAccuracy;
                    continue;
                }
                bGo = false;
            }
            return new int[]{iPeakInx, iMaxPeakInx};
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
    }

    public static List<Integer> getSubScanForPrecursor(Data data, int iParentScanNum, Peak parentPeak) {
        ArrayList<Integer> lScans = new ArrayList<Integer>();
        Scan scan = (Scan)data.getScans().get(iParentScanNum);
        double dMult = 100.0;
        for (Integer iSubScanNum : scan.getSubScans()) {
            try {
                Scan subScan = (Scan)data.getScans().get(iSubScanNum);
                if (subScan.getPrecursor().getPrecursorMz() == null || Math.round(subScan.getPrecursor().getPrecursorMz()) != Math.round(parentPeak.getMz())) continue;
                lScans.add(iSubScanNum);
                logger.debug((Object)("\t\t\tSubscan: " + subScan.getScanNo() + ", precursor m/z: " + subScan.getPrecursor().getPrecursorMz() + ". Parent peak m/z: " + parentPeak.getMz()));
            }
            catch (NullPointerException ex) {
                logger.error((Object)"Null subscan or precursor value in getSubScanForPrecursor", (Throwable)ex);
            }
        }
        return lScans;
    }

    public static GlycanFeature getNewGlycanFeature(Data _data, String sSeq, double dPeakMz, double glycanMz, double charge, String fragmentType, List<IonSettings> lAdductsToAnalyze, List<Integer> lAdductsToAnalyzeCounts, List<IonSettings> lExchangesToAnalyze, List<Integer> lExchangesToAnalyzeCounts, List<MoleculeSettings> lNeutralLossesToAnalyze, List<Integer> lNeutralLossesToAnalyzeCounts, Integer scanNum, int index, GlycanAnnotation annotation) {
        int i;
        GlycanFeature feature = new GlycanFeature();
        feature.setId(Integer.toString(_data.getNextFeatureIndex()));
        feature.setSequence(sSeq.substring(0, sSeq.indexOf("$")));
        feature.setCharge(Integer.valueOf((int)charge));
        double deviation = Math.abs(dPeakMz - glycanMz) / glycanMz * 1000000.0;
        feature.setDeviation(Double.valueOf(deviation));
        feature.setFragmentType(fragmentType);
        if (lAdductsToAnalyze != null) {
            for (i = 0; i < lAdductsToAnalyze.size(); ++i) {
                IonSettings adduct = lAdductsToAnalyze.get(i);
                int count = lAdductsToAnalyzeCounts.get(i);
                IonAdduct ion = new IonAdduct();
                ion.setCharge(adduct.getCharge());
                ion.setCount(Integer.valueOf(count));
                ion.setLabel(adduct.getLabel());
                ion.setMass(adduct.getMass());
                ion.setName(adduct.getName());
                feature.getIons().add(ion);
            }
        }
        if (lExchangesToAnalyze != null) {
            for (i = 0; i < lExchangesToAnalyze.size(); ++i) {
                IonSettings ionExchange = lExchangesToAnalyze.get(i);
                int exchangeCount = lExchangesToAnalyzeCounts.get(i);
                IonAdduct exchange = new IonAdduct();
                exchange.setCharge(ionExchange.getCharge());
                exchange.setCount(Integer.valueOf(exchangeCount));
                exchange.setLabel(ionExchange.getLabel());
                exchange.setName(ionExchange.getName());
                exchange.setMass(ionExchange.getMass());
                feature.getNeutralexchange().add(exchange);
            }
        }
        if (lNeutralLossesToAnalyze != null) {
            for (i = 0; i < lNeutralLossesToAnalyze.size(); ++i) {
                MoleculeSettings neutralLoss = lNeutralLossesToAnalyze.get(i);
                int neutralLossCount = lNeutralLossesToAnalyzeCounts.get(i);
                MoleculeSettings featureNeutralLoss = new MoleculeSettings();
                featureNeutralLoss.setCount(Integer.valueOf(neutralLossCount));
                featureNeutralLoss.setLabel(neutralLoss.getLabel());
                featureNeutralLoss.setMass(neutralLoss.getMass());
                featureNeutralLoss.setName(neutralLoss.getName());
                feature.getNeutralLoss().add(featureNeutralLoss);
            }
        }
        feature.setMz(Double.valueOf(glycanMz));
        String rowId = Feature.getRowId((Integer)index, (Integer)scanNum);
        FeatureSelection fSelection = new FeatureSelection();
        fSelection.setRowId(rowId);
        feature.getFeatureSelections().add(fSelection);
        feature.setAnnotationId(annotation.getId());
        feature.setPrecursor(Integer.valueOf(-1));
        return feature;
    }
}

