/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.grits.toolbox.ms.annotation.gelato.AnnotateFragments;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.GlycanMatcher;
import org.grits.toolbox.ms.annotation.gelato.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.GlycanScansAnnotation;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;

public class GlycanMatcherDirectInfusion
extends GlycanMatcher {
    private static final Logger logger = Logger.getLogger(GlycanMatcherDirectInfusion.class);
    HashMap<Integer, String> avoideDuplicateAnnotation = new HashMap();

    public GlycanMatcherDirectInfusion(GlycanStructureAnnotation parent) {
        super(parent);
    }

    @Override
    public List<Integer> getMatchingSubScans(Data data, int iCurScanNum, Peak parentPeak) {
        ArrayList<Integer> iMatchingScans = new ArrayList<Integer>();
        Iterator iterator = data.getScans().keySet().iterator();
        while (iterator.hasNext()) {
            List<Integer> lScans;
            int iHashScanNum = (Integer)iterator.next();
            Scan scan = (Scan)data.getScans().get(iHashScanNum);
            if (scan.getScanNo() < iCurScanNum || (lScans = GelatoUtils.getSubScanForPrecursor(this.getData(), iHashScanNum, parentPeak)).isEmpty()) continue;
            for (Integer iSubScanNum : lScans) {
                iMatchingScans.add(iSubScanNum);
            }
        }
        return iMatchingScans;
    }

    @Override
    protected boolean scorePeakToFeature(double glycanMz, Glycan glycan, String glycanType, GlycanAnnotation annotation, GlycanScansAnnotation glycanScanAnnotation, GlycanStructure structure, List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount, AnalyteSettings settings, Peak parentPeak, int iParentScan, String tempPath, AnnotationWriter writer) {
        AnnotateFragments annFragments = new AnnotateFragments(this.getParentScansAnnotation());
        boolean bScored = false;
        try {
            Iterator iterator = this.getData().getScans().keySet().iterator();
            while (iterator.hasNext()) {
                int iHashScanNum = (Integer)iterator.next();
                Scan scan = (Scan)this.getData().getScans().get(iHashScanNum);
                if (scan.getScanNo() < this.getScanNum()) continue;
                List<Integer> lScans = GelatoUtils.getSubScanForPrecursor(this.getData(), iHashScanNum, parentPeak);
                if (lScans.isEmpty() && iHashScanNum == iParentScan) {
                    GlycanFeature feature = GelatoUtils.getNewGlycanFeature(this.data, glycan.toString(), parentPeak.getMz(), glycanMz, iParentCharge, glycanType, lParentAdducts, lParentAdductCounts, lParentIonExchanges, lParentExchangeCounts, lParentNeutralLosses, lParentNeutralLossCounts, null, parentPeak.getId(), annotation);
                    GlycanMatcher.addAnnotationToScan(this.getData(), glycanScanAnnotation, iHashScanNum, annotation, structure, feature);
                    continue;
                }
                if (glycanScanAnnotation.getFragmentScansAnnotations() == null) {
                    glycanScanAnnotation.setFragmentScansAnnotations(new HashMap());
                }
                ArrayList<GlycanScansAnnotation> subScanAnnotations = null;
                if (!glycanScanAnnotation.getFragmentScansAnnotations().containsKey(iHashScanNum)) {
                    subScanAnnotations = new ArrayList();
                    glycanScanAnnotation.getFragmentScansAnnotations().put(iHashScanNum, subScanAnnotations);
                } else {
                    subScanAnnotations = (List)glycanScanAnnotation.getFragmentScansAnnotations().get(iHashScanNum);
                }
                if (lScans.isEmpty()) continue;
                for (Integer iSubScanNum : lScans) {
                    GlycanFeature feature = GelatoUtils.getNewGlycanFeature(this.getData(), glycan.toString(), parentPeak.getMz(), glycanMz, iParentCharge, null, lParentAdducts, lParentAdductCounts, lParentIonExchanges, lParentExchangeCounts, lParentNeutralLosses, lParentNeutralLossCounts, iSubScanNum, parentPeak.getId(), annotation);
                    logger.debug((Object)("\t\tFeature id: " + parentPeak.getId() + ", Feature mz: " + feature.getMz()));
                    GlycanMatcher.addAnnotationToScan(this.getData(), glycanScanAnnotation, iHashScanNum, annotation, structure, feature);
                    if (iSubScanNum == null || this.getData().getScans().get(iSubScanNum) == null || ((Scan)this.getData().getScans().get(iSubScanNum)).getPrecursor() == null || this.avoideDuplicateAnnotation.get(iSubScanNum) != null) continue;
                    this.avoideDuplicateAnnotation.put(iSubScanNum, "seen");
                    annFragments.annotateFragments(subScanAnnotations, iSubScanNum, feature, structure, lParentAdducts, lParentAdductCounts, iParentCharge, lParentIonExchanges, lParentExchangeCounts, iParentExchangeCount, lParentNeutralLosses, lParentNeutralLossCounts, iParentNeutralLossCount, annotation, structure.getGWBSequence(), this.getData(), settings, ((Scan)this.getData().getScans().get(iSubScanNum)).getPrecursor().getId(), tempPath, writer);
                    this.calculateScores(glycanScanAnnotation, annotation, feature, iHashScanNum, iSubScanNum);
                    bScored = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error matching glycans in GlycanMatcherGlycanBased.", (Throwable)e);
        }
        return bScored;
    }
}

