/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.GlycanMatcher;
import org.grits.toolbox.ms.annotation.gelato.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.gelato.GlycanStructureAnnotationMSProfile;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.GlycanScansAnnotation;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;

public class GlycanMatcherMSProfile
extends GlycanMatcher {
    private static final Logger logger = Logger.getLogger(GlycanMatcherMSProfile.class);

    public GlycanMatcherMSProfile(GlycanStructureAnnotation parent) {
        super(parent);
    }

    @Override
    protected void handleUnscoredPeak(Peak parentPeak) {
        Scan parentScan = (Scan)this.getData().getScans().get(this.getScanNum());
        try {
            Scan subScan = ((GlycanStructureAnnotationMSProfile)this.parent).getPhonySubScan(parentPeak, parentScan);
            int n = subScan.getScanNo();
        }
        catch (Exception ex) {
            logger.error((Object)"Error matching glycan structure to phony scan num.", (Throwable)ex);
        }
    }

    @Override
    protected boolean scorePeakToFeature(double glycanMz, Glycan glycan, String glycanType, GlycanAnnotation annotation, GlycanScansAnnotation glycanScanAnnotation, GlycanStructure structure, List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount, AnalyteSettings settings, Peak parentPeak, int iParentScan, String tempPath, AnnotationWriter writer) {
        Scan parentScan = (Scan)this.getData().getScans().get(this.getScanNum());
        try {
            Scan subScan = ((GlycanStructureAnnotationMSProfile)this.parent).getPhonySubScan(parentPeak, parentScan);
            int iSubScanNum = subScan.getScanNo();
            GlycanFeature feature = GelatoUtils.getNewGlycanFeature(this.getData(), glycan.toString(), parentPeak.getMz(), glycanMz, iParentCharge, null, lParentAdducts, lParentAdductCounts, lParentIonExchanges, lParentExchangeCounts, lParentNeutralLosses, lParentNeutralLossCounts, iSubScanNum, parentPeak.getId(), annotation);
            logger.debug((Object)("\t\tFeature id: " + parentPeak.getId() + ", Feature mz: " + feature.getMz()));
            GlycanMatcher.addAnnotationToScan(this.getData(), glycanScanAnnotation, this.getScanNum(), annotation, structure, feature);
            this.calculateScores(glycanScanAnnotation, annotation, feature, iParentScan, iSubScanNum);
            if (this.getData().getAnnotatedScan().get(iSubScanNum) == null) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(annotation.getStringId());
                this.getData().getAnnotatedScan().put(iSubScanNum, ids);
            } else {
                ((List)this.getData().getAnnotatedScan().get(iSubScanNum)).add(annotation.getStringId());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error matching glycan structure to phony scan num.", (Throwable)ex);
        }
        return true;
    }

    @Override
    protected boolean calculateScores(GlycanScansAnnotation glycanScanAnnotations, GlycanAnnotation annotation, GlycanFeature feature, int iParentScanNum, int iSubScanNum) {
        annotation.getScores().put(Integer.toString(iSubScanNum), -1.0);
        feature.getDoubleProp().put(GlycanStructureAnnotation.countingScoreData.getKey(), -1.0);
        feature.getDoubleProp().put(GlycanStructureAnnotation.intensityScoreData.getKey(), -1.0);
        feature.getDoubleProp().put(GlycanStructureAnnotation.rawCountingScoreData.getKey(), -1.0);
        feature.getDoubleProp().put(GlycanStructureAnnotation.rawIntensityScoreData.getKey(), -1.0);
        return true;
    }
}

