/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class GridHeaderEditor
extends ControlEditor {
    private Grid table;
    private GridColumn column;
    ControlListener columnListener;
    Listener resizeListener;
    private final Listener columnVisibleListener;
    private final Listener columnGroupListener;
    private final SelectionListener scrollListener;
    private final Listener mouseOverListener;

    GridHeaderEditor(final GridColumn column) {
        super((Composite)column.getParent());
        this.table = column.getParent();
        this.column = column;
        this.columnListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                GridHeaderEditor.this.layout();
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GridHeaderEditor.this.layout();
                    }
                });
            }

            public void controlResized(ControlEvent e) {
                GridHeaderEditor.this.layout();
            }
        };
        this.columnVisibleListener = new Listener(){

            public void handleEvent(Event event) {
                GridHeaderEditor.this.getEditor().setVisible(column.isVisible());
                GridHeaderEditor.this.layout();
            }
        };
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                GridHeaderEditor.this.layout();
            }
        };
        this.scrollListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridHeaderEditor.this.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.columnGroupListener = new Listener(){

            public void handleEvent(Event event) {
                if (GridHeaderEditor.this.getEditor() == null || GridHeaderEditor.this.getEditor().isDisposed()) {
                    return;
                }
                GridHeaderEditor.this.getEditor().setVisible(column.isVisible());
                GridHeaderEditor.this.layout();
            }
        };
        this.mouseOverListener = new Listener(){

            public void handleEvent(Event event) {
                if (GridHeaderEditor.this.table.getCursor() != null) {
                    ((GridHeaderEditor)GridHeaderEditor.this).table.hoveringOnColumnResizer = false;
                    GridHeaderEditor.this.table.setCursor(null);
                }
            }
        };
        this.table.addListener(11, this.resizeListener);
        if (this.table.getVerticalScrollBarProxy() != null) {
            this.table.getVerticalScrollBarProxy().addSelectionListener(this.scrollListener);
        }
        if (this.table.getHorizontalScrollBarProxy() != null) {
            this.table.getHorizontalScrollBarProxy().addSelectionListener(this.scrollListener);
        }
        this.grabVertical = true;
    }

    protected Rectangle internalComputeBounds() {
        this.column.getHeaderRenderer().setBounds(this.column.getBounds());
        return this.column.getHeaderRenderer().getControlBounds((Object)this.column, true);
    }

    public void dispose() {
        if (!this.table.isDisposed() && !this.column.isDisposed()) {
            this.column.removeControlListener(this.columnListener);
            if (this.column.getColumnGroup() != null) {
                this.column.getColumnGroup().removeListener(17, this.columnGroupListener);
                this.column.getColumnGroup().removeListener(18, this.columnGroupListener);
            }
        }
        if (!this.table.isDisposed()) {
            this.table.removeListener(11, this.resizeListener);
            if (this.table.getVerticalScrollBarProxy() != null) {
                this.table.getVerticalScrollBarProxy().removeSelectionListener(this.scrollListener);
            }
            if (this.table.getHorizontalScrollBarProxy() != null) {
                this.table.getHorizontalScrollBarProxy().removeSelectionListener(this.scrollListener);
            }
        }
        this.columnListener = null;
        this.resizeListener = null;
        this.table = null;
        super.dispose();
    }

    void initColumn() {
        this.column.addControlListener(this.columnListener);
        this.column.addListener(22, this.columnVisibleListener);
        this.column.addListener(23, this.columnVisibleListener);
        if (this.column.getColumnGroup() != null) {
            this.column.getColumnGroup().addListener(17, this.columnGroupListener);
            this.column.getColumnGroup().addListener(18, this.columnGroupListener);
        }
        this.layout();
    }

    public void layout() {
        Rectangle rect;
        if (this.table.isDisposed()) {
            return;
        }
        boolean hadFocus = false;
        if (this.getEditor() == null || this.getEditor().isDisposed() || !this.column.isVisible()) {
            return;
        }
        if (this.getEditor().getVisible()) {
            hadFocus = this.getEditor().isFocusControl();
        }
        if ((rect = this.internalComputeBounds()) == null || rect.x < 0) {
            this.getEditor().setVisible(false);
            return;
        }
        if (this.table.getItemHeaderWidth() > 0 && this.table.getItemHeaderWidth() > rect.x) {
            this.getEditor().setVisible(false);
            return;
        }
        this.getEditor().setVisible(true);
        this.getEditor().setBounds(rect);
        if (hadFocus) {
            if (this.getEditor() == null || this.getEditor().isDisposed()) {
                return;
            }
            this.getEditor().setFocus();
        }
    }

    public void setEditor(Control editor) {
        if (this.getEditor() != null) {
            this.getEditor().removeListener(6, this.mouseOverListener);
        }
        super.setEditor(editor);
        if (editor != null) {
            this.getEditor().addListener(6, this.mouseOverListener);
        }
    }
}

