/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.annotation.entry.process.loader;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.glycan.process.loader.MSGlycanAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.glycan.process.loader.MSGlycanAnnotationTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessorUtil;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.tools.gsl.annotation.datamodel.preference.MSGlycolipidAnnotationViewerPreference;
import org.grits.toolbox.tools.gsl.annotation.datamodel.tablemodel.MSGlycolipidAnnotationTableDataObject;
import org.grits.toolbox.tools.gsl.annotation.datamodel.tablemodel.dmtranslate.DMLipidAnnotation;
import org.grits.toolbox.tools.gsl.annotation.entry.process.loader.MSGlycolipidAnnotationTableDataProcessorUtil;

public class MSGlycolipidAnnotationTableDataProcessor
extends MSGlycanAnnotationTableDataProcessor {
    private static final Logger logger = Logger.getLogger(MSGlycolipidAnnotationTableDataProcessor.class);

    public MSGlycolipidAnnotationTableDataProcessor(Entry _entry, Property _sourceProperty, FillTypes _fillType, int iMinMSLevel) {
        super(_entry, _sourceProperty, _fillType, iMinMSLevel);
    }

    public MSGlycolipidAnnotationTableDataProcessor(Entry _entry, Property _sourceProperty, int iMinMSLevel) {
        super(_entry, _sourceProperty, iMinMSLevel);
    }

    public MSGlycolipidAnnotationTableDataProcessor(TableDataProcessor _parent, Property _sourceProperty, FillTypes _fillType, int iMinMSLevel) {
        super(_parent, _sourceProperty, _fillType, iMinMSLevel);
    }

    public void initializeTableDataObject(Property _sourceProperty) {
        this.setSimianTableDataObject((MassSpecTableDataObject)new MSGlycolipidAnnotationTableDataObject(this.getMassSpecEntityProperty().getMsLevel(), this.fillType));
        this.getSimianTableDataObject().initializePreferences();
        if (this.getSimianTableDataObject().getTablePreferences().settingsNeedInitialization()) {
            TableViewerPreference tvp = this.initializePreferences();
            MSGlycolipidAnnotationTableDataProcessor.setDefaultColumnViewSettings(this.fillType, tvp.getPreferenceSettings());
            this.getSimianTableDataObject().setTablePreferences(tvp);
            this.getSimianTableDataObject().getTablePreferences().writePreference();
        }
    }

    protected TableViewerPreference getNewTableViewerPreferences() {
        return new MSGlycolipidAnnotationViewerPreference();
    }

    public TableViewerPreference initializePreferences() {
        MSGlycolipidAnnotationViewerPreference newPreferences = (MSGlycolipidAnnotationViewerPreference)super.initializePreferences();
        MSGlycolipidAnnotationViewerPreference oldPreferences = (MSGlycolipidAnnotationViewerPreference)this.getSimianTableDataObject().getTablePreferences();
        if (oldPreferences != null) {
            newPreferences.setShowExtraInfo(oldPreferences.getShowExtraInfo());
        }
        MSGlycolipidAnnotationTableDataProcessorUtil.postProcessColumnSettings((TableViewerPreference)newPreferences);
        return newPreferences;
    }

    public static void setDefaultColumnViewSettings(FillTypes fillType, TableViewerColumnSettings tvs) {
        GRITSColumnHeader header;
        MSGlycanAnnotationTableDataProcessor.setDefaultColumnViewSettings((FillTypes)fillType, (TableViewerColumnSettings)tvs);
        if (fillType == FillTypes.PeaksWithFeatures && (header = tvs.getColumnHeader(DMLipidAnnotation.lipid_annotation_name.name())) != null) {
            tvs.setVisColInx(header, Integer.valueOf(-1));
        }
    }

    private MSGlycolipidAnnotationTableDataObject getMySimianTableDataObject() {
        return (MSGlycolipidAnnotationTableDataObject)this.getSimianTableDataObject();
    }

    protected void addHeaderLine(int iPrefColNum, GRITSColumnHeader colHeader, ArrayList<GRITSColumnHeader> alHeader) {
        if (colHeader.getKeyValue().equals(DMLipidAnnotation.lipid_annotation_name.name())) {
            this.getMySimianTableDataObject().addLipidCol(iPrefColNum);
        }
        super.addHeaderLine(iPrefColNum, colHeader, alHeader);
    }

    protected void fillFeatureData(Feature feature, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        Annotation annot;
        if (feature != null && (annot = this.getAnnotation(feature.getAnnotationId())) instanceof GlycanAnnotation) {
            super.fillFeatureData(feature, _settings, alRow);
            return;
        }
        MSGlycolipidAnnotationTableDataProcessorUtil.fillMSGlycolipidFeatureData(feature, alRow.getDataRow(), _settings);
        MSAnnotationTableDataProcessorUtil.fillMSFeatureCustomExtraData((Feature)feature, (ArrayList)alRow.getDataRow(), (TableViewerColumnSettings)_settings, (List)this.getGRITSdata().getDataHeader().getFeatureCustomExtraData());
    }

    protected void addAnnotationColumns(TableViewerColumnSettings _settings) {
        super.addAnnotationColumns(_settings);
        MSGlycolipidAnnotationTableDataProcessorUtil.fillMSGlycolipidAnnotationColumnSettingsLipidAnnotation(_settings);
    }

    protected void fillAnnotationData(Annotation a_annotation, Feature feature, Scan a_scan, int _iNumCandidates, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        MSAnnotationTableDataProcessorUtil.fillAnnotationData((Annotation)a_annotation, (int)_iNumCandidates, (ArrayList)alRow.getDataRow(), (TableViewerColumnSettings)_settings);
        MSAnnotationTableDataProcessorUtil.fillMSAnnotationCustomExtraData((Annotation)a_annotation, (ArrayList)alRow.getDataRow(), (TableViewerColumnSettings)_settings, (List)this.getGRITSdata().getDataHeader().getAnnotationCustomExtraData());
        MSGlycolipidAnnotationTableDataProcessorUtil.fillMSGlycolipidAnnotationData(a_annotation, feature, a_scan, _iNumCandidates, alRow.getDataRow(), _settings);
        if (feature != null) {
            MSGlycanAnnotationTableDataProcessorUtil.fillMSGlycanAnnotationCartoonColumns((Object)feature.getId(), (ArrayList)alRow.getDataRow(), (TableViewerColumnSettings)_settings, (this.getMassSpecEntityProperty().getMsLevel() > 2 ? 1 : 0) != 0);
        }
    }
}

