/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycolipidAnnotation;
import org.grits.toolbox.ms.om.data.LipidAnnotation;

public class GlycolipidAnnotationProvider {
    private int m_nAnnotations = 0;
    private Map<String, GlycanAnnotation> m_mapStringIDToGAnnot = new HashMap<String, GlycanAnnotation>();
    private Map<String, LipidAnnotation> m_mapStringIDToLAnnot = new HashMap<String, LipidAnnotation>();
    private List<String> m_lGlycolipidStringIDs = new ArrayList<String>();
    private Map<String, Integer> m_mapGlycolipidStringIDToID;
    private int m_iCurrentGlycolipidID = 0;
    private static String GlycosidicSeparater = "--";

    public void addGlycanAnnotation(GlycanAnnotation a_gAnnot) {
        if (this.m_mapStringIDToGAnnot.containsKey(a_gAnnot.getStringId())) {
            return;
        }
        a_gAnnot.setId(Integer.valueOf(++this.m_nAnnotations));
        this.m_mapStringIDToGAnnot.put(a_gAnnot.getStringId(), a_gAnnot);
    }

    public void addLipidAnnotation(LipidAnnotation a_lAnnot) {
        if (this.m_mapStringIDToLAnnot.containsKey(a_lAnnot.getStringId())) {
            return;
        }
        a_lAnnot.setId(Integer.valueOf(++this.m_nAnnotations));
        this.m_mapStringIDToLAnnot.put(a_lAnnot.getStringId(), a_lAnnot);
    }

    public void addGlycolipidStringId(String a_strGLID) {
        if (this.m_lGlycolipidStringIDs.contains(a_strGLID)) {
            return;
        }
        String[] t_lGlycanLipidIDs = a_strGLID.split(GlycosidicSeparater);
        if (!this.m_mapStringIDToGAnnot.containsKey(t_lGlycanLipidIDs[0])) {
            return;
        }
        if (!this.m_mapStringIDToLAnnot.containsKey(t_lGlycanLipidIDs[1])) {
            return;
        }
        this.m_mapGlycolipidStringIDToID.put(a_strGLID, ++this.m_nAnnotations);
        this.m_lGlycolipidStringIDs.add(a_strGLID);
    }

    public GlycolipidAnnotation getGlycolipidAnnotation(String a_strGLStringID) {
        if (this.m_lGlycolipidStringIDs.contains(a_strGLStringID)) {
            return null;
        }
        String[] t_lGlycanLipidIDs = a_strGLStringID.split(GlycosidicSeparater);
        GlycanAnnotation t_gAnnot = this.m_mapStringIDToGAnnot.get(t_lGlycanLipidIDs[0]);
        LipidAnnotation t_lAnnot = this.m_mapStringIDToLAnnot.get(t_lGlycanLipidIDs[1]);
        GlycolipidAnnotation t_glAnnot = this.getGlycolipidAnnotation(t_gAnnot, t_lAnnot);
        return t_glAnnot;
    }

    public GlycolipidAnnotation getNextGlycolipidAnnotation() {
        if (this.m_iCurrentGlycolipidID > this.m_lGlycolipidStringIDs.size() - 1) {
            return null;
        }
        String t_strGlycolipidID = this.m_lGlycolipidStringIDs.get(this.m_iCurrentGlycolipidID);
        ++this.m_iCurrentGlycolipidID;
        String[] t_lGlycanLipidIDs = t_strGlycolipidID.split(GlycosidicSeparater);
        GlycanAnnotation t_gAnnot = this.m_mapStringIDToGAnnot.get(t_lGlycanLipidIDs[0]);
        LipidAnnotation t_lAnnot = this.m_mapStringIDToLAnnot.get(t_lGlycanLipidIDs[1]);
        GlycolipidAnnotation t_glAnnot = this.getGlycolipidAnnotation(t_gAnnot, t_lAnnot);
        t_glAnnot.setId(Integer.valueOf(++this.m_nAnnotations));
        return t_glAnnot;
    }

    private GlycolipidAnnotation getGlycolipidAnnotation(GlycanAnnotation a_gAnnot, LipidAnnotation a_lAnnot) {
        GlycolipidAnnotation t_glAnnot = new GlycolipidAnnotation();
        String t_strGLSeq = a_gAnnot.getSequence().replace(",freeEnd", "," + a_lAnnot.getSequence() + "=0.0000u");
        t_glAnnot.setSequence(t_strGLSeq);
        t_glAnnot.setStringId(String.valueOf(a_gAnnot.getStringId()) + GlycosidicSeparater + a_lAnnot.getStringId());
        t_glAnnot.setGlycanAnnotation(a_gAnnot);
        t_glAnnot.setLipidAnnotation(a_lAnnot);
        t_glAnnot.setPerDerivatisationType(a_gAnnot.getPerDerivatisationType());
        return t_glAnnot;
    }
}

