/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.structure.lipid;

import java.util.List;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;

public class Lipid
implements ILipid {
    private int m_nCarboxyl;
    private int m_nAmine;
    private int m_nCarbamoyl;
    private int m_nCarbonNumber;
    private int m_nHydroxylGroups;
    private int m_nOAcetylated;
    private int m_nUnsaturatedBonds;

    public Lipid(int a_nCarboxyl, int a_nNH2, int a_nCONH2, int a_nLength, int a_nOH, int a_nOAc, int a_nDouble) {
        this.m_nCarboxyl = a_nCarboxyl;
        this.m_nAmine = a_nNH2;
        this.m_nCarbamoyl = a_nCONH2;
        this.m_nCarbonNumber = a_nLength;
        this.m_nHydroxylGroups = a_nOH;
        this.m_nOAcetylated = a_nOAc;
        this.m_nUnsaturatedBonds = a_nDouble;
    }

    public int getNumberOfCarboxyl() {
        return this.m_nCarboxyl;
    }

    public int getNumberOfAmine() {
        return this.m_nAmine;
    }

    public int getNumberOfCarbamoyl() {
        return this.m_nCarbamoyl;
    }

    @Override
    public int getCarbonLength() {
        return this.m_nCarbonNumber;
    }

    @Override
    public int getNumberOfHydroxylGroups() {
        return this.m_nHydroxylGroups;
    }

    @Override
    public int getNumberOfOAcetylGroups() {
        return this.m_nOAcetylated;
    }

    @Override
    public int getNumberOfUnsaturation() {
        return this.m_nUnsaturatedBonds;
    }

    @Override
    public String getCoreName() {
        String t_strName = String.valueOf(this.m_nCarbonNumber) + ":" + this.m_nUnsaturatedBonds;
        if (this.m_nHydroxylGroups > 0) {
            String t_strOH = this.m_nHydroxylGroups == 1 ? "h" : (this.m_nHydroxylGroups == 2 ? "d" : (this.m_nHydroxylGroups == 3 ? "t" : (this.m_nHydroxylGroups == 4 ? "tet" : "h" + this.m_nHydroxylGroups)));
            t_strName = String.valueOf(t_strOH) + t_strName;
        }
        return t_strName;
    }

    @Override
    public String getName() {
        String t_strName = "Fr(" + this.getCoreName() + ")";
        if (this.m_nAmine > 0) {
            t_strName = String.valueOf(t_strName) + "(NH2)";
            if (this.m_nAmine > 1) {
                t_strName = String.valueOf(t_strName) + this.m_nAmine;
            }
        }
        if (this.m_nCarboxyl > 0) {
            t_strName = String.valueOf(t_strName) + "(COOH)";
            if (this.m_nCarboxyl > 1) {
                t_strName = String.valueOf(t_strName) + this.m_nCarboxyl;
            }
        }
        if (this.m_nCarbamoyl > 0) {
            t_strName = String.valueOf(t_strName) + "(CONH2)";
            if (this.m_nCarbamoyl > 1) {
                t_strName = String.valueOf(t_strName) + this.m_nCarbamoyl;
            }
        }
        return t_strName;
    }

    @Override
    public String getCompositionName() {
        return this.getName();
    }

    @Override
    public boolean hasSubstructure() {
        return false;
    }

    @Override
    public List<String> getSubstructureNames() {
        return null;
    }
}

