/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.mass;

import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.tools.gsl.structure.lipid.Lipid;
import org.grits.toolbox.tools.gsl.util.mass.AtomicMass;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;

public class LipidChemicalComposition
extends ChemicalComposition {
    private Lipid m_oLipid;

    public LipidChemicalComposition(Lipid a_oLipid) {
        this.m_oLipid = a_oLipid;
        this.start();
    }

    @Override
    protected void start() {
        this.clear();
        int t_nCarbon = 0;
        int t_nHydrogen = 0;
        int t_nOxygen = 0;
        int t_nNitrogen = 0;
        t_nHydrogen += (t_nCarbon += this.m_oLipid.getCarbonLength()) * 2 + 2;
        t_nOxygen += this.m_oLipid.getNumberOfCarboxyl() * 2;
        t_nHydrogen -= this.m_oLipid.getNumberOfCarboxyl() * 2;
        t_nOxygen += this.m_oLipid.getNumberOfCarbamoyl();
        t_nNitrogen += this.m_oLipid.getNumberOfCarbamoyl();
        t_nHydrogen -= this.m_oLipid.getNumberOfCarbamoyl();
        t_nNitrogen += this.m_oLipid.getNumberOfAmine();
        t_nHydrogen += this.m_oLipid.getNumberOfAmine();
        t_nOxygen += this.m_oLipid.getNumberOfHydroxylGroups();
        t_nOxygen += this.m_oLipid.getNumberOfOAcetylGroups();
        t_nHydrogen += this.m_oLipid.getNumberOfOAcetylGroups() * 2;
        this.addNumberOfElements(AtomicMass.C, t_nCarbon += this.m_oLipid.getNumberOfOAcetylGroups() * 2);
        this.addNumberOfElements(AtomicMass.H, t_nHydrogen -= this.m_oLipid.getNumberOfUnsaturation() * 2);
        this.addNumberOfElements(AtomicMass.O, t_nOxygen += this.m_oLipid.getNumberOfOAcetylGroups());
        this.addNumberOfElements(AtomicMass.N, t_nNitrogen);
        if (!this.isDerivatized()) {
            return;
        }
        int t_nSubst = this.m_oLipid.getNumberOfAmine() + this.m_oLipid.getNumberOfCarbamoyl() + this.m_oLipid.getNumberOfHydroxylGroups() + this.m_oLipid.getNumberOfOAcetylGroups();
        this.addSubstituents(this.m_strDerivatizationType, t_nSubst);
        this.addSubstituents(GlycanPreDefinedOptions.DERIVITIZATION_PERACETYLATED, -this.m_oLipid.getNumberOfOAcetylGroups());
    }

    @Override
    public ChemicalComposition copy() {
        LipidChemicalComposition t_copy = new LipidChemicalComposition(this.m_oLipid);
        if (this.isDerivatized()) {
            t_copy.derivatize();
        }
        return t_copy;
    }
}

