/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.actions;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.model.Paper;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.views.PaperView;

public class DeletePaperAction {
    private static final Logger logger = Logger.getLogger(DeletePaperAction.class);
    @Inject
    IEventBroker eventBroker;
    GraphEditor editor;

    @Execute
    public void run(@Named(value="activeShell") Shell shell, MApplication application, MPart paperView, @Optional @Named(value="org.eclipse.ui.selection") Paper paperToBeDeleted) {
        if (paperView != null && paperView.getObject() != null) {
            boolean deleted;
            ProtocolNode protocol = ((PaperView)paperView.getObject()).getProtocol();
            if (protocol == null) {
                return;
            }
            this.editor = (GraphEditor)((Object)application.getContext().get(GraphEditor.class));
            TableViewer tableViewer = ((PaperView)paperView.getObject()).getTableViewer();
            if (paperToBeDeleted != null && (deleted = protocol.getPapers().remove(paperToBeDeleted))) {
                tableViewer.getTable().setRedraw(true);
                tableViewer.getTable().removeAll();
                tableViewer.setInput((Object)protocol);
                this.eventBroker.post("EventTopic_EventPart_Modified", (Object)protocol);
                if (this.editor == null) {
                    logger.error((Object)"Cannot get the reference to Graph Editor");
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Update Error", (String)"Cannot get the reference to Graph Editor");
                    return;
                }
                this.editor.refreshProtocolNode(protocol);
            }
        }
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") Paper paperToBeDeleted) {
        return paperToBeDeleted != null;
    }
}

