/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuant;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuantPeak;

public class MassSpecStandardQuantFile {
    private static final Logger logger = Logger.getLogger(MassSpecStandardQuantFile.class);
    public static final String[] HEADER_COLUMN_LABELS = new String[]{"Peak m/z", "MS Level", "Peak Label"};
    public static final String DELIMITER = "\t";
    public static final String FILE_EXTENSION_TXT = ".txt";
    public static final String FILE_EXTENSION_TXT_NAME = "Tab-delimited (.txt)";
    public static final String FILE_EXTENSION_XML = ".xml";
    public static final String FILE_EXTENSION_XML_NAME = "GRITS Standard Quantitation XML (.xml)";

    public static String[] getHeaderColumns() {
        return HEADER_COLUMN_LABELS;
    }

    public static boolean testTxtFile(File f) {
        boolean bPass = false;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String header = reader.readLine();
            String[] toks = header.split(DELIMITER);
            if (toks[0].equalsIgnoreCase(HEADER_COLUMN_LABELS[0])) {
                bPass = true;
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bPass;
    }

    public static boolean readTxtFile(MassSpecStandardQuant mssq, String sFilePath) {
        boolean bPass = false;
        try {
            File f = new File(sFilePath);
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String header = reader.readLine();
            String[] toks = header.split(DELIMITER);
            boolean bHasLabels = false;
            if (toks.length > 2 && toks[2].equalsIgnoreCase(HEADER_COLUMN_LABELS[2])) {
                bHasLabels = true;
            }
            String sCurLine = reader.readLine();
            if (mssq.getStandardQuantPeaks() == null) {
                mssq.setStandardQuantPeaks(new HashMap<Double, MassSpecStandardQuantPeak>());
            }
            while (sCurLine != null) {
                try {
                    if (!sCurLine.trim().equals("")) {
                        toks = sCurLine.split(DELIMITER);
                        MassSpecStandardQuantPeak peak = new MassSpecStandardQuantPeak();
                        Double dMz = Double.parseDouble(toks[0].trim());
                        peak.setPeakMz(dMz);
                        Integer iMSLevel = Integer.parseInt(toks[1].trim());
                        peak.setMSLevel(iMSLevel);
                        peak.setPeakLabel("");
                        if (bHasLabels && toks.length == 3 && toks[2] != null) {
                            String sLabel = toks[2].replaceAll("\\P{L}+", "");
                            peak.setPeakLabel(sLabel);
                        }
                        mssq.getStandardQuantPeaks().put(peak.getPeakMz(), peak);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                sCurLine = reader.readLine();
            }
            reader.close();
            bPass = true;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bPass;
    }

    public static boolean writeTxtFile(MassSpecStandardQuant mssq, String sFilePath) {
        boolean bPass = false;
        try {
            File f = new File(sFilePath);
            BufferedWriter writer = new BufferedWriter(new FileWriter(f));
            String sw = "";
            int i = 0;
            while (i < HEADER_COLUMN_LABELS.length) {
                writer.write(sw);
                writer.write(HEADER_COLUMN_LABELS[i]);
                if (sw.equals("")) {
                    sw = DELIMITER;
                }
                ++i;
            }
            writer.write(System.getProperty("line.separator"));
            Object[] peaks = mssq.getStandardQuantPeaks().values().toArray();
            int i2 = 0;
            while (i2 < peaks.length) {
                MassSpecStandardQuantPeak peak = (MassSpecStandardQuantPeak)peaks[i2];
                writer.write(Double.toString(peak.getPeakMz()));
                writer.write(DELIMITER);
                writer.write(Integer.toString(peak.getMSLevel()));
                writer.write(DELIMITER);
                writer.write(peak.getPeakLabel() == null ? "" : peak.getPeakLabel());
                writer.write(System.getProperty("line.separator"));
                ++i2;
            }
            writer.close();
            bPass = true;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bPass;
    }
}

