/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.datamodel.ms.preference;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMScan;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;

@XmlRootElement(name="massSpecViewerPreference")
public class MassSpecViewerPreference
extends TableViewerPreference {
    private static final String PREFERENCE_NAME_ALL = "org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference";
    private static final String CURRENT_VERSION = "1.1";
    protected int iMSLevel;
    protected FillTypes fillType = FillTypes.Scans;
    private static final Logger logger = Logger.getLogger(MassSpecViewerPreference.class);
    protected boolean bShowRaw = true;
    protected boolean bShowPicked = false;
    protected boolean bShowPickedLabels = false;
    protected boolean bShowAnnotated = false;
    protected boolean bShowAnnotatedLabels = false;

    public MassSpecViewerPreference() {
        this(0, FillTypes.Scans);
    }

    public MassSpecViewerPreference(int _iMSLevel, FillTypes fillType) {
        this.iMSLevel = _iMSLevel;
        this.fillType = fillType;
    }

    public boolean isShowRaw() {
        return this.bShowRaw;
    }

    @XmlAttribute(name="showRaw")
    public void setShowRaw(boolean bShowRaw) {
        this.bShowRaw = bShowRaw;
    }

    public boolean isShowAnnotated() {
        return this.bShowAnnotated;
    }

    @XmlAttribute(name="showAnnotated")
    public void setShowAnnotated(boolean bShowAnnotated) {
        this.bShowAnnotated = bShowAnnotated;
    }

    public boolean isShowAnnotatedLabels() {
        return this.bShowAnnotatedLabels;
    }

    @XmlAttribute(name="showAnnotatedLabels")
    public void setShowAnnotatedLabels(boolean bShowAnnotatedLabels) {
        this.bShowAnnotatedLabels = bShowAnnotatedLabels;
    }

    public boolean isShowPicked() {
        return this.bShowPicked;
    }

    @XmlAttribute(name="showPicked")
    public void setShowPicked(boolean bShowPicked) {
        this.bShowPicked = bShowPicked;
    }

    public boolean isShowPickedLabels() {
        return this.bShowPickedLabels;
    }

    @XmlAttribute(name="showPickedLabels")
    public void setShowPickedLabels(boolean bShowPickedLabels) {
        this.bShowPickedLabels = bShowPickedLabels;
    }

    public FillTypes getFillType() {
        return this.fillType;
    }

    @XmlAttribute(name="fillType")
    public void setFillType(FillTypes fillType) {
        this.fillType = fillType;
    }

    public void setMSLevel(int iMSLevel) {
        this.iMSLevel = iMSLevel;
    }

    @XmlAttribute(name="msLevel")
    public int getMSLevel() {
        return this.iMSLevel;
    }

    protected static String getPreferenceID(int _iMSLevel, FillTypes _fillType) {
        String sAdder = "";
        String sName = PREFERENCE_NAME_ALL;
        if (_fillType == FillTypes.Scans) {
            sAdder = ".Scans";
        } else if (_fillType == FillTypes.PeakList) {
            sAdder = ".Peaks";
        } else if (_fillType == FillTypes.PeaksWithFeatures) {
            sAdder = ".PeaksWithFeatures";
        }
        sName = String.valueOf(sName) + sAdder;
        sName = String.valueOf(sName) + ".MSLevel" + (_iMSLevel - 1);
        return sName;
    }

    public static PreferenceEntity getPreferenceEntity(int _iMSLevel, FillTypes _fillType) throws UnsupportedVersionException {
        PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)MassSpecViewerPreference.getPreferenceID(_iMSLevel, _fillType));
        return preferenceEntity;
    }

    protected String getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public boolean writePreference() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(MassSpecViewerPreference.getPreferenceID(this.getMSLevel(), this.getFillType()));
        preferenceEntity.setVersion(this.getCurrentVersion());
        preferenceEntity.setValue(this.marshalXML());
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }

    public GRITSColumnHeader getColumnHeader(String _sKey) {
        if (_sKey.equals(DMScan.scan_scanNo.name())) {
            return new GRITSColumnHeader(DMScan.scan_scanNo.getLabel(), DMScan.scan_scanNo.name());
        }
        if (_sKey.equals(DMScan.scan_pseudoScanNo.name())) {
            return new GRITSColumnHeader(DMScan.scan_pseudoScanNo.getLabel(), DMScan.scan_pseudoScanNo.name());
        }
        if (_sKey.equals(DMScan.scan_parentScan.name())) {
            return new GRITSColumnHeader(DMScan.scan_parentScan.getLabel(), DMScan.scan_parentScan.name());
        }
        if (_sKey.equals(DMScan.scan_retentionTime.name())) {
            return new GRITSColumnHeader(DMScan.scan_retentionTime.getLabel(), DMScan.scan_retentionTime.name());
        }
        if (_sKey.equals(DMScan.scan_scanStart.name())) {
            return new GRITSColumnHeader(DMScan.scan_scanStart.getLabel(), DMScan.scan_scanStart.name());
        }
        if (_sKey.equals(DMScan.scan_scanEnd.name())) {
            return new GRITSColumnHeader(DMScan.scan_scanEnd.getLabel(), DMScan.scan_scanEnd.name());
        }
        if (_sKey.equals(DMScan.scan_msLevel.name())) {
            return new GRITSColumnHeader(DMScan.scan_msLevel.getLabel(), DMScan.scan_msLevel.name());
        }
        if (_sKey.equals(DMScan.scan_polarity.name())) {
            return new GRITSColumnHeader(DMScan.scan_polarity.getLabel(), DMScan.scan_polarity.name());
        }
        if (_sKey.equals(DMScan.scan_activationMethode.name())) {
            return new GRITSColumnHeader(DMScan.scan_activationMethode.getLabel(), DMScan.scan_activationMethode.name());
        }
        if (_sKey.equals(DMScan.scan_numsubscans.name())) {
            return new GRITSColumnHeader(DMScan.scan_numsubscans.getLabel(), DMScan.scan_numsubscans.name());
        }
        if (_sKey.equals(DMScan.scan_numannotatedpeaks.name())) {
            return new GRITSColumnHeader(DMScan.scan_numannotatedpeaks.getLabel(), DMScan.scan_numannotatedpeaks.name());
        }
        if (_sKey.equals(DMPeak.peak_id.name())) {
            return new GRITSColumnHeader(DMPeak.peak_id.getLabel(), DMPeak.peak_id.name());
        }
        if (_sKey.equals(DMPeak.peak_mz.name())) {
            return new GRITSColumnHeader(DMPeak.peak_mz.getLabel(), DMPeak.peak_mz.name());
        }
        if (_sKey.equals(DMPeak.peak_intensity.name())) {
            return new GRITSColumnHeader(DMPeak.peak_intensity.getLabel(), DMPeak.peak_intensity.name());
        }
        if (_sKey.equals(DMPeak.peak_relative_intensity.name())) {
            return new GRITSColumnHeader(DMPeak.peak_relative_intensity.getLabel(), DMPeak.peak_relative_intensity.name());
        }
        if (_sKey.equals(DMPeak.peak_charge.name())) {
            return new GRITSColumnHeader(DMPeak.peak_charge.getLabel(), DMPeak.peak_charge.name());
        }
        if (_sKey.equals(DMPrecursorPeak.precursor_peak_mz.name())) {
            return new GRITSColumnHeader(DMPrecursorPeak.precursor_peak_mz.getLabel(), DMPrecursorPeak.precursor_peak_mz.name());
        }
        if (_sKey.equals(DMPrecursorPeak.precursor_peak_intensity.name())) {
            return new GRITSColumnHeader(DMPrecursorPeak.precursor_peak_intensity.getLabel(), DMPrecursorPeak.precursor_peak_intensity.name());
        }
        if (_sKey.equals(DMPrecursorPeak.precursor_peak_relative_intensity.name())) {
            return new GRITSColumnHeader(DMPrecursorPeak.precursor_peak_relative_intensity.getLabel(), DMPrecursorPeak.precursor_peak_relative_intensity.name());
        }
        if (_sKey.equals(DMPrecursorPeak.precursor_peak_charge.name())) {
            return new GRITSColumnHeader(DMPrecursorPeak.precursor_peak_charge.getLabel(), DMPrecursorPeak.precursor_peak_charge.name());
        }
        return null;
    }
}

