/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.handler;

import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.ms.annotation.gelato.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.gelato.GlycanStructureAnnotationLCMSMS;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.om.data.Data;

public class NewGelatoHandlerLCMSMS {
    private static final Logger logger = Logger.getLogger(NewGelatoHandlerLCMSMS.class);

    public static GlycanStructureAnnotation getNewStructureAnnotationObject(Data data, String t_tempFolder, String msAnnotationFolder, MSGlycanAnnotationProperty t_property, MSFile msFile) {
        try {
            return new GlycanStructureAnnotationLCMSMS(data, t_tempFolder, String.valueOf(msAnnotationFolder) + File.separator + t_property.getMSAnnotationMetaData().getAnnotationId(), msFile);
        }
        catch (Exception ex) {
            logger.error((Object)"General error.", (Throwable)ex);
            return null;
        }
    }

    public static void addResultFileToMetaData(GlycanStructureAnnotation gsa, MSGlycanAnnotationProperty msAnnotProperty) {
        String sAnnotationFile = gsa.getOverviewFileName();
        File annotationFile = new File(sAnnotationFile);
        MSPropertyDataFile pdf = new MSPropertyDataFile(annotationFile.getName(), "1.0", "file", FileCategory.ANNOTATION_CATEGORY, "GELATO", sAnnotationFile, new ArrayList());
        msAnnotProperty.getMSAnnotationMetaData().addFile(pdf);
        if (gsa.needsOverview()) {
            String sPreAnnotationFolder = gsa.getFinalArchiveName();
            File preAnnotationFolder = new File(sPreAnnotationFolder);
            File annotationFolder = new File(preAnnotationFolder.getParent());
            MSPropertyDataFile pdfFolder = new MSPropertyDataFile(String.valueOf(annotationFolder.getName()) + File.separator, "1.0", "folder", FileCategory.ANNOTATION_CATEGORY, "GELATO", annotationFolder.getPath(), new ArrayList());
            msAnnotProperty.getMSAnnotationMetaData().addFile(pdfFolder);
        }
    }

    public static void deleteResultFiles(GlycanStructureAnnotation gsa) {
        try {
            String sPreAnnotationFolder;
            File preAnnotationFolder;
            File annotationFolder;
            String sAnnotationFile = gsa.getOverviewFileName();
            File annotationFile = new File(sAnnotationFile);
            if (annotationFile.exists()) {
                annotationFile.delete();
            }
            if (gsa.needsOverview() && (annotationFolder = new File((preAnnotationFolder = new File(sPreAnnotationFolder = gsa.getFinalArchiveName())).getParent())).exists() && annotationFolder.isDirectory()) {
                File[] fileArray = annotationFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    f.delete();
                    ++n2;
                }
                annotationFolder.delete();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not delete generated files", (Throwable)e);
        }
    }
}

