/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Molecule;
import org.grits.toolbox.ms.om.data.MoleculeSettings;

public class AddEditIonDialog
extends TitleAreaDialog {
    private Text txtPreAdductNum;
    private Text txtAdductName;
    private Text txtAdductLabel;
    private Text txtAdductCharge;
    private Text txtAdductMass;
    private Combo cmbAdducts = null;
    private Combo cmbPositive = null;
    private Button button = null;
    private String sTitle = null;
    private String mode = null;
    private Molecule adduct = null;
    private List<Molecule> possibleIons = null;
    private boolean bAddOther = false;
    private DialogType dialogType = DialogType.ION_SETTINGS;
    private static final int OTHER_ADDUCT_NAME_MAX_LENGTH = 50;
    private static final int OTHER_ADDUCT_LABEL_MAX_LENGTH = 15;

    public AddEditIonDialog(Shell parentShell, String sTitle, List<Molecule> possibleIons, boolean _bAddOther, DialogType dialogType) {
        super(parentShell);
        this.sTitle = sTitle;
        this.adduct = new IonSettings();
        this.possibleIons = possibleIons;
        this.bAddOther = _bAddOther;
        this.dialogType = dialogType;
    }

    public AddEditIonDialog(Shell parentShell, String sTitle, Molecule adduct, List<Molecule> possibleIons, boolean _bAddOther, DialogType dialogType) {
        super(parentShell);
        this.sTitle = sTitle;
        this.adduct = adduct;
        this.mode = "edit";
        this.possibleIons = possibleIons;
        this.bAddOther = _bAddOther;
        this.dialogType = dialogType;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.sTitle);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblPredefineAdducts = new Label(container, 0);
        lblPredefineAdducts.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        if (this.dialogType != DialogType.NEUTRAL_LOSSGAIN) {
            lblPredefineAdducts.setText("Adducts");
        } else {
            lblPredefineAdducts.setText("Modifications");
        }
        this.cmbAdducts = new Combo(container, 0);
        int iAdder = this.bAddOther ? 1 : 0;
        String[] sLabels = new String[this.possibleIons.size() + iAdder];
        int i = 0;
        while (i < this.possibleIons.size()) {
            sLabels[i] = this.possibleIons.get(i).getLabel();
            ++i;
        }
        if (this.bAddOther) {
            sLabels[sLabels.length - 1] = GlycanPreDefinedOptions.OTHER;
        }
        this.cmbAdducts.setItems(sLabels);
        this.cmbAdducts.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNumber = new Label(container, 0);
        lblNumber.setText("Number");
        this.txtPreAdductNum = new Text(container, 2048);
        this.txtPreAdductNum.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label lblName = new Label(container, 0);
        lblName.setText("Name");
        this.txtAdductName = new Text(container, 2048);
        this.txtAdductName.setEnabled(false);
        this.txtAdductName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblLabel = new Label(container, 0);
        lblLabel.setText("Label");
        this.txtAdductLabel = new Text(container, 2048);
        this.txtAdductLabel.setEnabled(false);
        this.txtAdductLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.dialogType != DialogType.NEUTRAL_LOSSGAIN) {
            Label lblPositive = new Label(container, 0);
            lblPositive.setText("Polarity");
            this.cmbPositive = new Combo(container, 0);
            this.cmbPositive.setEnabled(false);
            this.cmbPositive.setItems(new String[]{"Positive", "Negative"});
            this.cmbPositive.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.cmbPositive.select(0);
            Label lblCharge = new Label(container, 0);
            lblCharge.setText("Charge");
            this.txtAdductCharge = new Text(container, 2048);
            this.txtAdductCharge.setEnabled(false);
            this.txtAdductCharge.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        Label lblMass = new Label(container, 0);
        if (this.dialogType == DialogType.NEUTRAL_LOSSGAIN) {
            lblMass.setText("Mass*");
        } else {
            lblMass.setText("Mass");
        }
        this.txtAdductMass = new Text(container, 2048);
        this.txtAdductMass.setEnabled(false);
        this.txtAdductMass.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.dialogType == DialogType.NEUTRAL_LOSSGAIN) {
            Label lblMassHint = new Label(container, 0);
            FontData fontData = label.getFont().getFontData()[0];
            Font font = new Font((Device)this.getShell().getDisplay(), new FontData(fontData.getName(), (int)((double)fontData.getHeight() * 0.9), 2));
            lblMassHint.setFont(font);
            lblMassHint.setText("* For neutral loss, use negative value for mass. For gain, use positive value.");
            lblMassHint.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        }
        if (this.mode != null) {
            int iIndexOther = this.updateTextFields();
            if (iIndexOther >= 0) {
                this.txtAdductMass.setEnabled(true);
                this.txtAdductName.setEnabled(true);
                this.txtAdductLabel.setEnabled(true);
                this.cmbAdducts.select(iIndexOther);
                if (this.dialogType != DialogType.NEUTRAL_LOSSGAIN) {
                    this.cmbPositive.setEnabled(true);
                    this.txtAdductCharge.setEnabled(true);
                }
            }
        } else {
            this.cmbAdducts.select(0);
            this.updateAdduct();
            this.updateTextFields();
            this.validateInput();
        }
        this.txtAdductMass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AddEditIonDialog.this.validateInput()) {
                    AddEditIonDialog.this.button.setEnabled(true);
                } else {
                    AddEditIonDialog.this.button.setEnabled(false);
                }
            }
        });
        this.txtAdductName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AddEditIonDialog.this.validateInput()) {
                    AddEditIonDialog.this.button.setEnabled(true);
                } else {
                    AddEditIonDialog.this.button.setEnabled(false);
                }
            }
        });
        this.txtAdductLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AddEditIonDialog.this.validateInput()) {
                    AddEditIonDialog.this.button.setEnabled(true);
                } else {
                    AddEditIonDialog.this.button.setEnabled(false);
                }
            }
        });
        this.txtPreAdductNum.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AddEditIonDialog.this.validateInput()) {
                    AddEditIonDialog.this.button.setEnabled(true);
                } else {
                    AddEditIonDialog.this.button.setEnabled(false);
                }
            }
        });
        if (this.dialogType != DialogType.NEUTRAL_LOSSGAIN) {
            this.txtAdductCharge.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (AddEditIonDialog.this.validateInput()) {
                        AddEditIonDialog.this.button.setEnabled(true);
                    } else {
                        AddEditIonDialog.this.button.setEnabled(false);
                    }
                }
            });
        }
        this.cmbAdducts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AddEditIonDialog.this.cmbAdducts.getItem(AddEditIonDialog.this.cmbAdducts.getSelectionIndex()).equalsIgnoreCase(GlycanPreDefinedOptions.OTHER)) {
                    AddEditIonDialog.this.txtAdductName.setEnabled(true);
                    if (!AddEditIonDialog.this.adduct.getLabel().equals(GlycanPreDefinedOptions.OTHER)) {
                        AddEditIonDialog.this.txtAdductLabel.setText("");
                    }
                    AddEditIonDialog.this.txtAdductLabel.setEnabled(true);
                    AddEditIonDialog.this.txtAdductMass.setEnabled(true);
                    if (AddEditIonDialog.this.dialogType != DialogType.NEUTRAL_LOSSGAIN) {
                        AddEditIonDialog.this.cmbPositive.setEnabled(true);
                        AddEditIonDialog.this.txtAdductCharge.setEnabled(true);
                    }
                } else {
                    AddEditIonDialog.this.txtAdductName.setEnabled(false);
                    AddEditIonDialog.this.txtAdductLabel.setEnabled(false);
                    AddEditIonDialog.this.txtAdductMass.setEnabled(false);
                    if (AddEditIonDialog.this.dialogType != DialogType.NEUTRAL_LOSSGAIN) {
                        AddEditIonDialog.this.cmbPositive.setEnabled(false);
                        AddEditIonDialog.this.txtAdductCharge.setEnabled(false);
                    }
                }
                AddEditIonDialog.this.updateAdduct();
                AddEditIonDialog.this.updateTextFields();
                if (AddEditIonDialog.this.validateInput()) {
                    AddEditIonDialog.this.button.setEnabled(true);
                } else {
                    AddEditIonDialog.this.button.setEnabled(false);
                }
            }
        });
        return area;
    }

    private int updateTextFields() {
        if (this.cmbAdducts.getItemCount() == 0) {
            return -1;
        }
        int iIndex = 0;
        int iIndexOther = -1;
        String[] stringArray = this.cmbAdducts.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String adductName = stringArray[n2];
            if (adductName.equalsIgnoreCase(this.adduct.getLabel())) {
                this.cmbAdducts.select(iIndex);
                break;
            }
            if (adductName.equals(GlycanPreDefinedOptions.OTHER)) {
                iIndexOther = iIndex;
            }
            ++iIndex;
            ++n2;
        }
        if (this.adduct.getMass() != null) {
            this.txtAdductMass.setText("" + this.adduct.getMass());
        }
        if (this.adduct.getName() != null) {
            this.txtAdductName.setText(this.adduct.getName());
        }
        if (this.adduct.getLabel() != null) {
            this.txtAdductLabel.setText(this.adduct.getLabel());
        }
        if (this.dialogType != DialogType.NEUTRAL_LOSSGAIN) {
            this.cmbPositive.select(((IonSettings)this.adduct).getPolarity() != false ? 0 : 1);
            if (((IonSettings)this.adduct).getCharge() != null) {
                this.txtAdductCharge.setText("" + ((IonSettings)this.adduct).getCharge());
            }
        }
        if (this.dialogType != DialogType.NEUTRAL_LOSSGAIN) {
            if (((IonSettings)this.adduct).getCounts().size() > 0) {
                this.txtPreAdductNum.setText("" + ((IonSettings)this.adduct).getCounts().get(0));
            }
        } else if (((MoleculeSettings)this.adduct).getCount() != null) {
            this.txtPreAdductNum.setText("" + ((MoleculeSettings)this.adduct).getCount());
        }
        return iIndexOther;
    }

    private int getOtherIndex() {
        int iIndex = 0;
        int iIndexOther = -1;
        String[] stringArray = this.cmbAdducts.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String adductName = stringArray[n2];
            if (adductName.equals(GlycanPreDefinedOptions.OTHER)) {
                iIndexOther = iIndex;
            }
            ++iIndex;
            ++n2;
        }
        return iIndexOther;
    }

    private void updateAdduct() {
        if (this.possibleIons == null || this.possibleIons.isEmpty()) {
            return;
        }
        String curAdduct = this.cmbAdducts.getItem(this.cmbAdducts.getSelectionIndex());
        int iIndex = 0;
        this.adduct = null;
        for (Molecule possibleIon : this.possibleIons) {
            if (!possibleIon.getLabel().equalsIgnoreCase(curAdduct)) continue;
            this.cmbAdducts.select(iIndex);
            this.adduct = possibleIon;
            break;
        }
        iIndex = 0;
        int iIndexOther = this.getOtherIndex();
        if (this.adduct == null) {
            this.adduct = this.dialogType != DialogType.NEUTRAL_LOSSGAIN ? new IonSettings() : new MoleculeSettings();
            if (!TextFieldUtils.isEmpty((Text)this.txtAdductMass) && TextFieldUtils.isDouble((Text)this.txtAdductMass)) {
                this.adduct.setMass(Double.valueOf(Double.parseDouble(this.txtAdductMass.getText())));
            }
            if (!TextFieldUtils.isEmpty((Text)this.txtAdductName)) {
                this.adduct.setName(this.txtAdductName.getText().trim());
            }
            if (!TextFieldUtils.isEmpty((Text)this.txtAdductLabel)) {
                this.adduct.setLabel(this.txtAdductLabel.getText().trim());
            }
            if (this.dialogType != DialogType.NEUTRAL_LOSSGAIN) {
                if (!TextFieldUtils.isEmpty((Text)this.txtAdductCharge) && TextFieldUtils.isInteger((Text)this.txtAdductCharge)) {
                    ((IonSettings)this.adduct).setCharge(Integer.valueOf(Integer.parseInt(this.txtAdductCharge.getText())));
                }
                ((IonSettings)this.adduct).setPolarity(Boolean.valueOf(this.cmbPositive.getText().equals("Positive")));
            }
            this.cmbAdducts.select(iIndexOther);
        }
        if (this.dialogType != DialogType.NEUTRAL_LOSSGAIN) {
            if (!TextFieldUtils.isEmpty((Text)this.txtPreAdductNum) && TextFieldUtils.isInteger((Text)this.txtPreAdductNum)) {
                ((IonSettings)this.adduct).getCounts().clear();
                ((IonSettings)this.adduct).getCounts().add(Integer.parseInt(this.txtPreAdductNum.getText()));
            }
        } else if (!TextFieldUtils.isEmpty((Text)this.txtPreAdductNum) && TextFieldUtils.isInteger((Text)this.txtPreAdductNum)) {
            ((MoleculeSettings)this.adduct).setCount(Integer.valueOf(Integer.parseInt(this.txtPreAdductNum.getText())));
        }
    }

    public boolean validateInput() {
        if (this.cmbAdducts.getItemCount() == 0) {
            return true;
        }
        int iSelInx = this.cmbAdducts.getSelectionIndex();
        if (iSelInx >= 0 && !this.cmbAdducts.getItem(this.cmbAdducts.getSelectionIndex()).equalsIgnoreCase(GlycanPreDefinedOptions.OTHER)) {
            if (TextFieldUtils.isEmpty((Text)this.txtPreAdductNum)) {
                this.setErrorMessage("Please enter a valid number");
                return false;
            }
            if (!TextFieldUtils.isNonZero((Text)this.txtPreAdductNum)) {
                this.setErrorMessage("Please enter a valid number");
                return false;
            }
        } else {
            if (TextFieldUtils.isEmpty((Text)this.txtAdductName)) {
                this.setErrorMessage("Please enter a valid name");
                return false;
            }
            if (this.txtAdductName.getText().trim().length() > 50) {
                this.setErrorMessage("The maximum length for the name of a custom ion is 50.");
                return false;
            }
            if (TextFieldUtils.isEmpty((Text)this.txtAdductLabel)) {
                this.setErrorMessage("Please enter a valid label");
                return false;
            }
            if (this.txtAdductLabel.getText().trim().length() > 15) {
                this.setErrorMessage("The maximum length for the label of a custom ion is 15.");
                return false;
            }
            if (TextFieldUtils.isEmpty((Text)this.txtAdductMass) || !TextFieldUtils.isDouble((Text)this.txtAdductMass)) {
                this.setErrorMessage("Please enter a valid mass");
                return false;
            }
            if (TextFieldUtils.isEmpty((Text)this.txtPreAdductNum) || !TextFieldUtils.isNonZero((Text)this.txtPreAdductNum)) {
                this.setErrorMessage("Please enter a valid number");
                return false;
            }
            if (this.dialogType != DialogType.NEUTRAL_LOSSGAIN && (TextFieldUtils.isEmpty((Text)this.txtAdductCharge) || !TextFieldUtils.isNonZero((Text)this.txtAdductCharge))) {
                this.setErrorMessage("Please enter a valid charge");
                return false;
            }
            String[] stringArray = this.cmbAdducts.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String adductName = stringArray[n2];
                if (adductName.equalsIgnoreCase(this.txtAdductLabel.getText().trim())) {
                    this.setErrorMessage("Specified label is already predefined. Please specify a different label.");
                    return false;
                }
                ++n2;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.button.setEnabled(this.validateInput());
        this.button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AddEditIonDialog.this.updateAdduct();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 500);
    }

    public Molecule getAdduct() {
        return this.adduct;
    }

    public void setAdduct(Molecule adduct) {
        this.adduct = adduct;
    }

    public static enum DialogType {
        ION_SETTINGS,
        ION_EXCHANGE,
        NEUTRAL_LOSSGAIN;

    }
}

