/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.merge.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.grits.toolbox.merge.om.data.ExperimentAnnotation;
import org.grits.toolbox.merge.om.data.ExtGlycanFeature;
import org.grits.toolbox.merge.om.data.ExtPeak;
import org.grits.toolbox.merge.om.data.Interval;
import org.grits.toolbox.merge.om.data.MergeSettings;
import org.grits.toolbox.merge.om.data.ReportRow;
import org.grits.toolbox.ms.annotation.utils.AnnotationRowExtraction;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.FeatureSelection;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;

public class ExtractRequiredData {
    private HashMap<Double, Interval> intervals = new HashMap();
    private HashMap<Integer, HashMap<Integer, List<Annotation>>> allAnnotations = new HashMap();
    private HashMap<Integer, HashMap<Integer, List<ExtGlycanFeature>>> allExtGlycanFeatures = new HashMap();
    private MergeSettings settings = null;

    public ExtractRequiredData(MergeSettings settings) {
        this.settings = settings;
    }

    private Scan getFirstMS1Scan(Data data) {
        for (Integer scanId : data.getScans().keySet()) {
            Scan scan = (Scan)data.getScans().get(scanId);
            if (scan.getMsLevel() != 1) continue;
            return scan;
        }
        return null;
    }

    private List<Peak> peakSetToList(Set<Peak> peakSet) {
        ArrayList<Peak> lPeaks = new ArrayList<Peak>();
        for (Peak peak : peakSet) {
            if (peak == null) continue;
            lPeaks.add(peak);
        }
        Collections.sort(lPeaks);
        return lPeaks;
    }

    public void extractIntervals() {
        AnnotationReader reader = new AnnotationReader();
        boolean flag = false;
        for (ExperimentAnnotation expAnnotations : this.settings.getExperimentList()) {
            String sReportFile = expAnnotations.getAnnotationFileArchive();
            Data data = reader.readDataWithoutFeatures(sReportFile);
            Scan firstMS1Scan = this.getFirstMS1Scan(data);
            ScanFeatures scanFeatures = reader.readScanAnnotation(sReportFile, firstMS1Scan.getScanNo().intValue());
            int iPeakCnt = 1;
            HashMap htPeakToFeatures = null;
            htPeakToFeatures = AnnotationRowExtraction.createRowIdToFeatureHash((ScanFeatures)scanFeatures);
            boolean bNeedsConvert = false;
            if (htPeakToFeatures.isEmpty()) {
                htPeakToFeatures = AnnotationRowExtraction.createPeakIdToFeatureHash((ScanFeatures)scanFeatures);
                bNeedsConvert = true;
            }
            HashMap htParentScanToParentPeaksToSubScan = AnnotationRowExtraction.createParentScanToParentPeaksToSubScanHash((Data)data);
            if (data.getDataHeader().getMethod().getMsType().equals("Direct Infusion")) {
                AnnotationRowExtraction.updateParentScanToParentPeaksToSubScanHashForDirectInfusion((HashMap)htParentScanToParentPeaksToSubScan, (Data)data);
            }
            List<Peak> sortedPeaks = this.peakSetToList(scanFeatures.getScanPeaks());
            for (Peak peak : sortedPeaks) {
                if (peak == null) continue;
                ArrayList precursorScans = AnnotationRowExtraction.getPrecursorScan((Data)data, (Integer)firstMS1Scan.getScanNo(), (Integer)peak.getId(), (HashMap)htParentScanToParentPeaksToSubScan);
                if (bNeedsConvert) {
                    AnnotationRowExtraction.convertPeakIdsToRowIds((Data)data, (ScanFeatures)scanFeatures, (int)firstMS1Scan.getScanNo(), (Integer)peak.getId(), (ArrayList)precursorScans, (HashMap)htPeakToFeatures);
                }
                Collections.sort(precursorScans);
                for (Scan precursorScan : precursorScans) {
                    String sRowId = Feature.getRowId((Integer)peak.getId(), (Integer)precursorScan.getScanNo());
                    if (!htPeakToFeatures.containsKey(sRowId)) continue;
                    flag = false;
                    ExtPeak precursor = new ExtPeak();
                    precursor.setExpAnnotationId(expAnnotations.getAnnotationEntryId());
                    precursor.setScanId(precursorScan.getScanNo());
                    precursor.setSourcePeakId(peak.getId());
                    precursor.setExtPeakId(iPeakCnt++);
                    precursor.setMz(peak.getMz());
                    precursor.setIntensity(peak.getIntensity());
                    precursor.setRelativeIntensity(peak.getRelativeIntensity());
                    precursor.setPrecursorIntensity(peak.getPrecursorIntensity());
                    precursor.setPrecursorMz(peak.getPrecursorMz());
                    precursor.setIntegerProp(peak.getIntegerProp());
                    precursor.setDoubleProp(peak.getDoubleProp());
                    precursor.setPrecursorCharge(peak.getPrecursorCharge());
                    precursor.setCharge(peak.getCharge());
                    for (Double mz : this.intervals.keySet()) {
                        double tol = 0.0;
                        tol = this.settings.getToleranceType().equals("Ppm") ? this.settings.getTolerance() / 1000000.0 * precursor.getMz() : this.settings.getTolerance();
                        if (!(Math.abs(precursor.getMz() - mz) <= tol)) continue;
                        this.intervals.get(mz).getPeaks().add(precursor);
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    Interval interval = new Interval();
                    interval.setMz(precursor.getMz());
                    interval.getPeaks().add(precursor);
                    this.intervals.put(interval.getMz(), interval);
                }
            }
        }
    }

    public void extractAnnotations() {
        AnnotationReader reader = new AnnotationReader();
        for (ExperimentAnnotation expAnnotations : this.settings.getExperimentList()) {
            String sReportFile = expAnnotations.getAnnotationFileArchive();
            Data data = reader.readDataWithoutFeatures(sReportFile);
            HashMap dataAnnotations = new HashMap();
            for (Annotation ann : data.getAnnotation()) {
                for (String scanId : ann.getScores().keySet()) {
                    int temp = Integer.parseInt(scanId);
                    if (dataAnnotations.get(temp) != null) {
                        ((List)dataAnnotations.get(temp)).add(ann);
                        continue;
                    }
                    ArrayList<Annotation> anns = new ArrayList<Annotation>();
                    anns.add(ann);
                    dataAnnotations.put(temp, anns);
                }
            }
            this.allAnnotations.put(expAnnotations.getAnnotationEntryId(), dataAnnotations);
        }
    }

    public List<CustomExtraData> extractFeatureCustomExtraData() {
        ArrayList<CustomExtraData> lCED = new ArrayList<CustomExtraData>();
        AnnotationReader reader = new AnnotationReader();
        for (ExperimentAnnotation expAnnotations : this.settings.getExperimentList()) {
            String sReportFile = expAnnotations.getAnnotationFileArchive();
            Data data = reader.readDataWithoutFeatures(sReportFile);
            if (data.getDataHeader().getFeatureCustomExtraData() == null) continue;
            for (CustomExtraData ced : data.getDataHeader().getFeatureCustomExtraData()) {
                if (lCED.contains(ced)) continue;
                lCED.add(ced);
            }
        }
        return lCED;
    }

    public List<CustomExtraData> extractAnnotationCustomExtraData() {
        ArrayList<CustomExtraData> lCED = new ArrayList<CustomExtraData>();
        AnnotationReader reader = new AnnotationReader();
        for (ExperimentAnnotation expAnnotations : this.settings.getExperimentList()) {
            String sReportFile = expAnnotations.getAnnotationFileArchive();
            Data data = reader.readDataWithoutFeatures(sReportFile);
            if (data.getDataHeader().getAnnotationCustomExtraData() == null) continue;
            for (CustomExtraData ced : data.getDataHeader().getAnnotationCustomExtraData()) {
                if (lCED.contains(ced)) continue;
                lCED.add(ced);
            }
        }
        return lCED;
    }

    public List<CustomExtraData> extractPeakCustomExtraData() {
        ArrayList<CustomExtraData> lCED = new ArrayList<CustomExtraData>();
        AnnotationReader reader = new AnnotationReader();
        for (ExperimentAnnotation expAnnotations : this.settings.getExperimentList()) {
            String sReportFile = expAnnotations.getAnnotationFileArchive();
            Data data = reader.readDataWithoutFeatures(sReportFile);
            if (data.getDataHeader().getPeakCustomExtraData() == null) continue;
            for (CustomExtraData ced : data.getDataHeader().getPeakCustomExtraData()) {
                if (lCED.contains(ced)) continue;
                lCED.add(ced);
            }
        }
        return lCED;
    }

    public void extractFeatures() {
        AnnotationReader reader = new AnnotationReader();
        for (ExperimentAnnotation expAnnotations : this.settings.getExperimentList()) {
            String sReportFile = expAnnotations.getAnnotationFileArchive();
            Data data = reader.readDataWithoutFeatures(sReportFile);
            Scan firstMS1Scan = this.getFirstMS1Scan(data);
            ScanFeatures scanFeatures = reader.readScanAnnotation(sReportFile, firstMS1Scan.getScanNo().intValue());
            HashMap htPeakToFeatures = null;
            htPeakToFeatures = AnnotationRowExtraction.createRowIdToFeatureHash((ScanFeatures)scanFeatures);
            boolean bNeedsConvert = false;
            if (htPeakToFeatures.isEmpty()) {
                htPeakToFeatures = AnnotationRowExtraction.createPeakIdToFeatureHash((ScanFeatures)scanFeatures);
                bNeedsConvert = true;
            }
            HashMap htParentScanToParentPeaksToSubScan = AnnotationRowExtraction.createParentScanToParentPeaksToSubScanHash((Data)data);
            if (data.getDataHeader().getMethod().getMsType().equals("Direct Infusion")) {
                AnnotationRowExtraction.updateParentScanToParentPeaksToSubScanHashForDirectInfusion((HashMap)htParentScanToParentPeaksToSubScan, (Data)data);
            }
            HashMap<Integer, List<ExtGlycanFeature>> extGlyFeatures = new HashMap<Integer, List<ExtGlycanFeature>>();
            for (Interval interval : this.intervals.values()) {
                for (ExtPeak peak : interval.getPeaks()) {
                    String sRowId;
                    if (peak.getExpAnnotationId() != expAnnotations.getAnnotationEntryId().intValue()) continue;
                    ArrayList precursorScans = AnnotationRowExtraction.getPrecursorScan((Data)data, (Integer)firstMS1Scan.getScanNo(), (Integer)peak.getSourcePeakId(), (HashMap)htParentScanToParentPeaksToSubScan);
                    if (bNeedsConvert) {
                        AnnotationRowExtraction.convertPeakIdsToRowIds((Data)data, (ScanFeatures)scanFeatures, (int)firstMS1Scan.getScanNo(), (Integer)peak.getSourcePeakId(), (ArrayList)precursorScans, (HashMap)htPeakToFeatures);
                    }
                    if (!htPeakToFeatures.containsKey(sRowId = Feature.getRowId((Integer)peak.getSourcePeakId(), (Integer)peak.getScanId()))) continue;
                    List alFeatures = (List)htPeakToFeatures.get(sRowId);
                    for (Feature feature : alFeatures) {
                        List<ExtGlycanFeature> extFeatures;
                        FeatureSelection fs = Feature.getFeatureSelection((Feature)feature, (String)sRowId);
                        if (!fs.getSelected().booleanValue()) continue;
                        Annotation parentAnnotation = AnnotationRowExtraction.getAnnotation((Data)data, (Integer)feature.getAnnotationId());
                        ExtGlycanFeature extGlyFeature = ExtractRequiredData.getNewExtGlycanFeature(peak, parentAnnotation, feature);
                        if (extGlyFeatures.get(peak.getSourcePeakId()) != null) {
                            extFeatures = (List)extGlyFeatures.get(peak.getSourcePeakId());
                            if (extFeatures.contains(extGlyFeature)) continue;
                            extFeatures.add(extGlyFeature);
                            continue;
                        }
                        extFeatures = new ArrayList<ExtGlycanFeature>();
                        extFeatures.add(extGlyFeature);
                        extGlyFeatures.put(peak.getSourcePeakId(), extFeatures);
                    }
                }
            }
            this.allExtGlycanFeatures.put(expAnnotations.getAnnotationEntryId(), extGlyFeatures);
        }
    }

    public static ExtGlycanFeature getNewExtGlycanFeature(ExtPeak peak, Annotation parentAnnotation, Feature feature) {
        ExtGlycanFeature extGlyFeature = new ExtGlycanFeature();
        extGlyFeature.setExpAnotationId(peak.getExpAnnotationId());
        extGlyFeature.setAnnotationId(parentAnnotation.getId());
        extGlyFeature.setStringAnnotationId(parentAnnotation.getStringId());
        extGlyFeature.setSequenceGWB(feature.getSequence());
        extGlyFeature.setSequence(parentAnnotation.getSequence());
        extGlyFeature.setSequenceFormat(parentAnnotation.getSequenceFormat());
        extGlyFeature.setFeatureDoubleProp(feature.getDoubleProp());
        extGlyFeature.setFeatureIntegerProp(feature.getIntegerProp());
        extGlyFeature.setFeatureStringProp(feature.getStringProp());
        extGlyFeature.setFeatureBooleanProp(feature.getBooleanProp());
        extGlyFeature.setAnnotationDoubleProp(parentAnnotation.getDoubleProp());
        extGlyFeature.setAnnotationIntegerProp(parentAnnotation.getIntegerProp());
        extGlyFeature.setAnnotationStringProp(parentAnnotation.getStringProp());
        extGlyFeature.setAnnotationBooleanProp(parentAnnotation.getBooleanProp());
        extGlyFeature.setIntensity(peak.getIntensity() != null ? peak.getIntensity() : 0.0);
        extGlyFeature.setCharge(feature.getCharge() != null ? feature.getCharge() : -1);
        extGlyFeature.setFeatureMz(peak.getMz());
        extGlyFeature.setFeatureId(feature.getId());
        extGlyFeature.setPeakId(peak.getExtPeakId());
        return extGlyFeature;
    }

    public List<ReportRow> generateReportRows() {
        ArrayList<ReportRow> rows = new ArrayList<ReportRow>();
        for (Interval interval : this.intervals.values()) {
            ReportRow row = new ReportRow();
            row.setInterval(interval);
            for (ExtPeak peak : interval.getPeaks()) {
                if (this.allExtGlycanFeatures.get(peak.getExpAnnotationId()).get(peak.getSourcePeakId()) == null) continue;
                List<ExtGlycanFeature> extFeatures = this.allExtGlycanFeatures.get(peak.getExpAnnotationId()).get(peak.getSourcePeakId());
                for (ExtGlycanFeature extGlyFeature : extFeatures) {
                    if (row.getAnnotations().contains(extGlyFeature)) continue;
                    row.getAnnotations().add(extGlyFeature);
                }
            }
            rows.add(row);
        }
        return rows;
    }

    public HashMap<Double, Interval> getIntervals() {
        return this.intervals;
    }

    public void setIntervals(HashMap<Double, Interval> intervals) {
        this.intervals = intervals;
    }
}

