/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.om.io.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.GlycanScansAnnotation;
import org.grits.toolbox.ms.om.data.IntensityFilter;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class AnnotationReader {
    private static final Logger logger = Logger.getLogger(AnnotationReader.class);
    public static final Class[] filterClassContext = new Class[]{IntensityFilter.class};

    public ScanFeatures readScanAnnotation(String fileName, int scanId) {
        try {
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FilterSetting.class);
            contextList.add(ScanFeatures.class);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            ScanFeatures scanFeatures = null;
            File f = this.extractXMLFile(fileName, scanId + ".xml");
            if (f != null && f.exists()) {
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                scanFeatures = (ScanFeatures)jaxbUnmarshaller.unmarshal(f);
                f.delete();
                return scanFeatures;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"Exception in AnnotationReader:readScanAnnotation.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File extractXMLFile(String filePath, String targetFileName) throws IOException {
        byte[] buffer = new byte[2048];
        FileInputStream theFile = new FileInputStream(filePath);
        ZipInputStream stream = new ZipInputStream(theFile);
        File outputFile = null;
        try {
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                block11: {
                    if (!entry.getName().trim().equalsIgnoreCase(targetFileName)) continue;
                    File f = new File(filePath);
                    String path = f.getParentFile().getAbsolutePath();
                    String outpath = path + File.separator + entry.getName();
                    FileOutputStream output = null;
                    try {
                        outputFile = new File(outpath);
                        output = new FileOutputStream(outputFile);
                        int len = 0;
                        while ((len = stream.read(buffer)) > 0) {
                            output.write(buffer, 0, len);
                        }
                        if (output == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (output != null) {
                            output.close();
                        }
                        File file = outputFile;
                        stream.close();
                        if (outputFile == null) {
                            return null;
                        }
                        return outputFile;
                    }
                    output.close();
                }
                File file = outputFile;
                return file;
            }
            {
                catch (Throwable throwable) {}
            }
        }
        finally {
            stream.close();
            if (outputFile == null) {
                return null;
            }
            return outputFile;
        }
    }

    public Data readDataWithoutFeatures(String fileName) {
        try {
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FilterSetting.class);
            contextList.add(Data.class);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Data data = new Data();
            File fData = this.extractXMLFile(fileName, "data.xml");
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            data = (Data)jaxbUnmarshaller.unmarshal(fData);
            DataHeader dataHeader = this.readDataHeader(fileName);
            if (dataHeader == null) {
                throw new Exception("DataHeader object is null!");
            }
            data.setDataHeader(dataHeader);
            Method method = this.readMethod(fileName);
            dataHeader.setMethod(method);
            fData.delete();
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Exception in AnnotationReader:readDataWithoutFeatures.", (Throwable)e);
            return null;
        }
    }

    public Data readData(String fileName) {
        try {
            Data data = new Data();
            File fData = this.extractXMLFile(fileName, "data.xml");
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FilterSetting.class);
            contextList.add(Data.class);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            data = (Data)jaxbUnmarshaller.unmarshal(fData);
            fData.delete();
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Exception in AnnotationReader:readDataWithoutFeatures.", (Throwable)e);
            return null;
        }
    }

    public Method readMethod(String filePath) {
        try {
            Method method = new Method();
            File f = this.extractXMLFile(filePath, "settings.xml");
            if (f != null && f.exists()) {
                ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
                contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
                contextList.add(FilterSetting.class);
                contextList.add(Method.class);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                method = (Method)jaxbUnmarshaller.unmarshal(f);
                f.delete();
                return method;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Exception in AnnotationReader:readMethod.", (Throwable)e);
            return null;
        }
    }

    public DataHeader readDataHeader(String filePath) {
        try {
            DataHeader dataHeader = null;
            File f = this.extractXMLFile(filePath, "dataHeader.xml");
            if (f != null && f.exists()) {
                ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
                contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
                contextList.add(FilterSetting.class);
                contextList.add(DataHeader.class);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                dataHeader = (DataHeader)jaxbUnmarshaller.unmarshal(f);
                f.delete();
                return dataHeader;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Exception in AnnotationReader:readDataHeader.", (Throwable)e);
            return null;
        }
    }

    public GlycanScansAnnotation readglycanAnnotation(String filePath, String glycanId) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanScansAnnotation.class});
            GlycanScansAnnotation glycanAnnotations = new GlycanScansAnnotation();
            File f = new File(filePath + File.separator + glycanId + ".xml");
            if (f != null && f.exists()) {
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                glycanAnnotations = (GlycanScansAnnotation)jaxbUnmarshaller.unmarshal(f);
                return glycanAnnotations;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

