/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.GlycanMatcher;
import org.grits.toolbox.ms.annotation.gelato.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;

public class GlycanStructureAnnotationLCMSMS
extends GlycanStructureAnnotation {
    private static final Logger logger = Logger.getLogger(GlycanStructureAnnotationLCMSMS.class);
    protected Data overviewData = null;

    public GlycanStructureAnnotationLCMSMS(Data data, String path, String archiveName, MSFile msFile) {
        super(data, path, archiveName, msFile);
    }

    @Override
    protected HashMap<Integer, Scan> getScans(MSFile msFile, int _iScanNumber, double dFragCutoff, String sFragCutoffType, double dPreCutoff, String sPreCutoffType) {
        if (msFile.getReader() instanceof IMSAnnotationFileReader) {
            List scans = ((IMSAnnotationFileReader)msFile.getReader()).readMSFile(msFile, _iScanNumber);
            return this.listToHashMap(scans, dFragCutoff, sFragCutoffType, dPreCutoff, sPreCutoffType);
        }
        return null;
    }

    @Override
    public List<Integer> determineScanBounds() {
        if (this.msFile.getReader() instanceof IMSAnnotationFileReader) {
            List scans = ((IMSAnnotationFileReader)this.msFile.getReader()).getScanList(this.msFile, -1);
            if (scans == null || scans.isEmpty()) {
                return null;
            }
            return scans;
        }
        return null;
    }

    private void clearPeakLists(Data data) {
        for (Scan scan : data.getScans().values()) {
            if (this.isCanceled()) {
                return;
            }
            if (scan.getAnnotatedPeaks() != null) {
                scan.getAnnotatedPeaks().clear();
            }
            scan.getPeaklist().clear();
        }
    }

    @Override
    protected void addAnnotation(GlycanAnnotation annotation) {
        super.addAnnotation(annotation);
        this.overviewData.getAnnotation().add(annotation);
    }

    @Override
    protected boolean processAnalyteSettings() {
        try {
            boolean bRes = super.processAnalyteSettings();
            if (this.isCanceled()) {
                return false;
            }
            if (bRes) {
                this.clearPeakLists(this.data);
                this.overviewData.getScans().putAll(this.data.getScans());
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAnalyteSettings", (Throwable)e);
        }
        return false;
    }

    @Override
    protected boolean processAnalyteSetting(AnalyteSettings _analyteSettings, List<GlycanStructure> _structures) {
        try {
            boolean bRes = super.processAnalyteSetting(_analyteSettings, _structures);
            if (this.isCanceled()) {
                return false;
            }
            return bRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAnalyteSettings", (Throwable)e);
            return false;
        }
    }

    @Override
    public int processScans() {
        try {
            this.overviewData = new Data();
            this.overviewData.setDataHeader(this.dataHeader);
            int iRes = super.processScans();
            if (this.isCanceled()) {
                return iRes;
            }
            if (iRes == GRITSProcessStatus.OK) {
                this.writer.generateScansAnnotationFiles(this.m_tempFilePath, this.overviewData, this.getOverviewFileName(), true, true, true, false);
                return GRITSProcessStatus.OK;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in processScans", (Throwable)e);
        }
        return GRITSProcessStatus.ERROR;
    }

    @Override
    public String getFinalArchiveName() {
        return AnnotationWriter.getArchiveFilePath((String)(this.m_preArchive + File.separator + this.iCurScanNum));
    }

    @Override
    public boolean needsOverview() {
        return true;
    }

    @Override
    public String getOverviewFileName() {
        return this.m_finalArchive;
    }

    @Override
    protected GlycanMatcher getNewGlycanMatcher() {
        return new GlycanMatcher(this);
    }

    @Override
    protected void cleanAfterCancel() {
        try {
            File fDir = new File(this.m_preArchive);
            for (File f : fDir.listFiles()) {
                f.delete();
            }
            fDir.delete();
            File f = new File(this.getOverviewFileName());
            f.delete();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setArchiveFilePaths() {
        try {
            new File(this.m_preArchive).mkdirs();
        }
        catch (Exception ex) {
            logger.error((Object)"Error creating archive folder.", (Throwable)ex);
        }
        this.m_finalArchive = AnnotationWriter.getArchiveFilePath((String)this.m_preArchive);
    }
}

