/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.structure;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.structure.GlycanDatabase;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.annotation.structure.IStructureHandler;
import org.grits.toolbox.ms.annotation.structure.StructureHandlerException;
import org.grits.toolbox.ms.om.data.GlycanFilter;

public class StructureHandlerFileSystem
implements IStructureHandler {
    private static final Logger logger = Logger.getLogger(StructureHandlerFileSystem.class);

    @Override
    public List<GlycanStructure> getStructures(GlycanFilter a_filter) throws StructureHandlerException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
            GlycanDatabase db = new GlycanDatabase();
            File f = new File(a_filter.getDatabase());
            if (f.exists()) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                db = (GlycanDatabase)jaxbUnmarshaller.unmarshal(f);
                a_filter.setVersion(db.getVersion());
                return db.getStructures();
            }
            return null;
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid database!", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean addStructure(GlycanStructure a_structure, String a_database) throws StructureHandlerException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            GlycanDatabase db = new GlycanDatabase();
            File f = new File(a_database);
            if (f.exists()) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                db = (GlycanDatabase)jaxbUnmarshaller.unmarshal(f);
                db.getStructures().add(a_structure);
                jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshaller.marshal((Object)db, f);
                jaxbMarshaller.marshal((Object)db, (OutputStream)System.out);
            } else {
                GlycanDatabase newDb = new GlycanDatabase();
                ArrayList<GlycanStructure> glycans = new ArrayList<GlycanStructure>();
                glycans.add(a_structure);
                newDb.setName(a_database);
                newDb.setStructures(glycans);
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
                jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshaller.marshal((Object)newDb, f);
                jaxbMarshaller.marshal((Object)newDb, (OutputStream)System.out);
            }
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot add structure to the database", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean addStructures(List<GlycanStructure> a_structures, String a_database) throws StructureHandlerException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            GlycanDatabase db = new GlycanDatabase();
            File f = new File(a_database);
            if (f.exists()) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                db = (GlycanDatabase)jaxbUnmarshaller.unmarshal(f);
                db.getStructures().addAll(a_structures);
                jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshaller.marshal((Object)db, f);
                jaxbMarshaller.marshal((Object)db, (OutputStream)System.out);
            } else {
                GlycanDatabase newDb = new GlycanDatabase();
                newDb.setName(a_database);
                newDb.setStructures(a_structures);
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
                jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshaller.marshal((Object)newDb, f);
                jaxbMarshaller.marshal((Object)newDb, (OutputStream)System.out);
            }
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot add structures to the database", (Throwable)e);
            return false;
        }
    }
}

