/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.sugar;

import java.util.HashMap;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTreeSingle;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

public class GlycoVisitorGlycanCode
implements GlycoVisitor {
    private HashMap<GlycoNode, Boolean> m_hUsedResidue = new HashMap();
    private Integer m_iHex = 0;
    private Integer m_iHexA = 0;
    private Integer m_iHexNAc = 0;
    private Integer m_i6dHex = 0;
    private Integer m_iNeuAc = 0;
    private Integer m_iNeuGc = 0;
    private Integer m_iKDN = 0;
    private Integer m_iS = 0;
    private Integer m_iOther = 0;

    public void clear() {
        this.m_iHex = 0;
        this.m_iHexA = 0;
        this.m_iHexNAc = 0;
        this.m_i6dHex = 0;
        this.m_iNeuAc = 0;
        this.m_iNeuGc = 0;
        this.m_iKDN = 0;
        this.m_iS = 0;
        this.m_iOther = 0;
        this.m_hUsedResidue.clear();
    }

    public GlycoTraverser getTraverser(GlycoVisitor a_visitor) throws GlycoVisitorException {
        return new GlycoTraverserTreeSingle(a_visitor);
    }

    public void visit(NonMonosaccharide arg0) throws GlycoVisitorException {
        GlycoVisitorGlycanCode glycoVisitorGlycanCode = this;
        Integer n = glycoVisitorGlycanCode.m_iOther;
        Integer n2 = glycoVisitorGlycanCode.m_iOther = Integer.valueOf(glycoVisitorGlycanCode.m_iOther + 1);
    }

    public void visit(SugarUnitCyclic arg0) throws GlycoVisitorException {
    }

    public void visit(SugarUnitAlternative arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("SugarUnitAlternative is not supported.");
    }

    public void visit(UnvalidatedGlycoNode arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("UnvalidatedGlycoNode is not supported.");
    }

    public void visit(GlycoEdge arg0) throws GlycoVisitorException {
    }

    public void start(Sugar a_sugar) throws GlycoVisitorException {
        this.clear();
        GlycoTraverser t_traverser = this.getTraverser(this);
        t_traverser.traverseGraph((GlycoGraph)a_sugar);
        for (UnderdeterminedSubTree t_tree : a_sugar.getUndeterminedSubTrees()) {
            t_traverser.traverseGraph((GlycoGraph)t_tree);
        }
    }

    public void visit(SugarUnitRepeat a_repeat) throws GlycoVisitorException {
        GlycoTraverser t_traverser = this.getTraverser(this);
        t_traverser.traverseGraph((GlycoGraph)a_repeat);
        for (UnderdeterminedSubTree t_tree : a_repeat.getUndeterminedSubTrees()) {
            t_traverser.traverseGraph((GlycoGraph)t_tree);
        }
    }

    public void visit(Substituent a_subst) throws GlycoVisitorException {
        if (this.m_hUsedResidue.get(a_subst) == null) {
            if (a_subst.getSubstituentType().equals((Object)SubstituentType.SULFATE)) {
                GlycoVisitorGlycanCode glycoVisitorGlycanCode = this;
                Integer n = glycoVisitorGlycanCode.m_iS;
                Integer n2 = glycoVisitorGlycanCode.m_iS = Integer.valueOf(glycoVisitorGlycanCode.m_iS + 1);
            } else {
                GlycoVisitorGlycanCode glycoVisitorGlycanCode = this;
                Integer n = glycoVisitorGlycanCode.m_iOther;
                Integer n3 = glycoVisitorGlycanCode.m_iOther = Integer.valueOf(glycoVisitorGlycanCode.m_iOther + 1);
            }
        }
    }

    public void visit(Monosaccharide a_ms) throws GlycoVisitorException {
        Integer n;
        Object object;
        int t_numberSubst = this.calcNumberSubst(a_ms);
        if (a_ms.getSuperclass().equals((Object)Superclass.HEX)) {
            for (Object t_modi : a_ms.getModification()) {
                if (this.isModiPosition(6, t_modi.getPositionOne()) && t_modi.getModificationType().equals((Object)ModificationType.DEOXY) && a_ms.getModification().size() == 1 && t_numberSubst == 0) {
                    GlycoVisitorGlycanCode glycoVisitorGlycanCode = this;
                    Integer n2 = glycoVisitorGlycanCode.m_i6dHex;
                    Integer n3 = glycoVisitorGlycanCode.m_i6dHex = Integer.valueOf(glycoVisitorGlycanCode.m_i6dHex + 1);
                    return;
                }
                if (!this.isModiPosition(6, t_modi.getPositionOne()) || !t_modi.getModificationType().equals((Object)ModificationType.ACID) || a_ms.getModification().size() != 1 || t_numberSubst != 0) continue;
                GlycoVisitorGlycanCode glycoVisitorGlycanCode = this;
                Integer n4 = glycoVisitorGlycanCode.m_iHexA;
                Integer n5 = glycoVisitorGlycanCode.m_iHexA = Integer.valueOf(glycoVisitorGlycanCode.m_iHexA + 1);
                return;
            }
            if (a_ms.getModification().size() != 0) {
                Object t_modi;
                object = this;
                t_modi = ((GlycoVisitorGlycanCode)object).m_iOther;
                Integer n6 = ((GlycoVisitorGlycanCode)object).m_iOther = Integer.valueOf(((GlycoVisitorGlycanCode)object).m_iOther + 1);
                return;
            }
            for (Object t_edge : a_ms.getChildEdges()) {
                if (!this.isPosition(2, (GlycoEdge)t_edge) || !this.isSubst(SubstituentType.N_ACETYL, t_edge.getChild()) || !this.isLinkageType(LinkageType.DEOXY, (GlycoEdge)t_edge) || t_numberSubst != 1) continue;
                this.m_hUsedResidue.put(t_edge.getChild(), Boolean.TRUE);
                GlycoVisitorGlycanCode glycoVisitorGlycanCode = this;
                Integer n7 = glycoVisitorGlycanCode.m_iHexNAc;
                Integer n8 = glycoVisitorGlycanCode.m_iHexNAc = Integer.valueOf(glycoVisitorGlycanCode.m_iHexNAc + 1);
                return;
            }
            if (t_numberSubst == 0) {
                Object t_edge;
                object = this;
                t_edge = ((GlycoVisitorGlycanCode)object).m_iHex;
                Integer n9 = ((GlycoVisitorGlycanCode)object).m_iHex = Integer.valueOf(((GlycoVisitorGlycanCode)object).m_iHex + 1);
                return;
            }
        } else if (a_ms.getSuperclass().equals((Object)Superclass.NON)) {
            for (Object t_edge : a_ms.getChildEdges()) {
                if (!this.isPosition(5, (GlycoEdge)t_edge) || !this.isLinkageType(LinkageType.DEOXY, (GlycoEdge)t_edge) || t_numberSubst != 1) continue;
                if (this.isSubst(SubstituentType.N_ACETYL, t_edge.getChild())) {
                    this.m_hUsedResidue.put(t_edge.getChild(), Boolean.TRUE);
                    GlycoVisitorGlycanCode glycoVisitorGlycanCode = this;
                    Integer n10 = glycoVisitorGlycanCode.m_iNeuAc;
                    Integer n11 = glycoVisitorGlycanCode.m_iNeuAc = Integer.valueOf(glycoVisitorGlycanCode.m_iNeuAc + 1);
                    return;
                }
                if (!this.isSubst(SubstituentType.N_GLYCOLYL, t_edge.getChild())) continue;
                this.m_hUsedResidue.put(t_edge.getChild(), Boolean.TRUE);
                GlycoVisitorGlycanCode glycoVisitorGlycanCode = this;
                Integer n12 = glycoVisitorGlycanCode.m_iNeuGc;
                Integer n13 = glycoVisitorGlycanCode.m_iNeuGc = Integer.valueOf(glycoVisitorGlycanCode.m_iNeuGc + 1);
                return;
            }
            if (t_numberSubst == 0) {
                object = this;
                n = ((GlycoVisitorGlycanCode)object).m_iKDN;
                Integer n14 = ((GlycoVisitorGlycanCode)object).m_iKDN = Integer.valueOf(((GlycoVisitorGlycanCode)object).m_iKDN + 1);
                return;
            }
        }
        object = this;
        n = ((GlycoVisitorGlycanCode)object).m_iOther;
        Integer n15 = ((GlycoVisitorGlycanCode)object).m_iOther = Integer.valueOf(((GlycoVisitorGlycanCode)object).m_iOther + 1);
    }

    private int calcNumberSubst(Monosaccharide a_ms) throws GlycoVisitorException {
        int t_counter = 0;
        GlycoVisitorNodeType t_visitorType = new GlycoVisitorNodeType();
        for (GlycoNode t_node : a_ms.getChildNodes()) {
            if (!t_visitorType.isSubstituent(t_node)) continue;
            ++t_counter;
        }
        return t_counter;
    }

    private boolean isLinkageType(LinkageType a_soll, GlycoEdge a_edge) {
        if (a_edge.getGlycosidicLinkages().size() != 1) {
            return false;
        }
        for (Linkage t_linkage : a_edge.getGlycosidicLinkages()) {
            if (!t_linkage.getParentLinkageType().equals((Object)a_soll)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubst(SubstituentType a_soll, GlycoNode a_nodeChild) throws GlycoVisitorException {
        GlycoVisitorNodeType t_visNodeType = new GlycoVisitorNodeType();
        Substituent t_subst = t_visNodeType.getSubstituent(a_nodeChild);
        if (t_subst == null) {
            return false;
        }
        return t_subst.getSubstituentType().equals((Object)a_soll);
    }

    private boolean isPosition(int a_iSollPosition, GlycoEdge a_edge) {
        if (a_edge.getGlycosidicLinkages().size() != 1) {
            return false;
        }
        for (Linkage t_linkage : a_edge.getGlycosidicLinkages()) {
            for (Integer t_iPos : t_linkage.getParentLinkages()) {
                if (t_iPos.equals(a_iSollPosition)) {
                    return true;
                }
                if (!t_iPos.equals(-1)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isModiPosition(int a_iSollPosition, int a_iIstPosition) {
        if (a_iSollPosition == a_iIstPosition) {
            return true;
        }
        return a_iIstPosition == 0;
    }

    public String getCode() {
        return String.format("%d.%d.%d.%d.%d.%d.%d.%d.%d", this.m_iHex, this.m_iHexNAc, this.m_i6dHex, this.m_iNeuAc, this.m_iNeuGc, this.m_iKDN, this.m_iHexA, this.m_iS, this.m_iOther);
    }

    public String getCompositionString() {
        Integer t_sia;
        StringBuffer t_buffer = new StringBuffer("");
        if (this.m_iHex > 0) {
            t_buffer.append(this.m_iHex.toString() + "Hex");
        }
        if (this.m_iHexNAc > 0) {
            t_buffer.append(this.m_iHexNAc.toString() + "HexNAc");
        }
        if (this.m_i6dHex > 0) {
            t_buffer.append(this.m_i6dHex.toString() + "dHex");
        }
        if (this.m_iHexA > 0) {
            t_buffer.append(this.m_iHexA.toString() + "HexA");
        }
        if ((t_sia = Integer.valueOf(this.m_iKDN + this.m_iNeuAc + this.m_iNeuGc)) > 0) {
            t_buffer.append(t_sia.toString() + "Sia(Ac, Gc,Kdn)");
        }
        if (this.m_iOther > 0) {
            t_buffer.append(" + " + this.m_iOther + " other");
        }
        return t_buffer.toString();
    }
}

